var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function getAugmentedNamespace(n) {
  if (n.__esModule)
    return n;
  var a = Object.defineProperty({}, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a, k, d.get ? d : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a;
}
var canUseDOM = !!(typeof window !== "undefined" && window.document && window.document.createElement);
var canUseDom = canUseDOM;
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
var freeGlobal$1 = freeGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal$1 || freeSelf || Function("return this")();
var root$1 = root;
var Symbol$1 = root$1.Symbol;
var Symbol$2 = Symbol$1;
var objectProto$1 = Object.prototype;
var hasOwnProperty$2 = objectProto$1.hasOwnProperty;
var nativeObjectToString$1 = objectProto$1.toString;
var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
function getRawTag(value) {
  var isOwn = hasOwnProperty$2.call(value, symToStringTag$1), tag = value[symToStringTag$1];
  try {
    value[symToStringTag$1] = void 0;
    var unmasked = true;
  } catch (e) {
  }
  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}
var objectProto = Object.prototype;
var nativeObjectToString = objectProto.toString;
function objectToString$2(value) {
  return nativeObjectToString.call(value);
}
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
function baseGetTag(value) {
  if (value == null) {
    return value === void 0 ? undefinedTag : nullTag;
  }
  return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString$2(value);
}
function isObjectLike(value) {
  return value != null && typeof value == "object";
}
var symbolTag = "[object Symbol]";
function isSymbol$1(value) {
  return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag;
}
var reWhitespace = /\s/;
function trimmedEndIndex(string) {
  var index = string.length;
  while (index-- && reWhitespace.test(string.charAt(index))) {
  }
  return index;
}
var reTrimStart = /^\s+/;
function baseTrim(string) {
  return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
}
function isObject$3(value) {
  var type = typeof value;
  return value != null && (type == "object" || type == "function");
}
var NAN = 0 / 0;
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary = /^0b[01]+$/i;
var reIsOctal = /^0o[0-7]+$/i;
var freeParseInt = parseInt;
function toNumber$1(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol$1(value)) {
    return NAN;
  }
  if (isObject$3(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject$3(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
var now = function() {
  return root$1.Date.now();
};
var now$1 = now;
var FUNC_ERROR_TEXT$1 = "Expected a function";
var nativeMax = Math.max, nativeMin = Math.min;
function debounce(func, wait, options) {
  var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT$1);
  }
  wait = toNumber$1(wait) || 0;
  if (isObject$3(options)) {
    leading = !!options.leading;
    maxing = "maxWait" in options;
    maxWait = maxing ? nativeMax(toNumber$1(options.maxWait) || 0, wait) : maxWait;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  function invokeFunc(time) {
    var args = lastArgs, thisArg = lastThis;
    lastArgs = lastThis = void 0;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }
  function leadingEdge(time) {
    lastInvokeTime = time;
    timerId = setTimeout(timerExpired, wait);
    return leading ? invokeFunc(time) : result;
  }
  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
    return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
  }
  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    var time = now$1();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    timerId = setTimeout(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = void 0;
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = void 0;
    return result;
  }
  function cancel() {
    if (timerId !== void 0) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = void 0;
  }
  function flush() {
    return timerId === void 0 ? result : trailingEdge(now$1());
  }
  function debounced() {
    var time = now$1(), isInvoking = shouldInvoke(time);
    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === void 0) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        clearTimeout(timerId);
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === void 0) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}
var FUNC_ERROR_TEXT = "Expected a function";
function throttle(func, wait, options) {
  var leading = true, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  if (isObject$3(options)) {
    leading = "leading" in options ? !!options.leading : leading;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  return debounce(func, wait, {
    "leading": leading,
    "maxWait": wait,
    "trailing": trailing
  });
}
var cachedScrollbarWidth = null;
var cachedDevicePixelRatio = null;
if (canUseDom) {
  window.addEventListener("resize", function() {
    if (cachedDevicePixelRatio !== window.devicePixelRatio) {
      cachedDevicePixelRatio = window.devicePixelRatio;
      cachedScrollbarWidth = null;
    }
  });
}
function scrollbarWidth() {
  if (cachedScrollbarWidth === null) {
    if (typeof document === "undefined") {
      cachedScrollbarWidth = 0;
      return cachedScrollbarWidth;
    }
    var body = document.body;
    var box = document.createElement("div");
    box.classList.add("simplebar-hide-scrollbar");
    body.appendChild(box);
    var width = box.getBoundingClientRect().right;
    body.removeChild(box);
    cachedScrollbarWidth = width;
  }
  return cachedScrollbarWidth;
}
function getElementWindow(element) {
  if (!element || !element.ownerDocument || !element.ownerDocument.defaultView) {
    return window;
  }
  return element.ownerDocument.defaultView;
}
function getElementDocument(element) {
  if (!element || !element.ownerDocument) {
    return document;
  }
  return element.ownerDocument;
}
function ownKeys$1(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly)
      symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source2 = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys$1(Object(source2), true).forEach(function(key) {
        _defineProperty(target, key, source2[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source2));
    } else {
      ownKeys$1(Object(source2)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source2, key));
      });
    }
  }
  return target;
}
var SimpleBar = /* @__PURE__ */ function() {
  function SimpleBar2(element) {
    var _this = this;
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    _classCallCheck(this, SimpleBar2);
    this.onScroll = function() {
      var elWindow = getElementWindow(_this.el);
      if (!_this.scrollXTicking) {
        elWindow.requestAnimationFrame(_this.scrollX);
        _this.scrollXTicking = true;
      }
      if (!_this.scrollYTicking) {
        elWindow.requestAnimationFrame(_this.scrollY);
        _this.scrollYTicking = true;
      }
      if (!_this.isScrolling) {
        _this.isScrolling = true;
        _this.el.classList.add(_this.classNames.scrolling);
      }
      _this.onStopScrolling();
    };
    this.scrollX = function() {
      if (_this.axis.x.isOverflowing) {
        _this.positionScrollbar("x");
      }
      _this.scrollXTicking = false;
    };
    this.scrollY = function() {
      if (_this.axis.y.isOverflowing) {
        _this.positionScrollbar("y");
      }
      _this.scrollYTicking = false;
    };
    this.onStopScrolling = function() {
      _this.el.classList.remove(_this.classNames.scrolling);
      _this.isScrolling = false;
    };
    this.onMouseEnter = function() {
      if (!_this.isMouseEntering) {
        _this.el.classList.add(_this.classNames.mouseEntered);
        _this.isMouseEntering = true;
      }
      _this.onMouseEntered();
    };
    this.onMouseEntered = function() {
      _this.el.classList.remove(_this.classNames.mouseEntered);
      _this.isMouseEntering = false;
    };
    this.onMouseMove = function(e) {
      _this.mouseX = e.clientX;
      _this.mouseY = e.clientY;
      if (_this.axis.x.isOverflowing || _this.axis.x.forceVisible) {
        _this.onMouseMoveForAxis("x");
      }
      if (_this.axis.y.isOverflowing || _this.axis.y.forceVisible) {
        _this.onMouseMoveForAxis("y");
      }
    };
    this.onMouseLeave = function() {
      _this.onMouseMove.cancel();
      if (_this.axis.x.isOverflowing || _this.axis.x.forceVisible) {
        _this.onMouseLeaveForAxis("x");
      }
      if (_this.axis.y.isOverflowing || _this.axis.y.forceVisible) {
        _this.onMouseLeaveForAxis("y");
      }
      _this.mouseX = -1;
      _this.mouseY = -1;
    };
    this.onWindowResize = function() {
      _this.scrollbarWidth = SimpleBar2.getScrollbarWidth();
      _this.hideNativeScrollbar();
    };
    this.onPointerEvent = function(e) {
      var isWithinTrackXBounds, isWithinTrackYBounds;
      _this.axis.x.track.rect = _this.axis.x.track.el.getBoundingClientRect();
      _this.axis.y.track.rect = _this.axis.y.track.el.getBoundingClientRect();
      if (_this.axis.x.isOverflowing || _this.axis.x.forceVisible) {
        isWithinTrackXBounds = _this.isWithinBounds(_this.axis.x.track.rect);
      }
      if (_this.axis.y.isOverflowing || _this.axis.y.forceVisible) {
        isWithinTrackYBounds = _this.isWithinBounds(_this.axis.y.track.rect);
      }
      if (isWithinTrackXBounds || isWithinTrackYBounds) {
        e.stopPropagation();
        if (e.type === "pointerdown" && e.pointerType !== "touch") {
          if (isWithinTrackXBounds) {
            _this.axis.x.scrollbar.rect = _this.axis.x.scrollbar.el.getBoundingClientRect();
            if (_this.isWithinBounds(_this.axis.x.scrollbar.rect)) {
              _this.onDragStart(e, "x");
            } else {
              _this.onTrackClick(e, "x");
            }
          }
          if (isWithinTrackYBounds) {
            _this.axis.y.scrollbar.rect = _this.axis.y.scrollbar.el.getBoundingClientRect();
            if (_this.isWithinBounds(_this.axis.y.scrollbar.rect)) {
              _this.onDragStart(e, "y");
            } else {
              _this.onTrackClick(e, "y");
            }
          }
        }
      }
    };
    this.drag = function(e) {
      var eventOffset;
      var track2 = _this.axis[_this.draggedAxis].track;
      var trackSize = track2.rect[_this.axis[_this.draggedAxis].sizeAttr];
      var scrollbar = _this.axis[_this.draggedAxis].scrollbar;
      var contentSize = _this.contentWrapperEl[_this.axis[_this.draggedAxis].scrollSizeAttr];
      var hostSize = parseInt(_this.elStyles[_this.axis[_this.draggedAxis].sizeAttr], 10);
      e.preventDefault();
      e.stopPropagation();
      if (_this.draggedAxis === "y") {
        eventOffset = e.pageY;
      } else {
        eventOffset = e.pageX;
      }
      var dragPos = eventOffset - track2.rect[_this.axis[_this.draggedAxis].offsetAttr] - _this.axis[_this.draggedAxis].dragOffset;
      var dragPerc = dragPos / (trackSize - scrollbar.size);
      var scrollPos = dragPerc * (contentSize - hostSize);
      if (_this.draggedAxis === "x") {
        scrollPos = _this.isRtl && SimpleBar2.getRtlHelpers().isScrollOriginAtZero ? scrollPos - (trackSize + scrollbar.size) : scrollPos;
      }
      _this.contentWrapperEl[_this.axis[_this.draggedAxis].scrollOffsetAttr] = scrollPos;
    };
    this.onEndDrag = function(e) {
      var elDocument = getElementDocument(_this.el);
      var elWindow = getElementWindow(_this.el);
      e.preventDefault();
      e.stopPropagation();
      _this.el.classList.remove(_this.classNames.dragging);
      elDocument.removeEventListener("mousemove", _this.drag, true);
      elDocument.removeEventListener("mouseup", _this.onEndDrag, true);
      _this.removePreventClickId = elWindow.setTimeout(function() {
        elDocument.removeEventListener("click", _this.preventClick, true);
        elDocument.removeEventListener("dblclick", _this.preventClick, true);
        _this.removePreventClickId = null;
      });
    };
    this.preventClick = function(e) {
      e.preventDefault();
      e.stopPropagation();
    };
    this.el = element;
    this.minScrollbarWidth = 20;
    this.stopScrollDelay = 175;
    this.options = _objectSpread(_objectSpread({}, SimpleBar2.defaultOptions), options);
    this.classNames = _objectSpread({
      contentEl: "simplebar-content",
      contentWrapper: "simplebar-content-wrapper",
      offset: "simplebar-offset",
      mask: "simplebar-mask",
      wrapper: "simplebar-wrapper",
      placeholder: "simplebar-placeholder",
      scrollbar: "simplebar-scrollbar",
      track: "simplebar-track",
      heightAutoObserverWrapperEl: "simplebar-height-auto-observer-wrapper",
      heightAutoObserverEl: "simplebar-height-auto-observer",
      visible: "simplebar-visible",
      horizontal: "simplebar-horizontal",
      vertical: "simplebar-vertical",
      hover: "simplebar-hover",
      dragging: "simplebar-dragging",
      scrolling: "simplebar-scrolling",
      scrollable: "simplebar-scrollable",
      mouseEntered: "simplebar-mouse-entered"
    }, this.options.classNames);
    this.axis = {
      x: {
        scrollOffsetAttr: "scrollLeft",
        sizeAttr: "width",
        scrollSizeAttr: "scrollWidth",
        offsetSizeAttr: "offsetWidth",
        offsetAttr: "left",
        overflowAttr: "overflowX",
        dragOffset: 0,
        isOverflowing: true,
        isVisible: false,
        forceVisible: false,
        track: {},
        scrollbar: {}
      },
      y: {
        scrollOffsetAttr: "scrollTop",
        sizeAttr: "height",
        scrollSizeAttr: "scrollHeight",
        offsetSizeAttr: "offsetHeight",
        offsetAttr: "top",
        overflowAttr: "overflowY",
        dragOffset: 0,
        isOverflowing: true,
        isVisible: false,
        forceVisible: false,
        track: {},
        scrollbar: {}
      }
    };
    this.removePreventClickId = null;
    this.isScrolling = false;
    this.isMouseEntering = false;
    if (SimpleBar2.instances.has(this.el)) {
      return;
    }
    if (options.classNames) {
      console.warn("simplebar: classNames option is deprecated. Please override the styles with CSS instead.");
    }
    if (options.autoHide) {
      console.warn("simplebar: autoHide option is deprecated. Please use CSS instead: '.simplebar-scrollbar::before { opacity: 0.5 };' for autoHide: false");
    }
    this.onMouseMove = throttle(this.onMouseMove, 64);
    this.onWindowResize = debounce(this.onWindowResize, 64, {
      leading: true
    });
    this.onStopScrolling = debounce(this.onStopScrolling, this.stopScrollDelay);
    this.onMouseEntered = debounce(this.onMouseEntered, this.stopScrollDelay);
    this.init();
  }
  _createClass(SimpleBar2, [{
    key: "init",
    value: function init() {
      SimpleBar2.instances.set(this.el, this);
      if (canUseDom) {
        this.initDOM();
        this.rtlHelpers = SimpleBar2.getRtlHelpers();
        this.scrollbarWidth = SimpleBar2.getScrollbarWidth();
        this.recalculate();
        this.initListeners();
      }
    }
  }, {
    key: "initDOM",
    value: function initDOM() {
      var _this2 = this;
      if (Array.prototype.filter.call(this.el.children, function(child) {
        return child.classList.contains(_this2.classNames.wrapper);
      }).length) {
        this.wrapperEl = this.el.querySelector(".".concat(this.classNames.wrapper));
        this.contentWrapperEl = this.options.scrollableNode || this.el.querySelector(".".concat(this.classNames.contentWrapper));
        this.contentEl = this.options.contentNode || this.el.querySelector(".".concat(this.classNames.contentEl));
        this.offsetEl = this.el.querySelector(".".concat(this.classNames.offset));
        this.maskEl = this.el.querySelector(".".concat(this.classNames.mask));
        this.placeholderEl = this.findChild(this.wrapperEl, ".".concat(this.classNames.placeholder));
        this.heightAutoObserverWrapperEl = this.el.querySelector(".".concat(this.classNames.heightAutoObserverWrapperEl));
        this.heightAutoObserverEl = this.el.querySelector(".".concat(this.classNames.heightAutoObserverEl));
        this.axis.x.track.el = this.findChild(this.el, ".".concat(this.classNames.track, ".").concat(this.classNames.horizontal));
        this.axis.y.track.el = this.findChild(this.el, ".".concat(this.classNames.track, ".").concat(this.classNames.vertical));
      } else {
        this.wrapperEl = document.createElement("div");
        this.contentWrapperEl = document.createElement("div");
        this.offsetEl = document.createElement("div");
        this.maskEl = document.createElement("div");
        this.contentEl = document.createElement("div");
        this.placeholderEl = document.createElement("div");
        this.heightAutoObserverWrapperEl = document.createElement("div");
        this.heightAutoObserverEl = document.createElement("div");
        this.wrapperEl.classList.add(this.classNames.wrapper);
        this.contentWrapperEl.classList.add(this.classNames.contentWrapper);
        this.offsetEl.classList.add(this.classNames.offset);
        this.maskEl.classList.add(this.classNames.mask);
        this.contentEl.classList.add(this.classNames.contentEl);
        this.placeholderEl.classList.add(this.classNames.placeholder);
        this.heightAutoObserverWrapperEl.classList.add(this.classNames.heightAutoObserverWrapperEl);
        this.heightAutoObserverEl.classList.add(this.classNames.heightAutoObserverEl);
        while (this.el.firstChild) {
          this.contentEl.appendChild(this.el.firstChild);
        }
        this.contentWrapperEl.appendChild(this.contentEl);
        this.offsetEl.appendChild(this.contentWrapperEl);
        this.maskEl.appendChild(this.offsetEl);
        this.heightAutoObserverWrapperEl.appendChild(this.heightAutoObserverEl);
        this.wrapperEl.appendChild(this.heightAutoObserverWrapperEl);
        this.wrapperEl.appendChild(this.maskEl);
        this.wrapperEl.appendChild(this.placeholderEl);
        this.el.appendChild(this.wrapperEl);
      }
      if (!this.axis.x.track.el || !this.axis.y.track.el) {
        var track2 = document.createElement("div");
        var scrollbar = document.createElement("div");
        track2.classList.add(this.classNames.track);
        scrollbar.classList.add(this.classNames.scrollbar);
        track2.appendChild(scrollbar);
        this.axis.x.track.el = track2.cloneNode(true);
        this.axis.x.track.el.classList.add(this.classNames.horizontal);
        this.axis.y.track.el = track2.cloneNode(true);
        this.axis.y.track.el.classList.add(this.classNames.vertical);
        this.el.appendChild(this.axis.x.track.el);
        this.el.appendChild(this.axis.y.track.el);
      }
      this.axis.x.scrollbar.el = this.axis.x.track.el.querySelector(".".concat(this.classNames.scrollbar));
      this.axis.y.scrollbar.el = this.axis.y.track.el.querySelector(".".concat(this.classNames.scrollbar));
      if (!this.options.autoHide) {
        this.axis.x.scrollbar.el.classList.add(this.classNames.visible);
        this.axis.y.scrollbar.el.classList.add(this.classNames.visible);
      }
      this.el.setAttribute("data-simplebar", "init");
    }
  }, {
    key: "initListeners",
    value: function initListeners() {
      var _this3 = this;
      var elWindow = getElementWindow(this.el);
      this.el.addEventListener("mouseenter", this.onMouseEnter);
      this.el.addEventListener("pointerdown", this.onPointerEvent, true);
      this.el.addEventListener("mousemove", this.onMouseMove);
      this.el.addEventListener("mouseleave", this.onMouseLeave);
      this.contentWrapperEl.addEventListener("scroll", this.onScroll);
      elWindow.addEventListener("resize", this.onWindowResize);
      if (window.ResizeObserver) {
        var resizeObserverStarted = false;
        var resizeObserver = elWindow.ResizeObserver || ResizeObserver;
        this.resizeObserver = new resizeObserver(function() {
          if (!resizeObserverStarted)
            return;
          elWindow.requestAnimationFrame(function() {
            _this3.recalculate();
          });
        });
        this.resizeObserver.observe(this.el);
        this.resizeObserver.observe(this.contentEl);
        elWindow.requestAnimationFrame(function() {
          resizeObserverStarted = true;
        });
      }
      this.mutationObserver = new elWindow.MutationObserver(function() {
        elWindow.requestAnimationFrame(function() {
          _this3.recalculate();
        });
      });
      this.mutationObserver.observe(this.contentEl, {
        childList: true,
        subtree: true,
        characterData: true
      });
    }
  }, {
    key: "recalculate",
    value: function recalculate() {
      var elWindow = getElementWindow(this.el);
      this.elStyles = elWindow.getComputedStyle(this.el);
      this.isRtl = this.elStyles.direction === "rtl";
      var contentElOffsetWidth = this.contentEl.offsetWidth;
      var isHeightAuto = this.heightAutoObserverEl.offsetHeight <= 1;
      var isWidthAuto = this.heightAutoObserverEl.offsetWidth <= 1 || contentElOffsetWidth > 0;
      var contentWrapperElOffsetWidth = this.contentWrapperEl.offsetWidth;
      var elOverflowX = this.elStyles.overflowX;
      var elOverflowY = this.elStyles.overflowY;
      this.contentEl.style.padding = "".concat(this.elStyles.paddingTop, " ").concat(this.elStyles.paddingRight, " ").concat(this.elStyles.paddingBottom, " ").concat(this.elStyles.paddingLeft);
      this.wrapperEl.style.margin = "-".concat(this.elStyles.paddingTop, " -").concat(this.elStyles.paddingRight, " -").concat(this.elStyles.paddingBottom, " -").concat(this.elStyles.paddingLeft);
      var contentElScrollHeight = this.contentEl.scrollHeight;
      var contentElScrollWidth = this.contentEl.scrollWidth;
      this.contentWrapperEl.style.height = isHeightAuto ? "auto" : "100%";
      this.placeholderEl.style.width = isWidthAuto ? "".concat(contentElOffsetWidth || contentElScrollWidth, "px") : "auto";
      this.placeholderEl.style.height = "".concat(contentElScrollHeight, "px");
      var contentWrapperElOffsetHeight = this.contentWrapperEl.offsetHeight;
      this.axis.x.isOverflowing = contentElOffsetWidth !== 0 && contentElScrollWidth > contentElOffsetWidth;
      this.axis.y.isOverflowing = contentElScrollHeight > contentWrapperElOffsetHeight;
      this.axis.x.isOverflowing = elOverflowX === "hidden" ? false : this.axis.x.isOverflowing;
      this.axis.y.isOverflowing = elOverflowY === "hidden" ? false : this.axis.y.isOverflowing;
      this.axis.x.forceVisible = this.options.forceVisible === "x" || this.options.forceVisible === true;
      this.axis.y.forceVisible = this.options.forceVisible === "y" || this.options.forceVisible === true;
      this.hideNativeScrollbar();
      var offsetForXScrollbar = this.axis.x.isOverflowing ? this.scrollbarWidth : 0;
      var offsetForYScrollbar = this.axis.y.isOverflowing ? this.scrollbarWidth : 0;
      this.axis.x.isOverflowing = this.axis.x.isOverflowing && contentElScrollWidth > contentWrapperElOffsetWidth - offsetForYScrollbar;
      this.axis.y.isOverflowing = this.axis.y.isOverflowing && contentElScrollHeight > contentWrapperElOffsetHeight - offsetForXScrollbar;
      this.axis.x.scrollbar.size = this.getScrollbarSize("x");
      this.axis.y.scrollbar.size = this.getScrollbarSize("y");
      this.axis.x.scrollbar.el.style.width = "".concat(this.axis.x.scrollbar.size, "px");
      this.axis.y.scrollbar.el.style.height = "".concat(this.axis.y.scrollbar.size, "px");
      this.positionScrollbar("x");
      this.positionScrollbar("y");
      this.toggleTrackVisibility("x");
      this.toggleTrackVisibility("y");
    }
  }, {
    key: "getScrollbarSize",
    value: function getScrollbarSize() {
      var axis = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "y";
      if (!this.axis[axis].isOverflowing) {
        return 0;
      }
      var contentSize = this.contentEl[this.axis[axis].scrollSizeAttr];
      var trackSize = this.axis[axis].track.el[this.axis[axis].offsetSizeAttr];
      var scrollbarSize;
      var scrollbarRatio = trackSize / contentSize;
      scrollbarSize = Math.max(~~(scrollbarRatio * trackSize), this.options.scrollbarMinSize);
      if (this.options.scrollbarMaxSize) {
        scrollbarSize = Math.min(scrollbarSize, this.options.scrollbarMaxSize);
      }
      return scrollbarSize;
    }
  }, {
    key: "positionScrollbar",
    value: function positionScrollbar() {
      var axis = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "y";
      if (!this.axis[axis].isOverflowing) {
        return;
      }
      var contentSize = this.contentWrapperEl[this.axis[axis].scrollSizeAttr];
      var trackSize = this.axis[axis].track.el[this.axis[axis].offsetSizeAttr];
      var hostSize = parseInt(this.elStyles[this.axis[axis].sizeAttr], 10);
      var scrollbar = this.axis[axis].scrollbar;
      var scrollOffset = this.contentWrapperEl[this.axis[axis].scrollOffsetAttr];
      scrollOffset = axis === "x" && this.isRtl && SimpleBar2.getRtlHelpers().isScrollOriginAtZero ? -scrollOffset : scrollOffset;
      var scrollPourcent = scrollOffset / (contentSize - hostSize);
      var handleOffset = ~~((trackSize - scrollbar.size) * scrollPourcent);
      handleOffset = axis === "x" && this.isRtl && SimpleBar2.getRtlHelpers().isScrollingToNegative ? -handleOffset + (trackSize - scrollbar.size) : handleOffset;
      scrollbar.el.style.transform = axis === "x" ? "translate3d(".concat(handleOffset, "px, 0, 0)") : "translate3d(0, ".concat(handleOffset, "px, 0)");
    }
  }, {
    key: "toggleTrackVisibility",
    value: function toggleTrackVisibility() {
      var axis = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "y";
      var track2 = this.axis[axis].track.el;
      var scrollbar = this.axis[axis].scrollbar.el;
      if (this.axis[axis].isOverflowing || this.axis[axis].forceVisible) {
        track2.style.visibility = "visible";
        this.contentWrapperEl.style[this.axis[axis].overflowAttr] = "scroll";
        this.el.classList.add("".concat(this.classNames.scrollable, "-").concat(axis));
      } else {
        track2.style.visibility = "hidden";
        this.contentWrapperEl.style[this.axis[axis].overflowAttr] = "hidden";
        this.el.classList.remove("".concat(this.classNames.scrollable, "-").concat(axis));
      }
      if (this.axis[axis].isOverflowing) {
        scrollbar.style.display = "block";
      } else {
        scrollbar.style.display = "none";
      }
    }
  }, {
    key: "hideNativeScrollbar",
    value: function hideNativeScrollbar() {
      this.offsetEl.style[this.isRtl ? "left" : "right"] = this.axis.y.isOverflowing || this.axis.y.forceVisible ? "-".concat(this.scrollbarWidth, "px") : 0;
      this.offsetEl.style.bottom = this.axis.x.isOverflowing || this.axis.x.forceVisible ? "-".concat(this.scrollbarWidth, "px") : 0;
    }
  }, {
    key: "onMouseMoveForAxis",
    value: function onMouseMoveForAxis() {
      var axis = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "y";
      this.axis[axis].track.rect = this.axis[axis].track.el.getBoundingClientRect();
      this.axis[axis].scrollbar.rect = this.axis[axis].scrollbar.el.getBoundingClientRect();
      var isWithinScrollbarBoundsX = this.isWithinBounds(this.axis[axis].scrollbar.rect);
      if (isWithinScrollbarBoundsX) {
        this.axis[axis].scrollbar.el.classList.add(this.classNames.hover);
      } else {
        this.axis[axis].scrollbar.el.classList.remove(this.classNames.hover);
      }
      if (this.isWithinBounds(this.axis[axis].track.rect)) {
        this.axis[axis].track.el.classList.add(this.classNames.hover);
      } else {
        this.axis[axis].track.el.classList.remove(this.classNames.hover);
      }
    }
  }, {
    key: "onMouseLeaveForAxis",
    value: function onMouseLeaveForAxis() {
      var axis = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "y";
      this.axis[axis].track.el.classList.remove(this.classNames.hover);
      this.axis[axis].scrollbar.el.classList.remove(this.classNames.hover);
    }
  }, {
    key: "onDragStart",
    value: function onDragStart(e) {
      var axis = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "y";
      var elDocument = getElementDocument(this.el);
      var elWindow = getElementWindow(this.el);
      var scrollbar = this.axis[axis].scrollbar;
      var eventOffset = axis === "y" ? e.pageY : e.pageX;
      this.axis[axis].dragOffset = eventOffset - scrollbar.rect[this.axis[axis].offsetAttr];
      this.draggedAxis = axis;
      this.el.classList.add(this.classNames.dragging);
      elDocument.addEventListener("mousemove", this.drag, true);
      elDocument.addEventListener("mouseup", this.onEndDrag, true);
      if (this.removePreventClickId === null) {
        elDocument.addEventListener("click", this.preventClick, true);
        elDocument.addEventListener("dblclick", this.preventClick, true);
      } else {
        elWindow.clearTimeout(this.removePreventClickId);
        this.removePreventClickId = null;
      }
    }
  }, {
    key: "onTrackClick",
    value: function onTrackClick(e) {
      var _this4 = this;
      var axis = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "y";
      if (!this.options.clickOnTrack)
        return;
      e.preventDefault();
      var elWindow = getElementWindow(this.el);
      this.axis[axis].scrollbar.rect = this.axis[axis].scrollbar.el.getBoundingClientRect();
      var scrollbar = this.axis[axis].scrollbar;
      var scrollbarOffset = scrollbar.rect[this.axis[axis].offsetAttr];
      var hostSize = parseInt(this.elStyles[this.axis[axis].sizeAttr], 10);
      var scrolled = this.contentWrapperEl[this.axis[axis].scrollOffsetAttr];
      var t = axis === "y" ? this.mouseY - scrollbarOffset : this.mouseX - scrollbarOffset;
      var dir = t < 0 ? -1 : 1;
      var scrollSize = dir === -1 ? scrolled - hostSize : scrolled + hostSize;
      var speed = 40;
      var scrollTo = function scrollTo2() {
        if (dir === -1) {
          if (scrolled > scrollSize) {
            scrolled -= speed;
            _this4.contentWrapperEl[_this4.axis[axis].scrollOffsetAttr] = scrolled;
            elWindow.requestAnimationFrame(scrollTo2);
          }
        } else {
          if (scrolled < scrollSize) {
            scrolled += speed;
            _this4.contentWrapperEl[_this4.axis[axis].scrollOffsetAttr] = scrolled;
            elWindow.requestAnimationFrame(scrollTo2);
          }
        }
      };
      scrollTo();
    }
  }, {
    key: "getContentElement",
    value: function getContentElement() {
      return this.contentEl;
    }
  }, {
    key: "getScrollElement",
    value: function getScrollElement() {
      return this.contentWrapperEl;
    }
  }, {
    key: "removeListeners",
    value: function removeListeners() {
      var elWindow = getElementWindow(this.el);
      this.el.removeEventListener("mouseenter", this.onMouseEnter);
      this.el.removeEventListener("pointerdown", this.onPointerEvent, true);
      this.el.removeEventListener("mousemove", this.onMouseMove);
      this.el.removeEventListener("mouseleave", this.onMouseLeave);
      if (this.contentWrapperEl) {
        this.contentWrapperEl.removeEventListener("scroll", this.onScroll);
      }
      elWindow.removeEventListener("resize", this.onWindowResize);
      if (this.mutationObserver) {
        this.mutationObserver.disconnect();
      }
      if (this.resizeObserver) {
        this.resizeObserver.disconnect();
      }
      this.onMouseMove.cancel();
      this.onWindowResize.cancel();
      this.onStopScrolling.cancel();
      this.onMouseEntered.cancel();
    }
  }, {
    key: "unMount",
    value: function unMount() {
      this.removeListeners();
      SimpleBar2.instances.delete(this.el);
    }
  }, {
    key: "isWithinBounds",
    value: function isWithinBounds(bbox) {
      return this.mouseX >= bbox.left && this.mouseX <= bbox.left + bbox.width && this.mouseY >= bbox.top && this.mouseY <= bbox.top + bbox.height;
    }
  }, {
    key: "findChild",
    value: function findChild(el, query) {
      var matches = el.matches || el.webkitMatchesSelector || el.mozMatchesSelector || el.msMatchesSelector;
      return Array.prototype.filter.call(el.children, function(child) {
        return matches.call(child, query);
      })[0];
    }
  }], [{
    key: "getRtlHelpers",
    value: function getRtlHelpers() {
      if (SimpleBar2.rtlHelpers) {
        return SimpleBar2.rtlHelpers;
      }
      var dummyDiv = document.createElement("div");
      dummyDiv.innerHTML = '<div class="simplebar-dummy-scrollbar-size"><div></div></div>';
      var scrollbarDummyEl = dummyDiv.firstElementChild;
      var dummyChild = scrollbarDummyEl.firstElementChild;
      document.body.appendChild(scrollbarDummyEl);
      scrollbarDummyEl.scrollLeft = 0;
      var dummyContainerOffset = SimpleBar2.getOffset(scrollbarDummyEl);
      var dummyChildOffset = SimpleBar2.getOffset(dummyChild);
      scrollbarDummyEl.scrollLeft = -999;
      var dummyChildOffsetAfterScroll = SimpleBar2.getOffset(dummyChild);
      document.body.removeChild(scrollbarDummyEl);
      SimpleBar2.rtlHelpers = {
        isScrollOriginAtZero: dummyContainerOffset.left !== dummyChildOffset.left,
        isScrollingToNegative: dummyChildOffset.left !== dummyChildOffsetAfterScroll.left
      };
      return SimpleBar2.rtlHelpers;
    }
  }, {
    key: "getScrollbarWidth",
    value: function getScrollbarWidth() {
      try {
        if (getComputedStyle(this.contentWrapperEl, "::-webkit-scrollbar").display === "none" || "scrollbarWidth" in document.documentElement.style || "-ms-overflow-style" in document.documentElement.style) {
          return 0;
        } else {
          return scrollbarWidth();
        }
      } catch (e) {
        return scrollbarWidth();
      }
    }
  }, {
    key: "getOffset",
    value: function getOffset(el) {
      var rect = el.getBoundingClientRect();
      var elDocument = getElementDocument(el);
      var elWindow = getElementWindow(el);
      return {
        top: rect.top + (elWindow.pageYOffset || elDocument.documentElement.scrollTop),
        left: rect.left + (elWindow.pageXOffset || elDocument.documentElement.scrollLeft)
      };
    }
  }]);
  return SimpleBar2;
}();
SimpleBar.defaultOptions = {
  autoHide: true,
  forceVisible: false,
  clickOnTrack: true,
  scrollbarMinSize: 25,
  scrollbarMaxSize: 0
};
SimpleBar.instances = new WeakMap();
var SimpleBar$1 = SimpleBar;
var getOptions = function getOptions2(obj) {
  var options = Array.prototype.reduce.call(obj, function(acc, attribute) {
    var option = attribute.name.match(/data-simplebar-(.+)/);
    if (option) {
      var key = option[1].replace(/\W+(.)/g, function(x, chr) {
        return chr.toUpperCase();
      });
      switch (attribute.value) {
        case "true":
          acc[key] = true;
          break;
        case "false":
          acc[key] = false;
          break;
        case void 0:
          acc[key] = true;
          break;
        default:
          acc[key] = attribute.value;
      }
    }
    return acc;
  }, {});
  return options;
};
SimpleBar$1.initDOMLoadedElements = function() {
  document.removeEventListener("DOMContentLoaded", this.initDOMLoadedElements);
  window.removeEventListener("load", this.initDOMLoadedElements);
  Array.prototype.forEach.call(document.querySelectorAll("[data-simplebar]"), function(el) {
    if (el.getAttribute("data-simplebar") !== "init" && !SimpleBar$1.instances.has(el))
      new SimpleBar$1(el, getOptions(el.attributes));
  });
};
SimpleBar$1.removeObserver = function() {
  this.globalObserver.disconnect();
};
SimpleBar$1.initHtmlApi = function() {
  this.initDOMLoadedElements = this.initDOMLoadedElements.bind(this);
  if (typeof MutationObserver !== "undefined") {
    this.globalObserver = new MutationObserver(SimpleBar$1.handleMutations);
    this.globalObserver.observe(document, {
      childList: true,
      subtree: true
    });
  }
  if (document.readyState === "complete" || document.readyState !== "loading" && !document.documentElement.doScroll) {
    window.setTimeout(this.initDOMLoadedElements);
  } else {
    document.addEventListener("DOMContentLoaded", this.initDOMLoadedElements);
    window.addEventListener("load", this.initDOMLoadedElements);
  }
};
SimpleBar$1.handleMutations = function(mutations) {
  mutations.forEach(function(mutation) {
    Array.prototype.forEach.call(mutation.addedNodes, function(addedNode) {
      if (addedNode.nodeType === 1) {
        if (addedNode.hasAttribute("data-simplebar")) {
          !SimpleBar$1.instances.has(addedNode) && new SimpleBar$1(addedNode, getOptions(addedNode.attributes));
        } else {
          Array.prototype.forEach.call(addedNode.querySelectorAll("[data-simplebar]"), function(el) {
            if (el.getAttribute("data-simplebar") !== "init" && !SimpleBar$1.instances.has(el))
              new SimpleBar$1(el, getOptions(el.attributes));
          });
        }
      }
    });
    Array.prototype.forEach.call(mutation.removedNodes, function(removedNode) {
      if (removedNode.nodeType === 1) {
        if (removedNode.hasAttribute("data-simplebar")) {
          SimpleBar$1.instances.has(removedNode) && SimpleBar$1.instances.get(removedNode).unMount();
        } else {
          Array.prototype.forEach.call(removedNode.querySelectorAll('[data-simplebar="init"]'), function(el) {
            SimpleBar$1.instances.has(el) && SimpleBar$1.instances.get(el).unMount();
          });
        }
      }
    });
  });
};
SimpleBar$1.getOptions = getOptions;
SimpleBar$1.default = SimpleBar$1;
if (canUseDom) {
  SimpleBar$1.initHtmlApi();
}
var iconify_min = {};
/**
* (c) Iconify
*
* For the full copyright and license information, please view the license.txt or license.gpl.txt
* files at https://github.com/iconify/iconify
*
* Licensed under Apache 2.0 or GPL 2.0 at your option.
* If derivative product is not compatible with one of licenses, you can pick one of licenses.
*
* @license Apache 2.0
* @license GPL 2.0
*/
(function(exports) {
  var Iconify = function() {
    function e(e2, n2, t2) {
      return e2(t2 = { path: n2, exports: {}, require: function(e3, n3) {
        return function() {
          throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
        }(n3 == null && t2.path);
      } }, t2.exports), t2.exports;
    }
    var n = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.fullIcon = n2.iconDefaults = n2.minifyProps = n2.matchName = void 0, n2.matchName = /^[a-z0-9]+(-[a-z0-9]+)*$/, n2.minifyProps = ["width", "height", "top", "left"], n2.iconDefaults = Object.freeze({ left: 0, top: 0, width: 16, height: 16, rotate: 0, vFlip: false, hFlip: false }), n2.fullIcon = function(e3) {
        return Object.assign({}, n2.iconDefaults, e3);
      };
    }), t = e(function(e2, t2) {
      Object.defineProperty(t2, "__esModule", { value: true }), t2.mergeIconData = void 0, t2.mergeIconData = function(e3, t3) {
        var r2 = Object.assign({}, e3);
        for (var o2 in n.iconDefaults) {
          var i2 = o2;
          if (t3[i2] !== void 0) {
            var a2 = t3[i2];
            if (r2[i2] === void 0) {
              r2[i2] = a2;
              continue;
            }
            switch (i2) {
              case "rotate":
                r2[i2] = (r2[i2] + a2) % 4;
                break;
              case "hFlip":
              case "vFlip":
                r2[i2] = a2 !== r2[i2];
                break;
              default:
                r2[i2] = a2;
            }
          }
        }
        return r2;
      };
    }), r = e(function(e2, r2) {
      Object.defineProperty(r2, "__esModule", { value: true }), r2.parseIconSet = void 0;
      var o2 = Object.keys(n.iconDefaults);
      function i2(e3, n2, r3, o3) {
        o3 === void 0 && (o3 = 0);
        var a2 = e3.parent;
        if (n2[a2] !== void 0)
          return t.mergeIconData(n2[a2], e3);
        if (r3[a2] !== void 0) {
          if (o3 > 2)
            return null;
          var c2 = i2(r3[a2], n2, r3, o3 + 1);
          if (c2)
            return t.mergeIconData(c2, e3);
        }
        return null;
      }
      r2.parseIconSet = function(e3, t2, r3) {
        r3 === void 0 && (r3 = "none");
        var a2 = [];
        if (typeof e3 != "object")
          return r3 !== "none" && a2;
        if (e3.not_found instanceof Array && e3.not_found.forEach(function(e4) {
          t2(e4, null), r3 === "all" && a2.push(e4);
        }), typeof e3.icons != "object")
          return r3 !== "none" && a2;
        var c2 = Object.create(null);
        o2.forEach(function(n2) {
          e3[n2] !== void 0 && typeof e3[n2] != "object" && (c2[n2] = e3[n2]);
        });
        var u2 = e3.icons;
        if (Object.keys(u2).forEach(function(e4) {
          var r4 = u2[e4];
          typeof r4.body == "string" && (t2(e4, Object.freeze(Object.assign({}, n.iconDefaults, c2, r4))), a2.push(e4));
        }), typeof e3.aliases == "object") {
          var f2 = e3.aliases;
          Object.keys(f2).forEach(function(e4) {
            var r4 = i2(f2[e4], u2, f2, 1);
            r4 && (t2(e4, Object.freeze(Object.assign({}, n.iconDefaults, c2, r4))), a2.push(e4));
          });
        }
        return r3 === "none" ? a2.length > 0 : a2;
      };
    }), o = e(function(e2, t2) {
      Object.defineProperty(t2, "__esModule", { value: true }), t2.validateIcon = t2.stringToIcon = void 0;
      t2.stringToIcon = function(e3, n2, r2, o2) {
        o2 === void 0 && (o2 = "");
        var i2 = e3.split(":");
        if (e3.slice(0, 1) === "@") {
          if (i2.length < 2 || i2.length > 3)
            return null;
          o2 = i2.shift().slice(1);
        }
        if (i2.length > 3 || !i2.length)
          return null;
        if (i2.length > 1) {
          var a2 = i2.pop(), c2 = i2.pop(), u2 = { provider: i2.length > 0 ? i2[0] : o2, prefix: c2, name: a2 };
          return n2 && !t2.validateIcon(u2) ? null : u2;
        }
        var f2 = i2[0], l2 = f2.split("-");
        if (l2.length > 1) {
          var s2 = { provider: o2, prefix: l2.shift(), name: l2.join("-") };
          return n2 && !t2.validateIcon(s2) ? null : s2;
        }
        if (r2 && o2 === "") {
          var d2 = { provider: o2, prefix: "", name: f2 };
          return n2 && !t2.validateIcon(d2, r2) ? null : d2;
        }
        return null;
      };
      t2.validateIcon = function(e3, t3) {
        return !!e3 && !(e3.provider !== "" && !e3.provider.match(n.matchName) || !(t3 && e3.prefix === "" || e3.prefix.match(n.matchName)) || !e3.name.match(n.matchName));
      };
    }), i = e(function(e2, t2) {
      Object.defineProperty(t2, "__esModule", { value: true }), t2.listIcons = t2.getIcon = t2.iconExists = t2.addIcon = t2.addIconSet = t2.getStorage = t2.newStorage = void 0;
      var o2 = Object.create(null);
      function i2(e3, n2) {
        return { provider: e3, prefix: n2, icons: Object.create(null), missing: Object.create(null) };
      }
      function a2(e3, n2) {
        o2[e3] === void 0 && (o2[e3] = Object.create(null));
        var t3 = o2[e3];
        return t3[n2] === void 0 && (t3[n2] = i2(e3, n2)), t3[n2];
      }
      t2.newStorage = i2, t2.getStorage = a2, t2.addIconSet = function(e3, n2, t3) {
        t3 === void 0 && (t3 = "none");
        var o3 = Date.now();
        return r.parseIconSet(n2, function(n3, t4) {
          t4 === null ? e3.missing[n3] = o3 : e3.icons[n3] = t4;
        }, t3);
      }, t2.addIcon = function(e3, t3, r2) {
        try {
          if (typeof r2.body == "string")
            return e3.icons[t3] = Object.freeze(n.fullIcon(r2)), true;
        } catch (e4) {
        }
        return false;
      }, t2.iconExists = function(e3, n2) {
        return e3.icons[n2] !== void 0;
      }, t2.getIcon = function(e3, n2) {
        var t3 = e3.icons[n2];
        return t3 === void 0 ? null : t3;
      }, t2.listIcons = function(e3, n2) {
        var t3 = [];
        return (typeof e3 == "string" ? [e3] : Object.keys(o2)).forEach(function(e4) {
          (typeof e4 == "string" && typeof n2 == "string" ? [n2] : o2[e4] === void 0 ? [] : Object.keys(o2[e4])).forEach(function(n3) {
            var r2 = a2(e4, n3), o3 = Object.keys(r2.icons).map(function(t4) {
              return (e4 !== "" ? "@" + e4 + ":" : "") + n3 + ":" + t4;
            });
            t3 = t3.concat(o3);
          });
        }), t3;
      };
    }), a = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.storageFunctions = n2.addCollection = n2.addIcon = n2.getIconData = n2.allowSimpleNames = void 0;
      var t2 = false;
      function a2(e3) {
        var n3 = typeof e3 == "string" ? o.stringToIcon(e3, true, t2) : e3;
        return n3 ? i.getIcon(i.getStorage(n3.provider, n3.prefix), n3.name) : null;
      }
      function c2(e3, n3) {
        var r2 = o.stringToIcon(e3, true, t2);
        if (!r2)
          return false;
        var a3 = i.getStorage(r2.provider, r2.prefix);
        return i.addIcon(a3, r2.name, n3);
      }
      function u2(e3, n3) {
        if (typeof e3 != "object")
          return false;
        if (typeof n3 != "string" && (n3 = typeof e3.provider == "string" ? e3.provider : ""), t2 && n3 === "" && (typeof e3.prefix != "string" || e3.prefix === "")) {
          var a3 = false;
          return r.parseIconSet(e3, function(e4, n4) {
            n4 !== null && c2(e4, n4) && (a3 = true);
          }), a3;
        }
        if (typeof e3.prefix != "string" || !o.validateIcon({ provider: n3, prefix: e3.prefix, name: "a" }))
          return false;
        var u3 = i.getStorage(n3, e3.prefix);
        return !!i.addIconSet(u3, e3);
      }
      n2.allowSimpleNames = function(e3) {
        return typeof e3 == "boolean" && (t2 = e3), t2;
      }, n2.getIconData = a2, n2.addIcon = c2, n2.addCollection = u2, n2.storageFunctions = { iconExists: function(e3) {
        return a2(e3) !== null;
      }, getIcon: function(e3) {
        var n3 = a2(e3);
        return n3 ? Object.assign({}, n3) : null;
      }, listIcons: i.listIcons, addIcon: c2, addCollection: u2 };
    }), c = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.replaceIDs = void 0;
      var t2 = /\sid="(\S+)"/g, r2 = "([^A-Za-z0-9_-])";
      var o2 = "IconifyId-" + Date.now().toString(16) + "-" + (16777216 * Math.random() | 0).toString(16) + "-", i2 = 0;
      n2.replaceIDs = function(e3, n3) {
        n3 === void 0 && (n3 = o2);
        for (var a2, c2 = []; a2 = t2.exec(e3); )
          c2.push(a2[1]);
        return c2.length ? (c2.forEach(function(t3) {
          var o3 = typeof n3 == "function" ? n3() : n3 + i2++;
          e3 = e3.replace(new RegExp(r2 + "(" + (t3.replace(/[.*+?^${}()|[\]\\]/g, "\\$&") + ")") + r2, "g"), "$1" + o3 + "$3");
        }), e3) : e3;
      };
    }), u = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.calculateSize = void 0;
      var t2 = /(-?[0-9.]*[0-9]+[0-9.]*)/g, r2 = /^-?[0-9.]*[0-9]+[0-9.]*$/g;
      n2.calculateSize = function(e3, n3, o2) {
        if (n3 === 1)
          return e3;
        if (o2 = o2 === void 0 ? 100 : o2, typeof e3 == "number")
          return Math.ceil(e3 * n3 * o2) / o2;
        if (typeof e3 != "string")
          return e3;
        var i2 = e3.split(t2);
        if (i2 === null || !i2.length)
          return e3;
        for (var a2 = [], c2 = i2.shift(), u2 = r2.test(c2); ; ) {
          if (u2) {
            var f2 = parseFloat(c2);
            isNaN(f2) ? a2.push(c2) : a2.push(Math.ceil(f2 * n3 * o2) / o2);
          } else
            a2.push(c2);
          if ((c2 = i2.shift()) === void 0)
            return a2.join("");
          u2 = !u2;
        }
      };
    }), f = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.mergeCustomisations = n2.defaults = void 0, n2.defaults = Object.freeze({ inline: false, width: null, height: null, hAlign: "center", vAlign: "middle", slice: false, hFlip: false, vFlip: false, rotate: 0 }), n2.mergeCustomisations = function(e3, n3) {
        var t2 = {};
        for (var r2 in e3) {
          var o2 = r2;
          if (t2[o2] = e3[o2], n3[o2] !== void 0) {
            var i2 = n3[o2];
            switch (o2) {
              case "inline":
              case "slice":
                typeof i2 == "boolean" && (t2[o2] = i2);
                break;
              case "hFlip":
              case "vFlip":
                i2 === true && (t2[o2] = !t2[o2]);
                break;
              case "hAlign":
              case "vAlign":
                typeof i2 == "string" && i2 !== "" && (t2[o2] = i2);
                break;
              case "width":
              case "height":
                (typeof i2 == "string" && i2 !== "" || typeof i2 == "number" && i2 || i2 === null) && (t2[o2] = i2);
                break;
              case "rotate":
                typeof i2 == "number" && (t2[o2] += i2);
            }
          }
        }
        return t2;
      };
    }), l = e(function(e2, n2) {
      function t2(e3) {
        var n3 = "";
        switch (e3.hAlign) {
          case "left":
            n3 += "xMin";
            break;
          case "right":
            n3 += "xMax";
            break;
          default:
            n3 += "xMid";
        }
        switch (e3.vAlign) {
          case "top":
            n3 += "YMin";
            break;
          case "bottom":
            n3 += "YMax";
            break;
          default:
            n3 += "YMid";
        }
        return n3 += e3.slice ? " slice" : " meet";
      }
      Object.defineProperty(n2, "__esModule", { value: true }), n2.iconToSVG = void 0, n2.iconToSVG = function(e3, n3) {
        var r2, o2, i2 = { left: e3.left, top: e3.top, width: e3.width, height: e3.height }, a2 = e3.body;
        [e3, n3].forEach(function(e4) {
          var n4, t3 = [], r3 = e4.hFlip, o3 = e4.vFlip, c3 = e4.rotate;
          switch (r3 ? o3 ? c3 += 2 : (t3.push("translate(" + (i2.width + i2.left) + " " + (0 - i2.top) + ")"), t3.push("scale(-1 1)"), i2.top = i2.left = 0) : o3 && (t3.push("translate(" + (0 - i2.left) + " " + (i2.height + i2.top) + ")"), t3.push("scale(1 -1)"), i2.top = i2.left = 0), c3 < 0 && (c3 -= 4 * Math.floor(c3 / 4)), c3 %= 4) {
            case 1:
              n4 = i2.height / 2 + i2.top, t3.unshift("rotate(90 " + n4 + " " + n4 + ")");
              break;
            case 2:
              t3.unshift("rotate(180 " + (i2.width / 2 + i2.left) + " " + (i2.height / 2 + i2.top) + ")");
              break;
            case 3:
              n4 = i2.width / 2 + i2.left, t3.unshift("rotate(-90 " + n4 + " " + n4 + ")");
          }
          c3 % 2 == 1 && (i2.left === 0 && i2.top === 0 || (n4 = i2.left, i2.left = i2.top, i2.top = n4), i2.width !== i2.height && (n4 = i2.width, i2.width = i2.height, i2.height = n4)), t3.length && (a2 = '<g transform="' + t3.join(" ") + '">' + a2 + "</g>");
        }), n3.width === null && n3.height === null ? (o2 = "1em", r2 = u.calculateSize(o2, i2.width / i2.height)) : n3.width !== null && n3.height !== null ? (r2 = n3.width, o2 = n3.height) : n3.height !== null ? (o2 = n3.height, r2 = u.calculateSize(o2, i2.width / i2.height)) : (r2 = n3.width, o2 = u.calculateSize(r2, i2.height / i2.width)), r2 === "auto" && (r2 = i2.width), o2 === "auto" && (o2 = i2.height);
        var c2 = { attributes: { width: r2 = typeof r2 == "string" ? r2 : r2 + "", height: o2 = typeof o2 == "string" ? o2 : o2 + "", preserveAspectRatio: t2(n3), viewBox: i2.left + " " + i2.top + " " + i2.width + " " + i2.height }, body: a2 };
        return n3.inline && (c2.inline = true), c2;
      };
    }), s = e(function(e2, t2) {
      Object.defineProperty(t2, "__esModule", { value: true }), t2.builderFunctions = void 0, t2.builderFunctions = { replaceIDs: c.replaceIDs, calculateSize: u.calculateSize, buildIcon: function(e3, t3) {
        return l.iconToSVG(n.fullIcon(e3), f.mergeCustomisations(f.defaults, t3));
      } };
    }), d = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.coreModules = void 0, n2.coreModules = {};
    }), v = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.storeCache = n2.loadCache = n2.mock = n2.emptyList = n2.count = n2.config = void 0;
      var t2 = "iconify2", r2 = "iconify", o2 = "iconify-count", a2 = "iconify-version", c2 = 36e5;
      n2.config = { local: true, session: true };
      var u2 = false;
      n2.count = { local: 0, session: 0 }, n2.emptyList = { local: [], session: [] };
      var f2 = typeof window == "undefined" ? {} : window;
      function l2(e3) {
        var t3 = e3 + "Storage";
        try {
          if (f2 && f2[t3] && typeof f2[t3].length == "number")
            return f2[t3];
        } catch (e4) {
        }
        return n2.config[e3] = false, null;
      }
      function s2(e3, t3, r3) {
        try {
          return e3.setItem(o2, r3 + ""), n2.count[t3] = r3, true;
        } catch (e4) {
          return false;
        }
      }
      function d2(e3) {
        var n3 = e3.getItem(o2);
        if (n3) {
          var t3 = parseInt(n3);
          return t3 || 0;
        }
        return 0;
      }
      n2.mock = function(e3) {
        u2 = false, f2 = e3;
      };
      n2.loadCache = function() {
        if (!u2) {
          u2 = true;
          var e3 = Math.floor(Date.now() / c2) - 168;
          for (var o3 in n2.config)
            f3(o3);
        }
        function f3(o4) {
          var c3 = l2(o4);
          if (c3) {
            var u3 = function(n3) {
              var t3 = r2 + n3, o5 = c3.getItem(t3);
              if (typeof o5 != "string")
                return false;
              var a3 = true;
              try {
                var u4 = JSON.parse(o5);
                if (typeof u4 != "object" || typeof u4.cached != "number" || u4.cached < e3 || typeof u4.provider != "string" || typeof u4.data != "object" || typeof u4.data.prefix != "string")
                  a3 = false;
                else {
                  var f5 = u4.provider, l3 = u4.data.prefix, s3 = i.getStorage(f5, l3);
                  a3 = i.addIconSet(s3, u4.data);
                }
              } catch (e4) {
                a3 = false;
              }
              return a3 || c3.removeItem(t3), a3;
            };
            try {
              var f4 = c3.getItem(a2);
              if (f4 !== t2)
                return f4 && function(e4) {
                  try {
                    for (var n3 = d2(e4), t3 = 0; t3 < n3; t3++)
                      e4.removeItem(r2 + t3);
                  } catch (e5) {
                  }
                }(c3), void function(e4, n3) {
                  try {
                    e4.setItem(a2, t2);
                  } catch (e5) {
                  }
                  s2(e4, n3, 0);
                }(c3, o4);
              for (var v2 = d2(c3), p3 = v2 - 1; p3 >= 0; p3--)
                u3(p3) || (p3 === v2 - 1 ? v2-- : n2.emptyList[o4].push(p3));
              s2(c3, o4, v2);
            } catch (e4) {
            }
          }
        }
      };
      n2.storeCache = function(e3, t3) {
        function o3(o4) {
          if (!n2.config[o4])
            return false;
          var i2 = l2(o4);
          if (!i2)
            return false;
          var a3 = n2.emptyList[o4].shift();
          if (a3 === void 0 && !s2(i2, o4, (a3 = n2.count[o4]) + 1))
            return false;
          try {
            var u3 = { cached: Math.floor(Date.now() / c2), provider: e3, data: t3 };
            i2.setItem(r2 + a3, JSON.stringify(u3));
          } catch (e4) {
            return false;
          }
          return true;
        }
        u2 || n2.loadCache(), o3("local") || o3("session");
      };
    }), p2 = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.toggleBrowserCache = void 0, n2.toggleBrowserCache = function(e3, n3) {
        switch (e3) {
          case "local":
          case "session":
            v.config[e3] = n3;
            break;
          case "all":
            for (var t2 in v.config)
              v.config[t2] = n3;
        }
      };
    }), h2 = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.defaultConfig = void 0, n2.defaultConfig = { resources: [], index: 0, timeout: 2e3, rotate: 750, random: false, dataAfterTimeout: false };
    }), g = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.sendQuery = void 0, n2.sendQuery = function(e3, n3, t2, r2, o2) {
        var i2, a2 = e3.resources.length, c2 = e3.random ? Math.floor(Math.random() * a2) : e3.index;
        if (e3.random) {
          var u2 = e3.resources.slice(0);
          for (i2 = []; u2.length > 1; ) {
            var f2 = Math.floor(Math.random() * u2.length);
            i2.push(u2[f2]), u2 = u2.slice(0, f2).concat(u2.slice(f2 + 1));
          }
          i2 = i2.concat(u2);
        } else
          i2 = e3.resources.slice(c2).concat(e3.resources.slice(0, c2));
        var l2 = Date.now(), s2 = "pending", d2 = 0, v2 = void 0, p3 = null, h3 = [], g2 = [];
        function m2() {
          p3 && (clearTimeout(p3), p3 = null);
        }
        function b2() {
          s2 === "pending" && (s2 = "aborted"), m2(), h3.forEach(function(e4) {
            e4.abort && e4.abort(), e4.status === "pending" && (e4.status = "aborted");
          }), h3 = [];
        }
        function y2(e4, n4) {
          n4 && (g2 = []), typeof e4 == "function" && g2.push(e4);
        }
        function I2() {
          return { startTime: l2, payload: n3, status: s2, queriesSent: d2, queriesPending: h3.length, subscribe: y2, abort: b2 };
        }
        function j2() {
          s2 = "failed", g2.forEach(function(e4) {
            e4(void 0, v2);
          });
        }
        function x2() {
          h3 = h3.filter(function(e4) {
            return e4.status === "pending" && (e4.status = "aborted"), e4.abort && e4.abort(), false;
          });
        }
        function O2() {
          if (s2 === "pending") {
            m2();
            var r3 = i2.shift();
            if (r3 !== void 0) {
              var a3 = { getQueryStatus: I2, status: "pending", resource: r3, done: function(n4, t3) {
                !function(n5, t4, r4) {
                  var a4 = t4 === void 0;
                  switch (h3 = h3.filter(function(e4) {
                    return e4 !== n5;
                  }), s2) {
                    case "pending":
                      break;
                    case "failed":
                      if (a4 || !e3.dataAfterTimeout)
                        return;
                      break;
                    default:
                      return;
                  }
                  if (a4)
                    return r4 !== void 0 && (v2 = r4), void (h3.length || (i2.length ? O2() : j2()));
                  if (m2(), x2(), o2 && !e3.random) {
                    var c4 = e3.resources.indexOf(n5.resource);
                    c4 !== -1 && c4 !== e3.index && o2(c4);
                  }
                  s2 = "completed", g2.forEach(function(e4) {
                    e4(t4);
                  });
                }(a3, n4, t3);
              } };
              h3.push(a3), d2++;
              var c3 = typeof e3.rotate == "function" ? e3.rotate(d2, l2) : e3.rotate;
              p3 = setTimeout(O2, c3), t2(r3, n3, a3);
            } else {
              if (h3.length) {
                var u3 = typeof e3.timeout == "function" ? e3.timeout(l2) : e3.timeout;
                if (u3)
                  return void (p3 = setTimeout(function() {
                    m2(), s2 === "pending" && (x2(), j2());
                  }, u3));
              }
              j2();
            }
          }
        }
        return typeof r2 == "function" && g2.push(r2), setTimeout(O2), I2;
      };
    }), m = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.initRedundancy = void 0, n2.initRedundancy = function(e3) {
        var n3 = function(e4) {
          if (!(typeof e4 == "object" && typeof e4.resources == "object" && e4.resources instanceof Array && e4.resources.length))
            throw new Error("Invalid Reduncancy configuration");
          var n4, t3 = Object.create(null);
          for (n4 in h2.defaultConfig)
            e4[n4] !== void 0 ? t3[n4] = e4[n4] : t3[n4] = h2.defaultConfig[n4];
          return t3;
        }(e3), t2 = [];
        function r2() {
          t2 = t2.filter(function(e4) {
            return e4().status === "pending";
          });
        }
        return { query: function(e4, o2, i2) {
          var a2 = g.sendQuery(n3, e4, o2, function(e5, n4) {
            r2(), i2 && i2(e5, n4);
          }, function(e5) {
            n3.index = e5;
          });
          return t2.push(a2), a2;
        }, find: function(e4) {
          var n4 = t2.find(function(n5) {
            return e4(n5);
          });
          return n4 !== void 0 ? n4 : null;
        }, setIndex: function(e4) {
          n3.index = e4;
        }, getIndex: function() {
          return n3.index;
        }, cleanup: r2 };
      };
    }), b = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.sortIcons = void 0, n2.sortIcons = function(e3) {
        var n3 = { loaded: [], missing: [], pending: [] }, t2 = Object.create(null);
        e3.sort(function(e4, n4) {
          return e4.provider !== n4.provider ? e4.provider.localeCompare(n4.provider) : e4.prefix !== n4.prefix ? e4.prefix.localeCompare(n4.prefix) : e4.name.localeCompare(n4.name);
        });
        var r2 = { provider: "", prefix: "", name: "" };
        return e3.forEach(function(e4) {
          if (r2.name !== e4.name || r2.prefix !== e4.prefix || r2.provider !== e4.provider) {
            r2 = e4;
            var o2 = e4.provider, a2 = e4.prefix, c2 = e4.name;
            t2[o2] === void 0 && (t2[o2] = Object.create(null));
            var u2 = t2[o2];
            u2[a2] === void 0 && (u2[a2] = i.getStorage(o2, a2));
            var f2 = u2[a2], l2 = { provider: o2, prefix: a2, name: c2 };
            (f2.icons[c2] !== void 0 ? n3.loaded : a2 === "" || f2.missing[c2] !== void 0 ? n3.missing : n3.pending).push(l2);
          }
        }), n3;
      };
    }), y = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.storeCallback = n2.updateCallbacks = n2.callbacks = void 0, n2.callbacks = Object.create(null);
      var t2 = Object.create(null);
      function r2(e3, t3) {
        e3.forEach(function(e4) {
          var r3 = e4.provider;
          if (n2.callbacks[r3] !== void 0) {
            var o3 = n2.callbacks[r3], i2 = e4.prefix, a2 = o3[i2];
            a2 && (o3[i2] = a2.filter(function(e5) {
              return e5.id !== t3;
            }));
          }
        });
      }
      n2.updateCallbacks = function(e3, o3) {
        t2[e3] === void 0 && (t2[e3] = Object.create(null));
        var a2 = t2[e3];
        a2[o3] || (a2[o3] = true, setTimeout(function() {
          if (a2[o3] = false, n2.callbacks[e3] !== void 0 && n2.callbacks[e3][o3] !== void 0) {
            var t3 = n2.callbacks[e3][o3].slice(0);
            if (t3.length) {
              var c2 = i.getStorage(e3, o3), u2 = false;
              t3.forEach(function(n3) {
                var t4 = n3.icons, i2 = t4.pending.length;
                t4.pending = t4.pending.filter(function(n4) {
                  if (n4.prefix !== o3)
                    return true;
                  var r3 = n4.name;
                  if (c2.icons[r3] !== void 0)
                    t4.loaded.push({ provider: e3, prefix: o3, name: r3 });
                  else {
                    if (c2.missing[r3] === void 0)
                      return u2 = true, true;
                    t4.missing.push({ provider: e3, prefix: o3, name: r3 });
                  }
                  return false;
                }), t4.pending.length !== i2 && (u2 || r2([{ provider: e3, prefix: o3 }], n3.id), n3.callback(t4.loaded.slice(0), t4.missing.slice(0), t4.pending.slice(0), n3.abort));
              });
            }
          }
        }));
      };
      var o2 = 0;
      n2.storeCallback = function(e3, t3, i2) {
        var a2 = o2++, c2 = r2.bind(null, i2, a2);
        if (!t3.pending.length)
          return c2;
        var u2 = { id: a2, icons: t3, callback: e3, abort: c2 };
        return i2.forEach(function(e4) {
          var t4 = e4.provider, r3 = e4.prefix;
          n2.callbacks[t4] === void 0 && (n2.callbacks[t4] = Object.create(null));
          var o3 = n2.callbacks[t4];
          o3[r3] === void 0 && (o3[r3] = []), o3[r3].push(u2);
        }), c2;
      };
    }), I = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.getAPIModule = n2.setAPIModule = void 0;
      var t2 = Object.create(null);
      n2.setAPIModule = function(e3, n3) {
        t2[e3] = n3;
      }, n2.getAPIModule = function(e3) {
        return t2[e3] === void 0 ? t2[""] : t2[e3];
      };
    }), j = e(function(e2, n2) {
      function t2(e3) {
        var n3;
        if (typeof e3.resources == "string")
          n3 = [e3.resources];
        else if (!((n3 = e3.resources) instanceof Array && n3.length))
          return null;
        return { resources: n3, path: e3.path === void 0 ? "/" : e3.path, maxURL: e3.maxURL ? e3.maxURL : 500, rotate: e3.rotate ? e3.rotate : 750, timeout: e3.timeout ? e3.timeout : 5e3, random: e3.random === true, index: e3.index ? e3.index : 0, dataAfterTimeout: e3.dataAfterTimeout !== false };
      }
      Object.defineProperty(n2, "__esModule", { value: true }), n2.getAPIConfig = n2.setAPIConfig = void 0;
      for (var r2 = Object.create(null), o2 = ["https://api.simplesvg.com", "https://api.unisvg.com"], i2 = []; o2.length > 0; )
        o2.length === 1 || Math.random() > 0.5 ? i2.push(o2.shift()) : i2.push(o2.pop());
      r2[""] = t2({ resources: ["https://api.iconify.design"].concat(i2) }), n2.setAPIConfig = function(e3, n3) {
        var o3 = t2(n3);
        return o3 !== null && (r2[e3] = o3, true);
      };
      n2.getAPIConfig = function(e3) {
        return r2[e3];
      };
    }), x = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.getProviders = n2.listToIcons = void 0, n2.listToIcons = function(e3, n3, t2) {
        n3 === void 0 && (n3 = true), t2 === void 0 && (t2 = false);
        var r2 = [];
        return e3.forEach(function(e4) {
          var i2 = typeof e4 == "string" ? o.stringToIcon(e4, false, t2) : e4;
          n3 && !o.validateIcon(i2, t2) || r2.push({ provider: i2.provider, prefix: i2.prefix, name: i2.name });
        }), r2;
      }, n2.getProviders = function(e3) {
        var n3 = Object.create(null);
        return e3.forEach(function(e4) {
          n3[e4.provider] = true;
        }), Object.keys(n3);
      };
    }), O = e(function(e2, n2) {
      function t2() {
      }
      Object.defineProperty(n2, "__esModule", { value: true }), n2.API = n2.getRedundancyCache = void 0;
      var r2 = Object.create(null), o2 = Object.create(null), c2 = Object.create(null), u2 = Object.create(null), f2 = Object.create(null);
      function l2(e3) {
        if (f2[e3] === void 0) {
          var n3 = j.getAPIConfig(e3);
          if (!n3)
            return;
          var t3 = { config: n3, redundancy: m.initRedundancy(n3) };
          f2[e3] = t3;
        }
        return f2[e3];
      }
      n2.getRedundancyCache = l2;
      var s2 = Object.create(null);
      function v2(e3, n3, t3) {
        function a2() {
          var t4 = (e3 === "" ? "" : "@" + e3 + ":") + n3, r3 = Math.floor(Date.now() / 6e4);
          s2[t4] < r3 && (s2[t4] = r3, console.error('Unable to retrieve icons for "' + t4 + '" because API is not configured properly.'));
        }
        o2[e3] === void 0 && (o2[e3] = Object.create(null));
        var f3 = o2[e3];
        u2[e3] === void 0 && (u2[e3] = Object.create(null));
        var v3 = u2[e3];
        r2[e3] === void 0 && (r2[e3] = Object.create(null));
        var p3, h3 = r2[e3];
        f3[n3] === void 0 ? f3[n3] = t3 : f3[n3] = f3[n3].concat(t3).sort(), v3[n3] || (v3[n3] = true, setTimeout(function() {
          v3[n3] = false;
          var t4 = f3[n3];
          delete f3[n3];
          var r3 = I.getAPIModule(e3);
          if (r3) {
            if (p3 === void 0) {
              var o3 = l2(e3);
              if (o3 === void 0)
                return void a2();
              p3 = o3;
            }
            r3.prepare(e3, n3, t4).forEach(function(t5) {
              p3.redundancy.query(t5, r3.send, function(r4, o4) {
                var a3 = i.getStorage(e3, n3);
                if (typeof r4 != "object") {
                  if (o4 !== 404)
                    return;
                  var u3 = Date.now();
                  t5.icons.forEach(function(e4) {
                    a3.missing[e4] = u3;
                  });
                } else
                  try {
                    var f4 = i.addIconSet(a3, r4, "all");
                    if (typeof f4 == "boolean")
                      return;
                    var l3 = h3[n3];
                    f4.forEach(function(e4) {
                      delete l3[e4];
                    }), d.coreModules.cache && d.coreModules.cache(e3, r4);
                  } catch (e4) {
                    console.error(e4);
                  }
                !function(e4, n4) {
                  c2[e4] === void 0 && (c2[e4] = Object.create(null));
                  var t6 = c2[e4];
                  t6[n4] || (t6[n4] = true, setTimeout(function() {
                    t6[n4] = false, y.updateCallbacks(e4, n4);
                  }));
                }(e3, n3);
              });
            });
          } else
            a2();
        }));
      }
      n2.API = { isPending: function(e3) {
        return r2[e3.provider] !== void 0 && r2[e3.provider][e3.prefix] !== void 0 && r2[e3.provider][e3.prefix][e3.name] !== void 0;
      }, loadIcons: function(e3, n3) {
        var o3 = x.listToIcons(e3, true, a.allowSimpleNames()), i2 = b.sortIcons(o3);
        if (!i2.pending.length) {
          var c3 = true;
          return n3 && setTimeout(function() {
            c3 && n3(i2.loaded, i2.missing, i2.pending, t2);
          }), function() {
            c3 = false;
          };
        }
        var u3, f3, l3 = Object.create(null), s3 = [];
        i2.pending.forEach(function(e4) {
          var n4 = e4.provider, t3 = e4.prefix;
          if (t3 !== f3 || n4 !== u3) {
            u3 = n4, f3 = t3, s3.push({ provider: n4, prefix: t3 }), r2[n4] === void 0 && (r2[n4] = Object.create(null));
            var o4 = r2[n4];
            o4[t3] === void 0 && (o4[t3] = Object.create(null)), l3[n4] === void 0 && (l3[n4] = Object.create(null));
            var i3 = l3[n4];
            i3[t3] === void 0 && (i3[t3] = []);
          }
        });
        var d2 = Date.now();
        return i2.pending.forEach(function(e4) {
          var n4 = e4.provider, t3 = e4.prefix, o4 = e4.name, i3 = r2[n4][t3];
          i3[o4] === void 0 && (i3[o4] = d2, l3[n4][t3].push(o4));
        }), s3.forEach(function(e4) {
          var n4 = e4.provider, t3 = e4.prefix;
          l3[n4][t3].length && v2(n4, t3, l3[n4][t3]);
        }), n3 ? y.storeCallback(n3, i2, s3) : t2;
      } };
    }), P = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.APIInternalFunctions = n2.APIFunctions = void 0, n2.APIFunctions = { loadIcons: O.API.loadIcons, addAPIProvider: j.setAPIConfig }, n2.APIInternalFunctions = { getAPI: O.getRedundancyCache, getAPIConfig: j.getAPIConfig, setAPIModule: I.setAPIModule };
    }), w = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.getAPIModule = void 0;
      var t2 = null, r2 = "{prefix}.js?icons={icons}&callback={callback}", o2 = Object.create(null), i2 = Object.create(null);
      function a2() {
        if (t2 === null) {
          var e3 = self, n3 = "Iconify", o3 = ".cb";
          if (e3[n3] === void 0)
            o3 = "", e3[n3 = "IconifyJSONP"] === void 0 && (e3[n3] = Object.create(null)), t2 = e3[n3];
          else {
            var i3 = e3[n3];
            i3.cb === void 0 && (i3.cb = Object.create(null)), t2 = i3.cb;
          }
          r2 = r2.replace("{callback}", n3 + o3 + ".{cb}");
        }
        return t2;
      }
      n2.getAPIModule = function(e3) {
        return { prepare: function(n3, t3, c2) {
          var u2 = [], f2 = o2[n3 + ":" + t3];
          f2 === void 0 && (f2 = function(n4, t4) {
            var c3, u3 = e3(n4);
            if (!u3)
              return 0;
            if (u3.maxURL) {
              var f3 = 0;
              u3.resources.forEach(function(e4) {
                var n5 = e4;
                f3 = Math.max(f3, n5.length);
              }), a2(), c3 = u3.maxURL - f3 - u3.path.length - r2.replace("{provider}", n4).replace("{prefix}", t4).replace("{icons}", "").length - 3;
            } else
              c3 = 0;
            var l3 = n4 + ":" + t4;
            return i2[l3] = u3.path, o2[l3] = c3, c3;
          }(n3, t3));
          var l2 = { provider: n3, prefix: t3, icons: [] }, s2 = 0;
          return c2.forEach(function(e4, r3) {
            (s2 += e4.length + 1) >= f2 && r3 > 0 && (u2.push(l2), l2 = { provider: n3, prefix: t3, icons: [] }, s2 = e4.length), l2.icons.push(e4);
          }), u2.push(l2), u2;
        }, send: function(e4, n3, t3) {
          for (var o3 = n3.provider, c2 = n3.prefix, u2 = n3.icons.join(","), f2 = o3 + ":" + c2, l2 = c2.split("-").shift().slice(0, 3), s2 = a2(), d2 = function(e5) {
            var n4, t4 = 0;
            for (n4 = e5.length - 1; n4 >= 0; n4--)
              t4 += e5.charCodeAt(n4);
            return t4 % 999;
          }(o3 + ":" + e4 + ":" + c2 + ":" + u2); s2[l2 + d2] !== void 0; )
            d2++;
          var v2 = l2 + d2, p3 = i2[f2] + r2.replace("{provider}", o3).replace("{prefix}", c2).replace("{icons}", u2).replace("{cb}", v2);
          s2[v2] = function(e5) {
            delete s2[v2], t3.done(e5);
          };
          var h3 = e4 + p3, g2 = document.createElement("script");
          g2.type = "text/javascript", g2.async = true, g2.src = h3, document.head.appendChild(g2);
        } };
      };
    }), M = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.getAPIModule = n2.setFetch = void 0;
      var t2 = "{prefix}.json?icons={icons}", r2 = Object.create(null), o2 = Object.create(null), i2 = null;
      try {
        i2 = fetch;
      } catch (e3) {
      }
      n2.setFetch = function(e3) {
        i2 = e3;
      };
      n2.getAPIModule = function(e3) {
        return { prepare: function(n3, i3, a2) {
          var c2 = [], u2 = r2[i3];
          u2 === void 0 && (u2 = function(n4, i4) {
            var a3, c3 = e3(n4);
            if (!c3)
              return 0;
            if (c3.maxURL) {
              var u3 = 0;
              c3.resources.forEach(function(e4) {
                var n5 = e4;
                u3 = Math.max(u3, n5.length);
              }), a3 = c3.maxURL - u3 - c3.path.length - t2.replace("{provider}", n4).replace("{prefix}", i4).replace("{icons}", "").length;
            } else
              a3 = 0;
            var f3 = n4 + ":" + i4;
            return o2[f3] = c3.path, r2[f3] = a3, a3;
          }(n3, i3));
          var f2 = { provider: n3, prefix: i3, icons: [] }, l2 = 0;
          return a2.forEach(function(e4, t3) {
            (l2 += e4.length + 1) >= u2 && t3 > 0 && (c2.push(f2), f2 = { provider: n3, prefix: i3, icons: [] }, l2 = e4.length), f2.icons.push(e4);
          }), c2.push(f2), c2;
        }, send: function(e4, n3, r3) {
          var a2 = n3.provider, c2 = n3.prefix, u2 = n3.icons.join(","), f2 = o2[a2 + ":" + c2] + t2.replace("{provider}", a2).replace("{prefix}", c2).replace("{icons}", u2);
          i2 ? i2(e4 + f2).then(function(e5) {
            if (e5.status === 200)
              return e5.json();
            r3.done(void 0, e5.status);
          }).then(function(e5) {
            typeof e5 == "object" && e5 !== null && r3.done(e5);
          }).catch(function(e5) {
            r3.done(void 0, e5.errno);
          }) : r3.done(void 0, 424);
        } };
      };
    }), A = "iconifyFinder" + Date.now(), S = "iconifyData" + Date.now();
    function _(e2, n2, t2, r2) {
      var o2;
      try {
        o2 = document.createElement("span");
      } catch (e3) {
        return r2 ? "" : null;
      }
      var i2 = l.iconToSVG(t2, f.mergeCustomisations(f.defaults, n2)), a2 = e2.element, u2 = e2.finder, s2 = e2.name, d2 = a2 ? a2.getAttribute("class") : "", v2 = u2 ? u2.classFilter(d2 ? d2.split(/\s+/) : []) : [], p3 = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="' + ("iconify iconify--" + s2.prefix + (s2.provider === "" ? "" : " iconify--" + s2.provider) + (v2.length ? " " + v2.join(" ") : "")) + '">' + c.replaceIDs(i2.body) + "</svg>";
      o2.innerHTML = p3;
      var h3 = o2.childNodes[0], g2 = h3.style, m2 = i2.attributes;
      if (Object.keys(m2).forEach(function(e3) {
        h3.setAttribute(e3, m2[e3]);
      }), i2.inline && (g2.verticalAlign = "-0.125em"), a2) {
        for (var b2 = a2.attributes, y2 = 0; y2 < b2.length; y2++) {
          var I2 = b2.item(y2);
          if (I2) {
            var j2 = I2.name;
            if (j2 !== "class" && j2 !== "style" && m2[j2] === void 0)
              try {
                h3.setAttribute(j2, I2.value);
              } catch (e3) {
              }
          }
        }
        for (var x2 = a2.style, O2 = 0; O2 < x2.length; O2++) {
          var P2 = x2[O2];
          g2[P2] = x2[P2];
        }
      }
      if (u2) {
        var w2 = { name: s2, status: "loaded", customisations: n2 };
        h3[S] = w2, h3[A] = u2;
      }
      var M2 = r2 ? o2.innerHTML : h3;
      return a2 && a2.parentNode ? a2.parentNode.replaceChild(h3, a2) : o2.removeChild(h3), M2;
    }
    var E = [];
    function k(e2) {
      for (var n2 = 0; n2 < E.length; n2++) {
        var t2 = E[n2];
        if ((typeof t2.node == "function" ? t2.node() : t2.node) === e2)
          return t2;
      }
    }
    function C(e2, n2) {
      n2 === void 0 && (n2 = false);
      var t2 = k(e2);
      return t2 ? (t2.temporary && (t2.temporary = n2), t2) : (t2 = { node: e2, temporary: n2 }, E.push(t2), t2);
    }
    function F() {
      return E;
    }
    var T = null, D = { childList: true, subtree: true, attributes: true };
    function N(e2) {
      if (e2.observer) {
        var n2 = e2.observer;
        n2.pendingScan || (n2.pendingScan = setTimeout(function() {
          delete n2.pendingScan, T && T(e2);
        }));
      }
    }
    function L(e2, n2) {
      if (e2.observer) {
        var t2 = e2.observer;
        if (!t2.pendingScan)
          for (var r2 = 0; r2 < n2.length; r2++) {
            var o2 = n2[r2];
            if (o2.addedNodes && o2.addedNodes.length > 0 || o2.type === "attributes" && o2.target[A] !== void 0)
              return void (t2.paused || N(e2));
          }
      }
    }
    function z(e2, n2) {
      e2.observer.instance.observe(n2, D);
    }
    function R(e2) {
      var n2 = e2.observer;
      if (!n2 || !n2.instance) {
        var t2 = typeof e2.node == "function" ? e2.node() : e2.node;
        t2 && (n2 || (n2 = { paused: 0 }, e2.observer = n2), n2.instance = new MutationObserver(L.bind(null, e2)), z(e2, t2), n2.paused || N(e2));
      }
    }
    function q() {
      F().forEach(R);
    }
    function U(e2) {
      if (e2.observer) {
        var n2 = e2.observer;
        n2.pendingScan && (clearTimeout(n2.pendingScan), delete n2.pendingScan), n2.instance && (n2.instance.disconnect(), delete n2.instance);
      }
    }
    function V(e2) {
      var n2 = T !== null;
      T !== e2 && (T = e2, n2 && F().forEach(U)), n2 ? q() : function(e3) {
        var n3 = document;
        n3.readyState === "complete" || n3.readyState !== "loading" && !n3.documentElement.doScroll ? e3() : (n3.addEventListener("DOMContentLoaded", e3), window.addEventListener("load", e3));
      }(q);
    }
    function G(e2) {
      (e2 ? [e2] : F()).forEach(function(e3) {
        if (e3.observer) {
          var n2 = e3.observer;
          if (n2.paused++, !(n2.paused > 1) && n2.instance)
            n2.instance.disconnect();
        } else
          e3.observer = { paused: 1 };
      });
    }
    function $(e2) {
      (e2 ? [e2] : F()).forEach(function(e3) {
        if (e3.observer) {
          var n2 = e3.observer;
          if (n2.paused && (n2.paused--, !n2.paused)) {
            var t2 = typeof e3.node == "function" ? e3.node() : e3.node;
            if (!t2)
              return;
            n2.instance ? z(e3, t2) : R(e3);
          }
        } else
          R(e3);
      });
    }
    function B(e2, n2) {
      n2 === void 0 && (n2 = false);
      var t2 = C(e2, n2);
      return R(t2), t2;
    }
    function Q(e2) {
      var n2 = k(e2);
      n2 && (U(n2), function(e3) {
        E = E.filter(function(n3) {
          var t2 = typeof n3.node == "function" ? n3.node() : n3.node;
          return e3 !== t2;
        });
      }(e2));
    }
    var H = [];
    function J(e2) {
      return typeof e2 == "string" && (e2 = o.stringToIcon(e2)), e2 !== null && o.validateIcon(e2) ? e2 : null;
    }
    function Y(e2) {
      var n2 = [];
      H.forEach(function(t3) {
        var r2 = t3.find(e2);
        Array.prototype.forEach.call(r2, function(e3) {
          var r3 = e3;
          if (r3[A] === void 0 || r3[A] === t3) {
            var o2 = J(t3.name(r3));
            if (o2 !== null) {
              r3[A] = t3;
              var i2 = { element: r3, finder: t3, name: o2 };
              n2.push(i2);
            }
          }
        });
      });
      var t2 = e2.querySelectorAll("svg.iconify");
      return Array.prototype.forEach.call(t2, function(e3) {
        var t3 = e3, r2 = t3[A], o2 = t3[S];
        if (r2 && o2) {
          var i2 = J(r2.name(t3));
          if (i2 !== null) {
            var a2, c2 = false;
            if (i2.prefix !== o2.name.prefix || i2.name !== o2.name.name ? c2 = true : (a2 = r2.customisations(t3), function(e4, n3) {
              var t4 = Object.keys(e4), r3 = Object.keys(n3);
              if (t4.length !== r3.length)
                return false;
              for (var o3 = 0; o3 < t4.length; o3++) {
                var i3 = t4[o3];
                if (n3[i3] !== e4[i3])
                  return false;
              }
              return true;
            }(o2.customisations, a2) || (c2 = true)), c2) {
              var u2 = { element: t3, finder: r2, name: i2, customisations: a2 };
              n2.push(u2);
            }
          }
        }
      }), n2;
    }
    var Z = false;
    function K() {
      Z || (Z = true, setTimeout(function() {
        Z && (Z = false, W());
      }));
    }
    function W(e2, n2) {
      n2 === void 0 && (n2 = false), Z = false;
      var t2 = Object.create(null);
      if ((e2 ? [e2] : F()).forEach(function(e3) {
        var r3 = typeof e3.node == "function" ? e3.node() : e3.node;
        if (r3 && r3.querySelectorAll) {
          var o2 = false, a2 = false;
          Y(r3).forEach(function(n3) {
            var r4, c2, u2 = n3.element, f2 = n3.name, l2 = f2.provider, s2 = f2.prefix, v2 = f2.name, p3 = u2[S];
            if (p3 !== void 0 && (r4 = p3.name, c2 = f2, r4 !== null && c2 !== null && r4.name === c2.name && r4.prefix === c2.prefix))
              switch (p3.status) {
                case "missing":
                  return;
                case "loading":
                  if (d.coreModules.api && d.coreModules.api.isPending({ provider: l2, prefix: s2, name: v2 }))
                    return void (o2 = true);
              }
            var h3 = i.getStorage(l2, s2);
            if (h3.icons[v2] === void 0) {
              if (h3.missing[v2])
                return p3 = { name: f2, status: "missing", customisations: {} }, void (u2[S] = p3);
              if (d.coreModules.api && !d.coreModules.api.isPending({ provider: l2, prefix: s2, name: v2 })) {
                t2[l2] === void 0 && (t2[l2] = Object.create(null));
                var g2 = t2[l2];
                g2[s2] === void 0 && (g2[s2] = Object.create(null)), g2[s2][v2] = true;
              }
              p3 = { name: f2, status: "loading", customisations: {} }, u2[S] = p3, o2 = true;
            } else {
              !a2 && e3.observer && (G(e3), a2 = true);
              var m2 = n3.customisations !== void 0 ? n3.customisations : n3.finder.customisations(u2);
              _(n3, m2, i.getIcon(h3, v2));
            }
          }), e3.temporary && !o2 ? Q(r3) : n2 && o2 ? B(r3, true) : a2 && e3.observer && $(e3);
        }
      }), d.coreModules.api) {
        var r2 = d.coreModules.api;
        Object.keys(t2).forEach(function(e3) {
          var n3 = t2[e3];
          Object.keys(n3).forEach(function(t3) {
            r2.loadIcons(Object.keys(n3[t3]).map(function(n4) {
              return { provider: e3, prefix: t3, name: n4 };
            }), K);
          });
        });
      }
    }
    var X = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.rotateFromString = void 0, n2.rotateFromString = function(e3) {
        var n3 = e3.replace(/^-?[0-9.]*/, "");
        function t2(e4) {
          for (; e4 < 0; )
            e4 += 4;
          return e4 % 4;
        }
        if (n3 === "") {
          var r2 = parseInt(e3);
          return isNaN(r2) ? 0 : t2(r2);
        }
        if (n3 !== e3) {
          var o2 = 0;
          switch (n3) {
            case "%":
              o2 = 25;
              break;
            case "deg":
              o2 = 90;
          }
          if (o2) {
            var i2 = parseFloat(e3.slice(0, e3.length - n3.length));
            return isNaN(i2) ? 0 : (i2 /= o2) % 1 == 0 ? t2(i2) : 0;
          }
        }
        return 0;
      };
    }), ee = e(function(e2, n2) {
      Object.defineProperty(n2, "__esModule", { value: true }), n2.alignmentFromString = n2.flipFromString = void 0;
      var t2 = /[\s,]+/;
      n2.flipFromString = function(e3, n3) {
        n3.split(t2).forEach(function(n4) {
          switch (n4.trim()) {
            case "horizontal":
              e3.hFlip = true;
              break;
            case "vertical":
              e3.vFlip = true;
          }
        });
      }, n2.alignmentFromString = function(e3, n3) {
        n3.split(t2).forEach(function(n4) {
          var t3 = n4.trim();
          switch (t3) {
            case "left":
            case "center":
            case "right":
              e3.hAlign = t3;
              break;
            case "top":
            case "middle":
            case "bottom":
              e3.vAlign = t3;
              break;
            case "slice":
            case "crop":
              e3.slice = true;
              break;
            case "meet":
              e3.slice = false;
          }
        });
      };
    });
    function ne(e2, n2) {
      return e2.hasAttribute(n2);
    }
    function te(e2, n2) {
      return e2.getAttribute(n2);
    }
    var re = ["inline", "hFlip", "vFlip"], oe = ["width", "height"], ie = "iconify-inline", ae = { find: function(e2) {
      return e2.querySelectorAll("i.iconify, span.iconify, i.iconify-inline, span.iconify-inline");
    }, name: function(e2) {
      return ne(e2, "data-icon") ? te(e2, "data-icon") : null;
    }, customisations: function(e2, n2) {
      n2 === void 0 && (n2 = { inline: false });
      var t2 = n2, r2 = e2.getAttribute("class");
      if ((r2 ? r2.split(/\s+/) : []).indexOf(ie) !== -1 && (t2.inline = true), ne(e2, "data-rotate")) {
        var o2 = X.rotateFromString(te(e2, "data-rotate"));
        o2 && (t2.rotate = o2);
      }
      return ne(e2, "data-flip") && ee.flipFromString(t2, te(e2, "data-flip")), ne(e2, "data-align") && ee.alignmentFromString(t2, te(e2, "data-align")), re.forEach(function(n3) {
        if (ne(e2, "data-" + n3)) {
          var r3 = function(e3, n4) {
            var t3 = e3.getAttribute(n4);
            return t3 === n4 || t3 === "true" || t3 !== "" && t3 !== "false" && null;
          }(e2, "data-" + n3);
          typeof r3 == "boolean" && (t2[n3] = r3);
        }
      }), oe.forEach(function(n3) {
        if (ne(e2, "data-" + n3)) {
          var r3 = te(e2, "data-" + n3);
          r3 !== "" && (t2[n3] = r3);
        }
      }), t2;
    }, classFilter: function(e2) {
      var n2 = [];
      return e2.forEach(function(e3) {
        e3 !== "iconify" && e3 !== "" && e3.slice(0, 9) !== "iconify--" && n2.push(e3);
      }), n2;
    } };
    function ce(e2, n2, t2) {
      var r2 = a.getIconData(e2);
      return r2 ? _({ name: o.stringToIcon(e2) }, f.mergeCustomisations(f.defaults, typeof n2 == "object" ? n2 : {}), r2, t2) : null;
    }
    var ue = { getVersion: function() {
      return "2.0.4";
    }, renderSVG: function(e2, n2) {
      return ce(e2, n2, false);
    }, renderHTML: function(e2, n2) {
      return ce(e2, n2, true);
    }, renderIcon: function(e2, n2) {
      var t2 = a.getIconData(e2);
      if (!t2)
        return null;
      var r2 = f.mergeCustomisations(f.defaults, typeof n2 == "object" ? n2 : {});
      return l.iconToSVG(t2, r2);
    }, scan: function(e2) {
      e2 ? function(e3) {
        var n2 = k(e3);
        n2 ? W(n2) : W({ node: e3, temporary: true }, true);
      }(e2) : W();
    }, observe: function(e2) {
      B(e2);
    }, stopObserving: function(e2) {
      Q(e2);
    }, pauseObserver: function(e2) {
      if (e2) {
        var n2 = k(e2);
        n2 && G(n2);
      } else
        G();
    }, resumeObserver: function(e2) {
      if (e2) {
        var n2 = k(e2);
        n2 && $(n2);
      } else
        $();
    } };
    if (typeof document != "undefined" && typeof window != "undefined") {
      !function() {
        if (document.documentElement)
          return C(document.documentElement);
        E.push({ node: function() {
          return document.documentElement;
        } });
      }(), function(e2) {
        H.indexOf(e2) === -1 && H.push(e2);
      }(ae);
      var fe = window;
      if (fe.IconifyPreload !== void 0) {
        var le = fe.IconifyPreload, se = "Invalid IconifyPreload syntax.";
        typeof le == "object" && le !== null && (le instanceof Array ? le : [le]).forEach(function(e2) {
          try {
            (typeof e2 != "object" || e2 === null || e2 instanceof Array || typeof e2.icons != "object" || typeof e2.prefix != "string" || !a.storageFunctions.addCollection(e2)) && console.error(se);
          } catch (e3) {
            console.error(se);
          }
        });
      }
      setTimeout(function() {
        V(W), W();
      });
    }
    var de = { enableCache: function(e2, n2) {
      return p2.toggleBrowserCache(e2, n2 !== false);
    }, disableCache: function(e2) {
      return p2.toggleBrowserCache(e2, true);
    } }, ve = { _api: P.APIInternalFunctions };
    [a.storageFunctions, s.builderFunctions, ue, de, P.APIFunctions].forEach(function(e2) {
      for (var n2 in e2)
        ve[n2] = e2[n2];
    }), d.coreModules.api = O.API;
    var pe = M.getAPIModule;
    try {
      typeof document != "undefined" && typeof window != "undefined" && (pe = typeof fetch == "function" && typeof Promise == "function" ? M.getAPIModule : w.getAPIModule);
    } catch (se2) {
    }
    if (I.setAPIModule("", pe(j.getAPIConfig)), ve._api.setFetch = function(e2) {
      M.setFetch(e2), pe !== M.getAPIModule && (pe = M.getAPIModule, I.setAPIModule("", pe(j.getAPIConfig)));
    }, typeof document != "undefined" && typeof window != "undefined") {
      d.coreModules.cache = v.storeCache, v.loadCache();
      var he = window;
      if (he.IconifyProviders !== void 0) {
        var ge = he.IconifyProviders;
        if (typeof ge == "object" && ge !== null)
          for (var me in ge) {
            var be = "IconifyProviders[" + me + "] is invalid.";
            try {
              var ye = ge[me];
              if (typeof ye != "object" || !ye || ye.resources === void 0)
                continue;
              j.setAPIConfig(me, ye) || console.error(be);
            } catch (e2) {
              console.error(be);
            }
          }
      }
    }
    return ve;
  }();
  try {
    self.Iconify === void 0 && (self.Iconify = Iconify);
  } catch (e) {
  }
  try {
    exports.__esModule = true, exports.default = Iconify;
  } catch (e) {
  }
})(iconify_min);
var Module = /* @__PURE__ */ getDefaultExportFromCjs(iconify_min);
function makeMap(str, expectsLowerCase) {
  const map = Object.create(null);
  const list = str.split(",");
  for (let i = 0; i < list.length; i++) {
    map[list[i]] = true;
  }
  return expectsLowerCase ? (val) => !!map[val.toLowerCase()] : (val) => !!map[val];
}
const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
function includeBooleanAttr(value) {
  return !!value || value === "";
}
function normalizeStyle(value) {
  if (isArray$2(value)) {
    const res = {};
    for (let i = 0; i < value.length; i++) {
      const item = value[i];
      const normalized = isString$3(item) ? parseStringStyle(item) : normalizeStyle(item);
      if (normalized) {
        for (const key in normalized) {
          res[key] = normalized[key];
        }
      }
    }
    return res;
  } else if (isString$3(value)) {
    return value;
  } else if (isObject$2(value)) {
    return value;
  }
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:(.+)/;
function parseStringStyle(cssText) {
  const ret = {};
  cssText.split(listDelimiterRE).forEach((item) => {
    if (item) {
      const tmp = item.split(propertyDelimiterRE);
      tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return ret;
}
function normalizeClass(value) {
  let res = "";
  if (isString$3(value)) {
    res = value;
  } else if (isArray$2(value)) {
    for (let i = 0; i < value.length; i++) {
      const normalized = normalizeClass(value[i]);
      if (normalized) {
        res += normalized + " ";
      }
    }
  } else if (isObject$2(value)) {
    for (const name in value) {
      if (value[name]) {
        res += name + " ";
      }
    }
  }
  return res.trim();
}
function normalizeProps(props) {
  if (!props)
    return null;
  let { class: klass, style } = props;
  if (klass && !isString$3(klass)) {
    props.class = normalizeClass(klass);
  }
  if (style) {
    props.style = normalizeStyle(style);
  }
  return props;
}
function looseCompareArrays(a, b) {
  if (a.length !== b.length)
    return false;
  let equal = true;
  for (let i = 0; equal && i < a.length; i++) {
    equal = looseEqual(a[i], b[i]);
  }
  return equal;
}
function looseEqual(a, b) {
  if (a === b)
    return true;
  let aValidType = isDate$2(a);
  let bValidType = isDate$2(b);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? a.getTime() === b.getTime() : false;
  }
  aValidType = isArray$2(a);
  bValidType = isArray$2(b);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? looseCompareArrays(a, b) : false;
  }
  aValidType = isObject$2(a);
  bValidType = isObject$2(b);
  if (aValidType || bValidType) {
    if (!aValidType || !bValidType) {
      return false;
    }
    const aKeysCount = Object.keys(a).length;
    const bKeysCount = Object.keys(b).length;
    if (aKeysCount !== bKeysCount) {
      return false;
    }
    for (const key in a) {
      const aHasKey = a.hasOwnProperty(key);
      const bHasKey = b.hasOwnProperty(key);
      if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a[key], b[key])) {
        return false;
      }
    }
  }
  return String(a) === String(b);
}
function looseIndexOf(arr, val) {
  return arr.findIndex((item) => looseEqual(item, val));
}
const toDisplayString$1 = (val) => {
  return val == null ? "" : isArray$2(val) || isObject$2(val) && (val.toString === objectToString$1 || !isFunction$2(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val) => {
  if (val && val.__v_isRef) {
    return replacer(_key, val.value);
  } else if (isMap(val)) {
    return {
      [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2]) => {
        entries[`${key} =>`] = val2;
        return entries;
      }, {})
    };
  } else if (isSet(val)) {
    return {
      [`Set(${val.size})`]: [...val.values()]
    };
  } else if (isObject$2(val) && !isArray$2(val) && !isPlainObject$3(val)) {
    return String(val);
  }
  return val;
};
const EMPTY_OBJ = {};
const EMPTY_ARR = [];
const NOOP = () => {
};
const NO = () => false;
const onRE = /^on[^a-z]/;
const isOn = (key) => onRE.test(key);
const isModelListener = (key) => key.startsWith("onUpdate:");
const extend$1 = Object.assign;
const remove = (arr, el) => {
  const i = arr.indexOf(el);
  if (i > -1) {
    arr.splice(i, 1);
  }
};
const hasOwnProperty$1 = Object.prototype.hasOwnProperty;
const hasOwn$1 = (val, key) => hasOwnProperty$1.call(val, key);
const isArray$2 = Array.isArray;
const isMap = (val) => toTypeString$1(val) === "[object Map]";
const isSet = (val) => toTypeString$1(val) === "[object Set]";
const isDate$2 = (val) => val instanceof Date;
const isFunction$2 = (val) => typeof val === "function";
const isString$3 = (val) => typeof val === "string";
const isSymbol = (val) => typeof val === "symbol";
const isObject$2 = (val) => val !== null && typeof val === "object";
const isPromise = (val) => {
  return isObject$2(val) && isFunction$2(val.then) && isFunction$2(val.catch);
};
const objectToString$1 = Object.prototype.toString;
const toTypeString$1 = (value) => objectToString$1.call(value);
const toRawType = (value) => {
  return toTypeString$1(value).slice(8, -1);
};
const isPlainObject$3 = (val) => toTypeString$1(val) === "[object Object]";
const isIntegerKey = (key) => isString$3(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /* @__PURE__ */ makeMap(",key,ref,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted");
const cacheStringFunction = (fn) => {
  const cache2 = Object.create(null);
  return (str) => {
    const hit = cache2[str];
    return hit || (cache2[str] = fn(str));
  };
};
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction((str) => {
  return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : "");
});
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
const capitalize = cacheStringFunction((str) => str.charAt(0).toUpperCase() + str.slice(1));
const toHandlerKey = cacheStringFunction((str) => str ? `on${capitalize(str)}` : ``);
const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
const invokeArrayFns = (fns, arg) => {
  for (let i = 0; i < fns.length; i++) {
    fns[i](arg);
  }
};
const def = (obj, key, value) => {
  Object.defineProperty(obj, key, {
    configurable: true,
    enumerable: false,
    value
  });
};
const toNumber = (val) => {
  const n = parseFloat(val);
  return isNaN(n) ? val : n;
};
let _globalThis$1;
const getGlobalThis$1 = () => {
  return _globalThis$1 || (_globalThis$1 = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
let activeEffectScope;
const effectScopeStack = [];
class EffectScope {
  constructor(detached = false) {
    this.active = true;
    this.effects = [];
    this.cleanups = [];
    if (!detached && activeEffectScope) {
      this.parent = activeEffectScope;
      this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
    }
  }
  run(fn) {
    if (this.active) {
      try {
        this.on();
        return fn();
      } finally {
        this.off();
      }
    }
  }
  on() {
    if (this.active) {
      effectScopeStack.push(this);
      activeEffectScope = this;
    }
  }
  off() {
    if (this.active) {
      effectScopeStack.pop();
      activeEffectScope = effectScopeStack[effectScopeStack.length - 1];
    }
  }
  stop(fromParent) {
    if (this.active) {
      this.effects.forEach((e) => e.stop());
      this.cleanups.forEach((cleanup) => cleanup());
      if (this.scopes) {
        this.scopes.forEach((e) => e.stop(true));
      }
      if (this.parent && !fromParent) {
        const last = this.parent.scopes.pop();
        if (last && last !== this) {
          this.parent.scopes[this.index] = last;
          last.index = this.index;
        }
      }
      this.active = false;
    }
  }
}
function effectScope(detached) {
  return new EffectScope(detached);
}
function recordEffectScope(effect, scope) {
  scope = scope || activeEffectScope;
  if (scope && scope.active) {
    scope.effects.push(effect);
  }
}
function getCurrentScope() {
  return activeEffectScope;
}
function onScopeDispose(fn) {
  if (activeEffectScope) {
    activeEffectScope.cleanups.push(fn);
  }
}
const createDep = (effects) => {
  const dep = new Set(effects);
  dep.w = 0;
  dep.n = 0;
  return dep;
};
const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
const newTracked = (dep) => (dep.n & trackOpBit) > 0;
const initDepMarkers = ({ deps }) => {
  if (deps.length) {
    for (let i = 0; i < deps.length; i++) {
      deps[i].w |= trackOpBit;
    }
  }
};
const finalizeDepMarkers = (effect) => {
  const { deps } = effect;
  if (deps.length) {
    let ptr = 0;
    for (let i = 0; i < deps.length; i++) {
      const dep = deps[i];
      if (wasTracked(dep) && !newTracked(dep)) {
        dep.delete(effect);
      } else {
        deps[ptr++] = dep;
      }
      dep.w &= ~trackOpBit;
      dep.n &= ~trackOpBit;
    }
    deps.length = ptr;
  }
};
const targetMap = new WeakMap();
let effectTrackDepth = 0;
let trackOpBit = 1;
const maxMarkerBits = 30;
const effectStack = [];
let activeEffect;
const ITERATE_KEY = Symbol("");
const MAP_KEY_ITERATE_KEY = Symbol("");
class ReactiveEffect {
  constructor(fn, scheduler = null, scope) {
    this.fn = fn;
    this.scheduler = scheduler;
    this.active = true;
    this.deps = [];
    recordEffectScope(this, scope);
  }
  run() {
    if (!this.active) {
      return this.fn();
    }
    if (!effectStack.includes(this)) {
      try {
        effectStack.push(activeEffect = this);
        enableTracking();
        trackOpBit = 1 << ++effectTrackDepth;
        if (effectTrackDepth <= maxMarkerBits) {
          initDepMarkers(this);
        } else {
          cleanupEffect(this);
        }
        return this.fn();
      } finally {
        if (effectTrackDepth <= maxMarkerBits) {
          finalizeDepMarkers(this);
        }
        trackOpBit = 1 << --effectTrackDepth;
        resetTracking();
        effectStack.pop();
        const n = effectStack.length;
        activeEffect = n > 0 ? effectStack[n - 1] : void 0;
      }
    }
  }
  stop() {
    if (this.active) {
      cleanupEffect(this);
      if (this.onStop) {
        this.onStop();
      }
      this.active = false;
    }
  }
}
function cleanupEffect(effect) {
  const { deps } = effect;
  if (deps.length) {
    for (let i = 0; i < deps.length; i++) {
      deps[i].delete(effect);
    }
    deps.length = 0;
  }
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = false;
}
function enableTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = true;
}
function resetTracking() {
  const last = trackStack.pop();
  shouldTrack = last === void 0 ? true : last;
}
function track(target, type, key) {
  if (!isTracking()) {
    return;
  }
  let depsMap = targetMap.get(target);
  if (!depsMap) {
    targetMap.set(target, depsMap = new Map());
  }
  let dep = depsMap.get(key);
  if (!dep) {
    depsMap.set(key, dep = createDep());
  }
  trackEffects(dep);
}
function isTracking() {
  return shouldTrack && activeEffect !== void 0;
}
function trackEffects(dep, debuggerEventExtraInfo) {
  let shouldTrack2 = false;
  if (effectTrackDepth <= maxMarkerBits) {
    if (!newTracked(dep)) {
      dep.n |= trackOpBit;
      shouldTrack2 = !wasTracked(dep);
    }
  } else {
    shouldTrack2 = !dep.has(activeEffect);
  }
  if (shouldTrack2) {
    dep.add(activeEffect);
    activeEffect.deps.push(dep);
  }
}
function trigger$1(target, type, key, newValue, oldValue, oldTarget) {
  const depsMap = targetMap.get(target);
  if (!depsMap) {
    return;
  }
  let deps = [];
  if (type === "clear") {
    deps = [...depsMap.values()];
  } else if (key === "length" && isArray$2(target)) {
    depsMap.forEach((dep, key2) => {
      if (key2 === "length" || key2 >= newValue) {
        deps.push(dep);
      }
    });
  } else {
    if (key !== void 0) {
      deps.push(depsMap.get(key));
    }
    switch (type) {
      case "add":
        if (!isArray$2(target)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        } else if (isIntegerKey(key)) {
          deps.push(depsMap.get("length"));
        }
        break;
      case "delete":
        if (!isArray$2(target)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        }
        break;
      case "set":
        if (isMap(target)) {
          deps.push(depsMap.get(ITERATE_KEY));
        }
        break;
    }
  }
  if (deps.length === 1) {
    if (deps[0]) {
      {
        triggerEffects(deps[0]);
      }
    }
  } else {
    const effects = [];
    for (const dep of deps) {
      if (dep) {
        effects.push(...dep);
      }
    }
    {
      triggerEffects(createDep(effects));
    }
  }
}
function triggerEffects(dep, debuggerEventExtraInfo) {
  for (const effect of isArray$2(dep) ? dep : [...dep]) {
    if (effect !== activeEffect || effect.allowRecurse) {
      if (effect.scheduler) {
        effect.scheduler();
      } else {
        effect.run();
      }
    }
  }
}
const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(Object.getOwnPropertyNames(Symbol).map((key) => Symbol[key]).filter(isSymbol));
const get = /* @__PURE__ */ createGetter();
const shallowGet = /* @__PURE__ */ createGetter(false, true);
const readonlyGet = /* @__PURE__ */ createGetter(true);
const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
function createArrayInstrumentations() {
  const instrumentations = {};
  ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
    instrumentations[key] = function(...args) {
      const arr = toRaw(this);
      for (let i = 0, l = this.length; i < l; i++) {
        track(arr, "get", i + "");
      }
      const res = arr[key](...args);
      if (res === -1 || res === false) {
        return arr[key](...args.map(toRaw));
      } else {
        return res;
      }
    };
  });
  ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
    instrumentations[key] = function(...args) {
      pauseTracking();
      const res = toRaw(this)[key].apply(this, args);
      resetTracking();
      return res;
    };
  });
  return instrumentations;
}
function createGetter(isReadonly2 = false, shallow = false) {
  return function get2(target, key, receiver) {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target)) {
      return target;
    }
    const targetIsArray = isArray$2(target);
    if (!isReadonly2 && targetIsArray && hasOwn$1(arrayInstrumentations, key)) {
      return Reflect.get(arrayInstrumentations, key, receiver);
    }
    const res = Reflect.get(target, key, receiver);
    if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
      return res;
    }
    if (!isReadonly2) {
      track(target, "get", key);
    }
    if (shallow) {
      return res;
    }
    if (isRef(res)) {
      const shouldUnwrap = !targetIsArray || !isIntegerKey(key);
      return shouldUnwrap ? res.value : res;
    }
    if (isObject$2(res)) {
      return isReadonly2 ? readonly(res) : reactive(res);
    }
    return res;
  };
}
const set = /* @__PURE__ */ createSetter();
const shallowSet = /* @__PURE__ */ createSetter(true);
function createSetter(shallow = false) {
  return function set2(target, key, value, receiver) {
    let oldValue = target[key];
    if (!shallow) {
      value = toRaw(value);
      oldValue = toRaw(oldValue);
      if (!isArray$2(target) && isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      }
    }
    const hadKey = isArray$2(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn$1(target, key);
    const result = Reflect.set(target, key, value, receiver);
    if (target === toRaw(receiver)) {
      if (!hadKey) {
        trigger$1(target, "add", key, value);
      } else if (hasChanged(value, oldValue)) {
        trigger$1(target, "set", key, value);
      }
    }
    return result;
  };
}
function deleteProperty(target, key) {
  const hadKey = hasOwn$1(target, key);
  target[key];
  const result = Reflect.deleteProperty(target, key);
  if (result && hadKey) {
    trigger$1(target, "delete", key, void 0);
  }
  return result;
}
function has(target, key) {
  const result = Reflect.has(target, key);
  if (!isSymbol(key) || !builtInSymbols.has(key)) {
    track(target, "has", key);
  }
  return result;
}
function ownKeys(target) {
  track(target, "iterate", isArray$2(target) ? "length" : ITERATE_KEY);
  return Reflect.ownKeys(target);
}
const mutableHandlers = {
  get,
  set,
  deleteProperty,
  has,
  ownKeys
};
const readonlyHandlers = {
  get: readonlyGet,
  set(target, key) {
    return true;
  },
  deleteProperty(target, key) {
    return true;
  }
};
const shallowReactiveHandlers = /* @__PURE__ */ extend$1({}, mutableHandlers, {
  get: shallowGet,
  set: shallowSet
});
const toShallow = (value) => value;
const getProto = (v) => Reflect.getPrototypeOf(v);
function get$1(target, key, isReadonly2 = false, isShallow = false) {
  target = target["__v_raw"];
  const rawTarget = toRaw(target);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "get", key);
  }
  !isReadonly2 && track(rawTarget, "get", rawKey);
  const { has: has2 } = getProto(rawTarget);
  const wrap = isShallow ? toShallow : isReadonly2 ? toReadonly : toReactive;
  if (has2.call(rawTarget, key)) {
    return wrap(target.get(key));
  } else if (has2.call(rawTarget, rawKey)) {
    return wrap(target.get(rawKey));
  } else if (target !== rawTarget) {
    target.get(key);
  }
}
function has$1(key, isReadonly2 = false) {
  const target = this["__v_raw"];
  const rawTarget = toRaw(target);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "has", key);
  }
  !isReadonly2 && track(rawTarget, "has", rawKey);
  return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
}
function size(target, isReadonly2 = false) {
  target = target["__v_raw"];
  !isReadonly2 && track(toRaw(target), "iterate", ITERATE_KEY);
  return Reflect.get(target, "size", target);
}
function add(value) {
  value = toRaw(value);
  const target = toRaw(this);
  const proto = getProto(target);
  const hadKey = proto.has.call(target, value);
  if (!hadKey) {
    target.add(value);
    trigger$1(target, "add", value, value);
  }
  return this;
}
function set$1(key, value) {
  value = toRaw(value);
  const target = toRaw(this);
  const { has: has2, get: get2 } = getProto(target);
  let hadKey = has2.call(target, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target, key);
  }
  const oldValue = get2.call(target, key);
  target.set(key, value);
  if (!hadKey) {
    trigger$1(target, "add", key, value);
  } else if (hasChanged(value, oldValue)) {
    trigger$1(target, "set", key, value);
  }
  return this;
}
function deleteEntry(key) {
  const target = toRaw(this);
  const { has: has2, get: get2 } = getProto(target);
  let hadKey = has2.call(target, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target, key);
  }
  get2 ? get2.call(target, key) : void 0;
  const result = target.delete(key);
  if (hadKey) {
    trigger$1(target, "delete", key, void 0);
  }
  return result;
}
function clear() {
  const target = toRaw(this);
  const hadItems = target.size !== 0;
  const result = target.clear();
  if (hadItems) {
    trigger$1(target, "clear", void 0, void 0);
  }
  return result;
}
function createForEach(isReadonly2, isShallow) {
  return function forEach3(callback, thisArg) {
    const observed = this;
    const target = observed["__v_raw"];
    const rawTarget = toRaw(target);
    const wrap = isShallow ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
    return target.forEach((value, key) => {
      return callback.call(thisArg, wrap(value), wrap(key), observed);
    });
  };
}
function createIterableMethod(method, isReadonly2, isShallow) {
  return function(...args) {
    const target = this["__v_raw"];
    const rawTarget = toRaw(target);
    const targetIsMap = isMap(rawTarget);
    const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
    const isKeyOnly = method === "keys" && targetIsMap;
    const innerIterator = target[method](...args);
    const wrap = isShallow ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
    return {
      next() {
        const { value, done } = innerIterator.next();
        return done ? { value, done } : {
          value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
          done
        };
      },
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function createReadonlyMethod(type) {
  return function(...args) {
    return type === "delete" ? false : this;
  };
}
function createInstrumentations() {
  const mutableInstrumentations2 = {
    get(key) {
      return get$1(this, key);
    },
    get size() {
      return size(this);
    },
    has: has$1,
    add,
    set: set$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, false)
  };
  const shallowInstrumentations2 = {
    get(key) {
      return get$1(this, key, false, true);
    },
    get size() {
      return size(this);
    },
    has: has$1,
    add,
    set: set$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, true)
  };
  const readonlyInstrumentations2 = {
    get(key) {
      return get$1(this, key, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false)
  };
  const shallowReadonlyInstrumentations2 = {
    get(key) {
      return get$1(this, key, true, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true)
  };
  const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
  iteratorMethods.forEach((method) => {
    mutableInstrumentations2[method] = createIterableMethod(method, false, false);
    readonlyInstrumentations2[method] = createIterableMethod(method, true, false);
    shallowInstrumentations2[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations2[method] = createIterableMethod(method, true, true);
  });
  return [
    mutableInstrumentations2,
    readonlyInstrumentations2,
    shallowInstrumentations2,
    shallowReadonlyInstrumentations2
  ];
}
const [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* @__PURE__ */ createInstrumentations();
function createInstrumentationGetter(isReadonly2, shallow) {
  const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
  return (target, key, receiver) => {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw") {
      return target;
    }
    return Reflect.get(hasOwn$1(instrumentations, key) && key in target ? instrumentations : target, key, receiver);
  };
}
const mutableCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, false)
};
const reactiveMap = new WeakMap();
const shallowReactiveMap = new WeakMap();
const readonlyMap = new WeakMap();
const shallowReadonlyMap = new WeakMap();
function targetTypeMap(rawType) {
  switch (rawType) {
    case "Object":
    case "Array":
      return 1;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2;
    default:
      return 0;
  }
}
function getTargetType(value) {
  return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
}
function reactive(target) {
  if (target && target["__v_isReadonly"]) {
    return target;
  }
  return createReactiveObject(target, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
}
function shallowReactive(target) {
  return createReactiveObject(target, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);
}
function readonly(target) {
  return createReactiveObject(target, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
}
function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
  if (!isObject$2(target)) {
    return target;
  }
  if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
    return target;
  }
  const existingProxy = proxyMap.get(target);
  if (existingProxy) {
    return existingProxy;
  }
  const targetType = getTargetType(target);
  if (targetType === 0) {
    return target;
  }
  const proxy = new Proxy(target, targetType === 2 ? collectionHandlers : baseHandlers);
  proxyMap.set(target, proxy);
  return proxy;
}
function isReactive(value) {
  if (isReadonly(value)) {
    return isReactive(value["__v_raw"]);
  }
  return !!(value && value["__v_isReactive"]);
}
function isReadonly(value) {
  return !!(value && value["__v_isReadonly"]);
}
function isProxy(value) {
  return isReactive(value) || isReadonly(value);
}
function toRaw(observed) {
  const raw = observed && observed["__v_raw"];
  return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
  def(value, "__v_skip", true);
  return value;
}
const toReactive = (value) => isObject$2(value) ? reactive(value) : value;
const toReadonly = (value) => isObject$2(value) ? readonly(value) : value;
function trackRefValue(ref2) {
  if (isTracking()) {
    ref2 = toRaw(ref2);
    if (!ref2.dep) {
      ref2.dep = createDep();
    }
    {
      trackEffects(ref2.dep);
    }
  }
}
function triggerRefValue(ref2, newVal) {
  ref2 = toRaw(ref2);
  if (ref2.dep) {
    {
      triggerEffects(ref2.dep);
    }
  }
}
function isRef(r) {
  return Boolean(r && r.__v_isRef === true);
}
function ref(value) {
  return createRef(value, false);
}
function shallowRef(value) {
  return createRef(value, true);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  return new RefImpl(rawValue, shallow);
}
class RefImpl {
  constructor(value, _shallow) {
    this._shallow = _shallow;
    this.dep = void 0;
    this.__v_isRef = true;
    this._rawValue = _shallow ? value : toRaw(value);
    this._value = _shallow ? value : toReactive(value);
  }
  get value() {
    trackRefValue(this);
    return this._value;
  }
  set value(newVal) {
    newVal = this._shallow ? newVal : toRaw(newVal);
    if (hasChanged(newVal, this._rawValue)) {
      this._rawValue = newVal;
      this._value = this._shallow ? newVal : toReactive(newVal);
      triggerRefValue(this);
    }
  }
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
const shallowUnwrapHandlers = {
  get: (target, key, receiver) => unref(Reflect.get(target, key, receiver)),
  set: (target, key, value, receiver) => {
    const oldValue = target[key];
    if (isRef(oldValue) && !isRef(value)) {
      oldValue.value = value;
      return true;
    } else {
      return Reflect.set(target, key, value, receiver);
    }
  }
};
function proxyRefs(objectWithRefs) {
  return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
function toRefs(object) {
  const ret = isArray$2(object) ? new Array(object.length) : {};
  for (const key in object) {
    ret[key] = toRef(object, key);
  }
  return ret;
}
class ObjectRefImpl {
  constructor(_object, _key) {
    this._object = _object;
    this._key = _key;
    this.__v_isRef = true;
  }
  get value() {
    return this._object[this._key];
  }
  set value(newVal) {
    this._object[this._key] = newVal;
  }
}
function toRef(object, key) {
  const val = object[key];
  return isRef(val) ? val : new ObjectRefImpl(object, key);
}
class ComputedRefImpl {
  constructor(getter, _setter, isReadonly2) {
    this._setter = _setter;
    this.dep = void 0;
    this._dirty = true;
    this.__v_isRef = true;
    this.effect = new ReactiveEffect(getter, () => {
      if (!this._dirty) {
        this._dirty = true;
        triggerRefValue(this);
      }
    });
    this["__v_isReadonly"] = isReadonly2;
  }
  get value() {
    const self2 = toRaw(this);
    trackRefValue(self2);
    if (self2._dirty) {
      self2._dirty = false;
      self2._value = self2.effect.run();
    }
    return self2._value;
  }
  set value(newValue) {
    this._setter(newValue);
  }
}
function computed(getterOrOptions, debugOptions) {
  let getter;
  let setter;
  const onlyGetter = isFunction$2(getterOrOptions);
  if (onlyGetter) {
    getter = getterOrOptions;
    setter = NOOP;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter);
  return cRef;
}
Promise.resolve();
function emit$1(instance, event, ...rawArgs) {
  const props = instance.vnode.props || EMPTY_OBJ;
  let args = rawArgs;
  const isModelListener2 = event.startsWith("update:");
  const modelArg = isModelListener2 && event.slice(7);
  if (modelArg && modelArg in props) {
    const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
    const { number: number2, trim: trim2 } = props[modifiersKey] || EMPTY_OBJ;
    if (trim2) {
      args = rawArgs.map((a) => a.trim());
    } else if (number2) {
      args = rawArgs.map(toNumber);
    }
  }
  let handlerName;
  let handler = props[handlerName = toHandlerKey(event)] || props[handlerName = toHandlerKey(camelize(event))];
  if (!handler && isModelListener2) {
    handler = props[handlerName = toHandlerKey(hyphenate(event))];
  }
  if (handler) {
    callWithAsyncErrorHandling(handler, instance, 6, args);
  }
  const onceHandler = props[handlerName + `Once`];
  if (onceHandler) {
    if (!instance.emitted) {
      instance.emitted = {};
    } else if (instance.emitted[handlerName]) {
      return;
    }
    instance.emitted[handlerName] = true;
    callWithAsyncErrorHandling(onceHandler, instance, 6, args);
  }
}
function normalizeEmitsOptions(comp, appContext, asMixin = false) {
  const cache2 = appContext.emitsCache;
  const cached = cache2.get(comp);
  if (cached !== void 0) {
    return cached;
  }
  const raw = comp.emits;
  let normalized = {};
  let hasExtends = false;
  if (!isFunction$2(comp)) {
    const extendEmits = (raw2) => {
      const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
      if (normalizedFromExtend) {
        hasExtends = true;
        extend$1(normalized, normalizedFromExtend);
      }
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendEmits);
    }
    if (comp.extends) {
      extendEmits(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendEmits);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp, null);
    return null;
  }
  if (isArray$2(raw)) {
    raw.forEach((key) => normalized[key] = null);
  } else {
    extend$1(normalized, raw);
  }
  cache2.set(comp, normalized);
  return normalized;
}
function isEmitListener(options, key) {
  if (!options || !isOn(key)) {
    return false;
  }
  key = key.slice(2).replace(/Once$/, "");
  return hasOwn$1(options, key[0].toLowerCase() + key.slice(1)) || hasOwn$1(options, hyphenate(key)) || hasOwn$1(options, key);
}
let currentRenderingInstance = null;
let currentScopeId = null;
function setCurrentRenderingInstance(instance) {
  const prev = currentRenderingInstance;
  currentRenderingInstance = instance;
  currentScopeId = instance && instance.type.__scopeId || null;
  return prev;
}
function pushScopeId(id) {
  currentScopeId = id;
}
function popScopeId() {
  currentScopeId = null;
}
const withScopeId = (_id) => withCtx;
function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
  if (!ctx)
    return fn;
  if (fn._n) {
    return fn;
  }
  const renderFnWithContext = (...args) => {
    if (renderFnWithContext._d) {
      setBlockTracking(-1);
    }
    const prevInstance = setCurrentRenderingInstance(ctx);
    const res = fn(...args);
    setCurrentRenderingInstance(prevInstance);
    if (renderFnWithContext._d) {
      setBlockTracking(1);
    }
    return res;
  };
  renderFnWithContext._n = true;
  renderFnWithContext._c = true;
  renderFnWithContext._d = true;
  return renderFnWithContext;
}
function markAttrsAccessed() {
}
function renderComponentRoot(instance) {
  const { type: Component, vnode, proxy, withProxy, props, propsOptions: [propsOptions], slots, attrs, emit, render: render2, renderCache, data: data2, setupState, ctx, inheritAttrs } = instance;
  let result;
  let fallthroughAttrs;
  const prev = setCurrentRenderingInstance(instance);
  try {
    if (vnode.shapeFlag & 4) {
      const proxyToUse = withProxy || proxy;
      result = normalizeVNode(render2.call(proxyToUse, proxyToUse, renderCache, props, setupState, data2, ctx));
      fallthroughAttrs = attrs;
    } else {
      const render3 = Component;
      if (false)
        ;
      result = normalizeVNode(render3.length > 1 ? render3(props, false ? {
        get attrs() {
          markAttrsAccessed();
          return attrs;
        },
        slots,
        emit
      } : { attrs, slots, emit }) : render3(props, null));
      fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
    }
  } catch (err) {
    blockStack.length = 0;
    handleError(err, instance, 1);
    result = createVNode(Comment);
  }
  let root2 = result;
  if (fallthroughAttrs && inheritAttrs !== false) {
    const keys = Object.keys(fallthroughAttrs);
    const { shapeFlag } = root2;
    if (keys.length) {
      if (shapeFlag & (1 | 6)) {
        if (propsOptions && keys.some(isModelListener)) {
          fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);
        }
        root2 = cloneVNode(root2, fallthroughAttrs);
      }
    }
  }
  if (vnode.dirs) {
    root2.dirs = root2.dirs ? root2.dirs.concat(vnode.dirs) : vnode.dirs;
  }
  if (vnode.transition) {
    root2.transition = vnode.transition;
  }
  {
    result = root2;
  }
  setCurrentRenderingInstance(prev);
  return result;
}
const getFunctionalFallthrough = (attrs) => {
  let res;
  for (const key in attrs) {
    if (key === "class" || key === "style" || isOn(key)) {
      (res || (res = {}))[key] = attrs[key];
    }
  }
  return res;
};
const filterModelListeners = (attrs, props) => {
  const res = {};
  for (const key in attrs) {
    if (!isModelListener(key) || !(key.slice(9) in props)) {
      res[key] = attrs[key];
    }
  }
  return res;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
  const { props: prevProps, children: prevChildren, component } = prevVNode;
  const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
  const emits = component.emitsOptions;
  if (nextVNode.dirs || nextVNode.transition) {
    return true;
  }
  if (optimized && patchFlag >= 0) {
    if (patchFlag & 1024) {
      return true;
    }
    if (patchFlag & 16) {
      if (!prevProps) {
        return !!nextProps;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    } else if (patchFlag & 8) {
      const dynamicProps = nextVNode.dynamicProps;
      for (let i = 0; i < dynamicProps.length; i++) {
        const key = dynamicProps[i];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
          return true;
        }
      }
    }
  } else {
    if (prevChildren || nextChildren) {
      if (!nextChildren || !nextChildren.$stable) {
        return true;
      }
    }
    if (prevProps === nextProps) {
      return false;
    }
    if (!prevProps) {
      return !!nextProps;
    }
    if (!nextProps) {
      return true;
    }
    return hasPropsChanged(prevProps, nextProps, emits);
  }
  return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
  const nextKeys = Object.keys(nextProps);
  if (nextKeys.length !== Object.keys(prevProps).length) {
    return true;
  }
  for (let i = 0; i < nextKeys.length; i++) {
    const key = nextKeys[i];
    if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
      return true;
    }
  }
  return false;
}
function updateHOCHostEl({ vnode, parent }, el) {
  while (parent && parent.subTree === vnode) {
    (vnode = parent.vnode).el = el;
    parent = parent.parent;
  }
}
const isSuspense = (type) => type.__isSuspense;
function queueEffectWithSuspense(fn, suspense) {
  if (suspense && suspense.pendingBranch) {
    if (isArray$2(fn)) {
      suspense.effects.push(...fn);
    } else {
      suspense.effects.push(fn);
    }
  } else {
    queuePostFlushCb(fn);
  }
}
function provide(key, value) {
  if (!currentInstance)
    ;
  else {
    let provides = currentInstance.provides;
    const parentProvides = currentInstance.parent && currentInstance.parent.provides;
    if (parentProvides === provides) {
      provides = currentInstance.provides = Object.create(parentProvides);
    }
    provides[key] = value;
  }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
  const instance = currentInstance || currentRenderingInstance;
  if (instance) {
    const provides = instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides;
    if (provides && key in provides) {
      return provides[key];
    } else if (arguments.length > 1) {
      return treatDefaultAsFactory && isFunction$2(defaultValue) ? defaultValue.call(instance.proxy) : defaultValue;
    } else
      ;
  }
}
function useTransitionState() {
  const state = {
    isMounted: false,
    isLeaving: false,
    isUnmounting: false,
    leavingVNodes: new Map()
  };
  onMounted(() => {
    state.isMounted = true;
  });
  onBeforeUnmount(() => {
    state.isUnmounting = true;
  });
  return state;
}
const TransitionHookValidator = [Function, Array];
const BaseTransitionImpl = {
  name: `BaseTransition`,
  props: {
    mode: String,
    appear: Boolean,
    persisted: Boolean,
    onBeforeEnter: TransitionHookValidator,
    onEnter: TransitionHookValidator,
    onAfterEnter: TransitionHookValidator,
    onEnterCancelled: TransitionHookValidator,
    onBeforeLeave: TransitionHookValidator,
    onLeave: TransitionHookValidator,
    onAfterLeave: TransitionHookValidator,
    onLeaveCancelled: TransitionHookValidator,
    onBeforeAppear: TransitionHookValidator,
    onAppear: TransitionHookValidator,
    onAfterAppear: TransitionHookValidator,
    onAppearCancelled: TransitionHookValidator
  },
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevTransitionKey;
    return () => {
      const children = slots.default && getTransitionRawChildren(slots.default(), true);
      if (!children || !children.length) {
        return;
      }
      const rawProps = toRaw(props);
      const { mode } = rawProps;
      const child = children[0];
      if (state.isLeaving) {
        return emptyPlaceholder(child);
      }
      const innerChild = getKeepAliveChild(child);
      if (!innerChild) {
        return emptyPlaceholder(child);
      }
      const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);
      setTransitionHooks(innerChild, enterHooks);
      const oldChild = instance.subTree;
      const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
      let transitionKeyChanged = false;
      const { getTransitionKey } = innerChild.type;
      if (getTransitionKey) {
        const key = getTransitionKey();
        if (prevTransitionKey === void 0) {
          prevTransitionKey = key;
        } else if (key !== prevTransitionKey) {
          prevTransitionKey = key;
          transitionKeyChanged = true;
        }
      }
      if (oldInnerChild && oldInnerChild.type !== Comment && (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {
        const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);
        setTransitionHooks(oldInnerChild, leavingHooks);
        if (mode === "out-in") {
          state.isLeaving = true;
          leavingHooks.afterLeave = () => {
            state.isLeaving = false;
            instance.update();
          };
          return emptyPlaceholder(child);
        } else if (mode === "in-out" && innerChild.type !== Comment) {
          leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {
            const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);
            leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
            el._leaveCb = () => {
              earlyRemove();
              el._leaveCb = void 0;
              delete enterHooks.delayedLeave;
            };
            enterHooks.delayedLeave = delayedLeave;
          };
        }
      }
      return child;
    };
  }
};
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
  const { leavingVNodes } = state;
  let leavingVNodesCache = leavingVNodes.get(vnode.type);
  if (!leavingVNodesCache) {
    leavingVNodesCache = Object.create(null);
    leavingVNodes.set(vnode.type, leavingVNodesCache);
  }
  return leavingVNodesCache;
}
function resolveTransitionHooks(vnode, props, state, instance) {
  const { appear, mode, persisted = false, onBeforeEnter, onEnter, onAfterEnter, onEnterCancelled, onBeforeLeave, onLeave, onAfterLeave, onLeaveCancelled, onBeforeAppear, onAppear, onAfterAppear, onAppearCancelled } = props;
  const key = String(vnode.key);
  const leavingVNodesCache = getLeavingNodesForType(state, vnode);
  const callHook2 = (hook, args) => {
    hook && callWithAsyncErrorHandling(hook, instance, 9, args);
  };
  const hooks = {
    mode,
    persisted,
    beforeEnter(el) {
      let hook = onBeforeEnter;
      if (!state.isMounted) {
        if (appear) {
          hook = onBeforeAppear || onBeforeEnter;
        } else {
          return;
        }
      }
      if (el._leaveCb) {
        el._leaveCb(true);
      }
      const leavingVNode = leavingVNodesCache[key];
      if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el._leaveCb) {
        leavingVNode.el._leaveCb();
      }
      callHook2(hook, [el]);
    },
    enter(el) {
      let hook = onEnter;
      let afterHook = onAfterEnter;
      let cancelHook = onEnterCancelled;
      if (!state.isMounted) {
        if (appear) {
          hook = onAppear || onEnter;
          afterHook = onAfterAppear || onAfterEnter;
          cancelHook = onAppearCancelled || onEnterCancelled;
        } else {
          return;
        }
      }
      let called = false;
      const done = el._enterCb = (cancelled) => {
        if (called)
          return;
        called = true;
        if (cancelled) {
          callHook2(cancelHook, [el]);
        } else {
          callHook2(afterHook, [el]);
        }
        if (hooks.delayedLeave) {
          hooks.delayedLeave();
        }
        el._enterCb = void 0;
      };
      if (hook) {
        hook(el, done);
        if (hook.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    leave(el, remove2) {
      const key2 = String(vnode.key);
      if (el._enterCb) {
        el._enterCb(true);
      }
      if (state.isUnmounting) {
        return remove2();
      }
      callHook2(onBeforeLeave, [el]);
      let called = false;
      const done = el._leaveCb = (cancelled) => {
        if (called)
          return;
        called = true;
        remove2();
        if (cancelled) {
          callHook2(onLeaveCancelled, [el]);
        } else {
          callHook2(onAfterLeave, [el]);
        }
        el._leaveCb = void 0;
        if (leavingVNodesCache[key2] === vnode) {
          delete leavingVNodesCache[key2];
        }
      };
      leavingVNodesCache[key2] = vnode;
      if (onLeave) {
        onLeave(el, done);
        if (onLeave.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    clone(vnode2) {
      return resolveTransitionHooks(vnode2, props, state, instance);
    }
  };
  return hooks;
}
function emptyPlaceholder(vnode) {
  if (isKeepAlive(vnode)) {
    vnode = cloneVNode(vnode);
    vnode.children = null;
    return vnode;
  }
}
function getKeepAliveChild(vnode) {
  return isKeepAlive(vnode) ? vnode.children ? vnode.children[0] : void 0 : vnode;
}
function setTransitionHooks(vnode, hooks) {
  if (vnode.shapeFlag & 6 && vnode.component) {
    setTransitionHooks(vnode.component.subTree, hooks);
  } else if (vnode.shapeFlag & 128) {
    vnode.ssContent.transition = hooks.clone(vnode.ssContent);
    vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
  } else {
    vnode.transition = hooks;
  }
}
function getTransitionRawChildren(children, keepComment = false) {
  let ret = [];
  let keyedFragmentCount = 0;
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    if (child.type === Fragment) {
      if (child.patchFlag & 128)
        keyedFragmentCount++;
      ret = ret.concat(getTransitionRawChildren(child.children, keepComment));
    } else if (keepComment || child.type !== Comment) {
      ret.push(child);
    }
  }
  if (keyedFragmentCount > 1) {
    for (let i = 0; i < ret.length; i++) {
      ret[i].patchFlag = -2;
    }
  }
  return ret;
}
function defineComponent(options) {
  return isFunction$2(options) ? { setup: options, name: options.name } : options;
}
const isAsyncWrapper = (i) => !!i.type.__asyncLoader;
function defineAsyncComponent(source2) {
  if (isFunction$2(source2)) {
    source2 = { loader: source2 };
  }
  const {
    loader,
    loadingComponent,
    errorComponent,
    delay = 200,
    timeout,
    suspensible = true,
    onError: userOnError
  } = source2;
  let pendingRequest = null;
  let resolvedComp;
  let retries = 0;
  const retry = () => {
    retries++;
    pendingRequest = null;
    return load();
  };
  const load = () => {
    let thisRequest;
    return pendingRequest || (thisRequest = pendingRequest = loader().catch((err) => {
      err = err instanceof Error ? err : new Error(String(err));
      if (userOnError) {
        return new Promise((resolve2, reject) => {
          const userRetry = () => resolve2(retry());
          const userFail = () => reject(err);
          userOnError(err, userRetry, userFail, retries + 1);
        });
      } else {
        throw err;
      }
    }).then((comp) => {
      if (thisRequest !== pendingRequest && pendingRequest) {
        return pendingRequest;
      }
      if (comp && (comp.__esModule || comp[Symbol.toStringTag] === "Module")) {
        comp = comp.default;
      }
      resolvedComp = comp;
      return comp;
    }));
  };
  return defineComponent({
    name: "AsyncComponentWrapper",
    __asyncLoader: load,
    get __asyncResolved() {
      return resolvedComp;
    },
    setup() {
      const instance = currentInstance;
      if (resolvedComp) {
        return () => createInnerComp(resolvedComp, instance);
      }
      const onError = (err) => {
        pendingRequest = null;
        handleError(err, instance, 13, !errorComponent);
      };
      if (suspensible && instance.suspense || isInSSRComponentSetup) {
        return load().then((comp) => {
          return () => createInnerComp(comp, instance);
        }).catch((err) => {
          onError(err);
          return () => errorComponent ? createVNode(errorComponent, {
            error: err
          }) : null;
        });
      }
      const loaded = ref(false);
      const error = ref();
      const delayed = ref(!!delay);
      if (delay) {
        setTimeout(() => {
          delayed.value = false;
        }, delay);
      }
      if (timeout != null) {
        setTimeout(() => {
          if (!loaded.value && !error.value) {
            const err = new Error(`Async component timed out after ${timeout}ms.`);
            onError(err);
            error.value = err;
          }
        }, timeout);
      }
      load().then(() => {
        loaded.value = true;
        if (instance.parent && isKeepAlive(instance.parent.vnode)) {
          queueJob(instance.parent.update);
        }
      }).catch((err) => {
        onError(err);
        error.value = err;
      });
      return () => {
        if (loaded.value && resolvedComp) {
          return createInnerComp(resolvedComp, instance);
        } else if (error.value && errorComponent) {
          return createVNode(errorComponent, {
            error: error.value
          });
        } else if (loadingComponent && !delayed.value) {
          return createVNode(loadingComponent);
        }
      };
    }
  });
}
function createInnerComp(comp, { vnode: { ref: ref2, props, children } }) {
  const vnode = createVNode(comp, props, children);
  vnode.ref = ref2;
  return vnode;
}
const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
function onActivated(hook, target) {
  registerKeepAliveHook(hook, "a", target);
}
function onDeactivated(hook, target) {
  registerKeepAliveHook(hook, "da", target);
}
function registerKeepAliveHook(hook, type, target = currentInstance) {
  const wrappedHook = hook.__wdc || (hook.__wdc = () => {
    let current = target;
    while (current) {
      if (current.isDeactivated) {
        return;
      }
      current = current.parent;
    }
    hook();
  });
  injectHook(type, wrappedHook, target);
  if (target) {
    let current = target.parent;
    while (current && current.parent) {
      if (isKeepAlive(current.parent.vnode)) {
        injectToKeepAliveRoot(wrappedHook, type, target, current);
      }
      current = current.parent;
    }
  }
}
function injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {
  const injected = injectHook(type, hook, keepAliveRoot, true);
  onUnmounted(() => {
    remove(keepAliveRoot[type], injected);
  }, target);
}
function injectHook(type, hook, target = currentInstance, prepend = false) {
  if (target) {
    const hooks = target[type] || (target[type] = []);
    const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
      if (target.isUnmounted) {
        return;
      }
      pauseTracking();
      setCurrentInstance(target);
      const res = callWithAsyncErrorHandling(hook, target, type, args);
      unsetCurrentInstance();
      resetTracking();
      return res;
    });
    if (prepend) {
      hooks.unshift(wrappedHook);
    } else {
      hooks.push(wrappedHook);
    }
    return wrappedHook;
  }
}
const createHook = (lifecycle) => (hook, target = currentInstance) => (!isInSSRComponentSetup || lifecycle === "sp") && injectHook(lifecycle, hook, target);
const onBeforeMount = createHook("bm");
const onMounted = createHook("m");
const onBeforeUpdate = createHook("bu");
const onUpdated = createHook("u");
const onBeforeUnmount = createHook("bum");
const onUnmounted = createHook("um");
const onServerPrefetch = createHook("sp");
const onRenderTriggered = createHook("rtg");
const onRenderTracked = createHook("rtc");
function onErrorCaptured(hook, target = currentInstance) {
  injectHook("ec", hook, target);
}
let shouldCacheAccess = true;
function applyOptions(instance) {
  const options = resolveMergedOptions(instance);
  const publicThis = instance.proxy;
  const ctx = instance.ctx;
  shouldCacheAccess = false;
  if (options.beforeCreate) {
    callHook$1(options.beforeCreate, instance, "bc");
  }
  const {
    data: dataOptions,
    computed: computedOptions,
    methods,
    watch: watchOptions,
    provide: provideOptions,
    inject: injectOptions,
    created,
    beforeMount,
    mounted,
    beforeUpdate,
    updated,
    activated,
    deactivated,
    beforeDestroy,
    beforeUnmount,
    destroyed,
    unmounted,
    render: render2,
    renderTracked,
    renderTriggered,
    errorCaptured,
    serverPrefetch,
    expose,
    inheritAttrs,
    components,
    directives,
    filters
  } = options;
  const checkDuplicateProperties = null;
  if (injectOptions) {
    resolveInjections(injectOptions, ctx, checkDuplicateProperties, instance.appContext.config.unwrapInjectedRef);
  }
  if (methods) {
    for (const key in methods) {
      const methodHandler = methods[key];
      if (isFunction$2(methodHandler)) {
        {
          ctx[key] = methodHandler.bind(publicThis);
        }
      }
    }
  }
  if (dataOptions) {
    const data2 = dataOptions.call(publicThis, publicThis);
    if (!isObject$2(data2))
      ;
    else {
      instance.data = reactive(data2);
    }
  }
  shouldCacheAccess = true;
  if (computedOptions) {
    for (const key in computedOptions) {
      const opt = computedOptions[key];
      const get2 = isFunction$2(opt) ? opt.bind(publicThis, publicThis) : isFunction$2(opt.get) ? opt.get.bind(publicThis, publicThis) : NOOP;
      const set2 = !isFunction$2(opt) && isFunction$2(opt.set) ? opt.set.bind(publicThis) : NOOP;
      const c = computed({
        get: get2,
        set: set2
      });
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => c.value,
        set: (v) => c.value = v
      });
    }
  }
  if (watchOptions) {
    for (const key in watchOptions) {
      createWatcher(watchOptions[key], ctx, publicThis, key);
    }
  }
  if (provideOptions) {
    const provides = isFunction$2(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
    Reflect.ownKeys(provides).forEach((key) => {
      provide(key, provides[key]);
    });
  }
  if (created) {
    callHook$1(created, instance, "c");
  }
  function registerLifecycleHook(register, hook) {
    if (isArray$2(hook)) {
      hook.forEach((_hook) => register(_hook.bind(publicThis)));
    } else if (hook) {
      register(hook.bind(publicThis));
    }
  }
  registerLifecycleHook(onBeforeMount, beforeMount);
  registerLifecycleHook(onMounted, mounted);
  registerLifecycleHook(onBeforeUpdate, beforeUpdate);
  registerLifecycleHook(onUpdated, updated);
  registerLifecycleHook(onActivated, activated);
  registerLifecycleHook(onDeactivated, deactivated);
  registerLifecycleHook(onErrorCaptured, errorCaptured);
  registerLifecycleHook(onRenderTracked, renderTracked);
  registerLifecycleHook(onRenderTriggered, renderTriggered);
  registerLifecycleHook(onBeforeUnmount, beforeUnmount);
  registerLifecycleHook(onUnmounted, unmounted);
  registerLifecycleHook(onServerPrefetch, serverPrefetch);
  if (isArray$2(expose)) {
    if (expose.length) {
      const exposed = instance.exposed || (instance.exposed = {});
      expose.forEach((key) => {
        Object.defineProperty(exposed, key, {
          get: () => publicThis[key],
          set: (val) => publicThis[key] = val
        });
      });
    } else if (!instance.exposed) {
      instance.exposed = {};
    }
  }
  if (render2 && instance.render === NOOP) {
    instance.render = render2;
  }
  if (inheritAttrs != null) {
    instance.inheritAttrs = inheritAttrs;
  }
  if (components)
    instance.components = components;
  if (directives)
    instance.directives = directives;
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP, unwrapRef = false) {
  if (isArray$2(injectOptions)) {
    injectOptions = normalizeInject(injectOptions);
  }
  for (const key in injectOptions) {
    const opt = injectOptions[key];
    let injected;
    if (isObject$2(opt)) {
      if ("default" in opt) {
        injected = inject(opt.from || key, opt.default, true);
      } else {
        injected = inject(opt.from || key);
      }
    } else {
      injected = inject(opt);
    }
    if (isRef(injected)) {
      if (unwrapRef) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => injected.value,
          set: (v) => injected.value = v
        });
      } else {
        ctx[key] = injected;
      }
    } else {
      ctx[key] = injected;
    }
  }
}
function callHook$1(hook, instance, type) {
  callWithAsyncErrorHandling(isArray$2(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy), instance, type);
}
function createWatcher(raw, ctx, publicThis, key) {
  const getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
  if (isString$3(raw)) {
    const handler = ctx[raw];
    if (isFunction$2(handler)) {
      watch(getter, handler);
    }
  } else if (isFunction$2(raw)) {
    watch(getter, raw.bind(publicThis));
  } else if (isObject$2(raw)) {
    if (isArray$2(raw)) {
      raw.forEach((r) => createWatcher(r, ctx, publicThis, key));
    } else {
      const handler = isFunction$2(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
      if (isFunction$2(handler)) {
        watch(getter, handler, raw);
      }
    }
  } else
    ;
}
function resolveMergedOptions(instance) {
  const base = instance.type;
  const { mixins, extends: extendsOptions } = base;
  const { mixins: globalMixins, optionsCache: cache2, config: { optionMergeStrategies } } = instance.appContext;
  const cached = cache2.get(base);
  let resolved;
  if (cached) {
    resolved = cached;
  } else if (!globalMixins.length && !mixins && !extendsOptions) {
    {
      resolved = base;
    }
  } else {
    resolved = {};
    if (globalMixins.length) {
      globalMixins.forEach((m) => mergeOptions$1(resolved, m, optionMergeStrategies, true));
    }
    mergeOptions$1(resolved, base, optionMergeStrategies);
  }
  cache2.set(base, resolved);
  return resolved;
}
function mergeOptions$1(to, from, strats, asMixin = false) {
  const { mixins, extends: extendsOptions } = from;
  if (extendsOptions) {
    mergeOptions$1(to, extendsOptions, strats, true);
  }
  if (mixins) {
    mixins.forEach((m) => mergeOptions$1(to, m, strats, true));
  }
  for (const key in from) {
    if (asMixin && key === "expose")
      ;
    else {
      const strat = internalOptionMergeStrats[key] || strats && strats[key];
      to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
  }
  return to;
}
const internalOptionMergeStrats = {
  data: mergeDataFn,
  props: mergeObjectOptions,
  emits: mergeObjectOptions,
  methods: mergeObjectOptions,
  computed: mergeObjectOptions,
  beforeCreate: mergeAsArray,
  created: mergeAsArray,
  beforeMount: mergeAsArray,
  mounted: mergeAsArray,
  beforeUpdate: mergeAsArray,
  updated: mergeAsArray,
  beforeDestroy: mergeAsArray,
  beforeUnmount: mergeAsArray,
  destroyed: mergeAsArray,
  unmounted: mergeAsArray,
  activated: mergeAsArray,
  deactivated: mergeAsArray,
  errorCaptured: mergeAsArray,
  serverPrefetch: mergeAsArray,
  components: mergeObjectOptions,
  directives: mergeObjectOptions,
  watch: mergeWatchOptions,
  provide: mergeDataFn,
  inject: mergeInject
};
function mergeDataFn(to, from) {
  if (!from) {
    return to;
  }
  if (!to) {
    return from;
  }
  return function mergedDataFn() {
    return extend$1(isFunction$2(to) ? to.call(this, this) : to, isFunction$2(from) ? from.call(this, this) : from);
  };
}
function mergeInject(to, from) {
  return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
  if (isArray$2(raw)) {
    const res = {};
    for (let i = 0; i < raw.length; i++) {
      res[raw[i]] = raw[i];
    }
    return res;
  }
  return raw;
}
function mergeAsArray(to, from) {
  return to ? [...new Set([].concat(to, from))] : from;
}
function mergeObjectOptions(to, from) {
  return to ? extend$1(extend$1(Object.create(null), to), from) : from;
}
function mergeWatchOptions(to, from) {
  if (!to)
    return from;
  if (!from)
    return to;
  const merged = extend$1(Object.create(null), to);
  for (const key in from) {
    merged[key] = mergeAsArray(to[key], from[key]);
  }
  return merged;
}
function initProps(instance, rawProps, isStateful, isSSR = false) {
  const props = {};
  const attrs = {};
  def(attrs, InternalObjectKey, 1);
  instance.propsDefaults = Object.create(null);
  setFullProps(instance, rawProps, props, attrs);
  for (const key in instance.propsOptions[0]) {
    if (!(key in props)) {
      props[key] = void 0;
    }
  }
  if (isStateful) {
    instance.props = isSSR ? props : shallowReactive(props);
  } else {
    if (!instance.type.props) {
      instance.props = attrs;
    } else {
      instance.props = props;
    }
  }
  instance.attrs = attrs;
}
function updateProps(instance, rawProps, rawPrevProps, optimized) {
  const { props, attrs, vnode: { patchFlag } } = instance;
  const rawCurrentProps = toRaw(props);
  const [options] = instance.propsOptions;
  let hasAttrsChanged = false;
  if ((optimized || patchFlag > 0) && !(patchFlag & 16)) {
    if (patchFlag & 8) {
      const propsToUpdate = instance.vnode.dynamicProps;
      for (let i = 0; i < propsToUpdate.length; i++) {
        let key = propsToUpdate[i];
        const value = rawProps[key];
        if (options) {
          if (hasOwn$1(attrs, key)) {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          } else {
            const camelizedKey = camelize(key);
            props[camelizedKey] = resolvePropValue(options, rawCurrentProps, camelizedKey, value, instance, false);
          }
        } else {
          if (value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
  } else {
    if (setFullProps(instance, rawProps, props, attrs)) {
      hasAttrsChanged = true;
    }
    let kebabKey;
    for (const key in rawCurrentProps) {
      if (!rawProps || !hasOwn$1(rawProps, key) && ((kebabKey = hyphenate(key)) === key || !hasOwn$1(rawProps, kebabKey))) {
        if (options) {
          if (rawPrevProps && (rawPrevProps[key] !== void 0 || rawPrevProps[kebabKey] !== void 0)) {
            props[key] = resolvePropValue(options, rawCurrentProps, key, void 0, instance, true);
          }
        } else {
          delete props[key];
        }
      }
    }
    if (attrs !== rawCurrentProps) {
      for (const key in attrs) {
        if (!rawProps || !hasOwn$1(rawProps, key)) {
          delete attrs[key];
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (hasAttrsChanged) {
    trigger$1(instance, "set", "$attrs");
  }
}
function setFullProps(instance, rawProps, props, attrs) {
  const [options, needCastKeys] = instance.propsOptions;
  let hasAttrsChanged = false;
  let rawCastValues;
  if (rawProps) {
    for (let key in rawProps) {
      if (isReservedProp(key)) {
        continue;
      }
      const value = rawProps[key];
      let camelKey;
      if (options && hasOwn$1(options, camelKey = camelize(key))) {
        if (!needCastKeys || !needCastKeys.includes(camelKey)) {
          props[camelKey] = value;
        } else {
          (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        }
      } else if (!isEmitListener(instance.emitsOptions, key)) {
        if (value !== attrs[key]) {
          attrs[key] = value;
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (needCastKeys) {
    const rawCurrentProps = toRaw(props);
    const castValues = rawCastValues || EMPTY_OBJ;
    for (let i = 0; i < needCastKeys.length; i++) {
      const key = needCastKeys[i];
      props[key] = resolvePropValue(options, rawCurrentProps, key, castValues[key], instance, !hasOwn$1(castValues, key));
    }
  }
  return hasAttrsChanged;
}
function resolvePropValue(options, props, key, value, instance, isAbsent) {
  const opt = options[key];
  if (opt != null) {
    const hasDefault = hasOwn$1(opt, "default");
    if (hasDefault && value === void 0) {
      const defaultValue = opt.default;
      if (opt.type !== Function && isFunction$2(defaultValue)) {
        const { propsDefaults } = instance;
        if (key in propsDefaults) {
          value = propsDefaults[key];
        } else {
          setCurrentInstance(instance);
          value = propsDefaults[key] = defaultValue.call(null, props);
          unsetCurrentInstance();
        }
      } else {
        value = defaultValue;
      }
    }
    if (opt[0]) {
      if (isAbsent && !hasDefault) {
        value = false;
      } else if (opt[1] && (value === "" || value === hyphenate(key))) {
        value = true;
      }
    }
  }
  return value;
}
function normalizePropsOptions(comp, appContext, asMixin = false) {
  const cache2 = appContext.propsCache;
  const cached = cache2.get(comp);
  if (cached) {
    return cached;
  }
  const raw = comp.props;
  const normalized = {};
  const needCastKeys = [];
  let hasExtends = false;
  if (!isFunction$2(comp)) {
    const extendProps = (raw2) => {
      hasExtends = true;
      const [props, keys] = normalizePropsOptions(raw2, appContext, true);
      extend$1(normalized, props);
      if (keys)
        needCastKeys.push(...keys);
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendProps);
    }
    if (comp.extends) {
      extendProps(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendProps);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp, EMPTY_ARR);
    return EMPTY_ARR;
  }
  if (isArray$2(raw)) {
    for (let i = 0; i < raw.length; i++) {
      const normalizedKey = camelize(raw[i]);
      if (validatePropName(normalizedKey)) {
        normalized[normalizedKey] = EMPTY_OBJ;
      }
    }
  } else if (raw) {
    for (const key in raw) {
      const normalizedKey = camelize(key);
      if (validatePropName(normalizedKey)) {
        const opt = raw[key];
        const prop = normalized[normalizedKey] = isArray$2(opt) || isFunction$2(opt) ? { type: opt } : opt;
        if (prop) {
          const booleanIndex = getTypeIndex(Boolean, prop.type);
          const stringIndex = getTypeIndex(String, prop.type);
          prop[0] = booleanIndex > -1;
          prop[1] = stringIndex < 0 || booleanIndex < stringIndex;
          if (booleanIndex > -1 || hasOwn$1(prop, "default")) {
            needCastKeys.push(normalizedKey);
          }
        }
      }
    }
  }
  const res = [normalized, needCastKeys];
  cache2.set(comp, res);
  return res;
}
function validatePropName(key) {
  if (key[0] !== "$") {
    return true;
  }
  return false;
}
function getType(ctor) {
  const match = ctor && ctor.toString().match(/^\s*function (\w+)/);
  return match ? match[1] : ctor === null ? "null" : "";
}
function isSameType(a, b) {
  return getType(a) === getType(b);
}
function getTypeIndex(type, expectedTypes) {
  if (isArray$2(expectedTypes)) {
    return expectedTypes.findIndex((t) => isSameType(t, type));
  } else if (isFunction$2(expectedTypes)) {
    return isSameType(expectedTypes, type) ? 0 : -1;
  }
  return -1;
}
const isInternalKey = (key) => key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value) => isArray$2(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
const normalizeSlot$1 = (key, rawSlot, ctx) => {
  const normalized = withCtx((...args) => {
    return normalizeSlotValue(rawSlot(...args));
  }, ctx);
  normalized._c = false;
  return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance) => {
  const ctx = rawSlots._ctx;
  for (const key in rawSlots) {
    if (isInternalKey(key))
      continue;
    const value = rawSlots[key];
    if (isFunction$2(value)) {
      slots[key] = normalizeSlot$1(key, value, ctx);
    } else if (value != null) {
      const normalized = normalizeSlotValue(value);
      slots[key] = () => normalized;
    }
  }
};
const normalizeVNodeSlots = (instance, children) => {
  const normalized = normalizeSlotValue(children);
  instance.slots.default = () => normalized;
};
const initSlots = (instance, children) => {
  if (instance.vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      instance.slots = toRaw(children);
      def(children, "_", type);
    } else {
      normalizeObjectSlots(children, instance.slots = {});
    }
  } else {
    instance.slots = {};
    if (children) {
      normalizeVNodeSlots(instance, children);
    }
  }
  def(instance.slots, InternalObjectKey, 1);
};
const updateSlots = (instance, children, optimized) => {
  const { vnode, slots } = instance;
  let needDeletionCheck = true;
  let deletionComparisonTarget = EMPTY_OBJ;
  if (vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      if (optimized && type === 1) {
        needDeletionCheck = false;
      } else {
        extend$1(slots, children);
        if (!optimized && type === 1) {
          delete slots._;
        }
      }
    } else {
      needDeletionCheck = !children.$stable;
      normalizeObjectSlots(children, slots);
    }
    deletionComparisonTarget = children;
  } else if (children) {
    normalizeVNodeSlots(instance, children);
    deletionComparisonTarget = { default: 1 };
  }
  if (needDeletionCheck) {
    for (const key in slots) {
      if (!isInternalKey(key) && !(key in deletionComparisonTarget)) {
        delete slots[key];
      }
    }
  }
};
function withDirectives(vnode, directives) {
  const internalInstance = currentRenderingInstance;
  if (internalInstance === null) {
    return vnode;
  }
  const instance = internalInstance.proxy;
  const bindings = vnode.dirs || (vnode.dirs = []);
  for (let i = 0; i < directives.length; i++) {
    let [dir, value, arg, modifiers = EMPTY_OBJ] = directives[i];
    if (isFunction$2(dir)) {
      dir = {
        mounted: dir,
        updated: dir
      };
    }
    if (dir.deep) {
      traverse(value);
    }
    bindings.push({
      dir,
      instance,
      value,
      oldValue: void 0,
      arg,
      modifiers
    });
  }
  return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name) {
  const bindings = vnode.dirs;
  const oldBindings = prevVNode && prevVNode.dirs;
  for (let i = 0; i < bindings.length; i++) {
    const binding = bindings[i];
    if (oldBindings) {
      binding.oldValue = oldBindings[i].value;
    }
    let hook = binding.dir[name];
    if (hook) {
      pauseTracking();
      callWithAsyncErrorHandling(hook, instance, 8, [
        vnode.el,
        binding,
        vnode,
        prevVNode
      ]);
      resetTracking();
    }
  }
}
function createAppContext() {
  return {
    app: null,
    config: {
      isNativeTag: NO,
      performance: false,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: Object.create(null),
    optionsCache: new WeakMap(),
    propsCache: new WeakMap(),
    emitsCache: new WeakMap()
  };
}
let uid = 0;
function createAppAPI(render2, hydrate) {
  return function createApp2(rootComponent, rootProps = null) {
    if (rootProps != null && !isObject$2(rootProps)) {
      rootProps = null;
    }
    const context = createAppContext();
    const installedPlugins = new Set();
    let isMounted = false;
    const app = context.app = {
      _uid: uid++,
      _component: rootComponent,
      _props: rootProps,
      _container: null,
      _context: context,
      _instance: null,
      version,
      get config() {
        return context.config;
      },
      set config(v) {
      },
      use(plugin, ...options) {
        if (installedPlugins.has(plugin))
          ;
        else if (plugin && isFunction$2(plugin.install)) {
          installedPlugins.add(plugin);
          plugin.install(app, ...options);
        } else if (isFunction$2(plugin)) {
          installedPlugins.add(plugin);
          plugin(app, ...options);
        } else
          ;
        return app;
      },
      mixin(mixin) {
        {
          if (!context.mixins.includes(mixin)) {
            context.mixins.push(mixin);
          }
        }
        return app;
      },
      component(name, component) {
        if (!component) {
          return context.components[name];
        }
        context.components[name] = component;
        return app;
      },
      directive(name, directive) {
        if (!directive) {
          return context.directives[name];
        }
        context.directives[name] = directive;
        return app;
      },
      mount(rootContainer, isHydrate, isSVG) {
        if (!isMounted) {
          const vnode = createVNode(rootComponent, rootProps);
          vnode.appContext = context;
          if (isHydrate && hydrate) {
            hydrate(vnode, rootContainer);
          } else {
            render2(vnode, rootContainer, isSVG);
          }
          isMounted = true;
          app._container = rootContainer;
          rootContainer.__vue_app__ = app;
          return getExposeProxy(vnode.component) || vnode.component.proxy;
        }
      },
      unmount() {
        if (isMounted) {
          render2(null, app._container);
          delete app._container.__vue_app__;
        }
      },
      provide(key, value) {
        context.provides[key] = value;
        return app;
      }
    };
    return app;
  };
}
const queuePostRenderEffect = queueEffectWithSuspense;
function createRenderer(options) {
  return baseCreateRenderer(options);
}
function baseCreateRenderer(options, createHydrationFns) {
  const target = getGlobalThis$1();
  target.__VUE__ = true;
  const { insert: hostInsert, remove: hostRemove, patchProp: hostPatchProp, createElement: hostCreateElement, createText: hostCreateText, createComment: hostCreateComment, setText: hostSetText, setElementText: hostSetElementText, parentNode: hostParentNode, nextSibling: hostNextSibling, setScopeId: hostSetScopeId = NOOP, cloneNode: hostCloneNode, insertStaticContent: hostInsertStaticContent } = options;
  const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = !!n2.dynamicChildren) => {
    if (n1 === n2) {
      return;
    }
    if (n1 && !isSameVNodeType(n1, n2)) {
      anchor = getNextHostNode(n1);
      unmount(n1, parentComponent, parentSuspense, true);
      n1 = null;
    }
    if (n2.patchFlag === -2) {
      optimized = false;
      n2.dynamicChildren = null;
    }
    const { type, ref: ref2, shapeFlag } = n2;
    switch (type) {
      case Text:
        processText(n1, n2, container, anchor);
        break;
      case Comment:
        processCommentNode(n1, n2, container, anchor);
        break;
      case Static:
        if (n1 == null) {
          mountStaticNode(n2, container, anchor, isSVG);
        }
        break;
      case Fragment:
        processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        break;
      default:
        if (shapeFlag & 1) {
          processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 6) {
          processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 64) {
          type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else if (shapeFlag & 128) {
          type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else
          ;
    }
    if (ref2 != null && parentComponent) {
      setRef(ref2, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    }
  };
  const processText = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateText(n2.children), container, anchor);
    } else {
      const el = n2.el = n1.el;
      if (n2.children !== n1.children) {
        hostSetText(el, n2.children);
      }
    }
  };
  const processCommentNode = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateComment(n2.children || ""), container, anchor);
    } else {
      n2.el = n1.el;
    }
  };
  const mountStaticNode = (n2, container, anchor, isSVG) => {
    [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG);
  };
  const moveStaticNode = ({ el, anchor }, container, nextSibling) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostInsert(el, container, nextSibling);
      el = next;
    }
    hostInsert(anchor, container, nextSibling);
  };
  const removeStaticNode = ({ el, anchor }) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostRemove(el);
      el = next;
    }
    hostRemove(anchor);
  };
  const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    isSVG = isSVG || n2.type === "svg";
    if (n1 == null) {
      mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let el;
    let vnodeHook;
    const { type, props, shapeFlag, transition, patchFlag, dirs } = vnode;
    if (vnode.el && hostCloneNode !== void 0 && patchFlag === -1) {
      el = vnode.el = hostCloneNode(vnode.el);
    } else {
      el = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);
      if (shapeFlag & 8) {
        hostSetElementText(el, vnode.children);
      } else if (shapeFlag & 16) {
        mountChildren(vnode.children, el, null, parentComponent, parentSuspense, isSVG && type !== "foreignObject", slotScopeIds, optimized);
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      if (props) {
        for (const key in props) {
          if (key !== "value" && !isReservedProp(key)) {
            hostPatchProp(el, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
        if ("value" in props) {
          hostPatchProp(el, "value", null, props.value);
        }
        if (vnodeHook = props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
      }
      setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
    }
    const needCallTransitionHooks = (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
    if (needCallTransitionHooks) {
      transition.beforeEnter(el);
    }
    hostInsert(el, container, anchor);
    if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        needCallTransitionHooks && transition.enter(el);
        dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
      }, parentSuspense);
    }
  };
  const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {
    if (scopeId) {
      hostSetScopeId(el, scopeId);
    }
    if (slotScopeIds) {
      for (let i = 0; i < slotScopeIds.length; i++) {
        hostSetScopeId(el, slotScopeIds[i]);
      }
    }
    if (parentComponent) {
      let subTree = parentComponent.subTree;
      if (vnode === subTree) {
        const parentVNode = parentComponent.vnode;
        setScopeId(el, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);
      }
    }
  };
  const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start = 0) => {
    for (let i = start; i < children.length; i++) {
      const child = children[i] = optimized ? cloneIfMounted(children[i]) : normalizeVNode(children[i]);
      patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const el = n2.el = n1.el;
    let { patchFlag, dynamicChildren, dirs } = n2;
    patchFlag |= n1.patchFlag & 16;
    const oldProps = n1.props || EMPTY_OBJ;
    const newProps = n2.props || EMPTY_OBJ;
    let vnodeHook;
    if (vnodeHook = newProps.onVnodeBeforeUpdate) {
      invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
    }
    if (dirs) {
      invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
    }
    const areChildrenSVG = isSVG && n2.type !== "foreignObject";
    if (dynamicChildren) {
      patchBlockChildren(n1.dynamicChildren, dynamicChildren, el, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);
    } else if (!optimized) {
      patchChildren(n1, n2, el, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);
    }
    if (patchFlag > 0) {
      if (patchFlag & 16) {
        patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
      } else {
        if (patchFlag & 2) {
          if (oldProps.class !== newProps.class) {
            hostPatchProp(el, "class", null, newProps.class, isSVG);
          }
        }
        if (patchFlag & 4) {
          hostPatchProp(el, "style", oldProps.style, newProps.style, isSVG);
        }
        if (patchFlag & 8) {
          const propsToUpdate = n2.dynamicProps;
          for (let i = 0; i < propsToUpdate.length; i++) {
            const key = propsToUpdate[i];
            const prev = oldProps[key];
            const next = newProps[key];
            if (next !== prev || key === "value") {
              hostPatchProp(el, key, prev, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);
            }
          }
        }
      }
      if (patchFlag & 1) {
        if (n1.children !== n2.children) {
          hostSetElementText(el, n2.children);
        }
      }
    } else if (!optimized && dynamicChildren == null) {
      patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
    }
    if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
      }, parentSuspense);
    }
  };
  const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds) => {
    for (let i = 0; i < newChildren.length; i++) {
      const oldVNode = oldChildren[i];
      const newVNode = newChildren[i];
      const container = oldVNode.el && (oldVNode.type === Fragment || !isSameVNodeType(oldVNode, newVNode) || oldVNode.shapeFlag & (6 | 64)) ? hostParentNode(oldVNode.el) : fallbackContainer;
      patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);
    }
  };
  const patchProps = (el, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG) => {
    if (oldProps !== newProps) {
      for (const key in newProps) {
        if (isReservedProp(key))
          continue;
        const next = newProps[key];
        const prev = oldProps[key];
        if (next !== prev && key !== "value") {
          hostPatchProp(el, key, prev, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
        }
      }
      if (oldProps !== EMPTY_OBJ) {
        for (const key in oldProps) {
          if (!isReservedProp(key) && !(key in newProps)) {
            hostPatchProp(el, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
      }
      if ("value" in newProps) {
        hostPatchProp(el, "value", oldProps.value, newProps.value);
      }
    }
  };
  const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
    const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
    let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    if (n1 == null) {
      hostInsert(fragmentStartAnchor, container, anchor);
      hostInsert(fragmentEndAnchor, container, anchor);
      mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && n1.dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);
        if (n2.key != null || parentComponent && n2 === parentComponent.subTree) {
          traverseStaticChildren(n1, n2, true);
        }
      } else {
        patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      }
    }
  };
  const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    n2.slotScopeIds = slotScopeIds;
    if (n1 == null) {
      if (n2.shapeFlag & 512) {
        parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);
      } else {
        mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);
      }
    } else {
      updateComponent(n1, n2, optimized);
    }
  };
  const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized) => {
    const instance = initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense);
    if (isKeepAlive(initialVNode)) {
      instance.ctx.renderer = internals;
    }
    {
      setupComponent(instance);
    }
    if (instance.asyncDep) {
      parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
      if (!initialVNode.el) {
        const placeholder = instance.subTree = createVNode(Comment);
        processCommentNode(null, placeholder, container, anchor);
      }
      return;
    }
    setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);
  };
  const updateComponent = (n1, n2, optimized) => {
    const instance = n2.component = n1.component;
    if (shouldUpdateComponent(n1, n2, optimized)) {
      if (instance.asyncDep && !instance.asyncResolved) {
        updateComponentPreRender(instance, n2, optimized);
        return;
      } else {
        instance.next = n2;
        invalidateJob(instance.update);
        instance.update();
      }
    } else {
      n2.component = n1.component;
      n2.el = n1.el;
      instance.vnode = n2;
    }
  };
  const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized) => {
    const componentUpdateFn = () => {
      if (!instance.isMounted) {
        let vnodeHook;
        const { el, props } = initialVNode;
        const { bm, m, parent } = instance;
        const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
        effect.allowRecurse = false;
        if (bm) {
          invokeArrayFns(bm);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
          invokeVNodeHook(vnodeHook, parent, initialVNode);
        }
        effect.allowRecurse = true;
        if (el && hydrateNode) {
          const hydrateSubTree = () => {
            instance.subTree = renderComponentRoot(instance);
            hydrateNode(el, instance.subTree, instance, parentSuspense, null);
          };
          if (isAsyncWrapperVNode) {
            initialVNode.type.__asyncLoader().then(() => !instance.isUnmounted && hydrateSubTree());
          } else {
            hydrateSubTree();
          }
        } else {
          const subTree = instance.subTree = renderComponentRoot(instance);
          patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);
          initialVNode.el = subTree.el;
        }
        if (m) {
          queuePostRenderEffect(m, parentSuspense);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
          const scopedInitialVNode = initialVNode;
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);
        }
        if (initialVNode.shapeFlag & 256) {
          instance.a && queuePostRenderEffect(instance.a, parentSuspense);
        }
        instance.isMounted = true;
        initialVNode = container = anchor = null;
      } else {
        let { next, bu, u, parent, vnode } = instance;
        let originNext = next;
        let vnodeHook;
        effect.allowRecurse = false;
        if (next) {
          next.el = vnode.el;
          updateComponentPreRender(instance, next, optimized);
        } else {
          next = vnode;
        }
        if (bu) {
          invokeArrayFns(bu);
        }
        if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
          invokeVNodeHook(vnodeHook, parent, next, vnode);
        }
        effect.allowRecurse = true;
        const nextTree = renderComponentRoot(instance);
        const prevTree = instance.subTree;
        instance.subTree = nextTree;
        patch(prevTree, nextTree, hostParentNode(prevTree.el), getNextHostNode(prevTree), instance, parentSuspense, isSVG);
        next.el = nextTree.el;
        if (originNext === null) {
          updateHOCHostEl(instance, nextTree.el);
        }
        if (u) {
          queuePostRenderEffect(u, parentSuspense);
        }
        if (vnodeHook = next.props && next.props.onVnodeUpdated) {
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);
        }
      }
    };
    const effect = new ReactiveEffect(componentUpdateFn, () => queueJob(instance.update), instance.scope);
    const update = instance.update = effect.run.bind(effect);
    update.id = instance.uid;
    effect.allowRecurse = update.allowRecurse = true;
    update();
  };
  const updateComponentPreRender = (instance, nextVNode, optimized) => {
    nextVNode.component = instance;
    const prevProps = instance.vnode.props;
    instance.vnode = nextVNode;
    instance.next = null;
    updateProps(instance, nextVNode.props, prevProps, optimized);
    updateSlots(instance, nextVNode.children, optimized);
    pauseTracking();
    flushPreFlushCbs(void 0, instance.update);
    resetTracking();
  };
  const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false) => {
    const c1 = n1 && n1.children;
    const prevShapeFlag = n1 ? n1.shapeFlag : 0;
    const c2 = n2.children;
    const { patchFlag, shapeFlag } = n2;
    if (patchFlag > 0) {
      if (patchFlag & 128) {
        patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      } else if (patchFlag & 256) {
        patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      }
    }
    if (shapeFlag & 8) {
      if (prevShapeFlag & 16) {
        unmountChildren(c1, parentComponent, parentSuspense);
      }
      if (c2 !== c1) {
        hostSetElementText(container, c2);
      }
    } else {
      if (prevShapeFlag & 16) {
        if (shapeFlag & 16) {
          patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else {
          unmountChildren(c1, parentComponent, parentSuspense, true);
        }
      } else {
        if (prevShapeFlag & 8) {
          hostSetElementText(container, "");
        }
        if (shapeFlag & 16) {
          mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      }
    }
  };
  const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    c1 = c1 || EMPTY_ARR;
    c2 = c2 || EMPTY_ARR;
    const oldLength = c1.length;
    const newLength = c2.length;
    const commonLength = Math.min(oldLength, newLength);
    let i;
    for (i = 0; i < commonLength; i++) {
      const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      patch(c1[i], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
    if (oldLength > newLength) {
      unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);
    } else {
      mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);
    }
  };
  const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let i = 0;
    const l2 = c2.length;
    let e1 = c1.length - 1;
    let e2 = l2 - 1;
    while (i <= e1 && i <= e2) {
      const n1 = c1[i];
      const n2 = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      i++;
    }
    while (i <= e1 && i <= e2) {
      const n1 = c1[e1];
      const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      e1--;
      e2--;
    }
    if (i > e1) {
      if (i <= e2) {
        const nextPos = e2 + 1;
        const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
        while (i <= e2) {
          patch(null, c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          i++;
        }
      }
    } else if (i > e2) {
      while (i <= e1) {
        unmount(c1[i], parentComponent, parentSuspense, true);
        i++;
      }
    } else {
      const s1 = i;
      const s2 = i;
      const keyToNewIndexMap = new Map();
      for (i = s2; i <= e2; i++) {
        const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
        if (nextChild.key != null) {
          keyToNewIndexMap.set(nextChild.key, i);
        }
      }
      let j;
      let patched = 0;
      const toBePatched = e2 - s2 + 1;
      let moved = false;
      let maxNewIndexSoFar = 0;
      const newIndexToOldIndexMap = new Array(toBePatched);
      for (i = 0; i < toBePatched; i++)
        newIndexToOldIndexMap[i] = 0;
      for (i = s1; i <= e1; i++) {
        const prevChild = c1[i];
        if (patched >= toBePatched) {
          unmount(prevChild, parentComponent, parentSuspense, true);
          continue;
        }
        let newIndex;
        if (prevChild.key != null) {
          newIndex = keyToNewIndexMap.get(prevChild.key);
        } else {
          for (j = s2; j <= e2; j++) {
            if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
              newIndex = j;
              break;
            }
          }
        }
        if (newIndex === void 0) {
          unmount(prevChild, parentComponent, parentSuspense, true);
        } else {
          newIndexToOldIndexMap[newIndex - s2] = i + 1;
          if (newIndex >= maxNewIndexSoFar) {
            maxNewIndexSoFar = newIndex;
          } else {
            moved = true;
          }
          patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          patched++;
        }
      }
      const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
      j = increasingNewIndexSequence.length - 1;
      for (i = toBePatched - 1; i >= 0; i--) {
        const nextIndex = s2 + i;
        const nextChild = c2[nextIndex];
        const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
        if (newIndexToOldIndexMap[i] === 0) {
          patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (moved) {
          if (j < 0 || i !== increasingNewIndexSequence[j]) {
            move(nextChild, container, anchor, 2);
          } else {
            j--;
          }
        }
      }
    }
  };
  const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
    const { el, type, transition, children, shapeFlag } = vnode;
    if (shapeFlag & 6) {
      move(vnode.component.subTree, container, anchor, moveType);
      return;
    }
    if (shapeFlag & 128) {
      vnode.suspense.move(container, anchor, moveType);
      return;
    }
    if (shapeFlag & 64) {
      type.move(vnode, container, anchor, internals);
      return;
    }
    if (type === Fragment) {
      hostInsert(el, container, anchor);
      for (let i = 0; i < children.length; i++) {
        move(children[i], container, anchor, moveType);
      }
      hostInsert(vnode.anchor, container, anchor);
      return;
    }
    if (type === Static) {
      moveStaticNode(vnode, container, anchor);
      return;
    }
    const needTransition = moveType !== 2 && shapeFlag & 1 && transition;
    if (needTransition) {
      if (moveType === 0) {
        transition.beforeEnter(el);
        hostInsert(el, container, anchor);
        queuePostRenderEffect(() => transition.enter(el), parentSuspense);
      } else {
        const { leave, delayLeave, afterLeave } = transition;
        const remove3 = () => hostInsert(el, container, anchor);
        const performLeave = () => {
          leave(el, () => {
            remove3();
            afterLeave && afterLeave();
          });
        };
        if (delayLeave) {
          delayLeave(el, remove3, performLeave);
        } else {
          performLeave();
        }
      }
    } else {
      hostInsert(el, container, anchor);
    }
  };
  const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
    const { type, props, ref: ref2, children, dynamicChildren, shapeFlag, patchFlag, dirs } = vnode;
    if (ref2 != null) {
      setRef(ref2, null, parentSuspense, vnode, true);
    }
    if (shapeFlag & 256) {
      parentComponent.ctx.deactivate(vnode);
      return;
    }
    const shouldInvokeDirs = shapeFlag & 1 && dirs;
    const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
    let vnodeHook;
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
      invokeVNodeHook(vnodeHook, parentComponent, vnode);
    }
    if (shapeFlag & 6) {
      unmountComponent(vnode.component, parentSuspense, doRemove);
    } else {
      if (shapeFlag & 128) {
        vnode.suspense.unmount(parentSuspense, doRemove);
        return;
      }
      if (shouldInvokeDirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
      }
      if (shapeFlag & 64) {
        vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);
      } else if (dynamicChildren && (type !== Fragment || patchFlag > 0 && patchFlag & 64)) {
        unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);
      } else if (type === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
        unmountChildren(children, parentComponent, parentSuspense);
      }
      if (doRemove) {
        remove2(vnode);
      }
    }
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
      }, parentSuspense);
    }
  };
  const remove2 = (vnode) => {
    const { type, el, anchor, transition } = vnode;
    if (type === Fragment) {
      removeFragment(el, anchor);
      return;
    }
    if (type === Static) {
      removeStaticNode(vnode);
      return;
    }
    const performRemove = () => {
      hostRemove(el);
      if (transition && !transition.persisted && transition.afterLeave) {
        transition.afterLeave();
      }
    };
    if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
      const { leave, delayLeave } = transition;
      const performLeave = () => leave(el, performRemove);
      if (delayLeave) {
        delayLeave(vnode.el, performRemove, performLeave);
      } else {
        performLeave();
      }
    } else {
      performRemove();
    }
  };
  const removeFragment = (cur, end) => {
    let next;
    while (cur !== end) {
      next = hostNextSibling(cur);
      hostRemove(cur);
      cur = next;
    }
    hostRemove(end);
  };
  const unmountComponent = (instance, parentSuspense, doRemove) => {
    const { bum, scope, update, subTree, um } = instance;
    if (bum) {
      invokeArrayFns(bum);
    }
    scope.stop();
    if (update) {
      update.active = false;
      unmount(subTree, instance, parentSuspense, doRemove);
    }
    if (um) {
      queuePostRenderEffect(um, parentSuspense);
    }
    queuePostRenderEffect(() => {
      instance.isUnmounted = true;
    }, parentSuspense);
    if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
      parentSuspense.deps--;
      if (parentSuspense.deps === 0) {
        parentSuspense.resolve();
      }
    }
  };
  const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {
    for (let i = start; i < children.length; i++) {
      unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);
    }
  };
  const getNextHostNode = (vnode) => {
    if (vnode.shapeFlag & 6) {
      return getNextHostNode(vnode.component.subTree);
    }
    if (vnode.shapeFlag & 128) {
      return vnode.suspense.next();
    }
    return hostNextSibling(vnode.anchor || vnode.el);
  };
  const render2 = (vnode, container, isSVG) => {
    if (vnode == null) {
      if (container._vnode) {
        unmount(container._vnode, null, null, true);
      }
    } else {
      patch(container._vnode || null, vnode, container, null, null, null, isSVG);
    }
    flushPostFlushCbs();
    container._vnode = vnode;
  };
  const internals = {
    p: patch,
    um: unmount,
    m: move,
    r: remove2,
    mt: mountComponent,
    mc: mountChildren,
    pc: patchChildren,
    pbc: patchBlockChildren,
    n: getNextHostNode,
    o: options
  };
  let hydrate;
  let hydrateNode;
  if (createHydrationFns) {
    [hydrate, hydrateNode] = createHydrationFns(internals);
  }
  return {
    render: render2,
    hydrate,
    createApp: createAppAPI(render2, hydrate)
  };
}
function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
  if (isArray$2(rawRef)) {
    rawRef.forEach((r, i) => setRef(r, oldRawRef && (isArray$2(oldRawRef) ? oldRawRef[i] : oldRawRef), parentSuspense, vnode, isUnmount));
    return;
  }
  if (isAsyncWrapper(vnode) && !isUnmount) {
    return;
  }
  const refValue = vnode.shapeFlag & 4 ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
  const value = isUnmount ? null : refValue;
  const { i: owner, r: ref2 } = rawRef;
  const oldRef = oldRawRef && oldRawRef.r;
  const refs = owner.refs === EMPTY_OBJ ? owner.refs = {} : owner.refs;
  const setupState = owner.setupState;
  if (oldRef != null && oldRef !== ref2) {
    if (isString$3(oldRef)) {
      refs[oldRef] = null;
      if (hasOwn$1(setupState, oldRef)) {
        setupState[oldRef] = null;
      }
    } else if (isRef(oldRef)) {
      oldRef.value = null;
    }
  }
  if (isString$3(ref2)) {
    const doSet = () => {
      {
        refs[ref2] = value;
      }
      if (hasOwn$1(setupState, ref2)) {
        setupState[ref2] = value;
      }
    };
    if (value) {
      doSet.id = -1;
      queuePostRenderEffect(doSet, parentSuspense);
    } else {
      doSet();
    }
  } else if (isRef(ref2)) {
    const doSet = () => {
      ref2.value = value;
    };
    if (value) {
      doSet.id = -1;
      queuePostRenderEffect(doSet, parentSuspense);
    } else {
      doSet();
    }
  } else if (isFunction$2(ref2)) {
    callWithErrorHandling(ref2, owner, 12, [value, refs]);
  } else
    ;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
  callWithAsyncErrorHandling(hook, instance, 7, [
    vnode,
    prevVNode
  ]);
}
function traverseStaticChildren(n1, n2, shallow = false) {
  const ch1 = n1.children;
  const ch2 = n2.children;
  if (isArray$2(ch1) && isArray$2(ch2)) {
    for (let i = 0; i < ch1.length; i++) {
      const c1 = ch1[i];
      let c2 = ch2[i];
      if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
        if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
          c2 = ch2[i] = cloneIfMounted(ch2[i]);
          c2.el = c1.el;
        }
        if (!shallow)
          traverseStaticChildren(c1, c2);
      }
    }
  }
}
function getSequence(arr) {
  const p2 = arr.slice();
  const result = [0];
  let i, j, u, v, c;
  const len = arr.length;
  for (i = 0; i < len; i++) {
    const arrI = arr[i];
    if (arrI !== 0) {
      j = result[result.length - 1];
      if (arr[j] < arrI) {
        p2[i] = j;
        result.push(i);
        continue;
      }
      u = 0;
      v = result.length - 1;
      while (u < v) {
        c = u + v >> 1;
        if (arr[result[c]] < arrI) {
          u = c + 1;
        } else {
          v = c;
        }
      }
      if (arrI < arr[result[u]]) {
        if (u > 0) {
          p2[i] = result[u - 1];
        }
        result[u] = i;
      }
    }
  }
  u = result.length;
  v = result[u - 1];
  while (u-- > 0) {
    result[u] = v;
    v = p2[v];
  }
  return result;
}
const isTeleport = (type) => type.__isTeleport;
const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
const isTargetSVG = (target) => typeof SVGElement !== "undefined" && target instanceof SVGElement;
const resolveTarget = (props, select) => {
  const targetSelector = props && props.to;
  if (isString$3(targetSelector)) {
    if (!select) {
      return null;
    } else {
      const target = select(targetSelector);
      return target;
    }
  } else {
    return targetSelector;
  }
};
const TeleportImpl = {
  __isTeleport: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {
    const { mc: mountChildren, pc: patchChildren, pbc: patchBlockChildren, o: { insert, querySelector, createText, createComment } } = internals;
    const disabled = isTeleportDisabled(n2.props);
    let { shapeFlag, children, dynamicChildren } = n2;
    if (n1 == null) {
      const placeholder = n2.el = createText("");
      const mainAnchor = n2.anchor = createText("");
      insert(placeholder, container, anchor);
      insert(mainAnchor, container, anchor);
      const target = n2.target = resolveTarget(n2.props, querySelector);
      const targetAnchor = n2.targetAnchor = createText("");
      if (target) {
        insert(targetAnchor, target);
        isSVG = isSVG || isTargetSVG(target);
      }
      const mount = (container2, anchor2) => {
        if (shapeFlag & 16) {
          mountChildren(children, container2, anchor2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      };
      if (disabled) {
        mount(container, mainAnchor);
      } else if (target) {
        mount(target, targetAnchor);
      }
    } else {
      n2.el = n1.el;
      const mainAnchor = n2.anchor = n1.anchor;
      const target = n2.target = n1.target;
      const targetAnchor = n2.targetAnchor = n1.targetAnchor;
      const wasDisabled = isTeleportDisabled(n1.props);
      const currentContainer = wasDisabled ? container : target;
      const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
      isSVG = isSVG || isTargetSVG(target);
      if (dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);
        traverseStaticChildren(n1, n2, true);
      } else if (!optimized) {
        patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);
      }
      if (disabled) {
        if (!wasDisabled) {
          moveTeleport(n2, container, mainAnchor, internals, 1);
        }
      } else {
        if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
          const nextTarget = n2.target = resolveTarget(n2.props, querySelector);
          if (nextTarget) {
            moveTeleport(n2, nextTarget, null, internals, 0);
          }
        } else if (wasDisabled) {
          moveTeleport(n2, target, targetAnchor, internals, 1);
        }
      }
    }
  },
  remove(vnode, parentComponent, parentSuspense, optimized, { um: unmount, o: { remove: hostRemove } }, doRemove) {
    const { shapeFlag, children, anchor, targetAnchor, target, props } = vnode;
    if (target) {
      hostRemove(targetAnchor);
    }
    if (doRemove || !isTeleportDisabled(props)) {
      hostRemove(anchor);
      if (shapeFlag & 16) {
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);
        }
      }
    }
  },
  move: moveTeleport,
  hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, { o: { insert }, m: move }, moveType = 2) {
  if (moveType === 0) {
    insert(vnode.targetAnchor, container, parentAnchor);
  }
  const { el, anchor, shapeFlag, children, props } = vnode;
  const isReorder = moveType === 2;
  if (isReorder) {
    insert(el, container, parentAnchor);
  }
  if (!isReorder || isTeleportDisabled(props)) {
    if (shapeFlag & 16) {
      for (let i = 0; i < children.length; i++) {
        move(children[i], container, parentAnchor, 2);
      }
    }
  }
  if (isReorder) {
    insert(anchor, container, parentAnchor);
  }
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, { o: { nextSibling, parentNode, querySelector } }, hydrateChildren) {
  const target = vnode.target = resolveTarget(vnode.props, querySelector);
  if (target) {
    const targetNode = target._lpa || target.firstChild;
    if (vnode.shapeFlag & 16) {
      if (isTeleportDisabled(vnode.props)) {
        vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);
        vnode.targetAnchor = targetNode;
      } else {
        vnode.anchor = nextSibling(node);
        vnode.targetAnchor = hydrateChildren(targetNode, vnode, target, parentComponent, parentSuspense, slotScopeIds, optimized);
      }
      target._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
    }
  }
  return vnode.anchor && nextSibling(vnode.anchor);
}
const Teleport = TeleportImpl;
const COMPONENTS = "components";
const DIRECTIVES = "directives";
function resolveComponent(name, maybeSelfReference) {
  return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;
}
const NULL_DYNAMIC_COMPONENT = Symbol();
function resolveDynamicComponent(component) {
  if (isString$3(component)) {
    return resolveAsset(COMPONENTS, component, false) || component;
  } else {
    return component || NULL_DYNAMIC_COMPONENT;
  }
}
function resolveDirective(name) {
  return resolveAsset(DIRECTIVES, name);
}
function resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {
  const instance = currentRenderingInstance || currentInstance;
  if (instance) {
    const Component = instance.type;
    if (type === COMPONENTS) {
      const selfName = getComponentName(Component);
      if (selfName && (selfName === name || selfName === camelize(name) || selfName === capitalize(camelize(name)))) {
        return Component;
      }
    }
    const res = resolve(instance[type] || Component[type], name) || resolve(instance.appContext[type], name);
    if (!res && maybeSelfReference) {
      return Component;
    }
    return res;
  }
}
function resolve(registry, name) {
  return registry && (registry[name] || registry[camelize(name)] || registry[capitalize(camelize(name))]);
}
const Fragment = Symbol(void 0);
const Text = Symbol(void 0);
const Comment = Symbol(void 0);
const Static = Symbol(void 0);
const blockStack = [];
let currentBlock = null;
function openBlock(disableTracking = false) {
  blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
  blockStack.pop();
  currentBlock = blockStack[blockStack.length - 1] || null;
}
let isBlockTreeEnabled = 1;
function setBlockTracking(value) {
  isBlockTreeEnabled += value;
}
function setupBlock(vnode) {
  vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
  closeBlock();
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(vnode);
  }
  return vnode;
}
function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
  return setupBlock(createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, true));
}
function createBlock(type, props, children, patchFlag, dynamicProps) {
  return setupBlock(createVNode(type, props, children, patchFlag, dynamicProps, true));
}
function isVNode(value) {
  return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
  return n1.type === n2.type && n1.key === n2.key;
}
const InternalObjectKey = `__vInternal`;
const normalizeKey = ({ key }) => key != null ? key : null;
const normalizeRef = ({ ref: ref2 }) => {
  return ref2 != null ? isString$3(ref2) || isRef(ref2) || isFunction$2(ref2) ? { i: currentRenderingInstance, r: ref2 } : ref2 : null;
};
function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
  const vnode = {
    __v_isVNode: true,
    __v_skip: true,
    type,
    props,
    key: props && normalizeKey(props),
    ref: props && normalizeRef(props),
    scopeId: currentScopeId,
    slotScopeIds: null,
    children,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag,
    patchFlag,
    dynamicProps,
    dynamicChildren: null,
    appContext: null
  };
  if (needFullChildrenNormalization) {
    normalizeChildren(vnode, children);
    if (shapeFlag & 128) {
      type.normalize(vnode);
    }
  } else if (children) {
    vnode.shapeFlag |= isString$3(children) ? 8 : 16;
  }
  if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock && (vnode.patchFlag > 0 || shapeFlag & 6) && vnode.patchFlag !== 32) {
    currentBlock.push(vnode);
  }
  return vnode;
}
const createVNode = _createVNode;
function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
  if (!type || type === NULL_DYNAMIC_COMPONENT) {
    type = Comment;
  }
  if (isVNode(type)) {
    const cloned = cloneVNode(type, props, true);
    if (children) {
      normalizeChildren(cloned, children);
    }
    return cloned;
  }
  if (isClassComponent(type)) {
    type = type.__vccOpts;
  }
  if (props) {
    props = guardReactiveProps(props);
    let { class: klass, style } = props;
    if (klass && !isString$3(klass)) {
      props.class = normalizeClass(klass);
    }
    if (isObject$2(style)) {
      if (isProxy(style) && !isArray$2(style)) {
        style = extend$1({}, style);
      }
      props.style = normalizeStyle(style);
    }
  }
  const shapeFlag = isString$3(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : isObject$2(type) ? 4 : isFunction$2(type) ? 2 : 0;
  return createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);
}
function guardReactiveProps(props) {
  if (!props)
    return null;
  return isProxy(props) || InternalObjectKey in props ? extend$1({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false) {
  const { props, ref: ref2, patchFlag, children } = vnode;
  const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
  const cloned = {
    __v_isVNode: true,
    __v_skip: true,
    type: vnode.type,
    props: mergedProps,
    key: mergedProps && normalizeKey(mergedProps),
    ref: extraProps && extraProps.ref ? mergeRef && ref2 ? isArray$2(ref2) ? ref2.concat(normalizeRef(extraProps)) : [ref2, normalizeRef(extraProps)] : normalizeRef(extraProps) : ref2,
    scopeId: vnode.scopeId,
    slotScopeIds: vnode.slotScopeIds,
    children,
    target: vnode.target,
    targetAnchor: vnode.targetAnchor,
    staticCount: vnode.staticCount,
    shapeFlag: vnode.shapeFlag,
    patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
    dynamicProps: vnode.dynamicProps,
    dynamicChildren: vnode.dynamicChildren,
    appContext: vnode.appContext,
    dirs: vnode.dirs,
    transition: vnode.transition,
    component: vnode.component,
    suspense: vnode.suspense,
    ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
    ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
    el: vnode.el,
    anchor: vnode.anchor
  };
  return cloned;
}
function createTextVNode(text = " ", flag = 0) {
  return createVNode(Text, null, text, flag);
}
function createStaticVNode(content, numberOfNodes) {
  const vnode = createVNode(Static, null, content);
  vnode.staticCount = numberOfNodes;
  return vnode;
}
function createCommentVNode(text = "", asBlock = false) {
  return asBlock ? (openBlock(), createBlock(Comment, null, text)) : createVNode(Comment, null, text);
}
function normalizeVNode(child) {
  if (child == null || typeof child === "boolean") {
    return createVNode(Comment);
  } else if (isArray$2(child)) {
    return createVNode(Fragment, null, child.slice());
  } else if (typeof child === "object") {
    return cloneIfMounted(child);
  } else {
    return createVNode(Text, null, String(child));
  }
}
function cloneIfMounted(child) {
  return child.el === null || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
  let type = 0;
  const { shapeFlag } = vnode;
  if (children == null) {
    children = null;
  } else if (isArray$2(children)) {
    type = 16;
  } else if (typeof children === "object") {
    if (shapeFlag & (1 | 64)) {
      const slot = children.default;
      if (slot) {
        slot._c && (slot._d = false);
        normalizeChildren(vnode, slot());
        slot._c && (slot._d = true);
      }
      return;
    } else {
      type = 32;
      const slotFlag = children._;
      if (!slotFlag && !(InternalObjectKey in children)) {
        children._ctx = currentRenderingInstance;
      } else if (slotFlag === 3 && currentRenderingInstance) {
        if (currentRenderingInstance.slots._ === 1) {
          children._ = 1;
        } else {
          children._ = 2;
          vnode.patchFlag |= 1024;
        }
      }
    }
  } else if (isFunction$2(children)) {
    children = { default: children, _ctx: currentRenderingInstance };
    type = 32;
  } else {
    children = String(children);
    if (shapeFlag & 64) {
      type = 16;
      children = [createTextVNode(children)];
    } else {
      type = 8;
    }
  }
  vnode.children = children;
  vnode.shapeFlag |= type;
}
function mergeProps(...args) {
  const ret = {};
  for (let i = 0; i < args.length; i++) {
    const toMerge = args[i];
    for (const key in toMerge) {
      if (key === "class") {
        if (ret.class !== toMerge.class) {
          ret.class = normalizeClass([ret.class, toMerge.class]);
        }
      } else if (key === "style") {
        ret.style = normalizeStyle([ret.style, toMerge.style]);
      } else if (isOn(key)) {
        const existing = ret[key];
        const incoming = toMerge[key];
        if (existing !== incoming) {
          ret[key] = existing ? [].concat(existing, incoming) : incoming;
        }
      } else if (key !== "") {
        ret[key] = toMerge[key];
      }
    }
  }
  return ret;
}
function renderList(source2, renderItem, cache2, index) {
  let ret;
  const cached = cache2 && cache2[index];
  if (isArray$2(source2) || isString$3(source2)) {
    ret = new Array(source2.length);
    for (let i = 0, l = source2.length; i < l; i++) {
      ret[i] = renderItem(source2[i], i, void 0, cached && cached[i]);
    }
  } else if (typeof source2 === "number") {
    ret = new Array(source2);
    for (let i = 0; i < source2; i++) {
      ret[i] = renderItem(i + 1, i, void 0, cached && cached[i]);
    }
  } else if (isObject$2(source2)) {
    if (source2[Symbol.iterator]) {
      ret = Array.from(source2, (item, i) => renderItem(item, i, void 0, cached && cached[i]));
    } else {
      const keys = Object.keys(source2);
      ret = new Array(keys.length);
      for (let i = 0, l = keys.length; i < l; i++) {
        const key = keys[i];
        ret[i] = renderItem(source2[key], key, i, cached && cached[i]);
      }
    }
  } else {
    ret = [];
  }
  if (cache2) {
    cache2[index] = ret;
  }
  return ret;
}
function createSlots(slots, dynamicSlots) {
  for (let i = 0; i < dynamicSlots.length; i++) {
    const slot = dynamicSlots[i];
    if (isArray$2(slot)) {
      for (let j = 0; j < slot.length; j++) {
        slots[slot[j].name] = slot[j].fn;
      }
    } else if (slot) {
      slots[slot.name] = slot.fn;
    }
  }
  return slots;
}
function renderSlot(slots, name, props = {}, fallback, noSlotted) {
  if (currentRenderingInstance.isCE) {
    return createVNode("slot", name === "default" ? null : { name }, fallback && fallback());
  }
  let slot = slots[name];
  if (slot && slot._c) {
    slot._d = false;
  }
  openBlock();
  const validSlotContent = slot && ensureValidVNode(slot(props));
  const rendered = createBlock(Fragment, { key: props.key || `_${name}` }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 ? 64 : -2);
  if (!noSlotted && rendered.scopeId) {
    rendered.slotScopeIds = [rendered.scopeId + "-s"];
  }
  if (slot && slot._c) {
    slot._d = true;
  }
  return rendered;
}
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode(child))
      return true;
    if (child.type === Comment)
      return false;
    if (child.type === Fragment && !ensureValidVNode(child.children))
      return false;
    return true;
  }) ? vnodes : null;
}
function toHandlers(obj) {
  const ret = {};
  for (const key in obj) {
    ret[toHandlerKey(key)] = obj[key];
  }
  return ret;
}
const getPublicInstance = (i) => {
  if (!i)
    return null;
  if (isStatefulComponent(i))
    return getExposeProxy(i) || i.proxy;
  return getPublicInstance(i.parent);
};
const publicPropertiesMap = extend$1(Object.create(null), {
  $: (i) => i,
  $el: (i) => i.vnode.el,
  $data: (i) => i.data,
  $props: (i) => i.props,
  $attrs: (i) => i.attrs,
  $slots: (i) => i.slots,
  $refs: (i) => i.refs,
  $parent: (i) => getPublicInstance(i.parent),
  $root: (i) => getPublicInstance(i.root),
  $emit: (i) => i.emit,
  $options: (i) => resolveMergedOptions(i),
  $forceUpdate: (i) => () => queueJob(i.update),
  $nextTick: (i) => nextTick.bind(i.proxy),
  $watch: (i) => instanceWatch.bind(i)
});
const PublicInstanceProxyHandlers = {
  get({ _: instance }, key) {
    const { ctx, setupState, data: data2, props, accessCache, type, appContext } = instance;
    let normalizedProps;
    if (key[0] !== "$") {
      const n = accessCache[key];
      if (n !== void 0) {
        switch (n) {
          case 0:
            return setupState[key];
          case 1:
            return data2[key];
          case 3:
            return ctx[key];
          case 2:
            return props[key];
        }
      } else if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
        accessCache[key] = 0;
        return setupState[key];
      } else if (data2 !== EMPTY_OBJ && hasOwn$1(data2, key)) {
        accessCache[key] = 1;
        return data2[key];
      } else if ((normalizedProps = instance.propsOptions[0]) && hasOwn$1(normalizedProps, key)) {
        accessCache[key] = 2;
        return props[key];
      } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
        accessCache[key] = 3;
        return ctx[key];
      } else if (shouldCacheAccess) {
        accessCache[key] = 4;
      }
    }
    const publicGetter = publicPropertiesMap[key];
    let cssModule, globalProperties;
    if (publicGetter) {
      if (key === "$attrs") {
        track(instance, "get", key);
      }
      return publicGetter(instance);
    } else if ((cssModule = type.__cssModules) && (cssModule = cssModule[key])) {
      return cssModule;
    } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
      accessCache[key] = 3;
      return ctx[key];
    } else if (globalProperties = appContext.config.globalProperties, hasOwn$1(globalProperties, key)) {
      {
        return globalProperties[key];
      }
    } else
      ;
  },
  set({ _: instance }, key, value) {
    const { data: data2, setupState, ctx } = instance;
    if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
      setupState[key] = value;
    } else if (data2 !== EMPTY_OBJ && hasOwn$1(data2, key)) {
      data2[key] = value;
    } else if (hasOwn$1(instance.props, key)) {
      return false;
    }
    if (key[0] === "$" && key.slice(1) in instance) {
      return false;
    } else {
      {
        ctx[key] = value;
      }
    }
    return true;
  },
  has({ _: { data: data2, setupState, accessCache, ctx, appContext, propsOptions } }, key) {
    let normalizedProps;
    return accessCache[key] !== void 0 || data2 !== EMPTY_OBJ && hasOwn$1(data2, key) || setupState !== EMPTY_OBJ && hasOwn$1(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn$1(normalizedProps, key) || hasOwn$1(ctx, key) || hasOwn$1(publicPropertiesMap, key) || hasOwn$1(appContext.config.globalProperties, key);
  }
};
const emptyAppContext = createAppContext();
let uid$1 = 0;
function createComponentInstance(vnode, parent, suspense) {
  const type = vnode.type;
  const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
  const instance = {
    uid: uid$1++,
    vnode,
    type,
    parent,
    appContext,
    root: null,
    next: null,
    subTree: null,
    update: null,
    scope: new EffectScope(true),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: parent ? parent.provides : Object.create(appContext.provides),
    accessCache: null,
    renderCache: [],
    components: null,
    directives: null,
    propsOptions: normalizePropsOptions(type, appContext),
    emitsOptions: normalizeEmitsOptions(type, appContext),
    emit: null,
    emitted: null,
    propsDefaults: EMPTY_OBJ,
    inheritAttrs: type.inheritAttrs,
    ctx: EMPTY_OBJ,
    data: EMPTY_OBJ,
    props: EMPTY_OBJ,
    attrs: EMPTY_OBJ,
    slots: EMPTY_OBJ,
    refs: EMPTY_OBJ,
    setupState: EMPTY_OBJ,
    setupContext: null,
    suspense,
    suspenseId: suspense ? suspense.pendingId : 0,
    asyncDep: null,
    asyncResolved: false,
    isMounted: false,
    isUnmounted: false,
    isDeactivated: false,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  {
    instance.ctx = { _: instance };
  }
  instance.root = parent ? parent.root : instance;
  instance.emit = emit$1.bind(null, instance);
  if (vnode.ce) {
    vnode.ce(instance);
  }
  return instance;
}
let currentInstance = null;
const getCurrentInstance = () => currentInstance || currentRenderingInstance;
const setCurrentInstance = (instance) => {
  currentInstance = instance;
  instance.scope.on();
};
const unsetCurrentInstance = () => {
  currentInstance && currentInstance.scope.off();
  currentInstance = null;
};
function isStatefulComponent(instance) {
  return instance.vnode.shapeFlag & 4;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false) {
  isInSSRComponentSetup = isSSR;
  const { props, children } = instance.vnode;
  const isStateful = isStatefulComponent(instance);
  initProps(instance, props, isStateful, isSSR);
  initSlots(instance, children);
  const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
  isInSSRComponentSetup = false;
  return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
  const Component = instance.type;
  instance.accessCache = Object.create(null);
  instance.proxy = markRaw(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
  const { setup } = Component;
  if (setup) {
    const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
    setCurrentInstance(instance);
    pauseTracking();
    const setupResult = callWithErrorHandling(setup, instance, 0, [instance.props, setupContext]);
    resetTracking();
    unsetCurrentInstance();
    if (isPromise(setupResult)) {
      setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
      if (isSSR) {
        return setupResult.then((resolvedResult) => {
          handleSetupResult(instance, resolvedResult, isSSR);
        }).catch((e) => {
          handleError(e, instance, 0);
        });
      } else {
        instance.asyncDep = setupResult;
      }
    } else {
      handleSetupResult(instance, setupResult, isSSR);
    }
  } else {
    finishComponentSetup(instance, isSSR);
  }
}
function handleSetupResult(instance, setupResult, isSSR) {
  if (isFunction$2(setupResult)) {
    if (instance.type.__ssrInlineRender) {
      instance.ssrRender = setupResult;
    } else {
      instance.render = setupResult;
    }
  } else if (isObject$2(setupResult)) {
    instance.setupState = proxyRefs(setupResult);
  } else
    ;
  finishComponentSetup(instance, isSSR);
}
let compile;
function finishComponentSetup(instance, isSSR, skipOptions) {
  const Component = instance.type;
  if (!instance.render) {
    if (!isSSR && compile && !Component.render) {
      const template = Component.template;
      if (template) {
        const { isCustomElement, compilerOptions } = instance.appContext.config;
        const { delimiters, compilerOptions: componentCompilerOptions } = Component;
        const finalCompilerOptions = extend$1(extend$1({
          isCustomElement,
          delimiters
        }, compilerOptions), componentCompilerOptions);
        Component.render = compile(template, finalCompilerOptions);
      }
    }
    instance.render = Component.render || NOOP;
  }
  {
    setCurrentInstance(instance);
    pauseTracking();
    applyOptions(instance);
    resetTracking();
    unsetCurrentInstance();
  }
}
function createAttrsProxy(instance) {
  return new Proxy(instance.attrs, {
    get(target, key) {
      track(instance, "get", "$attrs");
      return target[key];
    }
  });
}
function createSetupContext(instance) {
  const expose = (exposed) => {
    instance.exposed = exposed || {};
  };
  let attrs;
  {
    return {
      get attrs() {
        return attrs || (attrs = createAttrsProxy(instance));
      },
      slots: instance.slots,
      emit: instance.emit,
      expose
    };
  }
}
function getExposeProxy(instance) {
  if (instance.exposed) {
    return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
      get(target, key) {
        if (key in target) {
          return target[key];
        } else if (key in publicPropertiesMap) {
          return publicPropertiesMap[key](instance);
        }
      }
    }));
  }
}
const classifyRE = /(?:^|[-_])(\w)/g;
const classify = (str) => str.replace(classifyRE, (c) => c.toUpperCase()).replace(/[-_]/g, "");
function getComponentName(Component) {
  return isFunction$2(Component) ? Component.displayName || Component.name : Component.name;
}
function formatComponentName(instance, Component, isRoot = false) {
  let name = getComponentName(Component);
  if (!name && Component.__file) {
    const match = Component.__file.match(/([^/\\]+)\.\w+$/);
    if (match) {
      name = match[1];
    }
  }
  if (!name && instance && instance.parent) {
    const inferFromRegistry = (registry) => {
      for (const key in registry) {
        if (registry[key] === Component) {
          return key;
        }
      }
    };
    name = inferFromRegistry(instance.components || instance.parent.type.components) || inferFromRegistry(instance.appContext.components);
  }
  return name ? classify(name) : isRoot ? `App` : `Anonymous`;
}
function isClassComponent(value) {
  return isFunction$2(value) && "__vccOpts" in value;
}
const stack = [];
function warn$1(msg, ...args) {
  pauseTracking();
  const instance = stack.length ? stack[stack.length - 1].component : null;
  const appWarnHandler = instance && instance.appContext.config.warnHandler;
  const trace = getComponentTrace();
  if (appWarnHandler) {
    callWithErrorHandling(appWarnHandler, instance, 11, [
      msg + args.join(""),
      instance && instance.proxy,
      trace.map(({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`).join("\n"),
      trace
    ]);
  } else {
    const warnArgs = [`[Vue warn]: ${msg}`, ...args];
    if (trace.length && true) {
      warnArgs.push(`
`, ...formatTrace(trace));
    }
    console.warn(...warnArgs);
  }
  resetTracking();
}
function getComponentTrace() {
  let currentVNode = stack[stack.length - 1];
  if (!currentVNode) {
    return [];
  }
  const normalizedStack = [];
  while (currentVNode) {
    const last = normalizedStack[0];
    if (last && last.vnode === currentVNode) {
      last.recurseCount++;
    } else {
      normalizedStack.push({
        vnode: currentVNode,
        recurseCount: 0
      });
    }
    const parentInstance = currentVNode.component && currentVNode.component.parent;
    currentVNode = parentInstance && parentInstance.vnode;
  }
  return normalizedStack;
}
function formatTrace(trace) {
  const logs = [];
  trace.forEach((entry, i) => {
    logs.push(...i === 0 ? [] : [`
`], ...formatTraceEntry(entry));
  });
  return logs;
}
function formatTraceEntry({ vnode, recurseCount }) {
  const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
  const isRoot = vnode.component ? vnode.component.parent == null : false;
  const open = ` at <${formatComponentName(vnode.component, vnode.type, isRoot)}`;
  const close = `>` + postfix;
  return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
}
function formatProps(props) {
  const res = [];
  const keys = Object.keys(props);
  keys.slice(0, 3).forEach((key) => {
    res.push(...formatProp(key, props[key]));
  });
  if (keys.length > 3) {
    res.push(` ...`);
  }
  return res;
}
function formatProp(key, value, raw) {
  if (isString$3(value)) {
    value = JSON.stringify(value);
    return raw ? value : [`${key}=${value}`];
  } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
    return raw ? value : [`${key}=${value}`];
  } else if (isRef(value)) {
    value = formatProp(key, toRaw(value.value), true);
    return raw ? value : [`${key}=Ref<`, value, `>`];
  } else if (isFunction$2(value)) {
    return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
  } else {
    value = toRaw(value);
    return raw ? value : [`${key}=`, value];
  }
}
function callWithErrorHandling(fn, instance, type, args) {
  let res;
  try {
    res = args ? fn(...args) : fn();
  } catch (err) {
    handleError(err, instance, type);
  }
  return res;
}
function callWithAsyncErrorHandling(fn, instance, type, args) {
  if (isFunction$2(fn)) {
    const res = callWithErrorHandling(fn, instance, type, args);
    if (res && isPromise(res)) {
      res.catch((err) => {
        handleError(err, instance, type);
      });
    }
    return res;
  }
  const values = [];
  for (let i = 0; i < fn.length; i++) {
    values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));
  }
  return values;
}
function handleError(err, instance, type, throwInDev = true) {
  const contextVNode = instance ? instance.vnode : null;
  if (instance) {
    let cur = instance.parent;
    const exposedInstance = instance.proxy;
    const errorInfo = type;
    while (cur) {
      const errorCapturedHooks = cur.ec;
      if (errorCapturedHooks) {
        for (let i = 0; i < errorCapturedHooks.length; i++) {
          if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {
            return;
          }
        }
      }
      cur = cur.parent;
    }
    const appErrorHandler = instance.appContext.config.errorHandler;
    if (appErrorHandler) {
      callWithErrorHandling(appErrorHandler, null, 10, [err, exposedInstance, errorInfo]);
      return;
    }
  }
  logError(err, type, contextVNode, throwInDev);
}
function logError(err, type, contextVNode, throwInDev = true) {
  {
    console.error(err);
  }
}
let isFlushing = false;
let isFlushPending = false;
const queue = [];
let flushIndex = 0;
const pendingPreFlushCbs = [];
let activePreFlushCbs = null;
let preFlushIndex = 0;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = Promise.resolve();
let currentFlushPromise = null;
let currentPreFlushParentJob = null;
function nextTick(fn) {
  const p2 = currentFlushPromise || resolvedPromise;
  return fn ? p2.then(this ? fn.bind(this) : fn) : p2;
}
function findInsertionIndex(id) {
  let start = flushIndex + 1;
  let end = queue.length;
  while (start < end) {
    const middle = start + end >>> 1;
    const middleJobId = getId(queue[middle]);
    middleJobId < id ? start = middle + 1 : end = middle;
  }
  return start;
}
function queueJob(job) {
  if ((!queue.length || !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) && job !== currentPreFlushParentJob) {
    if (job.id == null) {
      queue.push(job);
    } else {
      queue.splice(findInsertionIndex(job.id), 0, job);
    }
    queueFlush();
  }
}
function queueFlush() {
  if (!isFlushing && !isFlushPending) {
    isFlushPending = true;
    currentFlushPromise = resolvedPromise.then(flushJobs);
  }
}
function invalidateJob(job) {
  const i = queue.indexOf(job);
  if (i > flushIndex) {
    queue.splice(i, 1);
  }
}
function queueCb(cb, activeQueue, pendingQueue, index) {
  if (!isArray$2(cb)) {
    if (!activeQueue || !activeQueue.includes(cb, cb.allowRecurse ? index + 1 : index)) {
      pendingQueue.push(cb);
    }
  } else {
    pendingQueue.push(...cb);
  }
  queueFlush();
}
function queuePreFlushCb(cb) {
  queueCb(cb, activePreFlushCbs, pendingPreFlushCbs, preFlushIndex);
}
function queuePostFlushCb(cb) {
  queueCb(cb, activePostFlushCbs, pendingPostFlushCbs, postFlushIndex);
}
function flushPreFlushCbs(seen, parentJob = null) {
  if (pendingPreFlushCbs.length) {
    currentPreFlushParentJob = parentJob;
    activePreFlushCbs = [...new Set(pendingPreFlushCbs)];
    pendingPreFlushCbs.length = 0;
    for (preFlushIndex = 0; preFlushIndex < activePreFlushCbs.length; preFlushIndex++) {
      activePreFlushCbs[preFlushIndex]();
    }
    activePreFlushCbs = null;
    preFlushIndex = 0;
    currentPreFlushParentJob = null;
    flushPreFlushCbs(seen, parentJob);
  }
}
function flushPostFlushCbs(seen) {
  if (pendingPostFlushCbs.length) {
    const deduped = [...new Set(pendingPostFlushCbs)];
    pendingPostFlushCbs.length = 0;
    if (activePostFlushCbs) {
      activePostFlushCbs.push(...deduped);
      return;
    }
    activePostFlushCbs = deduped;
    activePostFlushCbs.sort((a, b) => getId(a) - getId(b));
    for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
      activePostFlushCbs[postFlushIndex]();
    }
    activePostFlushCbs = null;
    postFlushIndex = 0;
  }
}
const getId = (job) => job.id == null ? Infinity : job.id;
function flushJobs(seen) {
  isFlushPending = false;
  isFlushing = true;
  flushPreFlushCbs(seen);
  queue.sort((a, b) => getId(a) - getId(b));
  const check = NOOP;
  try {
    for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job && job.active !== false) {
        if (false)
          ;
        callWithErrorHandling(job, null, 14);
      }
    }
  } finally {
    flushIndex = 0;
    queue.length = 0;
    flushPostFlushCbs();
    isFlushing = false;
    currentFlushPromise = null;
    if (queue.length || pendingPreFlushCbs.length || pendingPostFlushCbs.length) {
      flushJobs(seen);
    }
  }
}
function watchEffect(effect, options) {
  return doWatch(effect, null, options);
}
function watchPostEffect(effect, options) {
  return doWatch(effect, null, { flush: "post" });
}
const INITIAL_WATCHER_VALUE = {};
function watch(source2, cb, options) {
  return doWatch(source2, cb, options);
}
function doWatch(source2, cb, { immediate, deep, flush, onTrack, onTrigger } = EMPTY_OBJ) {
  const instance = currentInstance;
  let getter;
  let forceTrigger = false;
  let isMultiSource = false;
  if (isRef(source2)) {
    getter = () => source2.value;
    forceTrigger = !!source2._shallow;
  } else if (isReactive(source2)) {
    getter = () => source2;
    deep = true;
  } else if (isArray$2(source2)) {
    isMultiSource = true;
    forceTrigger = source2.some(isReactive);
    getter = () => source2.map((s) => {
      if (isRef(s)) {
        return s.value;
      } else if (isReactive(s)) {
        return traverse(s);
      } else if (isFunction$2(s)) {
        return callWithErrorHandling(s, instance, 2);
      } else
        ;
    });
  } else if (isFunction$2(source2)) {
    if (cb) {
      getter = () => callWithErrorHandling(source2, instance, 2);
    } else {
      getter = () => {
        if (instance && instance.isUnmounted) {
          return;
        }
        if (cleanup) {
          cleanup();
        }
        return callWithAsyncErrorHandling(source2, instance, 3, [onInvalidate]);
      };
    }
  } else {
    getter = NOOP;
  }
  if (cb && deep) {
    const baseGetter = getter;
    getter = () => traverse(baseGetter());
  }
  let cleanup;
  let onInvalidate = (fn) => {
    cleanup = effect.onStop = () => {
      callWithErrorHandling(fn, instance, 4);
    };
  };
  if (isInSSRComponentSetup) {
    onInvalidate = NOOP;
    if (!cb) {
      getter();
    } else if (immediate) {
      callWithAsyncErrorHandling(cb, instance, 3, [
        getter(),
        isMultiSource ? [] : void 0,
        onInvalidate
      ]);
    }
    return NOOP;
  }
  let oldValue = isMultiSource ? [] : INITIAL_WATCHER_VALUE;
  const job = () => {
    if (!effect.active) {
      return;
    }
    if (cb) {
      const newValue = effect.run();
      if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i) => hasChanged(v, oldValue[i])) : hasChanged(newValue, oldValue)) || false) {
        if (cleanup) {
          cleanup();
        }
        callWithAsyncErrorHandling(cb, instance, 3, [
          newValue,
          oldValue === INITIAL_WATCHER_VALUE ? void 0 : oldValue,
          onInvalidate
        ]);
        oldValue = newValue;
      }
    } else {
      effect.run();
    }
  };
  job.allowRecurse = !!cb;
  let scheduler;
  if (flush === "sync") {
    scheduler = job;
  } else if (flush === "post") {
    scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
  } else {
    scheduler = () => {
      if (!instance || instance.isMounted) {
        queuePreFlushCb(job);
      } else {
        job();
      }
    };
  }
  const effect = new ReactiveEffect(getter, scheduler);
  if (cb) {
    if (immediate) {
      job();
    } else {
      oldValue = effect.run();
    }
  } else if (flush === "post") {
    queuePostRenderEffect(effect.run.bind(effect), instance && instance.suspense);
  } else {
    effect.run();
  }
  return () => {
    effect.stop();
    if (instance && instance.scope) {
      remove(instance.scope.effects, effect);
    }
  };
}
function instanceWatch(source2, value, options) {
  const publicThis = this.proxy;
  const getter = isString$3(source2) ? source2.includes(".") ? createPathGetter(publicThis, source2) : () => publicThis[source2] : source2.bind(publicThis, publicThis);
  let cb;
  if (isFunction$2(value)) {
    cb = value;
  } else {
    cb = value.handler;
    options = value;
  }
  const cur = currentInstance;
  setCurrentInstance(this);
  const res = doWatch(getter, cb.bind(publicThis), options);
  if (cur) {
    setCurrentInstance(cur);
  } else {
    unsetCurrentInstance();
  }
  return res;
}
function createPathGetter(ctx, path) {
  const segments = path.split(".");
  return () => {
    let cur = ctx;
    for (let i = 0; i < segments.length && cur; i++) {
      cur = cur[segments[i]];
    }
    return cur;
  };
}
function traverse(value, seen) {
  if (!isObject$2(value) || value["__v_skip"]) {
    return value;
  }
  seen = seen || new Set();
  if (seen.has(value)) {
    return value;
  }
  seen.add(value);
  if (isRef(value)) {
    traverse(value.value, seen);
  } else if (isArray$2(value)) {
    for (let i = 0; i < value.length; i++) {
      traverse(value[i], seen);
    }
  } else if (isSet(value) || isMap(value)) {
    value.forEach((v) => {
      traverse(v, seen);
    });
  } else if (isPlainObject$3(value)) {
    for (const key in value) {
      traverse(value[key], seen);
    }
  }
  return value;
}
function h(type, propsOrChildren, children) {
  const l = arguments.length;
  if (l === 2) {
    if (isObject$2(propsOrChildren) && !isArray$2(propsOrChildren)) {
      if (isVNode(propsOrChildren)) {
        return createVNode(type, null, [propsOrChildren]);
      }
      return createVNode(type, propsOrChildren);
    } else {
      return createVNode(type, null, propsOrChildren);
    }
  } else {
    if (l > 3) {
      children = Array.prototype.slice.call(arguments, 2);
    } else if (l === 3 && isVNode(children)) {
      children = [children];
    }
    return createVNode(type, propsOrChildren, children);
  }
}
const version = "3.2.19";
const svgNS = "http://www.w3.org/2000/svg";
const doc = typeof document !== "undefined" ? document : null;
const staticTemplateCache = new Map();
const nodeOps = {
  insert: (child, parent, anchor) => {
    parent.insertBefore(child, anchor || null);
  },
  remove: (child) => {
    const parent = child.parentNode;
    if (parent) {
      parent.removeChild(child);
    }
  },
  createElement: (tag, isSVG, is, props) => {
    const el = isSVG ? doc.createElementNS(svgNS, tag) : doc.createElement(tag, is ? { is } : void 0);
    if (tag === "select" && props && props.multiple != null) {
      el.setAttribute("multiple", props.multiple);
    }
    return el;
  },
  createText: (text) => doc.createTextNode(text),
  createComment: (text) => doc.createComment(text),
  setText: (node, text) => {
    node.nodeValue = text;
  },
  setElementText: (el, text) => {
    el.textContent = text;
  },
  parentNode: (node) => node.parentNode,
  nextSibling: (node) => node.nextSibling,
  querySelector: (selector) => doc.querySelector(selector),
  setScopeId(el, id) {
    el.setAttribute(id, "");
  },
  cloneNode(el) {
    const cloned = el.cloneNode(true);
    if (`_value` in el) {
      cloned._value = el._value;
    }
    return cloned;
  },
  insertStaticContent(content, parent, anchor, isSVG) {
    const before = anchor ? anchor.previousSibling : parent.lastChild;
    let template = staticTemplateCache.get(content);
    if (!template) {
      const t = doc.createElement("template");
      t.innerHTML = isSVG ? `<svg>${content}</svg>` : content;
      template = t.content;
      if (isSVG) {
        const wrapper = template.firstChild;
        while (wrapper.firstChild) {
          template.appendChild(wrapper.firstChild);
        }
        template.removeChild(wrapper);
      }
      staticTemplateCache.set(content, template);
    }
    parent.insertBefore(template.cloneNode(true), anchor);
    return [
      before ? before.nextSibling : parent.firstChild,
      anchor ? anchor.previousSibling : parent.lastChild
    ];
  }
};
function patchClass(el, value, isSVG) {
  const transitionClasses = el._vtc;
  if (transitionClasses) {
    value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
  }
  if (value == null) {
    el.removeAttribute("class");
  } else if (isSVG) {
    el.setAttribute("class", value);
  } else {
    el.className = value;
  }
}
function patchStyle(el, prev, next) {
  const style = el.style;
  const currentDisplay = style.display;
  if (!next) {
    el.removeAttribute("style");
  } else if (isString$3(next)) {
    if (prev !== next) {
      style.cssText = next;
    }
  } else {
    for (const key in next) {
      setStyle(style, key, next[key]);
    }
    if (prev && !isString$3(prev)) {
      for (const key in prev) {
        if (next[key] == null) {
          setStyle(style, key, "");
        }
      }
    }
  }
  if ("_vod" in el) {
    style.display = currentDisplay;
  }
}
const importantRE = /\s*!important$/;
function setStyle(style, name, val) {
  if (isArray$2(val)) {
    val.forEach((v) => setStyle(style, name, v));
  } else {
    if (name.startsWith("--")) {
      style.setProperty(name, val);
    } else {
      const prefixed = autoPrefix(style, name);
      if (importantRE.test(val)) {
        style.setProperty(hyphenate(prefixed), val.replace(importantRE, ""), "important");
      } else {
        style[prefixed] = val;
      }
    }
  }
}
const prefixes = ["Webkit", "Moz", "ms"];
const prefixCache = {};
function autoPrefix(style, rawName) {
  const cached = prefixCache[rawName];
  if (cached) {
    return cached;
  }
  let name = camelize(rawName);
  if (name !== "filter" && name in style) {
    return prefixCache[rawName] = name;
  }
  name = capitalize(name);
  for (let i = 0; i < prefixes.length; i++) {
    const prefixed = prefixes[i] + name;
    if (prefixed in style) {
      return prefixCache[rawName] = prefixed;
    }
  }
  return rawName;
}
const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el, key, value, isSVG, instance) {
  if (isSVG && key.startsWith("xlink:")) {
    if (value == null) {
      el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
    } else {
      el.setAttributeNS(xlinkNS, key, value);
    }
  } else {
    const isBoolean2 = isSpecialBooleanAttr(key);
    if (value == null || isBoolean2 && !includeBooleanAttr(value)) {
      el.removeAttribute(key);
    } else {
      el.setAttribute(key, isBoolean2 ? "" : value);
    }
  }
}
function patchDOMProp(el, key, value, prevChildren, parentComponent, parentSuspense, unmountChildren) {
  if (key === "innerHTML" || key === "textContent") {
    if (prevChildren) {
      unmountChildren(prevChildren, parentComponent, parentSuspense);
    }
    el[key] = value == null ? "" : value;
    return;
  }
  if (key === "value" && el.tagName !== "PROGRESS") {
    el._value = value;
    const newValue = value == null ? "" : value;
    if (el.value !== newValue) {
      el.value = newValue;
    }
    if (value == null) {
      el.removeAttribute(key);
    }
    return;
  }
  if (value === "" || value == null) {
    const type = typeof el[key];
    if (type === "boolean") {
      el[key] = includeBooleanAttr(value);
      return;
    } else if (value == null && type === "string") {
      el[key] = "";
      el.removeAttribute(key);
      return;
    } else if (type === "number") {
      try {
        el[key] = 0;
      } catch (_a) {
      }
      el.removeAttribute(key);
      return;
    }
  }
  try {
    el[key] = value;
  } catch (e) {
  }
}
let _getNow = Date.now;
let skipTimestampCheck = false;
if (typeof window !== "undefined") {
  if (_getNow() > document.createEvent("Event").timeStamp) {
    _getNow = () => performance.now();
  }
  const ffMatch = navigator.userAgent.match(/firefox\/(\d+)/i);
  skipTimestampCheck = !!(ffMatch && Number(ffMatch[1]) <= 53);
}
let cachedNow = 0;
const p = Promise.resolve();
const reset = () => {
  cachedNow = 0;
};
const getNow = () => cachedNow || (p.then(reset), cachedNow = _getNow());
function addEventListener(el, event, handler, options) {
  el.addEventListener(event, handler, options);
}
function removeEventListener(el, event, handler, options) {
  el.removeEventListener(event, handler, options);
}
function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
  const invokers = el._vei || (el._vei = {});
  const existingInvoker = invokers[rawName];
  if (nextValue && existingInvoker) {
    existingInvoker.value = nextValue;
  } else {
    const [name, options] = parseName(rawName);
    if (nextValue) {
      const invoker = invokers[rawName] = createInvoker(nextValue, instance);
      addEventListener(el, name, invoker, options);
    } else if (existingInvoker) {
      removeEventListener(el, name, existingInvoker, options);
      invokers[rawName] = void 0;
    }
  }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name) {
  let options;
  if (optionsModifierRE.test(name)) {
    options = {};
    let m;
    while (m = name.match(optionsModifierRE)) {
      name = name.slice(0, name.length - m[0].length);
      options[m[0].toLowerCase()] = true;
    }
  }
  return [hyphenate(name.slice(2)), options];
}
function createInvoker(initialValue, instance) {
  const invoker = (e) => {
    const timeStamp = e.timeStamp || _getNow();
    if (skipTimestampCheck || timeStamp >= invoker.attached - 1) {
      callWithAsyncErrorHandling(patchStopImmediatePropagation(e, invoker.value), instance, 5, [e]);
    }
  };
  invoker.value = initialValue;
  invoker.attached = getNow();
  return invoker;
}
function patchStopImmediatePropagation(e, value) {
  if (isArray$2(value)) {
    const originalStop = e.stopImmediatePropagation;
    e.stopImmediatePropagation = () => {
      originalStop.call(e);
      e._stopped = true;
    };
    return value.map((fn) => (e2) => !e2._stopped && fn(e2));
  } else {
    return value;
  }
}
const nativeOnRE = /^on[a-z]/;
const patchProp = (el, key, prevValue, nextValue, isSVG = false, prevChildren, parentComponent, parentSuspense, unmountChildren) => {
  if (key === "class") {
    patchClass(el, nextValue, isSVG);
  } else if (key === "style") {
    patchStyle(el, prevValue, nextValue);
  } else if (isOn(key)) {
    if (!isModelListener(key)) {
      patchEvent(el, key, prevValue, nextValue, parentComponent);
    }
  } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) {
    patchDOMProp(el, key, nextValue, prevChildren, parentComponent, parentSuspense, unmountChildren);
  } else {
    if (key === "true-value") {
      el._trueValue = nextValue;
    } else if (key === "false-value") {
      el._falseValue = nextValue;
    }
    patchAttr(el, key, nextValue, isSVG);
  }
};
function shouldSetAsProp(el, key, value, isSVG) {
  if (isSVG) {
    if (key === "innerHTML" || key === "textContent") {
      return true;
    }
    if (key in el && nativeOnRE.test(key) && isFunction$2(value)) {
      return true;
    }
    return false;
  }
  if (key === "spellcheck" || key === "draggable") {
    return false;
  }
  if (key === "form") {
    return false;
  }
  if (key === "list" && el.tagName === "INPUT") {
    return false;
  }
  if (key === "type" && el.tagName === "TEXTAREA") {
    return false;
  }
  if (nativeOnRE.test(key) && isString$3(value)) {
    return false;
  }
  return key in el;
}
function useCssVars(getter) {
  const instance = getCurrentInstance();
  if (!instance) {
    return;
  }
  const setVars = () => setVarsOnVNode(instance.subTree, getter(instance.proxy));
  watchPostEffect(setVars);
  onMounted(() => {
    const ob = new MutationObserver(setVars);
    ob.observe(instance.subTree.el.parentNode, { childList: true });
    onUnmounted(() => ob.disconnect());
  });
}
function setVarsOnVNode(vnode, vars) {
  if (vnode.shapeFlag & 128) {
    const suspense = vnode.suspense;
    vnode = suspense.activeBranch;
    if (suspense.pendingBranch && !suspense.isHydrating) {
      suspense.effects.push(() => {
        setVarsOnVNode(suspense.activeBranch, vars);
      });
    }
  }
  while (vnode.component) {
    vnode = vnode.component.subTree;
  }
  if (vnode.shapeFlag & 1 && vnode.el) {
    setVarsOnNode(vnode.el, vars);
  } else if (vnode.type === Fragment) {
    vnode.children.forEach((c) => setVarsOnVNode(c, vars));
  } else if (vnode.type === Static) {
    let { el, anchor } = vnode;
    while (el) {
      setVarsOnNode(el, vars);
      if (el === anchor)
        break;
      el = el.nextSibling;
    }
  }
}
function setVarsOnNode(el, vars) {
  if (el.nodeType === 1) {
    const style = el.style;
    for (const key in vars) {
      style.setProperty(`--${key}`, vars[key]);
    }
  }
}
const TRANSITION = "transition";
const ANIMATION = "animation";
const Transition = (props, { slots }) => h(BaseTransition, resolveTransitionProps(props), slots);
Transition.displayName = "Transition";
const DOMTransitionPropsValidators = {
  name: String,
  type: String,
  css: {
    type: Boolean,
    default: true
  },
  duration: [String, Number, Object],
  enterFromClass: String,
  enterActiveClass: String,
  enterToClass: String,
  appearFromClass: String,
  appearActiveClass: String,
  appearToClass: String,
  leaveFromClass: String,
  leaveActiveClass: String,
  leaveToClass: String
};
const TransitionPropsValidators = Transition.props = /* @__PURE__ */ extend$1({}, BaseTransition.props, DOMTransitionPropsValidators);
const callHook = (hook, args = []) => {
  if (isArray$2(hook)) {
    hook.forEach((h2) => h2(...args));
  } else if (hook) {
    hook(...args);
  }
};
const hasExplicitCallback = (hook) => {
  return hook ? isArray$2(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
  const baseProps = {};
  for (const key in rawProps) {
    if (!(key in DOMTransitionPropsValidators)) {
      baseProps[key] = rawProps[key];
    }
  }
  if (rawProps.css === false) {
    return baseProps;
  }
  const { name = "v", type, duration, enterFromClass = `${name}-enter-from`, enterActiveClass = `${name}-enter-active`, enterToClass = `${name}-enter-to`, appearFromClass = enterFromClass, appearActiveClass = enterActiveClass, appearToClass = enterToClass, leaveFromClass = `${name}-leave-from`, leaveActiveClass = `${name}-leave-active`, leaveToClass = `${name}-leave-to` } = rawProps;
  const durations = normalizeDuration(duration);
  const enterDuration = durations && durations[0];
  const leaveDuration = durations && durations[1];
  const { onBeforeEnter, onEnter, onEnterCancelled, onLeave, onLeaveCancelled, onBeforeAppear = onBeforeEnter, onAppear = onEnter, onAppearCancelled = onEnterCancelled } = baseProps;
  const finishEnter = (el, isAppear, done) => {
    removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
    removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
    done && done();
  };
  const finishLeave = (el, done) => {
    removeTransitionClass(el, leaveToClass);
    removeTransitionClass(el, leaveActiveClass);
    done && done();
  };
  const makeEnterHook = (isAppear) => {
    return (el, done) => {
      const hook = isAppear ? onAppear : onEnter;
      const resolve2 = () => finishEnter(el, isAppear, done);
      callHook(hook, [el, resolve2]);
      nextFrame(() => {
        removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
        addTransitionClass(el, isAppear ? appearToClass : enterToClass);
        if (!hasExplicitCallback(hook)) {
          whenTransitionEnds(el, type, enterDuration, resolve2);
        }
      });
    };
  };
  return extend$1(baseProps, {
    onBeforeEnter(el) {
      callHook(onBeforeEnter, [el]);
      addTransitionClass(el, enterFromClass);
      addTransitionClass(el, enterActiveClass);
    },
    onBeforeAppear(el) {
      callHook(onBeforeAppear, [el]);
      addTransitionClass(el, appearFromClass);
      addTransitionClass(el, appearActiveClass);
    },
    onEnter: makeEnterHook(false),
    onAppear: makeEnterHook(true),
    onLeave(el, done) {
      const resolve2 = () => finishLeave(el, done);
      addTransitionClass(el, leaveFromClass);
      forceReflow();
      addTransitionClass(el, leaveActiveClass);
      nextFrame(() => {
        removeTransitionClass(el, leaveFromClass);
        addTransitionClass(el, leaveToClass);
        if (!hasExplicitCallback(onLeave)) {
          whenTransitionEnds(el, type, leaveDuration, resolve2);
        }
      });
      callHook(onLeave, [el, resolve2]);
    },
    onEnterCancelled(el) {
      finishEnter(el, false);
      callHook(onEnterCancelled, [el]);
    },
    onAppearCancelled(el) {
      finishEnter(el, true);
      callHook(onAppearCancelled, [el]);
    },
    onLeaveCancelled(el) {
      finishLeave(el);
      callHook(onLeaveCancelled, [el]);
    }
  });
}
function normalizeDuration(duration) {
  if (duration == null) {
    return null;
  } else if (isObject$2(duration)) {
    return [NumberOf(duration.enter), NumberOf(duration.leave)];
  } else {
    const n = NumberOf(duration);
    return [n, n];
  }
}
function NumberOf(val) {
  const res = toNumber(val);
  return res;
}
function addTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.add(c));
  (el._vtc || (el._vtc = new Set())).add(cls);
}
function removeTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.remove(c));
  const { _vtc } = el;
  if (_vtc) {
    _vtc.delete(cls);
    if (!_vtc.size) {
      el._vtc = void 0;
    }
  }
}
function nextFrame(cb) {
  requestAnimationFrame(() => {
    requestAnimationFrame(cb);
  });
}
let endId = 0;
function whenTransitionEnds(el, expectedType, explicitTimeout, resolve2) {
  const id = el._endId = ++endId;
  const resolveIfNotStale = () => {
    if (id === el._endId) {
      resolve2();
    }
  };
  if (explicitTimeout) {
    return setTimeout(resolveIfNotStale, explicitTimeout);
  }
  const { type, timeout, propCount } = getTransitionInfo(el, expectedType);
  if (!type) {
    return resolve2();
  }
  const endEvent = type + "end";
  let ended = 0;
  const end = () => {
    el.removeEventListener(endEvent, onEnd);
    resolveIfNotStale();
  };
  const onEnd = (e) => {
    if (e.target === el && ++ended >= propCount) {
      end();
    }
  };
  setTimeout(() => {
    if (ended < propCount) {
      end();
    }
  }, timeout + 1);
  el.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el, expectedType) {
  const styles = window.getComputedStyle(el);
  const getStyleProperties = (key) => (styles[key] || "").split(", ");
  const transitionDelays = getStyleProperties(TRANSITION + "Delay");
  const transitionDurations = getStyleProperties(TRANSITION + "Duration");
  const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  const animationDelays = getStyleProperties(ANIMATION + "Delay");
  const animationDurations = getStyleProperties(ANIMATION + "Duration");
  const animationTimeout = getTimeout(animationDelays, animationDurations);
  let type = null;
  let timeout = 0;
  let propCount = 0;
  if (expectedType === TRANSITION) {
    if (transitionTimeout > 0) {
      type = TRANSITION;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
    propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
  }
  const hasTransform = type === TRANSITION && /\b(transform|all)(,|$)/.test(styles[TRANSITION + "Property"]);
  return {
    type,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max(...durations.map((d, i) => toMs(d) + toMs(delays[i])));
}
function toMs(s) {
  return Number(s.slice(0, -1).replace(",", ".")) * 1e3;
}
function forceReflow() {
  return document.body.offsetHeight;
}
const positionMap = new WeakMap();
const newPositionMap = new WeakMap();
const TransitionGroupImpl = {
  name: "TransitionGroup",
  props: /* @__PURE__ */ extend$1({}, TransitionPropsValidators, {
    tag: String,
    moveClass: String
  }),
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevChildren;
    let children;
    onUpdated(() => {
      if (!prevChildren.length) {
        return;
      }
      const moveClass = props.moveClass || `${props.name || "v"}-move`;
      if (!hasCSSTransform(prevChildren[0].el, instance.vnode.el, moveClass)) {
        return;
      }
      prevChildren.forEach(callPendingCbs);
      prevChildren.forEach(recordPosition);
      const movedChildren = prevChildren.filter(applyTranslation);
      forceReflow();
      movedChildren.forEach((c) => {
        const el = c.el;
        const style = el.style;
        addTransitionClass(el, moveClass);
        style.transform = style.webkitTransform = style.transitionDuration = "";
        const cb = el._moveCb = (e) => {
          if (e && e.target !== el) {
            return;
          }
          if (!e || /transform$/.test(e.propertyName)) {
            el.removeEventListener("transitionend", cb);
            el._moveCb = null;
            removeTransitionClass(el, moveClass);
          }
        };
        el.addEventListener("transitionend", cb);
      });
    });
    return () => {
      const rawProps = toRaw(props);
      const cssTransitionProps = resolveTransitionProps(rawProps);
      let tag = rawProps.tag || Fragment;
      prevChildren = children;
      children = slots.default ? getTransitionRawChildren(slots.default()) : [];
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (child.key != null) {
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
        }
      }
      if (prevChildren) {
        for (let i = 0; i < prevChildren.length; i++) {
          const child = prevChildren[i];
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
          positionMap.set(child, child.el.getBoundingClientRect());
        }
      }
      return createVNode(tag, null, children);
    };
  }
};
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c) {
  const el = c.el;
  if (el._moveCb) {
    el._moveCb();
  }
  if (el._enterCb) {
    el._enterCb();
  }
}
function recordPosition(c) {
  newPositionMap.set(c, c.el.getBoundingClientRect());
}
function applyTranslation(c) {
  const oldPos = positionMap.get(c);
  const newPos = newPositionMap.get(c);
  const dx = oldPos.left - newPos.left;
  const dy = oldPos.top - newPos.top;
  if (dx || dy) {
    const s = c.el.style;
    s.transform = s.webkitTransform = `translate(${dx}px,${dy}px)`;
    s.transitionDuration = "0s";
    return c;
  }
}
function hasCSSTransform(el, root2, moveClass) {
  const clone = el.cloneNode();
  if (el._vtc) {
    el._vtc.forEach((cls) => {
      cls.split(/\s+/).forEach((c) => c && clone.classList.remove(c));
    });
  }
  moveClass.split(/\s+/).forEach((c) => c && clone.classList.add(c));
  clone.style.display = "none";
  const container = root2.nodeType === 1 ? root2 : root2.parentNode;
  container.appendChild(clone);
  const { hasTransform } = getTransitionInfo(clone);
  container.removeChild(clone);
  return hasTransform;
}
const getModelAssigner = (vnode) => {
  const fn = vnode.props["onUpdate:modelValue"];
  return isArray$2(fn) ? (value) => invokeArrayFns(fn, value) : fn;
};
function onCompositionStart(e) {
  e.target.composing = true;
}
function onCompositionEnd(e) {
  const target = e.target;
  if (target.composing) {
    target.composing = false;
    trigger(target, "input");
  }
}
function trigger(el, type) {
  const e = document.createEvent("HTMLEvents");
  e.initEvent(type, true, true);
  el.dispatchEvent(e);
}
const vModelText = {
  created(el, { modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el._assign = getModelAssigner(vnode);
    const castToNumber = number2 || vnode.props && vnode.props.type === "number";
    addEventListener(el, lazy ? "change" : "input", (e) => {
      if (e.target.composing)
        return;
      let domValue = el.value;
      if (trim2) {
        domValue = domValue.trim();
      } else if (castToNumber) {
        domValue = toNumber(domValue);
      }
      el._assign(domValue);
    });
    if (trim2) {
      addEventListener(el, "change", () => {
        el.value = el.value.trim();
      });
    }
    if (!lazy) {
      addEventListener(el, "compositionstart", onCompositionStart);
      addEventListener(el, "compositionend", onCompositionEnd);
      addEventListener(el, "change", onCompositionEnd);
    }
  },
  mounted(el, { value }) {
    el.value = value == null ? "" : value;
  },
  beforeUpdate(el, { value, modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el._assign = getModelAssigner(vnode);
    if (el.composing)
      return;
    if (document.activeElement === el) {
      if (lazy) {
        return;
      }
      if (trim2 && el.value.trim() === value) {
        return;
      }
      if ((number2 || el.type === "number") && toNumber(el.value) === value) {
        return;
      }
    }
    const newValue = value == null ? "" : value;
    if (el.value !== newValue) {
      el.value = newValue;
    }
  }
};
const vModelCheckbox = {
  deep: true,
  created(el, _, vnode) {
    el._assign = getModelAssigner(vnode);
    addEventListener(el, "change", () => {
      const modelValue = el._modelValue;
      const elementValue = getValue(el);
      const checked = el.checked;
      const assign2 = el._assign;
      if (isArray$2(modelValue)) {
        const index = looseIndexOf(modelValue, elementValue);
        const found = index !== -1;
        if (checked && !found) {
          assign2(modelValue.concat(elementValue));
        } else if (!checked && found) {
          const filtered = [...modelValue];
          filtered.splice(index, 1);
          assign2(filtered);
        }
      } else if (isSet(modelValue)) {
        const cloned = new Set(modelValue);
        if (checked) {
          cloned.add(elementValue);
        } else {
          cloned.delete(elementValue);
        }
        assign2(cloned);
      } else {
        assign2(getCheckboxValue(el, checked));
      }
    });
  },
  mounted: setChecked,
  beforeUpdate(el, binding, vnode) {
    el._assign = getModelAssigner(vnode);
    setChecked(el, binding, vnode);
  }
};
function setChecked(el, { value, oldValue }, vnode) {
  el._modelValue = value;
  if (isArray$2(value)) {
    el.checked = looseIndexOf(value, vnode.props.value) > -1;
  } else if (isSet(value)) {
    el.checked = value.has(vnode.props.value);
  } else if (value !== oldValue) {
    el.checked = looseEqual(value, getCheckboxValue(el, true));
  }
}
const vModelSelect = {
  deep: true,
  created(el, { value, modifiers: { number: number2 } }, vnode) {
    const isSetModel = isSet(value);
    addEventListener(el, "change", () => {
      const selectedVal = Array.prototype.filter.call(el.options, (o) => o.selected).map((o) => number2 ? toNumber(getValue(o)) : getValue(o));
      el._assign(el.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]);
    });
    el._assign = getModelAssigner(vnode);
  },
  mounted(el, { value }) {
    setSelected(el, value);
  },
  beforeUpdate(el, _binding, vnode) {
    el._assign = getModelAssigner(vnode);
  },
  updated(el, { value }) {
    setSelected(el, value);
  }
};
function setSelected(el, value) {
  const isMultiple = el.multiple;
  if (isMultiple && !isArray$2(value) && !isSet(value)) {
    return;
  }
  for (let i = 0, l = el.options.length; i < l; i++) {
    const option = el.options[i];
    const optionValue = getValue(option);
    if (isMultiple) {
      if (isArray$2(value)) {
        option.selected = looseIndexOf(value, optionValue) > -1;
      } else {
        option.selected = value.has(optionValue);
      }
    } else {
      if (looseEqual(getValue(option), value)) {
        if (el.selectedIndex !== i)
          el.selectedIndex = i;
        return;
      }
    }
  }
  if (!isMultiple && el.selectedIndex !== -1) {
    el.selectedIndex = -1;
  }
}
function getValue(el) {
  return "_value" in el ? el._value : el.value;
}
function getCheckboxValue(el, checked) {
  const key = checked ? "_trueValue" : "_falseValue";
  return key in el ? el[key] : checked;
}
const systemModifiers = ["ctrl", "shift", "alt", "meta"];
const modifierGuards = {
  stop: (e) => e.stopPropagation(),
  prevent: (e) => e.preventDefault(),
  self: (e) => e.target !== e.currentTarget,
  ctrl: (e) => !e.ctrlKey,
  shift: (e) => !e.shiftKey,
  alt: (e) => !e.altKey,
  meta: (e) => !e.metaKey,
  left: (e) => "button" in e && e.button !== 0,
  middle: (e) => "button" in e && e.button !== 1,
  right: (e) => "button" in e && e.button !== 2,
  exact: (e, modifiers) => systemModifiers.some((m) => e[`${m}Key`] && !modifiers.includes(m))
};
const withModifiers = (fn, modifiers) => {
  return (event, ...args) => {
    for (let i = 0; i < modifiers.length; i++) {
      const guard = modifierGuards[modifiers[i]];
      if (guard && guard(event, modifiers))
        return;
    }
    return fn(event, ...args);
  };
};
const vShow = {
  beforeMount(el, { value }, { transition }) {
    el._vod = el.style.display === "none" ? "" : el.style.display;
    if (transition && value) {
      transition.beforeEnter(el);
    } else {
      setDisplay(el, value);
    }
  },
  mounted(el, { value }, { transition }) {
    if (transition && value) {
      transition.enter(el);
    }
  },
  updated(el, { value, oldValue }, { transition }) {
    if (!value === !oldValue)
      return;
    if (transition) {
      if (value) {
        transition.beforeEnter(el);
        setDisplay(el, true);
        transition.enter(el);
      } else {
        transition.leave(el, () => {
          setDisplay(el, false);
        });
      }
    } else {
      setDisplay(el, value);
    }
  },
  beforeUnmount(el, { value }) {
    setDisplay(el, value);
  }
};
function setDisplay(el, value) {
  el.style.display = value ? el._vod : "none";
}
const rendererOptions = extend$1({ patchProp }, nodeOps);
let renderer;
function ensureRenderer() {
  return renderer || (renderer = createRenderer(rendererOptions));
}
const render = (...args) => {
  ensureRenderer().render(...args);
};
const createApp = (...args) => {
  const app = ensureRenderer().createApp(...args);
  const { mount } = app;
  app.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (!container)
      return;
    const component = app._component;
    if (!isFunction$2(component) && !component.render && !component.template) {
      component.template = container.innerHTML;
    }
    container.innerHTML = "";
    const proxy = mount(container, false, container instanceof SVGElement);
    if (container instanceof Element) {
      container.removeAttribute("v-cloak");
      container.setAttribute("data-v-app", "");
    }
    return proxy;
  };
  return app;
};
function normalizeContainer(container) {
  if (isString$3(container)) {
    const res = document.querySelector(container);
    return res;
  }
  return container;
}
/*!
  * vue-router v4.0.10
  * (c) 2021 Eduardo San Martin Morote
  * @license MIT
  */
const hasSymbol$1 = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const PolySymbol = (name) => hasSymbol$1 ? Symbol(name) : "_vr_" + name;
const matchedRouteKey = /* @__PURE__ */ PolySymbol("rvlm");
const viewDepthKey = /* @__PURE__ */ PolySymbol("rvd");
const routerKey = /* @__PURE__ */ PolySymbol("r");
const routeLocationKey = /* @__PURE__ */ PolySymbol("rl");
const routerViewLocationKey = /* @__PURE__ */ PolySymbol("rvl");
const isBrowser = typeof window !== "undefined";
function isESModule(obj) {
  return obj.__esModule || hasSymbol$1 && obj[Symbol.toStringTag] === "Module";
}
const assign$2 = Object.assign;
function applyToParams(fn, params) {
  const newParams = {};
  for (const key in params) {
    const value = params[key];
    newParams[key] = Array.isArray(value) ? value.map(fn) : fn(value);
  }
  return newParams;
}
let noop$2 = () => {
};
const TRAILING_SLASH_RE = /\/$/;
const removeTrailingSlash = (path) => path.replace(TRAILING_SLASH_RE, "");
function parseURL(parseQuery2, location2, currentLocation = "/") {
  let path, query = {}, searchString = "", hash = "";
  const searchPos = location2.indexOf("?");
  const hashPos = location2.indexOf("#", searchPos > -1 ? searchPos : 0);
  if (searchPos > -1) {
    path = location2.slice(0, searchPos);
    searchString = location2.slice(searchPos + 1, hashPos > -1 ? hashPos : location2.length);
    query = parseQuery2(searchString);
  }
  if (hashPos > -1) {
    path = path || location2.slice(0, hashPos);
    hash = location2.slice(hashPos, location2.length);
  }
  path = resolveRelativePath(path != null ? path : location2, currentLocation);
  return {
    fullPath: path + (searchString && "?") + searchString + hash,
    path,
    query,
    hash
  };
}
function stringifyURL(stringifyQuery2, location2) {
  let query = location2.query ? stringifyQuery2(location2.query) : "";
  return location2.path + (query && "?") + query + (location2.hash || "");
}
function stripBase(pathname, base) {
  if (!base || !pathname.toLowerCase().startsWith(base.toLowerCase()))
    return pathname;
  return pathname.slice(base.length) || "/";
}
function isSameRouteLocation(stringifyQuery2, a, b) {
  let aLastIndex = a.matched.length - 1;
  let bLastIndex = b.matched.length - 1;
  return aLastIndex > -1 && aLastIndex === bLastIndex && isSameRouteRecord(a.matched[aLastIndex], b.matched[bLastIndex]) && isSameRouteLocationParams(a.params, b.params) && stringifyQuery2(a.query) === stringifyQuery2(b.query) && a.hash === b.hash;
}
function isSameRouteRecord(a, b) {
  return (a.aliasOf || a) === (b.aliasOf || b);
}
function isSameRouteLocationParams(a, b) {
  if (Object.keys(a).length !== Object.keys(b).length)
    return false;
  for (let key in a) {
    if (!isSameRouteLocationParamsValue(a[key], b[key]))
      return false;
  }
  return true;
}
function isSameRouteLocationParamsValue(a, b) {
  return Array.isArray(a) ? isEquivalentArray(a, b) : Array.isArray(b) ? isEquivalentArray(b, a) : a === b;
}
function isEquivalentArray(a, b) {
  return Array.isArray(b) ? a.length === b.length && a.every((value, i) => value === b[i]) : a.length === 1 && a[0] === b;
}
function resolveRelativePath(to, from) {
  if (to.startsWith("/"))
    return to;
  if (!to)
    return from;
  const fromSegments = from.split("/");
  const toSegments = to.split("/");
  let position = fromSegments.length - 1;
  let toPosition;
  let segment;
  for (toPosition = 0; toPosition < toSegments.length; toPosition++) {
    segment = toSegments[toPosition];
    if (position === 1 || segment === ".")
      continue;
    if (segment === "..")
      position--;
    else
      break;
  }
  return fromSegments.slice(0, position).join("/") + "/" + toSegments.slice(toPosition - (toPosition === toSegments.length ? 1 : 0)).join("/");
}
var NavigationType;
(function(NavigationType2) {
  NavigationType2["pop"] = "pop";
  NavigationType2["push"] = "push";
})(NavigationType || (NavigationType = {}));
var NavigationDirection;
(function(NavigationDirection2) {
  NavigationDirection2["back"] = "back";
  NavigationDirection2["forward"] = "forward";
  NavigationDirection2["unknown"] = "";
})(NavigationDirection || (NavigationDirection = {}));
function normalizeBase(base) {
  if (!base) {
    if (isBrowser) {
      const baseEl = document.querySelector("base");
      base = baseEl && baseEl.getAttribute("href") || "/";
      base = base.replace(/^\w+:\/\/[^\/]+/, "");
    } else {
      base = "/";
    }
  }
  if (base[0] !== "/" && base[0] !== "#")
    base = "/" + base;
  return removeTrailingSlash(base);
}
const BEFORE_HASH_RE = /^[^#]+#/;
function createHref(base, location2) {
  return base.replace(BEFORE_HASH_RE, "#") + location2;
}
function getElementPosition(el, offset) {
  const docRect = document.documentElement.getBoundingClientRect();
  const elRect = el.getBoundingClientRect();
  return {
    behavior: offset.behavior,
    left: elRect.left - docRect.left - (offset.left || 0),
    top: elRect.top - docRect.top - (offset.top || 0)
  };
}
const computeScrollPosition = () => ({
  left: window.pageXOffset,
  top: window.pageYOffset
});
function scrollToPosition(position) {
  let scrollToOptions;
  if ("el" in position) {
    let positionEl = position.el;
    const isIdSelector = typeof positionEl === "string" && positionEl.startsWith("#");
    const el = typeof positionEl === "string" ? isIdSelector ? document.getElementById(positionEl.slice(1)) : document.querySelector(positionEl) : positionEl;
    if (!el) {
      return;
    }
    scrollToOptions = getElementPosition(el, position);
  } else {
    scrollToOptions = position;
  }
  if ("scrollBehavior" in document.documentElement.style)
    window.scrollTo(scrollToOptions);
  else {
    window.scrollTo(scrollToOptions.left != null ? scrollToOptions.left : window.pageXOffset, scrollToOptions.top != null ? scrollToOptions.top : window.pageYOffset);
  }
}
function getScrollKey(path, delta) {
  const position = history.state ? history.state.position - delta : -1;
  return position + path;
}
const scrollPositions = new Map();
function saveScrollPosition(key, scrollPosition) {
  scrollPositions.set(key, scrollPosition);
}
function getSavedScrollPosition(key) {
  const scroll = scrollPositions.get(key);
  scrollPositions.delete(key);
  return scroll;
}
let createBaseLocation = () => location.protocol + "//" + location.host;
function createCurrentLocation(base, location2) {
  const { pathname, search, hash } = location2;
  const hashPos = base.indexOf("#");
  if (hashPos > -1) {
    let slicePos = hash.includes(base.slice(hashPos)) ? base.slice(hashPos).length : 1;
    let pathFromHash = hash.slice(slicePos);
    if (pathFromHash[0] !== "/")
      pathFromHash = "/" + pathFromHash;
    return stripBase(pathFromHash, "");
  }
  const path = stripBase(pathname, base);
  return path + search + hash;
}
function useHistoryListeners(base, historyState, currentLocation, replace) {
  let listeners = [];
  let teardowns = [];
  let pauseState = null;
  const popStateHandler = ({ state }) => {
    const to = createCurrentLocation(base, location);
    const from = currentLocation.value;
    const fromState = historyState.value;
    let delta = 0;
    if (state) {
      currentLocation.value = to;
      historyState.value = state;
      if (pauseState && pauseState === from) {
        pauseState = null;
        return;
      }
      delta = fromState ? state.position - fromState.position : 0;
    } else {
      replace(to);
    }
    listeners.forEach((listener) => {
      listener(currentLocation.value, from, {
        delta,
        type: NavigationType.pop,
        direction: delta ? delta > 0 ? NavigationDirection.forward : NavigationDirection.back : NavigationDirection.unknown
      });
    });
  };
  function pauseListeners() {
    pauseState = currentLocation.value;
  }
  function listen(callback) {
    listeners.push(callback);
    const teardown = () => {
      const index = listeners.indexOf(callback);
      if (index > -1)
        listeners.splice(index, 1);
    };
    teardowns.push(teardown);
    return teardown;
  }
  function beforeUnloadListener() {
    const { history: history2 } = window;
    if (!history2.state)
      return;
    history2.replaceState(assign$2({}, history2.state, { scroll: computeScrollPosition() }), "");
  }
  function destroy() {
    for (const teardown of teardowns)
      teardown();
    teardowns = [];
    window.removeEventListener("popstate", popStateHandler);
    window.removeEventListener("beforeunload", beforeUnloadListener);
  }
  window.addEventListener("popstate", popStateHandler);
  window.addEventListener("beforeunload", beforeUnloadListener);
  return {
    pauseListeners,
    listen,
    destroy
  };
}
function buildState(back, current, forward, replaced = false, computeScroll = false) {
  return {
    back,
    current,
    forward,
    replaced,
    position: window.history.length,
    scroll: computeScroll ? computeScrollPosition() : null
  };
}
function useHistoryStateNavigation(base) {
  const { history: history2, location: location2 } = window;
  let currentLocation = {
    value: createCurrentLocation(base, location2)
  };
  let historyState = { value: history2.state };
  if (!historyState.value) {
    changeLocation(currentLocation.value, {
      back: null,
      current: currentLocation.value,
      forward: null,
      position: history2.length - 1,
      replaced: true,
      scroll: null
    }, true);
  }
  function changeLocation(to, state, replace2) {
    const hashIndex = base.indexOf("#");
    const url = hashIndex > -1 ? (location2.host && document.querySelector("base") ? base : base.slice(hashIndex)) + to : createBaseLocation() + base + to;
    try {
      history2[replace2 ? "replaceState" : "pushState"](state, "", url);
      historyState.value = state;
    } catch (err) {
      {
        console.error(err);
      }
      location2[replace2 ? "replace" : "assign"](url);
    }
  }
  function replace(to, data2) {
    const state = assign$2({}, history2.state, buildState(historyState.value.back, to, historyState.value.forward, true), data2, { position: historyState.value.position });
    changeLocation(to, state, true);
    currentLocation.value = to;
  }
  function push(to, data2) {
    const currentState = assign$2({}, historyState.value, history2.state, {
      forward: to,
      scroll: computeScrollPosition()
    });
    changeLocation(currentState.current, currentState, true);
    const state = assign$2({}, buildState(currentLocation.value, to, null), { position: currentState.position + 1 }, data2);
    changeLocation(to, state, false);
    currentLocation.value = to;
  }
  return {
    location: currentLocation,
    state: historyState,
    push,
    replace
  };
}
function createWebHistory(base) {
  base = normalizeBase(base);
  const historyNavigation = useHistoryStateNavigation(base);
  const historyListeners = useHistoryListeners(base, historyNavigation.state, historyNavigation.location, historyNavigation.replace);
  function go(delta, triggerListeners = true) {
    if (!triggerListeners)
      historyListeners.pauseListeners();
    history.go(delta);
  }
  const routerHistory = assign$2({
    location: "",
    base,
    go,
    createHref: createHref.bind(null, base)
  }, historyNavigation, historyListeners);
  Object.defineProperty(routerHistory, "location", {
    enumerable: true,
    get: () => historyNavigation.location.value
  });
  Object.defineProperty(routerHistory, "state", {
    enumerable: true,
    get: () => historyNavigation.state.value
  });
  return routerHistory;
}
function isRouteLocation(route) {
  return typeof route === "string" || route && typeof route === "object";
}
function isRouteName(name) {
  return typeof name === "string" || typeof name === "symbol";
}
const START_LOCATION_NORMALIZED = {
  path: "/",
  name: void 0,
  params: {},
  query: {},
  hash: "",
  fullPath: "/",
  matched: [],
  meta: {},
  redirectedFrom: void 0
};
const NavigationFailureSymbol = /* @__PURE__ */ PolySymbol("nf");
var NavigationFailureType;
(function(NavigationFailureType2) {
  NavigationFailureType2[NavigationFailureType2["aborted"] = 4] = "aborted";
  NavigationFailureType2[NavigationFailureType2["cancelled"] = 8] = "cancelled";
  NavigationFailureType2[NavigationFailureType2["duplicated"] = 16] = "duplicated";
})(NavigationFailureType || (NavigationFailureType = {}));
function createRouterError(type, params) {
  {
    return assign$2(new Error(), {
      type,
      [NavigationFailureSymbol]: true
    }, params);
  }
}
function isNavigationFailure(error, type) {
  return error instanceof Error && NavigationFailureSymbol in error && (type == null || !!(error.type & type));
}
const BASE_PARAM_PATTERN = "[^/]+?";
const BASE_PATH_PARSER_OPTIONS = {
  sensitive: false,
  strict: false,
  start: true,
  end: true
};
const REGEX_CHARS_RE = /[.+*?^${}()[\]/\\]/g;
function tokensToParser(segments, extraOptions) {
  const options = assign$2({}, BASE_PATH_PARSER_OPTIONS, extraOptions);
  let score = [];
  let pattern = options.start ? "^" : "";
  const keys = [];
  for (const segment of segments) {
    const segmentScores = segment.length ? [] : [90];
    if (options.strict && !segment.length)
      pattern += "/";
    for (let tokenIndex = 0; tokenIndex < segment.length; tokenIndex++) {
      const token = segment[tokenIndex];
      let subSegmentScore = 40 + (options.sensitive ? 0.25 : 0);
      if (token.type === 0) {
        if (!tokenIndex)
          pattern += "/";
        pattern += token.value.replace(REGEX_CHARS_RE, "\\$&");
        subSegmentScore += 40;
      } else if (token.type === 1) {
        const { value, repeatable, optional, regexp } = token;
        keys.push({
          name: value,
          repeatable,
          optional
        });
        const re2 = regexp ? regexp : BASE_PARAM_PATTERN;
        if (re2 !== BASE_PARAM_PATTERN) {
          subSegmentScore += 10;
          try {
            new RegExp(`(${re2})`);
          } catch (err) {
            throw new Error(`Invalid custom RegExp for param "${value}" (${re2}): ` + err.message);
          }
        }
        let subPattern = repeatable ? `((?:${re2})(?:/(?:${re2}))*)` : `(${re2})`;
        if (!tokenIndex)
          subPattern = optional && segment.length < 2 ? `(?:/${subPattern})` : "/" + subPattern;
        if (optional)
          subPattern += "?";
        pattern += subPattern;
        subSegmentScore += 20;
        if (optional)
          subSegmentScore += -8;
        if (repeatable)
          subSegmentScore += -20;
        if (re2 === ".*")
          subSegmentScore += -50;
      }
      segmentScores.push(subSegmentScore);
    }
    score.push(segmentScores);
  }
  if (options.strict && options.end) {
    const i = score.length - 1;
    score[i][score[i].length - 1] += 0.7000000000000001;
  }
  if (!options.strict)
    pattern += "/?";
  if (options.end)
    pattern += "$";
  else if (options.strict)
    pattern += "(?:/|$)";
  const re = new RegExp(pattern, options.sensitive ? "" : "i");
  function parse2(path) {
    const match = path.match(re);
    const params = {};
    if (!match)
      return null;
    for (let i = 1; i < match.length; i++) {
      const value = match[i] || "";
      const key = keys[i - 1];
      params[key.name] = value && key.repeatable ? value.split("/") : value;
    }
    return params;
  }
  function stringify(params) {
    let path = "";
    let avoidDuplicatedSlash = false;
    for (const segment of segments) {
      if (!avoidDuplicatedSlash || !path.endsWith("/"))
        path += "/";
      avoidDuplicatedSlash = false;
      for (const token of segment) {
        if (token.type === 0) {
          path += token.value;
        } else if (token.type === 1) {
          const { value, repeatable, optional } = token;
          const param = value in params ? params[value] : "";
          if (Array.isArray(param) && !repeatable)
            throw new Error(`Provided param "${value}" is an array but it is not repeatable (* or + modifiers)`);
          const text = Array.isArray(param) ? param.join("/") : param;
          if (!text) {
            if (optional) {
              if (segment.length < 2) {
                if (path.endsWith("/"))
                  path = path.slice(0, -1);
                else
                  avoidDuplicatedSlash = true;
              }
            } else
              throw new Error(`Missing required param "${value}"`);
          }
          path += text;
        }
      }
    }
    return path;
  }
  return {
    re,
    score,
    keys,
    parse: parse2,
    stringify
  };
}
function compareScoreArray(a, b) {
  let i = 0;
  while (i < a.length && i < b.length) {
    const diff = b[i] - a[i];
    if (diff)
      return diff;
    i++;
  }
  if (a.length < b.length) {
    return a.length === 1 && a[0] === 40 + 40 ? -1 : 1;
  } else if (a.length > b.length) {
    return b.length === 1 && b[0] === 40 + 40 ? 1 : -1;
  }
  return 0;
}
function comparePathParserScore(a, b) {
  let i = 0;
  const aScore = a.score;
  const bScore = b.score;
  while (i < aScore.length && i < bScore.length) {
    const comp = compareScoreArray(aScore[i], bScore[i]);
    if (comp)
      return comp;
    i++;
  }
  return bScore.length - aScore.length;
}
const ROOT_TOKEN = {
  type: 0,
  value: ""
};
const VALID_PARAM_RE = /[a-zA-Z0-9_]/;
function tokenizePath(path) {
  if (!path)
    return [[]];
  if (path === "/")
    return [[ROOT_TOKEN]];
  if (!path.startsWith("/")) {
    throw new Error(`Invalid path "${path}"`);
  }
  function crash(message) {
    throw new Error(`ERR (${state})/"${buffer}": ${message}`);
  }
  let state = 0;
  let previousState = state;
  const tokens = [];
  let segment;
  function finalizeSegment() {
    if (segment)
      tokens.push(segment);
    segment = [];
  }
  let i = 0;
  let char;
  let buffer = "";
  let customRe = "";
  function consumeBuffer() {
    if (!buffer)
      return;
    if (state === 0) {
      segment.push({
        type: 0,
        value: buffer
      });
    } else if (state === 1 || state === 2 || state === 3) {
      if (segment.length > 1 && (char === "*" || char === "+"))
        crash(`A repeatable param (${buffer}) must be alone in its segment. eg: '/:ids+.`);
      segment.push({
        type: 1,
        value: buffer,
        regexp: customRe,
        repeatable: char === "*" || char === "+",
        optional: char === "*" || char === "?"
      });
    } else {
      crash("Invalid state to consume buffer");
    }
    buffer = "";
  }
  function addCharToBuffer() {
    buffer += char;
  }
  while (i < path.length) {
    char = path[i++];
    if (char === "\\" && state !== 2) {
      previousState = state;
      state = 4;
      continue;
    }
    switch (state) {
      case 0:
        if (char === "/") {
          if (buffer) {
            consumeBuffer();
          }
          finalizeSegment();
        } else if (char === ":") {
          consumeBuffer();
          state = 1;
        } else {
          addCharToBuffer();
        }
        break;
      case 4:
        addCharToBuffer();
        state = previousState;
        break;
      case 1:
        if (char === "(") {
          state = 2;
        } else if (VALID_PARAM_RE.test(char)) {
          addCharToBuffer();
        } else {
          consumeBuffer();
          state = 0;
          if (char !== "*" && char !== "?" && char !== "+")
            i--;
        }
        break;
      case 2:
        if (char === ")") {
          if (customRe[customRe.length - 1] == "\\")
            customRe = customRe.slice(0, -1) + char;
          else
            state = 3;
        } else {
          customRe += char;
        }
        break;
      case 3:
        consumeBuffer();
        state = 0;
        if (char !== "*" && char !== "?" && char !== "+")
          i--;
        customRe = "";
        break;
      default:
        crash("Unknown state");
        break;
    }
  }
  if (state === 2)
    crash(`Unfinished custom RegExp for param "${buffer}"`);
  consumeBuffer();
  finalizeSegment();
  return tokens;
}
function createRouteRecordMatcher(record, parent, options) {
  const parser = tokensToParser(tokenizePath(record.path), options);
  const matcher = assign$2(parser, {
    record,
    parent,
    children: [],
    alias: []
  });
  if (parent) {
    if (!matcher.record.aliasOf === !parent.record.aliasOf)
      parent.children.push(matcher);
  }
  return matcher;
}
function createRouterMatcher(routes, globalOptions) {
  const matchers = [];
  const matcherMap = new Map();
  globalOptions = mergeOptions({ strict: false, end: true, sensitive: false }, globalOptions);
  function getRecordMatcher(name) {
    return matcherMap.get(name);
  }
  function addRoute(record, parent, originalRecord) {
    let isRootAdd = !originalRecord;
    let mainNormalizedRecord = normalizeRouteRecord(record);
    mainNormalizedRecord.aliasOf = originalRecord && originalRecord.record;
    const options = mergeOptions(globalOptions, record);
    const normalizedRecords = [
      mainNormalizedRecord
    ];
    if ("alias" in record) {
      const aliases = typeof record.alias === "string" ? [record.alias] : record.alias;
      for (const alias of aliases) {
        normalizedRecords.push(assign$2({}, mainNormalizedRecord, {
          components: originalRecord ? originalRecord.record.components : mainNormalizedRecord.components,
          path: alias,
          aliasOf: originalRecord ? originalRecord.record : mainNormalizedRecord
        }));
      }
    }
    let matcher;
    let originalMatcher;
    for (const normalizedRecord of normalizedRecords) {
      let { path } = normalizedRecord;
      if (parent && path[0] !== "/") {
        let parentPath = parent.record.path;
        let connectingSlash = parentPath[parentPath.length - 1] === "/" ? "" : "/";
        normalizedRecord.path = parent.record.path + (path && connectingSlash + path);
      }
      matcher = createRouteRecordMatcher(normalizedRecord, parent, options);
      if (originalRecord) {
        originalRecord.alias.push(matcher);
      } else {
        originalMatcher = originalMatcher || matcher;
        if (originalMatcher !== matcher)
          originalMatcher.alias.push(matcher);
        if (isRootAdd && record.name && !isAliasRecord(matcher))
          removeRoute(record.name);
      }
      if ("children" in mainNormalizedRecord) {
        let children = mainNormalizedRecord.children;
        for (let i = 0; i < children.length; i++) {
          addRoute(children[i], matcher, originalRecord && originalRecord.children[i]);
        }
      }
      originalRecord = originalRecord || matcher;
      insertMatcher(matcher);
    }
    return originalMatcher ? () => {
      removeRoute(originalMatcher);
    } : noop$2;
  }
  function removeRoute(matcherRef) {
    if (isRouteName(matcherRef)) {
      const matcher = matcherMap.get(matcherRef);
      if (matcher) {
        matcherMap.delete(matcherRef);
        matchers.splice(matchers.indexOf(matcher), 1);
        matcher.children.forEach(removeRoute);
        matcher.alias.forEach(removeRoute);
      }
    } else {
      let index = matchers.indexOf(matcherRef);
      if (index > -1) {
        matchers.splice(index, 1);
        if (matcherRef.record.name)
          matcherMap.delete(matcherRef.record.name);
        matcherRef.children.forEach(removeRoute);
        matcherRef.alias.forEach(removeRoute);
      }
    }
  }
  function getRoutes() {
    return matchers;
  }
  function insertMatcher(matcher) {
    let i = 0;
    while (i < matchers.length && comparePathParserScore(matcher, matchers[i]) >= 0)
      i++;
    matchers.splice(i, 0, matcher);
    if (matcher.record.name && !isAliasRecord(matcher))
      matcherMap.set(matcher.record.name, matcher);
  }
  function resolve2(location2, currentLocation) {
    let matcher;
    let params = {};
    let path;
    let name;
    if ("name" in location2 && location2.name) {
      matcher = matcherMap.get(location2.name);
      if (!matcher)
        throw createRouterError(1, {
          location: location2
        });
      name = matcher.record.name;
      params = assign$2(paramsFromLocation(currentLocation.params, matcher.keys.filter((k) => !k.optional).map((k) => k.name)), location2.params);
      path = matcher.stringify(params);
    } else if ("path" in location2) {
      path = location2.path;
      matcher = matchers.find((m) => m.re.test(path));
      if (matcher) {
        params = matcher.parse(path);
        name = matcher.record.name;
      }
    } else {
      matcher = currentLocation.name ? matcherMap.get(currentLocation.name) : matchers.find((m) => m.re.test(currentLocation.path));
      if (!matcher)
        throw createRouterError(1, {
          location: location2,
          currentLocation
        });
      name = matcher.record.name;
      params = assign$2({}, currentLocation.params, location2.params);
      path = matcher.stringify(params);
    }
    const matched = [];
    let parentMatcher = matcher;
    while (parentMatcher) {
      matched.unshift(parentMatcher.record);
      parentMatcher = parentMatcher.parent;
    }
    return {
      name,
      path,
      params,
      matched,
      meta: mergeMetaFields(matched)
    };
  }
  routes.forEach((route) => addRoute(route));
  return { addRoute, resolve: resolve2, removeRoute, getRoutes, getRecordMatcher };
}
function paramsFromLocation(params, keys) {
  let newParams = {};
  for (let key of keys) {
    if (key in params)
      newParams[key] = params[key];
  }
  return newParams;
}
function normalizeRouteRecord(record) {
  return {
    path: record.path,
    redirect: record.redirect,
    name: record.name,
    meta: record.meta || {},
    aliasOf: void 0,
    beforeEnter: record.beforeEnter,
    props: normalizeRecordProps(record),
    children: record.children || [],
    instances: {},
    leaveGuards: new Set(),
    updateGuards: new Set(),
    enterCallbacks: {},
    components: "components" in record ? record.components || {} : { default: record.component }
  };
}
function normalizeRecordProps(record) {
  const propsObject = {};
  const props = record.props || false;
  if ("component" in record) {
    propsObject.default = props;
  } else {
    for (let name in record.components)
      propsObject[name] = typeof props === "boolean" ? props : props[name];
  }
  return propsObject;
}
function isAliasRecord(record) {
  while (record) {
    if (record.record.aliasOf)
      return true;
    record = record.parent;
  }
  return false;
}
function mergeMetaFields(matched) {
  return matched.reduce((meta, record) => assign$2(meta, record.meta), {});
}
function mergeOptions(defaults2, partialOptions) {
  let options = {};
  for (let key in defaults2) {
    options[key] = key in partialOptions ? partialOptions[key] : defaults2[key];
  }
  return options;
}
const HASH_RE = /#/g;
const AMPERSAND_RE = /&/g;
const SLASH_RE = /\//g;
const EQUAL_RE = /=/g;
const IM_RE = /\?/g;
const PLUS_RE = /\+/g;
const ENC_BRACKET_OPEN_RE = /%5B/g;
const ENC_BRACKET_CLOSE_RE = /%5D/g;
const ENC_CARET_RE = /%5E/g;
const ENC_BACKTICK_RE = /%60/g;
const ENC_CURLY_OPEN_RE = /%7B/g;
const ENC_PIPE_RE = /%7C/g;
const ENC_CURLY_CLOSE_RE = /%7D/g;
const ENC_SPACE_RE = /%20/g;
function commonEncode(text) {
  return encodeURI("" + text).replace(ENC_PIPE_RE, "|").replace(ENC_BRACKET_OPEN_RE, "[").replace(ENC_BRACKET_CLOSE_RE, "]");
}
function encodeHash(text) {
  return commonEncode(text).replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryValue(text) {
  return commonEncode(text).replace(PLUS_RE, "%2B").replace(ENC_SPACE_RE, "+").replace(HASH_RE, "%23").replace(AMPERSAND_RE, "%26").replace(ENC_BACKTICK_RE, "`").replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryKey(text) {
  return encodeQueryValue(text).replace(EQUAL_RE, "%3D");
}
function encodePath(text) {
  return commonEncode(text).replace(HASH_RE, "%23").replace(IM_RE, "%3F");
}
function encodeParam(text) {
  return encodePath(text).replace(SLASH_RE, "%2F");
}
function decode(text) {
  try {
    return decodeURIComponent("" + text);
  } catch (err) {
  }
  return "" + text;
}
function parseQuery(search) {
  const query = {};
  if (search === "" || search === "?")
    return query;
  const hasLeadingIM = search[0] === "?";
  const searchParams = (hasLeadingIM ? search.slice(1) : search).split("&");
  for (let i = 0; i < searchParams.length; ++i) {
    const searchParam = searchParams[i].replace(PLUS_RE, " ");
    let eqPos = searchParam.indexOf("=");
    let key = decode(eqPos < 0 ? searchParam : searchParam.slice(0, eqPos));
    let value = eqPos < 0 ? null : decode(searchParam.slice(eqPos + 1));
    if (key in query) {
      let currentValue = query[key];
      if (!Array.isArray(currentValue)) {
        currentValue = query[key] = [currentValue];
      }
      currentValue.push(value);
    } else {
      query[key] = value;
    }
  }
  return query;
}
function stringifyQuery(query) {
  let search = "";
  for (let key in query) {
    const value = query[key];
    key = encodeQueryKey(key);
    if (value == null) {
      if (value !== void 0) {
        search += (search.length ? "&" : "") + key;
      }
      continue;
    }
    let values = Array.isArray(value) ? value.map((v) => v && encodeQueryValue(v)) : [value && encodeQueryValue(value)];
    values.forEach((value2) => {
      if (value2 !== void 0) {
        search += (search.length ? "&" : "") + key;
        if (value2 != null)
          search += "=" + value2;
      }
    });
  }
  return search;
}
function normalizeQuery(query) {
  const normalizedQuery = {};
  for (let key in query) {
    let value = query[key];
    if (value !== void 0) {
      normalizedQuery[key] = Array.isArray(value) ? value.map((v) => v == null ? null : "" + v) : value == null ? value : "" + value;
    }
  }
  return normalizedQuery;
}
function useCallbacks() {
  let handlers = [];
  function add2(handler) {
    handlers.push(handler);
    return () => {
      const i = handlers.indexOf(handler);
      if (i > -1)
        handlers.splice(i, 1);
    };
  }
  function reset2() {
    handlers = [];
  }
  return {
    add: add2,
    list: () => handlers,
    reset: reset2
  };
}
function guardToPromiseFn(guard, to, from, record, name) {
  const enterCallbackArray = record && (record.enterCallbacks[name] = record.enterCallbacks[name] || []);
  return () => new Promise((resolve2, reject) => {
    const next = (valid) => {
      if (valid === false)
        reject(createRouterError(4, {
          from,
          to
        }));
      else if (valid instanceof Error) {
        reject(valid);
      } else if (isRouteLocation(valid)) {
        reject(createRouterError(2, {
          from: to,
          to: valid
        }));
      } else {
        if (enterCallbackArray && record.enterCallbacks[name] === enterCallbackArray && typeof valid === "function")
          enterCallbackArray.push(valid);
        resolve2();
      }
    };
    const guardReturn = guard.call(record && record.instances[name], to, from, next);
    let guardCall = Promise.resolve(guardReturn);
    if (guard.length < 3)
      guardCall = guardCall.then(next);
    guardCall.catch((err) => reject(err));
  });
}
function extractComponentsGuards(matched, guardType, to, from) {
  const guards = [];
  for (const record of matched) {
    for (const name in record.components) {
      let rawComponent = record.components[name];
      if (guardType !== "beforeRouteEnter" && !record.instances[name])
        continue;
      if (isRouteComponent(rawComponent)) {
        let options = rawComponent.__vccOpts || rawComponent;
        const guard = options[guardType];
        guard && guards.push(guardToPromiseFn(guard, to, from, record, name));
      } else {
        let componentPromise = rawComponent();
        guards.push(() => componentPromise.then((resolved) => {
          if (!resolved)
            return Promise.reject(new Error(`Couldn't resolve component "${name}" at "${record.path}"`));
          const resolvedComponent = isESModule(resolved) ? resolved.default : resolved;
          record.components[name] = resolvedComponent;
          let options = resolvedComponent.__vccOpts || resolvedComponent;
          const guard = options[guardType];
          return guard && guardToPromiseFn(guard, to, from, record, name)();
        }));
      }
    }
  }
  return guards;
}
function isRouteComponent(component) {
  return typeof component === "object" || "displayName" in component || "props" in component || "__vccOpts" in component;
}
function useLink(props) {
  const router = inject(routerKey);
  const currentRoute = inject(routeLocationKey);
  const route = computed(() => router.resolve(unref(props.to)));
  const activeRecordIndex = computed(() => {
    let { matched } = route.value;
    let { length } = matched;
    const routeMatched = matched[length - 1];
    let currentMatched = currentRoute.matched;
    if (!routeMatched || !currentMatched.length)
      return -1;
    let index = currentMatched.findIndex(isSameRouteRecord.bind(null, routeMatched));
    if (index > -1)
      return index;
    let parentRecordPath = getOriginalPath(matched[length - 2]);
    return length > 1 && getOriginalPath(routeMatched) === parentRecordPath && currentMatched[currentMatched.length - 1].path !== parentRecordPath ? currentMatched.findIndex(isSameRouteRecord.bind(null, matched[length - 2])) : index;
  });
  const isActive = computed(() => activeRecordIndex.value > -1 && includesParams(currentRoute.params, route.value.params));
  const isExactActive = computed(() => activeRecordIndex.value > -1 && activeRecordIndex.value === currentRoute.matched.length - 1 && isSameRouteLocationParams(currentRoute.params, route.value.params));
  function navigate(e = {}) {
    if (guardEvent(e)) {
      return router[unref(props.replace) ? "replace" : "push"](unref(props.to)).catch(noop$2);
    }
    return Promise.resolve();
  }
  return {
    route,
    href: computed(() => route.value.href),
    isActive,
    isExactActive,
    navigate
  };
}
const RouterLinkImpl = /* @__PURE__ */ defineComponent({
  name: "RouterLink",
  props: {
    to: {
      type: [String, Object],
      required: true
    },
    replace: Boolean,
    activeClass: String,
    exactActiveClass: String,
    custom: Boolean,
    ariaCurrentValue: {
      type: String,
      default: "page"
    }
  },
  useLink,
  setup(props, { slots }) {
    const link = reactive(useLink(props));
    const { options } = inject(routerKey);
    const elClass = computed(() => ({
      [getLinkClass(props.activeClass, options.linkActiveClass, "router-link-active")]: link.isActive,
      [getLinkClass(props.exactActiveClass, options.linkExactActiveClass, "router-link-exact-active")]: link.isExactActive
    }));
    return () => {
      const children = slots.default && slots.default(link);
      return props.custom ? children : h("a", {
        "aria-current": link.isExactActive ? props.ariaCurrentValue : null,
        href: link.href,
        onClick: link.navigate,
        class: elClass.value
      }, children);
    };
  }
});
const RouterLink = RouterLinkImpl;
function guardEvent(e) {
  if (e.metaKey || e.altKey || e.ctrlKey || e.shiftKey)
    return;
  if (e.defaultPrevented)
    return;
  if (e.button !== void 0 && e.button !== 0)
    return;
  if (e.currentTarget && e.currentTarget.getAttribute) {
    const target = e.currentTarget.getAttribute("target");
    if (/\b_blank\b/i.test(target))
      return;
  }
  if (e.preventDefault)
    e.preventDefault();
  return true;
}
function includesParams(outer, inner) {
  for (let key in inner) {
    let innerValue = inner[key];
    let outerValue = outer[key];
    if (typeof innerValue === "string") {
      if (innerValue !== outerValue)
        return false;
    } else {
      if (!Array.isArray(outerValue) || outerValue.length !== innerValue.length || innerValue.some((value, i) => value !== outerValue[i]))
        return false;
    }
  }
  return true;
}
function getOriginalPath(record) {
  return record ? record.aliasOf ? record.aliasOf.path : record.path : "";
}
const getLinkClass = (propClass, globalClass, defaultClass) => propClass != null ? propClass : globalClass != null ? globalClass : defaultClass;
const RouterViewImpl = /* @__PURE__ */ defineComponent({
  name: "RouterView",
  inheritAttrs: false,
  props: {
    name: {
      type: String,
      default: "default"
    },
    route: Object
  },
  setup(props, { attrs, slots }) {
    const injectedRoute = inject(routerViewLocationKey);
    const routeToDisplay = computed(() => props.route || injectedRoute.value);
    const depth = inject(viewDepthKey, 0);
    const matchedRouteRef = computed(() => routeToDisplay.value.matched[depth]);
    provide(viewDepthKey, depth + 1);
    provide(matchedRouteKey, matchedRouteRef);
    provide(routerViewLocationKey, routeToDisplay);
    const viewRef = ref();
    watch(() => [viewRef.value, matchedRouteRef.value, props.name], ([instance, to, name], [oldInstance, from, oldName]) => {
      if (to) {
        to.instances[name] = instance;
        if (from && from !== to && instance && instance === oldInstance) {
          if (!to.leaveGuards.size) {
            to.leaveGuards = from.leaveGuards;
          }
          if (!to.updateGuards.size) {
            to.updateGuards = from.updateGuards;
          }
        }
      }
      if (instance && to && (!from || !isSameRouteRecord(to, from) || !oldInstance)) {
        (to.enterCallbacks[name] || []).forEach((callback) => callback(instance));
      }
    }, { flush: "post" });
    return () => {
      const route = routeToDisplay.value;
      const matchedRoute = matchedRouteRef.value;
      const ViewComponent = matchedRoute && matchedRoute.components[props.name];
      const currentName = props.name;
      if (!ViewComponent) {
        return normalizeSlot(slots.default, { Component: ViewComponent, route });
      }
      const routePropsOption = matchedRoute.props[props.name];
      const routeProps = routePropsOption ? routePropsOption === true ? route.params : typeof routePropsOption === "function" ? routePropsOption(route) : routePropsOption : null;
      const onVnodeUnmounted = (vnode) => {
        if (vnode.component.isUnmounted) {
          matchedRoute.instances[currentName] = null;
        }
      };
      const component = h(ViewComponent, assign$2({}, routeProps, attrs, {
        onVnodeUnmounted,
        ref: viewRef
      }));
      return normalizeSlot(slots.default, { Component: component, route }) || component;
    };
  }
});
function normalizeSlot(slot, data2) {
  if (!slot)
    return null;
  const slotContent = slot(data2);
  return slotContent.length === 1 ? slotContent[0] : slotContent;
}
const RouterView = RouterViewImpl;
function createRouter(options) {
  const matcher = createRouterMatcher(options.routes, options);
  let parseQuery$1 = options.parseQuery || parseQuery;
  let stringifyQuery$1 = options.stringifyQuery || stringifyQuery;
  let routerHistory = options.history;
  const beforeGuards = useCallbacks();
  const beforeResolveGuards = useCallbacks();
  const afterGuards = useCallbacks();
  const currentRoute = shallowRef(START_LOCATION_NORMALIZED);
  let pendingLocation = START_LOCATION_NORMALIZED;
  if (isBrowser && options.scrollBehavior && "scrollRestoration" in history) {
    history.scrollRestoration = "manual";
  }
  const normalizeParams = applyToParams.bind(null, (paramValue) => "" + paramValue);
  const encodeParams = applyToParams.bind(null, encodeParam);
  const decodeParams = applyToParams.bind(null, decode);
  function addRoute(parentOrRoute, route) {
    let parent;
    let record;
    if (isRouteName(parentOrRoute)) {
      parent = matcher.getRecordMatcher(parentOrRoute);
      record = route;
    } else {
      record = parentOrRoute;
    }
    return matcher.addRoute(record, parent);
  }
  function removeRoute(name) {
    let recordMatcher = matcher.getRecordMatcher(name);
    if (recordMatcher) {
      matcher.removeRoute(recordMatcher);
    }
  }
  function getRoutes() {
    return matcher.getRoutes().map((routeMatcher) => routeMatcher.record);
  }
  function hasRoute(name) {
    return !!matcher.getRecordMatcher(name);
  }
  function resolve2(rawLocation, currentLocation) {
    currentLocation = assign$2({}, currentLocation || currentRoute.value);
    if (typeof rawLocation === "string") {
      let locationNormalized = parseURL(parseQuery$1, rawLocation, currentLocation.path);
      let matchedRoute2 = matcher.resolve({ path: locationNormalized.path }, currentLocation);
      let href2 = routerHistory.createHref(locationNormalized.fullPath);
      return assign$2(locationNormalized, matchedRoute2, {
        params: decodeParams(matchedRoute2.params),
        hash: decode(locationNormalized.hash),
        redirectedFrom: void 0,
        href: href2
      });
    }
    let matcherLocation;
    if ("path" in rawLocation) {
      matcherLocation = assign$2({}, rawLocation, {
        path: parseURL(parseQuery$1, rawLocation.path, currentLocation.path).path
      });
    } else {
      matcherLocation = assign$2({}, rawLocation, {
        params: encodeParams(rawLocation.params)
      });
      currentLocation.params = encodeParams(currentLocation.params);
    }
    let matchedRoute = matcher.resolve(matcherLocation, currentLocation);
    const hash = rawLocation.hash || "";
    matchedRoute.params = normalizeParams(decodeParams(matchedRoute.params));
    const fullPath = stringifyURL(stringifyQuery$1, assign$2({}, rawLocation, {
      hash: encodeHash(hash),
      path: matchedRoute.path
    }));
    let href = routerHistory.createHref(fullPath);
    return assign$2({
      fullPath,
      hash,
      query: stringifyQuery$1 === stringifyQuery ? normalizeQuery(rawLocation.query) : rawLocation.query
    }, matchedRoute, {
      redirectedFrom: void 0,
      href
    });
  }
  function locationAsObject(to) {
    return typeof to === "string" ? parseURL(parseQuery$1, to, currentRoute.value.path) : assign$2({}, to);
  }
  function checkCanceledNavigation(to, from) {
    if (pendingLocation !== to) {
      return createRouterError(8, {
        from,
        to
      });
    }
  }
  function push(to) {
    return pushWithRedirect(to);
  }
  function replace(to) {
    return push(assign$2(locationAsObject(to), { replace: true }));
  }
  function handleRedirectRecord(to) {
    const lastMatched = to.matched[to.matched.length - 1];
    if (lastMatched && lastMatched.redirect) {
      const { redirect } = lastMatched;
      let newTargetLocation = typeof redirect === "function" ? redirect(to) : redirect;
      if (typeof newTargetLocation === "string") {
        newTargetLocation = newTargetLocation.includes("?") || newTargetLocation.includes("#") ? newTargetLocation = locationAsObject(newTargetLocation) : { path: newTargetLocation };
        newTargetLocation.params = {};
      }
      return assign$2({
        query: to.query,
        hash: to.hash,
        params: to.params
      }, newTargetLocation);
    }
  }
  function pushWithRedirect(to, redirectedFrom) {
    const targetLocation = pendingLocation = resolve2(to);
    const from = currentRoute.value;
    const data2 = to.state;
    const force = to.force;
    const replace2 = to.replace === true;
    const shouldRedirect = handleRedirectRecord(targetLocation);
    if (shouldRedirect)
      return pushWithRedirect(assign$2(locationAsObject(shouldRedirect), {
        state: data2,
        force,
        replace: replace2
      }), redirectedFrom || targetLocation);
    const toLocation = targetLocation;
    toLocation.redirectedFrom = redirectedFrom;
    let failure;
    if (!force && isSameRouteLocation(stringifyQuery$1, from, targetLocation)) {
      failure = createRouterError(16, { to: toLocation, from });
      handleScroll(from, from, true, false);
    }
    return (failure ? Promise.resolve(failure) : navigate(toLocation, from)).catch((error) => isNavigationFailure(error) ? error : triggerError(error, toLocation, from)).then((failure2) => {
      if (failure2) {
        if (isNavigationFailure(failure2, 2)) {
          return pushWithRedirect(assign$2(locationAsObject(failure2.to), {
            state: data2,
            force,
            replace: replace2
          }), redirectedFrom || toLocation);
        }
      } else {
        failure2 = finalizeNavigation(toLocation, from, true, replace2, data2);
      }
      triggerAfterEach(toLocation, from, failure2);
      return failure2;
    });
  }
  function checkCanceledNavigationAndReject(to, from) {
    const error = checkCanceledNavigation(to, from);
    return error ? Promise.reject(error) : Promise.resolve();
  }
  function navigate(to, from) {
    let guards;
    const [leavingRecords, updatingRecords, enteringRecords] = extractChangingRecords(to, from);
    guards = extractComponentsGuards(leavingRecords.reverse(), "beforeRouteLeave", to, from);
    for (const record of leavingRecords) {
      record.leaveGuards.forEach((guard) => {
        guards.push(guardToPromiseFn(guard, to, from));
      });
    }
    const canceledNavigationCheck = checkCanceledNavigationAndReject.bind(null, to, from);
    guards.push(canceledNavigationCheck);
    return runGuardQueue(guards).then(() => {
      guards = [];
      for (const guard of beforeGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = extractComponentsGuards(updatingRecords, "beforeRouteUpdate", to, from);
      for (const record of updatingRecords) {
        record.updateGuards.forEach((guard) => {
          guards.push(guardToPromiseFn(guard, to, from));
        });
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const record of to.matched) {
        if (record.beforeEnter && !from.matched.includes(record)) {
          if (Array.isArray(record.beforeEnter)) {
            for (const beforeEnter of record.beforeEnter)
              guards.push(guardToPromiseFn(beforeEnter, to, from));
          } else {
            guards.push(guardToPromiseFn(record.beforeEnter, to, from));
          }
        }
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      to.matched.forEach((record) => record.enterCallbacks = {});
      guards = extractComponentsGuards(enteringRecords, "beforeRouteEnter", to, from);
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const guard of beforeResolveGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).catch((err) => isNavigationFailure(err, 8) ? err : Promise.reject(err));
  }
  function triggerAfterEach(to, from, failure) {
    for (const guard of afterGuards.list())
      guard(to, from, failure);
  }
  function finalizeNavigation(toLocation, from, isPush, replace2, data2) {
    const error = checkCanceledNavigation(toLocation, from);
    if (error)
      return error;
    const isFirstNavigation = from === START_LOCATION_NORMALIZED;
    const state = !isBrowser ? {} : history.state;
    if (isPush) {
      if (replace2 || isFirstNavigation)
        routerHistory.replace(toLocation.fullPath, assign$2({
          scroll: isFirstNavigation && state && state.scroll
        }, data2));
      else
        routerHistory.push(toLocation.fullPath, data2);
    }
    currentRoute.value = toLocation;
    handleScroll(toLocation, from, isPush, isFirstNavigation);
    markAsReady();
  }
  let removeHistoryListener;
  function setupListeners() {
    removeHistoryListener = routerHistory.listen((to, _from, info) => {
      let toLocation = resolve2(to);
      const shouldRedirect = handleRedirectRecord(toLocation);
      if (shouldRedirect) {
        pushWithRedirect(assign$2(shouldRedirect, { replace: true }), toLocation).catch(noop$2);
        return;
      }
      pendingLocation = toLocation;
      const from = currentRoute.value;
      if (isBrowser) {
        saveScrollPosition(getScrollKey(from.fullPath, info.delta), computeScrollPosition());
      }
      navigate(toLocation, from).catch((error) => {
        if (isNavigationFailure(error, 4 | 8)) {
          return error;
        }
        if (isNavigationFailure(error, 2)) {
          pushWithRedirect(error.to, toLocation).then((failure) => {
            if (isNavigationFailure(failure, 4 | 16) && !info.delta && info.type === NavigationType.pop) {
              routerHistory.go(-1, false);
            }
          }).catch(noop$2);
          return Promise.reject();
        }
        if (info.delta)
          routerHistory.go(-info.delta, false);
        return triggerError(error, toLocation, from);
      }).then((failure) => {
        failure = failure || finalizeNavigation(toLocation, from, false);
        if (failure) {
          if (info.delta) {
            routerHistory.go(-info.delta, false);
          } else if (info.type === NavigationType.pop && isNavigationFailure(failure, 4 | 16)) {
            routerHistory.go(-1, false);
          }
        }
        triggerAfterEach(toLocation, from, failure);
      }).catch(noop$2);
    });
  }
  let readyHandlers = useCallbacks();
  let errorHandlers = useCallbacks();
  let ready;
  function triggerError(error, to, from) {
    markAsReady(error);
    const list = errorHandlers.list();
    if (list.length) {
      list.forEach((handler) => handler(error, to, from));
    } else {
      console.error(error);
    }
    return Promise.reject(error);
  }
  function isReady() {
    if (ready && currentRoute.value !== START_LOCATION_NORMALIZED)
      return Promise.resolve();
    return new Promise((resolve3, reject) => {
      readyHandlers.add([resolve3, reject]);
    });
  }
  function markAsReady(err) {
    if (ready)
      return;
    ready = true;
    setupListeners();
    readyHandlers.list().forEach(([resolve3, reject]) => err ? reject(err) : resolve3());
    readyHandlers.reset();
  }
  function handleScroll(to, from, isPush, isFirstNavigation) {
    const { scrollBehavior } = options;
    if (!isBrowser || !scrollBehavior)
      return Promise.resolve();
    let scrollPosition = !isPush && getSavedScrollPosition(getScrollKey(to.fullPath, 0)) || (isFirstNavigation || !isPush) && history.state && history.state.scroll || null;
    return nextTick().then(() => scrollBehavior(to, from, scrollPosition)).then((position) => position && scrollToPosition(position)).catch((err) => triggerError(err, to, from));
  }
  const go = (delta) => routerHistory.go(delta);
  let started;
  const installedApps = new Set();
  const router = {
    currentRoute,
    addRoute,
    removeRoute,
    hasRoute,
    getRoutes,
    resolve: resolve2,
    options,
    push,
    replace,
    go,
    back: () => go(-1),
    forward: () => go(1),
    beforeEach: beforeGuards.add,
    beforeResolve: beforeResolveGuards.add,
    afterEach: afterGuards.add,
    onError: errorHandlers.add,
    isReady,
    install(app) {
      const router2 = this;
      app.component("RouterLink", RouterLink);
      app.component("RouterView", RouterView);
      app.config.globalProperties.$router = router2;
      Object.defineProperty(app.config.globalProperties, "$route", {
        enumerable: true,
        get: () => unref(currentRoute)
      });
      if (isBrowser && !started && currentRoute.value === START_LOCATION_NORMALIZED) {
        started = true;
        push(routerHistory.location).catch((err) => {
        });
      }
      const reactiveRoute = {};
      for (let key in START_LOCATION_NORMALIZED) {
        reactiveRoute[key] = computed(() => currentRoute.value[key]);
      }
      app.provide(routerKey, router2);
      app.provide(routeLocationKey, reactive(reactiveRoute));
      app.provide(routerViewLocationKey, currentRoute);
      let unmountApp = app.unmount;
      installedApps.add(app);
      app.unmount = function() {
        installedApps.delete(app);
        if (installedApps.size < 1) {
          removeHistoryListener();
          currentRoute.value = START_LOCATION_NORMALIZED;
          started = false;
          ready = false;
        }
        unmountApp();
      };
    }
  };
  return router;
}
function runGuardQueue(guards) {
  return guards.reduce((promise, guard) => promise.then(() => guard()), Promise.resolve());
}
function extractChangingRecords(to, from) {
  const leavingRecords = [];
  const updatingRecords = [];
  const enteringRecords = [];
  const len = Math.max(from.matched.length, to.matched.length);
  for (let i = 0; i < len; i++) {
    const recordFrom = from.matched[i];
    if (recordFrom) {
      if (to.matched.find((record) => isSameRouteRecord(record, recordFrom)))
        updatingRecords.push(recordFrom);
      else
        leavingRecords.push(recordFrom);
    }
    const recordTo = to.matched[i];
    if (recordTo) {
      if (!from.matched.find((record) => isSameRouteRecord(record, recordTo))) {
        enteringRecords.push(recordTo);
      }
    }
  }
  return [leavingRecords, updatingRecords, enteringRecords];
}
function useRouter() {
  return inject(routerKey);
}
function useRoute() {
  return inject(routeLocationKey);
}
var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var PROVIDE_KEY = `usehead`;
var HEAD_COUNT_KEY = `head:count`;
var HEAD_ATTRS_KEY = `data-head-attrs`;
var createElement = (tag, attrs, document2) => {
  const el = document2.createElement(tag);
  for (const key of Object.keys(attrs)) {
    let value = attrs[key];
    if (key === "key" || value === false) {
      continue;
    }
    if (key === "children") {
      el.textContent = value;
    } else {
      el.setAttribute(key, value);
    }
  }
  return el;
};
var getTagKey = (props) => {
  if (props.key !== void 0) {
    return { name: "key", value: props.key };
  }
  if (props.name !== void 0) {
    return { name: "name", value: props.name };
  }
  if (props.property !== void 0) {
    return {
      name: "property",
      value: props.property
    };
  }
};
var injectHead = () => {
  const head = inject(PROVIDE_KEY);
  if (!head) {
    throw new Error(`You may forget to apply app.use(head)`);
  }
  return head;
};
var acceptFields = [
  "title",
  "meta",
  "link",
  "base",
  "style",
  "script",
  "htmlAttrs",
  "bodyAttrs"
];
var headObjToTags = (obj) => {
  const tags = [];
  for (const key of Object.keys(obj)) {
    if (obj[key] == null)
      continue;
    if (key === "title") {
      tags.push({ tag: key, props: { children: obj[key] } });
    } else if (key === "base") {
      tags.push({ tag: key, props: __spreadValues({ key: "default" }, obj[key]) });
    } else if (acceptFields.includes(key)) {
      const value = obj[key];
      if (Array.isArray(value)) {
        value.forEach((item) => {
          tags.push({ tag: key, props: item });
        });
      } else if (value) {
        tags.push({ tag: key, props: value });
      }
    }
  }
  return tags;
};
var setAttrs = (el, attrs) => {
  const existingAttrs = el.getAttribute(HEAD_ATTRS_KEY);
  if (existingAttrs) {
    for (const key of existingAttrs.split(",")) {
      el.removeAttribute(key);
    }
  }
  const keys = [];
  for (const key in attrs) {
    const value = attrs[key];
    if (value == null)
      continue;
    if (value === false) {
      el.removeAttribute(key);
    } else {
      el.setAttribute(key, value);
    }
    keys.push(key);
  }
  if (keys.length) {
    el.setAttribute(HEAD_ATTRS_KEY, keys.join(","));
  } else {
    el.removeAttribute(HEAD_ATTRS_KEY);
  }
};
var insertTags = (tags, document2 = window.document) => {
  const head = document2.head;
  let headCountEl = head.querySelector(`meta[name="${HEAD_COUNT_KEY}"]`);
  const headCount = headCountEl ? Number(headCountEl.getAttribute("content")) : 0;
  const oldElements = [];
  if (headCountEl) {
    for (let i = 0, j = headCountEl.previousElementSibling; i < headCount; i++, j = j.previousElementSibling) {
      if (j) {
        oldElements.push(j);
      }
    }
  } else {
    headCountEl = document2.createElement("meta");
    headCountEl.setAttribute("name", HEAD_COUNT_KEY);
    headCountEl.setAttribute("content", "0");
    head.append(headCountEl);
  }
  const newElements = [];
  let title;
  let htmlAttrs = {};
  let bodyAttrs = {};
  for (const tag of tags) {
    if (tag.tag === "title") {
      title = tag.props.children;
      continue;
    }
    if (tag.tag === "htmlAttrs") {
      Object.assign(htmlAttrs, tag.props);
      continue;
    }
    if (tag.tag === "bodyAttrs") {
      Object.assign(bodyAttrs, tag.props);
      continue;
    }
    if (tag.tag === "meta") {
      const key = getTagKey(tag.props);
      if (key) {
        const elementList = [
          ...head.querySelectorAll(`meta[${key.name}="${key.value}"]`)
        ];
        for (const el of elementList) {
          if (!oldElements.includes(el)) {
            oldElements.push(el);
          }
        }
      }
    }
    newElements.push(createElement(tag.tag, tag.props, document2));
  }
  oldElements.forEach((el) => {
    if (el.nextSibling && el.nextSibling.nodeType === Node.TEXT_NODE) {
      el.nextSibling.remove();
    }
    el.remove();
  });
  if (title !== void 0) {
    document2.title = title;
  }
  setAttrs(document2.documentElement, htmlAttrs);
  setAttrs(document2.body, bodyAttrs);
  newElements.forEach((el) => {
    head.insertBefore(el, headCountEl);
  });
  headCountEl.setAttribute("content", "" + newElements.length);
};
var createHead = () => {
  let allHeadObjs = [];
  const head = {
    install(app) {
      app.config.globalProperties.$head = head;
      app.provide(PROVIDE_KEY, head);
    },
    get headTags() {
      const deduped = [];
      allHeadObjs.forEach((objs) => {
        const tags = headObjToTags(objs.value);
        tags.forEach((tag) => {
          if (tag.tag === "meta" || tag.tag === "base") {
            const key = getTagKey(tag.props);
            if (key) {
              let index = -1;
              for (let i = 0; i < deduped.length; i++) {
                const prev = deduped[i];
                const prevValue = prev.props[key.name];
                const nextValue = tag.props[key.name];
                if (prev.tag === tag.tag && prevValue === nextValue) {
                  index = i;
                  break;
                }
              }
              if (index !== -1) {
                deduped.splice(index, 1);
              }
            }
          }
          deduped.push(tag);
        });
      });
      return deduped;
    },
    addHeadObjs(objs) {
      allHeadObjs.push(objs);
    },
    removeHeadObjs(objs) {
      allHeadObjs = allHeadObjs.filter((_objs) => _objs !== objs);
    },
    updateDOM(document2) {
      insertTags(head.headTags, document2);
    }
  };
  return head;
};
var IS_BROWSER = typeof window !== "undefined";
var useHead = (obj) => {
  const headObj = ref(obj);
  const head = injectHead();
  head.addHeadObjs(headObj);
  if (IS_BROWSER) {
    watchEffect(() => {
      head.updateDOM();
    });
    onBeforeUnmount(() => {
      head.removeHeadObjs(headObj);
      head.updateDOM();
    });
  }
};
var isVue2 = false;
/*!
  * pinia v2.0.9
  * (c) 2021 Eduardo San Martin Morote
  * @license MIT
  */
let activePinia;
const setActivePinia = (pinia) => activePinia = pinia;
const piniaSymbol = Symbol();
function isPlainObject$2(o) {
  return o && typeof o === "object" && Object.prototype.toString.call(o) === "[object Object]" && typeof o.toJSON !== "function";
}
var MutationType;
(function(MutationType2) {
  MutationType2["direct"] = "direct";
  MutationType2["patchObject"] = "patch object";
  MutationType2["patchFunction"] = "patch function";
})(MutationType || (MutationType = {}));
function createPinia() {
  const scope = effectScope(true);
  const state = scope.run(() => ref({}));
  let _p = [];
  let toBeInstalled = [];
  const pinia = markRaw({
    install(app) {
      setActivePinia(pinia);
      {
        pinia._a = app;
        app.provide(piniaSymbol, pinia);
        app.config.globalProperties.$pinia = pinia;
        toBeInstalled.forEach((plugin) => _p.push(plugin));
        toBeInstalled = [];
      }
    },
    use(plugin) {
      if (!this._a && !isVue2) {
        toBeInstalled.push(plugin);
      } else {
        _p.push(plugin);
      }
      return this;
    },
    _p,
    _a: null,
    _e: scope,
    _s: new Map(),
    state
  });
  return pinia;
}
const noop$1 = () => {
};
function addSubscription(subscriptions, callback, detached, onCleanup = noop$1) {
  subscriptions.push(callback);
  const removeSubscription = () => {
    const idx = subscriptions.indexOf(callback);
    if (idx > -1) {
      subscriptions.splice(idx, 1);
      onCleanup();
    }
  };
  if (!detached && getCurrentInstance()) {
    onUnmounted(removeSubscription);
  }
  return removeSubscription;
}
function triggerSubscriptions(subscriptions, ...args) {
  subscriptions.forEach((callback) => {
    callback(...args);
  });
}
function mergeReactiveObjects(target, patchToApply) {
  for (const key in patchToApply) {
    const subPatch = patchToApply[key];
    const targetValue = target[key];
    if (isPlainObject$2(targetValue) && isPlainObject$2(subPatch) && !isRef(subPatch) && !isReactive(subPatch)) {
      target[key] = mergeReactiveObjects(targetValue, subPatch);
    } else {
      target[key] = subPatch;
    }
  }
  return target;
}
const skipHydrateSymbol = Symbol();
function shouldHydrate(obj) {
  return !isPlainObject$2(obj) || !obj.hasOwnProperty(skipHydrateSymbol);
}
const { assign: assign$1 } = Object;
function isComputed(o) {
  return !!(isRef(o) && o.effect);
}
function createOptionsStore(id, options, pinia, hot) {
  const { state, actions, getters } = options;
  const initialState = pinia.state.value[id];
  let store;
  function setup() {
    if (!initialState && true) {
      {
        pinia.state.value[id] = state ? state() : {};
      }
    }
    const localState = toRefs(pinia.state.value[id]);
    return assign$1(localState, actions, Object.keys(getters || {}).reduce((computedGetters, name) => {
      computedGetters[name] = markRaw(computed(() => {
        setActivePinia(pinia);
        const store2 = pinia._s.get(id);
        return getters[name].call(store2, store2);
      }));
      return computedGetters;
    }, {}));
  }
  store = createSetupStore(id, setup, options, pinia);
  store.$reset = function $reset() {
    const newState = state ? state() : {};
    this.$patch(($state) => {
      assign$1($state, newState);
    });
  };
  return store;
}
function createSetupStore($id, setup, options = {}, pinia, hot) {
  let scope;
  const buildState2 = options.state;
  const optionsForPlugin = assign$1({ actions: {} }, options);
  const $subscribeOptions = {
    deep: true
  };
  let isListening;
  let isSyncListening;
  let subscriptions = markRaw([]);
  let actionSubscriptions = markRaw([]);
  let debuggerEvents;
  const initialState = pinia.state.value[$id];
  if (!buildState2 && !initialState && true) {
    {
      pinia.state.value[$id] = {};
    }
  }
  ref({});
  function $patch(partialStateOrMutator) {
    let subscriptionMutation;
    isListening = isSyncListening = false;
    if (typeof partialStateOrMutator === "function") {
      partialStateOrMutator(pinia.state.value[$id]);
      subscriptionMutation = {
        type: MutationType.patchFunction,
        storeId: $id,
        events: debuggerEvents
      };
    } else {
      mergeReactiveObjects(pinia.state.value[$id], partialStateOrMutator);
      subscriptionMutation = {
        type: MutationType.patchObject,
        payload: partialStateOrMutator,
        storeId: $id,
        events: debuggerEvents
      };
    }
    nextTick().then(() => {
      isListening = true;
    });
    isSyncListening = true;
    triggerSubscriptions(subscriptions, subscriptionMutation, pinia.state.value[$id]);
  }
  const $reset = noop$1;
  function $dispose() {
    scope.stop();
    subscriptions = [];
    actionSubscriptions = [];
    pinia._s.delete($id);
  }
  function wrapAction(name, action) {
    return function() {
      setActivePinia(pinia);
      const args = Array.from(arguments);
      const afterCallbackList = [];
      const onErrorCallbackList = [];
      function after(callback) {
        afterCallbackList.push(callback);
      }
      function onError(callback) {
        onErrorCallbackList.push(callback);
      }
      triggerSubscriptions(actionSubscriptions, {
        args,
        name,
        store,
        after,
        onError
      });
      let ret;
      try {
        ret = action.apply(this && this.$id === $id ? this : store, args);
      } catch (error) {
        triggerSubscriptions(onErrorCallbackList, error);
        throw error;
      }
      if (ret instanceof Promise) {
        return ret.then((value) => {
          triggerSubscriptions(afterCallbackList, value);
          return value;
        }).catch((error) => {
          triggerSubscriptions(onErrorCallbackList, error);
          return Promise.reject(error);
        });
      }
      triggerSubscriptions(afterCallbackList, ret);
      return ret;
    };
  }
  const partialStore = {
    _p: pinia,
    $id,
    $onAction: addSubscription.bind(null, actionSubscriptions),
    $patch,
    $reset,
    $subscribe(callback, options2 = {}) {
      const removeSubscription = addSubscription(subscriptions, callback, options2.detached, () => stopWatcher());
      const stopWatcher = scope.run(() => watch(() => pinia.state.value[$id], (state) => {
        if (options2.flush === "sync" ? isSyncListening : isListening) {
          callback({
            storeId: $id,
            type: MutationType.direct,
            events: debuggerEvents
          }, state);
        }
      }, assign$1({}, $subscribeOptions, options2)));
      return removeSubscription;
    },
    $dispose
  };
  const store = reactive(assign$1({}, partialStore));
  pinia._s.set($id, store);
  const setupStore = pinia._e.run(() => {
    scope = effectScope();
    return scope.run(() => setup());
  });
  for (const key in setupStore) {
    const prop = setupStore[key];
    if (isRef(prop) && !isComputed(prop) || isReactive(prop)) {
      if (!buildState2) {
        if (initialState && shouldHydrate(prop)) {
          if (isRef(prop)) {
            prop.value = initialState[key];
          } else {
            mergeReactiveObjects(prop, initialState[key]);
          }
        }
        {
          pinia.state.value[$id][key] = prop;
        }
      }
    } else if (typeof prop === "function") {
      const actionValue = wrapAction(key, prop);
      {
        setupStore[key] = actionValue;
      }
      optionsForPlugin.actions[key] = prop;
    } else
      ;
  }
  {
    assign$1(store, setupStore);
    assign$1(toRaw(store), setupStore);
  }
  Object.defineProperty(store, "$state", {
    get: () => pinia.state.value[$id],
    set: (state) => {
      $patch(($state) => {
        assign$1($state, state);
      });
    }
  });
  pinia._p.forEach((extender) => {
    {
      assign$1(store, scope.run(() => extender({
        store,
        app: pinia._a,
        pinia,
        options: optionsForPlugin
      })));
    }
  });
  if (initialState && buildState2 && options.hydrate) {
    options.hydrate(store.$state, initialState);
  }
  isListening = true;
  isSyncListening = true;
  return store;
}
function defineStore(idOrOptions, setup, setupOptions) {
  let id;
  let options;
  const isSetupStore = typeof setup === "function";
  if (typeof idOrOptions === "string") {
    id = idOrOptions;
    options = isSetupStore ? setupOptions : setup;
  } else {
    options = idOrOptions;
    id = idOrOptions.id;
  }
  function useStore(pinia, hot) {
    const currentInstance2 = getCurrentInstance();
    pinia = pinia || currentInstance2 && inject(piniaSymbol);
    if (pinia)
      setActivePinia(pinia);
    pinia = activePinia;
    if (!pinia._s.has(id)) {
      if (isSetupStore) {
        createSetupStore(id, setup, options, pinia);
      } else {
        createOptionsStore(id, options, pinia);
      }
    }
    const store = pinia._s.get(id);
    return store;
  }
  useStore.$id = id;
  return useStore;
}
function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
const isClient = typeof window !== "undefined";
const isString$2 = (val) => typeof val === "string";
const noop = () => {
};
function createFilterWrapper(filter, fn) {
  function wrapper(...args) {
    filter(() => fn.apply(this, args), { fn, thisArg: this, args });
  }
  return wrapper;
}
const bypassFilter = (invoke) => {
  return invoke();
};
var __getOwnPropSymbols$8 = Object.getOwnPropertySymbols;
var __hasOwnProp$8 = Object.prototype.hasOwnProperty;
var __propIsEnum$8 = Object.prototype.propertyIsEnumerable;
var __objRest$5 = (source2, exclude) => {
  var target = {};
  for (var prop in source2)
    if (__hasOwnProp$8.call(source2, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source2[prop];
  if (source2 != null && __getOwnPropSymbols$8)
    for (var prop of __getOwnPropSymbols$8(source2)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$8.call(source2, prop))
        target[prop] = source2[prop];
    }
  return target;
};
function watchWithFilter(source2, cb, options = {}) {
  const _a = options, {
    eventFilter = bypassFilter
  } = _a, watchOptions = __objRest$5(_a, [
    "eventFilter"
  ]);
  return watch(source2, createFilterWrapper(eventFilter, cb), watchOptions);
}
function unrefElement(elRef) {
  var _a;
  const plain = unref(elRef);
  return (_a = plain == null ? void 0 : plain.$el) != null ? _a : plain;
}
const defaultWindow = isClient ? window : void 0;
isClient ? window.document : void 0;
isClient ? window.navigator : void 0;
function useEventListener(...args) {
  let target;
  let event;
  let listener;
  let options;
  if (isString$2(args[0])) {
    [event, listener, options] = args;
    target = defaultWindow;
  } else {
    [target, event, listener, options] = args;
  }
  if (!target)
    return noop;
  let cleanup = noop;
  const stopWatch = watch(() => unref(target), (el) => {
    cleanup();
    if (!el)
      return;
    el.addEventListener(event, listener, options);
    cleanup = () => {
      el.removeEventListener(event, listener, options);
      cleanup = noop;
    };
  }, { immediate: true, flush: "post" });
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return stop;
}
function onClickOutside(target, handler, options = {}) {
  const { window: window2 = defaultWindow, event = "pointerdown" } = options;
  if (!window2)
    return;
  const listener = (event2) => {
    const el = unrefElement(target);
    if (!el)
      return;
    if (el === event2.target || event2.composedPath().includes(el))
      return;
    handler(event2);
  };
  return useEventListener(window2, event, listener, { passive: true });
}
function useMediaQuery(query, options = {}) {
  const { window: window2 = defaultWindow } = options;
  if (!window2)
    return ref(false);
  const mediaQuery = window2.matchMedia(query);
  const matches = ref(mediaQuery.matches);
  const handler = (event) => {
    matches.value = event.matches;
  };
  if ("addEventListener" in mediaQuery)
    mediaQuery.addEventListener("change", handler);
  else
    mediaQuery.addListener(handler);
  tryOnScopeDispose(() => {
    if ("removeEventListener" in mediaQuery)
      mediaQuery.removeEventListener("change", handler);
    else
      mediaQuery.removeListener(handler);
  });
  return matches;
}
const StorageSerializers = {
  boolean: {
    read: (v) => v === "true",
    write: (v) => String(v)
  },
  object: {
    read: (v) => JSON.parse(v),
    write: (v) => JSON.stringify(v)
  },
  number: {
    read: (v) => Number.parseFloat(v),
    write: (v) => String(v)
  },
  any: {
    read: (v) => v,
    write: (v) => String(v)
  },
  string: {
    read: (v) => v,
    write: (v) => String(v)
  }
};
function useStorage(key, initialValue, storage = ((_a) => (_a = defaultWindow) == null ? void 0 : _a.localStorage)(), options = {}) {
  var _a2;
  const {
    flush = "pre",
    deep = true,
    listenToStorageChanges = true,
    window: window2 = defaultWindow,
    eventFilter,
    onError = (e) => {
      console.error(e);
    }
  } = options;
  const rawInit = unref(initialValue);
  const type = rawInit == null ? "any" : typeof rawInit === "boolean" ? "boolean" : typeof rawInit === "string" ? "string" : typeof rawInit === "object" ? "object" : Array.isArray(rawInit) ? "object" : !Number.isNaN(rawInit) ? "number" : "any";
  const data2 = ref(initialValue);
  const serializer = (_a2 = options.serializer) != null ? _a2 : StorageSerializers[type];
  function read(event) {
    if (!storage || event && event.key !== key)
      return;
    try {
      const rawValue = event ? event.newValue : storage.getItem(key);
      if (rawValue == null) {
        data2.value = rawInit;
        if (rawInit !== null)
          storage.setItem(key, serializer.write(rawInit));
      } else {
        data2.value = serializer.read(rawValue);
      }
    } catch (e) {
      onError(e);
    }
  }
  read();
  if (window2 && listenToStorageChanges)
    useEventListener(window2, "storage", read);
  if (storage) {
    watchWithFilter(data2, () => {
      try {
        if (data2.value == null)
          storage.removeItem(key);
        else
          storage.setItem(key, serializer.write(data2.value));
      } catch (e) {
        onError(e);
      }
    }, {
      flush,
      deep,
      eventFilter
    });
  }
  return data2;
}
function usePreferredDark(options) {
  return useMediaQuery("(prefers-color-scheme: dark)", options);
}
var SwipeDirection;
(function(SwipeDirection2) {
  SwipeDirection2["UP"] = "UP";
  SwipeDirection2["RIGHT"] = "RIGHT";
  SwipeDirection2["DOWN"] = "DOWN";
  SwipeDirection2["LEFT"] = "LEFT";
  SwipeDirection2["NONE"] = "NONE";
})(SwipeDirection || (SwipeDirection = {}));
function useWindowScroll({ window: window2 = defaultWindow } = {}) {
  if (!window2) {
    return {
      x: ref(0),
      y: ref(0)
    };
  }
  const x = ref(window2.pageXOffset);
  const y = ref(window2.pageYOffset);
  useEventListener("scroll", () => {
    x.value = window2.pageXOffset;
    y.value = window2.pageYOffset;
  }, {
    capture: false,
    passive: true
  });
  return { x, y };
}
/*!
  * shared v9.2.0-beta.11
  * (c) 2021 kazuya kawaguchi
  * Released under the MIT License.
  */
const hasSymbol = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const makeSymbol = (name) => hasSymbol ? Symbol(name) : name;
const generateFormatCacheKey = (locale, key, source2) => friendlyJSONstringify({ l: locale, k: key, s: source2 });
const friendlyJSONstringify = (json) => JSON.stringify(json).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029").replace(/\u0027/g, "\\u0027");
const isNumber$1 = (val) => typeof val === "number" && isFinite(val);
const isDate$1 = (val) => toTypeString(val) === "[object Date]";
const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
const isEmptyObject = (val) => isPlainObject$1(val) && Object.keys(val).length === 0;
function warn(msg, err) {
  if (typeof console !== "undefined") {
    console.warn(`[intlify] ` + msg);
    if (err) {
      console.warn(err.stack);
    }
  }
}
const assign = Object.assign;
let _globalThis;
const getGlobalThis = () => {
  return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
function escapeHtml(rawText) {
  return rawText.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
}
const hasOwnProperty = Object.prototype.hasOwnProperty;
function hasOwn(obj, key) {
  return hasOwnProperty.call(obj, key);
}
const isArray$1 = Array.isArray;
const isFunction$1 = (val) => typeof val === "function";
const isString$1 = (val) => typeof val === "string";
const isBoolean = (val) => typeof val === "boolean";
const isObject$1 = (val) => val !== null && typeof val === "object";
const objectToString = Object.prototype.toString;
const toTypeString = (value) => objectToString.call(value);
const isPlainObject$1 = (val) => toTypeString(val) === "[object Object]";
const toDisplayString = (val) => {
  return val == null ? "" : isArray$1(val) || isPlainObject$1(val) && val.toString === objectToString ? JSON.stringify(val, null, 2) : String(val);
};
/*!
  * message-compiler v9.2.0-beta.11
  * (c) 2021 kazuya kawaguchi
  * Released under the MIT License.
  */
const CompileErrorCodes = {
  EXPECTED_TOKEN: 1,
  INVALID_TOKEN_IN_PLACEHOLDER: 2,
  UNTERMINATED_SINGLE_QUOTE_IN_PLACEHOLDER: 3,
  UNKNOWN_ESCAPE_SEQUENCE: 4,
  INVALID_UNICODE_ESCAPE_SEQUENCE: 5,
  UNBALANCED_CLOSING_BRACE: 6,
  UNTERMINATED_CLOSING_BRACE: 7,
  EMPTY_PLACEHOLDER: 8,
  NOT_ALLOW_NEST_PLACEHOLDER: 9,
  INVALID_LINKED_FORMAT: 10,
  MUST_HAVE_MESSAGES_IN_PLURAL: 11,
  UNEXPECTED_EMPTY_LINKED_MODIFIER: 12,
  UNEXPECTED_EMPTY_LINKED_KEY: 13,
  UNEXPECTED_LEXICAL_ANALYSIS: 14,
  __EXTEND_POINT__: 15
};
function createCompileError(code2, loc, options = {}) {
  const { domain, messages, args } = options;
  const msg = code2;
  const error = new SyntaxError(String(msg));
  error.code = code2;
  if (loc) {
    error.location = loc;
  }
  error.domain = domain;
  return error;
}
/*!
  * devtools-if v9.2.0-beta.11
  * (c) 2021 kazuya kawaguchi
  * Released under the MIT License.
  */
const IntlifyDevToolsHooks = {
  I18nInit: "i18n:init",
  FunctionTranslate: "function:translate"
};
/*!
  * core-base v9.2.0-beta.11
  * (c) 2021 kazuya kawaguchi
  * Released under the MIT License.
  */
const pathStateMachine = [];
pathStateMachine[0] = {
  ["w"]: [0],
  ["i"]: [3, 0],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[1] = {
  ["w"]: [1],
  ["."]: [2],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[2] = {
  ["w"]: [2],
  ["i"]: [3, 0],
  ["0"]: [3, 0]
};
pathStateMachine[3] = {
  ["i"]: [3, 0],
  ["0"]: [3, 0],
  ["w"]: [1, 1],
  ["."]: [2, 1],
  ["["]: [4, 1],
  ["o"]: [7, 1]
};
pathStateMachine[4] = {
  ["'"]: [5, 0],
  ['"']: [6, 0],
  ["["]: [
    4,
    2
  ],
  ["]"]: [1, 3],
  ["o"]: 8,
  ["l"]: [4, 0]
};
pathStateMachine[5] = {
  ["'"]: [4, 0],
  ["o"]: 8,
  ["l"]: [5, 0]
};
pathStateMachine[6] = {
  ['"']: [4, 0],
  ["o"]: 8,
  ["l"]: [6, 0]
};
const literalValueRE = /^\s?(?:true|false|-?[\d.]+|'[^']*'|"[^"]*")\s?$/;
function isLiteral(exp) {
  return literalValueRE.test(exp);
}
function stripQuotes(str) {
  const a = str.charCodeAt(0);
  const b = str.charCodeAt(str.length - 1);
  return a === b && (a === 34 || a === 39) ? str.slice(1, -1) : str;
}
function getPathCharType(ch) {
  if (ch === void 0 || ch === null) {
    return "o";
  }
  const code2 = ch.charCodeAt(0);
  switch (code2) {
    case 91:
    case 93:
    case 46:
    case 34:
    case 39:
      return ch;
    case 95:
    case 36:
    case 45:
      return "i";
    case 9:
    case 10:
    case 13:
    case 160:
    case 65279:
    case 8232:
    case 8233:
      return "w";
  }
  return "i";
}
function formatSubPath(path) {
  const trimmed = path.trim();
  if (path.charAt(0) === "0" && isNaN(parseInt(path))) {
    return false;
  }
  return isLiteral(trimmed) ? stripQuotes(trimmed) : "*" + trimmed;
}
function parse(path) {
  const keys = [];
  let index = -1;
  let mode = 0;
  let subPathDepth = 0;
  let c;
  let key;
  let newChar;
  let type;
  let transition;
  let action;
  let typeMap;
  const actions = [];
  actions[0] = () => {
    if (key === void 0) {
      key = newChar;
    } else {
      key += newChar;
    }
  };
  actions[1] = () => {
    if (key !== void 0) {
      keys.push(key);
      key = void 0;
    }
  };
  actions[2] = () => {
    actions[0]();
    subPathDepth++;
  };
  actions[3] = () => {
    if (subPathDepth > 0) {
      subPathDepth--;
      mode = 4;
      actions[0]();
    } else {
      subPathDepth = 0;
      if (key === void 0) {
        return false;
      }
      key = formatSubPath(key);
      if (key === false) {
        return false;
      } else {
        actions[1]();
      }
    }
  };
  function maybeUnescapeQuote() {
    const nextChar = path[index + 1];
    if (mode === 5 && nextChar === "'" || mode === 6 && nextChar === '"') {
      index++;
      newChar = "\\" + nextChar;
      actions[0]();
      return true;
    }
  }
  while (mode !== null) {
    index++;
    c = path[index];
    if (c === "\\" && maybeUnescapeQuote()) {
      continue;
    }
    type = getPathCharType(c);
    typeMap = pathStateMachine[mode];
    transition = typeMap[type] || typeMap["l"] || 8;
    if (transition === 8) {
      return;
    }
    mode = transition[0];
    if (transition[1] !== void 0) {
      action = actions[transition[1]];
      if (action) {
        newChar = c;
        if (action() === false) {
          return;
        }
      }
    }
    if (mode === 7) {
      return keys;
    }
  }
}
const cache = new Map();
function resolveWithKeyValue(obj, path) {
  return isObject$1(obj) ? obj[path] : null;
}
function resolveValue(obj, path) {
  if (!isObject$1(obj)) {
    return null;
  }
  let hit = cache.get(path);
  if (!hit) {
    hit = parse(path);
    if (hit) {
      cache.set(path, hit);
    }
  }
  if (!hit) {
    return null;
  }
  const len = hit.length;
  let last = obj;
  let i = 0;
  while (i < len) {
    const val = last[hit[i]];
    if (val === void 0) {
      return null;
    }
    last = val;
    i++;
  }
  return last;
}
const DEFAULT_MODIFIER = (str) => str;
const DEFAULT_MESSAGE = (ctx) => "";
const DEFAULT_MESSAGE_DATA_TYPE = "text";
const DEFAULT_NORMALIZE = (values) => values.length === 0 ? "" : values.join("");
const DEFAULT_INTERPOLATE = toDisplayString;
function pluralDefault(choice, choicesLength) {
  choice = Math.abs(choice);
  if (choicesLength === 2) {
    return choice ? choice > 1 ? 1 : 0 : 1;
  }
  return choice ? Math.min(choice, 2) : 0;
}
function getPluralIndex(options) {
  const index = isNumber$1(options.pluralIndex) ? options.pluralIndex : -1;
  return options.named && (isNumber$1(options.named.count) || isNumber$1(options.named.n)) ? isNumber$1(options.named.count) ? options.named.count : isNumber$1(options.named.n) ? options.named.n : index : index;
}
function normalizeNamed(pluralIndex, props) {
  if (!props.count) {
    props.count = pluralIndex;
  }
  if (!props.n) {
    props.n = pluralIndex;
  }
}
function createMessageContext(options = {}) {
  const locale = options.locale;
  const pluralIndex = getPluralIndex(options);
  const pluralRule = isObject$1(options.pluralRules) && isString$1(locale) && isFunction$1(options.pluralRules[locale]) ? options.pluralRules[locale] : pluralDefault;
  const orgPluralRule = isObject$1(options.pluralRules) && isString$1(locale) && isFunction$1(options.pluralRules[locale]) ? pluralDefault : void 0;
  const plural = (messages) => messages[pluralRule(pluralIndex, messages.length, orgPluralRule)];
  const _list = options.list || [];
  const list = (index) => _list[index];
  const _named = options.named || {};
  isNumber$1(options.pluralIndex) && normalizeNamed(pluralIndex, _named);
  const named = (key) => _named[key];
  function message(key) {
    const msg = isFunction$1(options.messages) ? options.messages(key) : isObject$1(options.messages) ? options.messages[key] : false;
    return !msg ? options.parent ? options.parent.message(key) : DEFAULT_MESSAGE : msg;
  }
  const _modifier = (name) => options.modifiers ? options.modifiers[name] : DEFAULT_MODIFIER;
  const normalize = isPlainObject$1(options.processor) && isFunction$1(options.processor.normalize) ? options.processor.normalize : DEFAULT_NORMALIZE;
  const interpolate = isPlainObject$1(options.processor) && isFunction$1(options.processor.interpolate) ? options.processor.interpolate : DEFAULT_INTERPOLATE;
  const type = isPlainObject$1(options.processor) && isString$1(options.processor.type) ? options.processor.type : DEFAULT_MESSAGE_DATA_TYPE;
  const ctx = {
    ["list"]: list,
    ["named"]: named,
    ["plural"]: plural,
    ["linked"]: (key, modifier) => {
      const msg = message(key)(ctx);
      return isString$1(modifier) ? _modifier(modifier)(msg) : msg;
    },
    ["message"]: message,
    ["type"]: type,
    ["interpolate"]: interpolate,
    ["normalize"]: normalize
  };
  return ctx;
}
let devtools = null;
function setDevToolsHook(hook) {
  devtools = hook;
}
function initI18nDevTools(i18n, version2, meta) {
  devtools && devtools.emit(IntlifyDevToolsHooks.I18nInit, {
    timestamp: Date.now(),
    i18n,
    version: version2,
    meta
  });
}
const translateDevTools = /* @__PURE__ */ createDevToolsHook(IntlifyDevToolsHooks.FunctionTranslate);
function createDevToolsHook(hook) {
  return (payloads) => devtools && devtools.emit(hook, payloads);
}
const CoreWarnCodes = {
  NOT_FOUND_KEY: 1,
  FALLBACK_TO_TRANSLATE: 2,
  CANNOT_FORMAT_NUMBER: 3,
  FALLBACK_TO_NUMBER_FORMAT: 4,
  CANNOT_FORMAT_DATE: 5,
  FALLBACK_TO_DATE_FORMAT: 6,
  __EXTEND_POINT__: 7
};
function fallbackWithSimple(ctx, fallback, start) {
  return [...new Set([
    start,
    ...isArray$1(fallback) ? fallback : isObject$1(fallback) ? Object.keys(fallback) : isString$1(fallback) ? [fallback] : [start]
  ])];
}
function fallbackWithLocaleChain(ctx, fallback, start) {
  const startLocale = isString$1(start) ? start : DEFAULT_LOCALE;
  const context = ctx;
  if (!context.__localeChainCache) {
    context.__localeChainCache = new Map();
  }
  let chain = context.__localeChainCache.get(startLocale);
  if (!chain) {
    chain = [];
    let block = [start];
    while (isArray$1(block)) {
      block = appendBlockToChain(chain, block, fallback);
    }
    const defaults2 = isArray$1(fallback) || !isPlainObject$1(fallback) ? fallback : fallback["default"] ? fallback["default"] : null;
    block = isString$1(defaults2) ? [defaults2] : defaults2;
    if (isArray$1(block)) {
      appendBlockToChain(chain, block, false);
    }
    context.__localeChainCache.set(startLocale, chain);
  }
  return chain;
}
function appendBlockToChain(chain, block, blocks) {
  let follow = true;
  for (let i = 0; i < block.length && isBoolean(follow); i++) {
    const locale = block[i];
    if (isString$1(locale)) {
      follow = appendLocaleToChain(chain, block[i], blocks);
    }
  }
  return follow;
}
function appendLocaleToChain(chain, locale, blocks) {
  let follow;
  const tokens = locale.split("-");
  do {
    const target = tokens.join("-");
    follow = appendItemToChain(chain, target, blocks);
    tokens.splice(-1, 1);
  } while (tokens.length && follow === true);
  return follow;
}
function appendItemToChain(chain, target, blocks) {
  let follow = false;
  if (!chain.includes(target)) {
    follow = true;
    if (target) {
      follow = target[target.length - 1] !== "!";
      const locale = target.replace(/!/g, "");
      chain.push(locale);
      if ((isArray$1(blocks) || isPlainObject$1(blocks)) && blocks[locale]) {
        follow = blocks[locale];
      }
    }
  }
  return follow;
}
const VERSION$2 = "9.2.0-beta.11";
const NOT_REOSLVED = -1;
const DEFAULT_LOCALE = "en-US";
const MISSING_RESOLVE_VALUE = "";
function getDefaultLinkedModifiers() {
  return {
    upper: (val) => isString$1(val) ? val.toUpperCase() : val,
    lower: (val) => isString$1(val) ? val.toLowerCase() : val,
    capitalize: (val) => isString$1(val) ? `${val.charAt(0).toLocaleUpperCase()}${val.substr(1)}` : val
  };
}
let _compiler;
let _resolver;
function registerMessageResolver(resolver) {
  _resolver = resolver;
}
let _fallbacker;
function registerLocaleFallbacker(fallbacker) {
  _fallbacker = fallbacker;
}
let _additionalMeta = null;
const setAdditionalMeta = (meta) => {
  _additionalMeta = meta;
};
const getAdditionalMeta = () => _additionalMeta;
let _cid = 0;
function createCoreContext(options = {}) {
  const version2 = isString$1(options.version) ? options.version : VERSION$2;
  const locale = isString$1(options.locale) ? options.locale : DEFAULT_LOCALE;
  const fallbackLocale = isArray$1(options.fallbackLocale) || isPlainObject$1(options.fallbackLocale) || isString$1(options.fallbackLocale) || options.fallbackLocale === false ? options.fallbackLocale : locale;
  const messages = isPlainObject$1(options.messages) ? options.messages : { [locale]: {} };
  const datetimeFormats = isPlainObject$1(options.datetimeFormats) ? options.datetimeFormats : { [locale]: {} };
  const numberFormats = isPlainObject$1(options.numberFormats) ? options.numberFormats : { [locale]: {} };
  const modifiers = assign({}, options.modifiers || {}, getDefaultLinkedModifiers());
  const pluralRules = options.pluralRules || {};
  const missing = isFunction$1(options.missing) ? options.missing : null;
  const missingWarn = isBoolean(options.missingWarn) || isRegExp(options.missingWarn) ? options.missingWarn : true;
  const fallbackWarn = isBoolean(options.fallbackWarn) || isRegExp(options.fallbackWarn) ? options.fallbackWarn : true;
  const fallbackFormat = !!options.fallbackFormat;
  const unresolving = !!options.unresolving;
  const postTranslation = isFunction$1(options.postTranslation) ? options.postTranslation : null;
  const processor = isPlainObject$1(options.processor) ? options.processor : null;
  const warnHtmlMessage = isBoolean(options.warnHtmlMessage) ? options.warnHtmlMessage : true;
  const escapeParameter = !!options.escapeParameter;
  const messageCompiler = isFunction$1(options.messageCompiler) ? options.messageCompiler : _compiler;
  const messageResolver = isFunction$1(options.messageResolver) ? options.messageResolver : _resolver || resolveWithKeyValue;
  const localeFallbacker = isFunction$1(options.localeFallbacker) ? options.localeFallbacker : _fallbacker || fallbackWithSimple;
  const onWarn = isFunction$1(options.onWarn) ? options.onWarn : warn;
  const internalOptions = options;
  const __datetimeFormatters = isObject$1(internalOptions.__datetimeFormatters) ? internalOptions.__datetimeFormatters : new Map();
  const __numberFormatters = isObject$1(internalOptions.__numberFormatters) ? internalOptions.__numberFormatters : new Map();
  const __meta = isObject$1(internalOptions.__meta) ? internalOptions.__meta : {};
  _cid++;
  const context = {
    version: version2,
    cid: _cid,
    locale,
    fallbackLocale,
    messages,
    modifiers,
    pluralRules,
    missing,
    missingWarn,
    fallbackWarn,
    fallbackFormat,
    unresolving,
    postTranslation,
    processor,
    warnHtmlMessage,
    escapeParameter,
    messageCompiler,
    messageResolver,
    localeFallbacker,
    onWarn,
    __meta
  };
  {
    context.datetimeFormats = datetimeFormats;
    context.numberFormats = numberFormats;
    context.__datetimeFormatters = __datetimeFormatters;
    context.__numberFormatters = __numberFormatters;
  }
  if (__INTLIFY_PROD_DEVTOOLS__) {
    initI18nDevTools(context, version2, __meta);
  }
  return context;
}
function handleMissing(context, key, locale, missingWarn, type) {
  const { missing, onWarn } = context;
  if (missing !== null) {
    const ret = missing(context, locale, key, type);
    return isString$1(ret) ? ret : key;
  } else {
    return key;
  }
}
function updateFallbackLocale(ctx, locale, fallback) {
  const context = ctx;
  context.__localeChainCache = new Map();
  ctx.localeFallbacker(ctx, fallback, locale);
}
let code$1 = CompileErrorCodes.__EXTEND_POINT__;
const inc$1 = () => code$1++;
const CoreErrorCodes = {
  INVALID_ARGUMENT: code$1,
  INVALID_DATE_ARGUMENT: inc$1(),
  INVALID_ISO_DATE_ARGUMENT: inc$1(),
  __EXTEND_POINT__: inc$1()
};
function createCoreError(code2) {
  return createCompileError(code2, null, void 0);
}
const NOOP_MESSAGE_FUNCTION = () => "";
const isMessageFunction = (val) => isFunction$1(val);
function translate(context, ...args) {
  const { fallbackFormat, postTranslation, unresolving, fallbackLocale, messages } = context;
  const [key, options] = parseTranslateArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  const fallbackWarn = isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const escapeParameter = isBoolean(options.escapeParameter) ? options.escapeParameter : context.escapeParameter;
  const resolvedMessage = !!options.resolvedMessage;
  const defaultMsgOrKey = isString$1(options.default) || isBoolean(options.default) ? !isBoolean(options.default) ? options.default : key : fallbackFormat ? key : "";
  const enableDefaultMsg = fallbackFormat || defaultMsgOrKey !== "";
  const locale = isString$1(options.locale) ? options.locale : context.locale;
  escapeParameter && escapeParams(options);
  let [format, targetLocale, message] = !resolvedMessage ? resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) : [
    key,
    locale,
    messages[locale] || {}
  ];
  let cacheBaseKey = key;
  if (!resolvedMessage && !(isString$1(format) || isMessageFunction(format))) {
    if (enableDefaultMsg) {
      format = defaultMsgOrKey;
      cacheBaseKey = format;
    }
  }
  if (!resolvedMessage && (!(isString$1(format) || isMessageFunction(format)) || !isString$1(targetLocale))) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let occurred = false;
  const errorDetector = () => {
    occurred = true;
  };
  const msg = !isMessageFunction(format) ? compileMessageFormat(context, key, targetLocale, format, cacheBaseKey, errorDetector) : format;
  if (occurred) {
    return format;
  }
  const ctxOptions = getMessageContextOptions(context, targetLocale, message, options);
  const msgContext = createMessageContext(ctxOptions);
  const messaged = evaluateMessage(context, msg, msgContext);
  const ret = postTranslation ? postTranslation(messaged) : messaged;
  if (__INTLIFY_PROD_DEVTOOLS__) {
    const payloads = {
      timestamp: Date.now(),
      key: isString$1(key) ? key : isMessageFunction(format) ? format.key : "",
      locale: targetLocale || (isMessageFunction(format) ? format.locale : ""),
      format: isString$1(format) ? format : isMessageFunction(format) ? format.source : "",
      message: ret
    };
    payloads.meta = assign({}, context.__meta, getAdditionalMeta() || {});
    translateDevTools(payloads);
  }
  return ret;
}
function escapeParams(options) {
  if (isArray$1(options.list)) {
    options.list = options.list.map((item) => isString$1(item) ? escapeHtml(item) : item);
  } else if (isObject$1(options.named)) {
    Object.keys(options.named).forEach((key) => {
      if (isString$1(options.named[key])) {
        options.named[key] = escapeHtml(options.named[key]);
      }
    });
  }
}
function resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) {
  const { messages, onWarn, messageResolver: resolveValue2, localeFallbacker } = context;
  const locales = localeFallbacker(context, fallbackLocale, locale);
  let message = {};
  let targetLocale;
  let format = null;
  const type = "translate";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    message = messages[targetLocale] || {};
    if ((format = resolveValue2(message, key)) === null) {
      format = message[key];
    }
    if (isString$1(format) || isFunction$1(format))
      break;
    const missingRet = handleMissing(context, key, targetLocale, missingWarn, type);
    if (missingRet !== key) {
      format = missingRet;
    }
  }
  return [format, targetLocale, message];
}
function compileMessageFormat(context, key, targetLocale, format, cacheBaseKey, errorDetector) {
  const { messageCompiler, warnHtmlMessage } = context;
  if (isMessageFunction(format)) {
    const msg2 = format;
    msg2.locale = msg2.locale || targetLocale;
    msg2.key = msg2.key || key;
    return msg2;
  }
  const msg = messageCompiler(format, getCompileOptions(context, targetLocale, cacheBaseKey, format, warnHtmlMessage, errorDetector));
  msg.locale = targetLocale;
  msg.key = key;
  msg.source = format;
  return msg;
}
function evaluateMessage(context, msg, msgCtx) {
  const messaged = msg(msgCtx);
  return messaged;
}
function parseTranslateArgs(...args) {
  const [arg1, arg2, arg3] = args;
  const options = {};
  if (!isString$1(arg1) && !isNumber$1(arg1) && !isMessageFunction(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const key = isNumber$1(arg1) ? String(arg1) : isMessageFunction(arg1) ? arg1 : arg1;
  if (isNumber$1(arg2)) {
    options.plural = arg2;
  } else if (isString$1(arg2)) {
    options.default = arg2;
  } else if (isPlainObject$1(arg2) && !isEmptyObject(arg2)) {
    options.named = arg2;
  } else if (isArray$1(arg2)) {
    options.list = arg2;
  }
  if (isNumber$1(arg3)) {
    options.plural = arg3;
  } else if (isString$1(arg3)) {
    options.default = arg3;
  } else if (isPlainObject$1(arg3)) {
    assign(options, arg3);
  }
  return [key, options];
}
function getCompileOptions(context, locale, key, source2, warnHtmlMessage, errorDetector) {
  return {
    warnHtmlMessage,
    onError: (err) => {
      errorDetector && errorDetector(err);
      {
        throw err;
      }
    },
    onCacheKey: (source3) => generateFormatCacheKey(locale, key, source3)
  };
}
function getMessageContextOptions(context, locale, message, options) {
  const { modifiers, pluralRules, messageResolver: resolveValue2 } = context;
  const resolveMessage = (key) => {
    const val = resolveValue2(message, key);
    if (isString$1(val)) {
      let occurred = false;
      const errorDetector = () => {
        occurred = true;
      };
      const msg = compileMessageFormat(context, key, locale, val, key, errorDetector);
      return !occurred ? msg : NOOP_MESSAGE_FUNCTION;
    } else if (isMessageFunction(val)) {
      return val;
    } else {
      return NOOP_MESSAGE_FUNCTION;
    }
  };
  const ctxOptions = {
    locale,
    modifiers,
    pluralRules,
    messages: resolveMessage
  };
  if (context.processor) {
    ctxOptions.processor = context.processor;
  }
  if (options.list) {
    ctxOptions.list = options.list;
  }
  if (options.named) {
    ctxOptions.named = options.named;
  }
  if (isNumber$1(options.plural)) {
    ctxOptions.pluralIndex = options.plural;
  }
  return ctxOptions;
}
function datetime(context, ...args) {
  const { datetimeFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __datetimeFormatters } = context;
  const [key, value, options, overrides] = parseDateTimeArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const part = !!options.part;
  const locale = isString$1(options.locale) ? options.locale : context.locale;
  const locales = localeFallbacker(context, fallbackLocale, locale);
  if (!isString$1(key) || key === "") {
    return new Intl.DateTimeFormat(locale).format(value);
  }
  let datetimeFormat = {};
  let targetLocale;
  let format = null;
  const type = "datetime format";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    datetimeFormat = datetimeFormats[targetLocale] || {};
    format = datetimeFormat[key];
    if (isPlainObject$1(format))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type);
  }
  if (!isPlainObject$1(format) || !isString$1(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id = `${id}__${JSON.stringify(overrides)}`;
  }
  let formatter = __datetimeFormatters.get(id);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat(targetLocale, assign({}, format, overrides));
    __datetimeFormatters.set(id, formatter);
  }
  return !part ? formatter.format(value) : formatter.formatToParts(value);
}
function parseDateTimeArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options = {};
  let overrides = {};
  let value;
  if (isString$1(arg1)) {
    const matches = arg1.match(/(\d{4}-\d{2}-\d{2})(T|\s)?(.*)/);
    if (!matches) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
    const dateTime = matches[3] ? matches[3].trim().startsWith("T") ? `${matches[1].trim()}${matches[3].trim()}` : `${matches[1].trim()}T${matches[3].trim()}` : matches[1].trim();
    value = new Date(dateTime);
    try {
      value.toISOString();
    } catch (e) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
  } else if (isDate$1(arg1)) {
    if (isNaN(arg1.getTime())) {
      throw createCoreError(CoreErrorCodes.INVALID_DATE_ARGUMENT);
    }
    value = arg1;
  } else if (isNumber$1(arg1)) {
    value = arg1;
  } else {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  if (isString$1(arg2)) {
    options.key = arg2;
  } else if (isPlainObject$1(arg2)) {
    options = arg2;
  }
  if (isString$1(arg3)) {
    options.locale = arg3;
  } else if (isPlainObject$1(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$1(arg4)) {
    overrides = arg4;
  }
  return [options.key || "", value, options, overrides];
}
function clearDateTimeFormat(ctx, locale, format) {
  const context = ctx;
  for (const key in format) {
    const id = `${locale}__${key}`;
    if (!context.__datetimeFormatters.has(id)) {
      continue;
    }
    context.__datetimeFormatters.delete(id);
  }
}
function number(context, ...args) {
  const { numberFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __numberFormatters } = context;
  const [key, value, options, overrides] = parseNumberArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const part = !!options.part;
  const locale = isString$1(options.locale) ? options.locale : context.locale;
  const locales = localeFallbacker(context, fallbackLocale, locale);
  if (!isString$1(key) || key === "") {
    return new Intl.NumberFormat(locale).format(value);
  }
  let numberFormat = {};
  let targetLocale;
  let format = null;
  const type = "number format";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    numberFormat = numberFormats[targetLocale] || {};
    format = numberFormat[key];
    if (isPlainObject$1(format))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type);
  }
  if (!isPlainObject$1(format) || !isString$1(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id = `${id}__${JSON.stringify(overrides)}`;
  }
  let formatter = __numberFormatters.get(id);
  if (!formatter) {
    formatter = new Intl.NumberFormat(targetLocale, assign({}, format, overrides));
    __numberFormatters.set(id, formatter);
  }
  return !part ? formatter.format(value) : formatter.formatToParts(value);
}
function parseNumberArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options = {};
  let overrides = {};
  if (!isNumber$1(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const value = arg1;
  if (isString$1(arg2)) {
    options.key = arg2;
  } else if (isPlainObject$1(arg2)) {
    options = arg2;
  }
  if (isString$1(arg3)) {
    options.locale = arg3;
  } else if (isPlainObject$1(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$1(arg4)) {
    overrides = arg4;
  }
  return [options.key || "", value, options, overrides];
}
function clearNumberFormat(ctx, locale, format) {
  const context = ctx;
  for (const key in format) {
    const id = `${locale}__${key}`;
    if (!context.__numberFormatters.has(id)) {
      continue;
    }
    context.__numberFormatters.delete(id);
  }
}
{
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
/*!
  * vue-i18n v9.2.0-beta.11
  * (c) 2021 kazuya kawaguchi
  * Released under the MIT License.
  */
const VERSION$1 = "9.2.0-beta.11";
function initFeatureFlags() {
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
CoreWarnCodes.__EXTEND_POINT__;
let code = CompileErrorCodes.__EXTEND_POINT__;
const inc = () => code++;
const I18nErrorCodes = {
  UNEXPECTED_RETURN_TYPE: code,
  INVALID_ARGUMENT: inc(),
  MUST_BE_CALL_SETUP_TOP: inc(),
  NOT_INSLALLED: inc(),
  NOT_AVAILABLE_IN_LEGACY_MODE: inc(),
  REQUIRED_VALUE: inc(),
  INVALID_VALUE: inc(),
  CANNOT_SETUP_VUE_DEVTOOLS_PLUGIN: inc(),
  NOT_INSLALLED_WITH_PROVIDE: inc(),
  UNEXPECTED_ERROR: inc(),
  NOT_COMPATIBLE_LEGACY_VUE_I18N: inc(),
  BRIDGE_SUPPORT_VUE_2_ONLY: inc(),
  __EXTEND_POINT__: inc()
};
function createI18nError(code2, ...args) {
  return createCompileError(code2, null, void 0);
}
const TransrateVNodeSymbol = /* @__PURE__ */ makeSymbol("__transrateVNode");
const DatetimePartsSymbol = /* @__PURE__ */ makeSymbol("__datetimeParts");
const NumberPartsSymbol = /* @__PURE__ */ makeSymbol("__numberParts");
const SetPluralRulesSymbol = makeSymbol("__setPluralRules");
makeSymbol("__intlifyMeta");
const InejctWithOption = /* @__PURE__ */ makeSymbol("__injectWithOption");
function handleFlatJson(obj) {
  if (!isObject$1(obj)) {
    return obj;
  }
  for (const key in obj) {
    if (!hasOwn(obj, key)) {
      continue;
    }
    if (!key.includes(".")) {
      if (isObject$1(obj[key])) {
        handleFlatJson(obj[key]);
      }
    } else {
      const subKeys = key.split(".");
      const lastIndex = subKeys.length - 1;
      let currentObj = obj;
      for (let i = 0; i < lastIndex; i++) {
        if (!(subKeys[i] in currentObj)) {
          currentObj[subKeys[i]] = {};
        }
        currentObj = currentObj[subKeys[i]];
      }
      currentObj[subKeys[lastIndex]] = obj[key];
      delete obj[key];
      if (isObject$1(currentObj[subKeys[lastIndex]])) {
        handleFlatJson(currentObj[subKeys[lastIndex]]);
      }
    }
  }
  return obj;
}
function getLocaleMessages(locale, options) {
  const { messages, __i18n, messageResolver, flatJson } = options;
  const ret = isPlainObject$1(messages) ? messages : isArray$1(__i18n) ? {} : { [locale]: {} };
  if (isArray$1(__i18n)) {
    __i18n.forEach((custom) => {
      if ("locale" in custom && "resource" in custom) {
        const { locale: locale2, resource } = custom;
        if (locale2) {
          ret[locale2] = ret[locale2] || {};
          deepCopy(resource, ret[locale2]);
        } else {
          deepCopy(resource, ret);
        }
      } else {
        isString$1(custom) && deepCopy(JSON.parse(custom), ret);
      }
    });
  }
  if (messageResolver == null && flatJson) {
    for (const key in ret) {
      if (hasOwn(ret, key)) {
        handleFlatJson(ret[key]);
      }
    }
  }
  return ret;
}
const isNotObjectOrIsArray = (val) => !isObject$1(val) || isArray$1(val);
function deepCopy(src, des) {
  if (isNotObjectOrIsArray(src) || isNotObjectOrIsArray(des)) {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
  for (const key in src) {
    if (hasOwn(src, key)) {
      if (isNotObjectOrIsArray(src[key]) || isNotObjectOrIsArray(des[key])) {
        des[key] = src[key];
      } else {
        deepCopy(src[key], des[key]);
      }
    }
  }
}
function getComponentOptions(instance) {
  return instance.type;
}
const DEVTOOLS_META = "__INTLIFY_META__";
let composerID = 0;
function defineCoreMissingHandler(missing) {
  return (ctx, locale, key, type) => {
    return missing(locale, key, getCurrentInstance() || void 0, type);
  };
}
const getMetaInfo = () => {
  const instance = getCurrentInstance();
  let meta = null;
  return instance && (meta = getComponentOptions(instance)[DEVTOOLS_META]) ? { [DEVTOOLS_META]: meta } : null;
};
function createComposer(options = {}, VueI18nLegacy) {
  const { __root } = options;
  const _isGlobal = __root === void 0;
  let _inheritLocale = isBoolean(options.inheritLocale) ? options.inheritLocale : true;
  const _locale = ref(__root && _inheritLocale ? __root.locale.value : isString$1(options.locale) ? options.locale : DEFAULT_LOCALE);
  const _fallbackLocale = ref(__root && _inheritLocale ? __root.fallbackLocale.value : isString$1(options.fallbackLocale) || isArray$1(options.fallbackLocale) || isPlainObject$1(options.fallbackLocale) || options.fallbackLocale === false ? options.fallbackLocale : _locale.value);
  const _messages = ref(getLocaleMessages(_locale.value, options));
  const _datetimeFormats = ref(isPlainObject$1(options.datetimeFormats) ? options.datetimeFormats : { [_locale.value]: {} });
  const _numberFormats = ref(isPlainObject$1(options.numberFormats) ? options.numberFormats : { [_locale.value]: {} });
  let _missingWarn = __root ? __root.missingWarn : isBoolean(options.missingWarn) || isRegExp(options.missingWarn) ? options.missingWarn : true;
  let _fallbackWarn = __root ? __root.fallbackWarn : isBoolean(options.fallbackWarn) || isRegExp(options.fallbackWarn) ? options.fallbackWarn : true;
  let _fallbackRoot = __root ? __root.fallbackRoot : isBoolean(options.fallbackRoot) ? options.fallbackRoot : true;
  let _fallbackFormat = !!options.fallbackFormat;
  let _missing = isFunction$1(options.missing) ? options.missing : null;
  let _runtimeMissing = isFunction$1(options.missing) ? defineCoreMissingHandler(options.missing) : null;
  let _postTranslation = isFunction$1(options.postTranslation) ? options.postTranslation : null;
  let _warnHtmlMessage = isBoolean(options.warnHtmlMessage) ? options.warnHtmlMessage : true;
  let _escapeParameter = !!options.escapeParameter;
  const _modifiers = __root ? __root.modifiers : isPlainObject$1(options.modifiers) ? options.modifiers : {};
  let _pluralRules = options.pluralRules || __root && __root.pluralRules;
  let _context;
  function getCoreContext() {
    const ctxOptions = {
      version: VERSION$1,
      locale: _locale.value,
      fallbackLocale: _fallbackLocale.value,
      messages: _messages.value,
      modifiers: _modifiers,
      pluralRules: _pluralRules,
      missing: _runtimeMissing === null ? void 0 : _runtimeMissing,
      missingWarn: _missingWarn,
      fallbackWarn: _fallbackWarn,
      fallbackFormat: _fallbackFormat,
      unresolving: true,
      postTranslation: _postTranslation === null ? void 0 : _postTranslation,
      warnHtmlMessage: _warnHtmlMessage,
      escapeParameter: _escapeParameter,
      messageResolver: options.messageResolver,
      __meta: { framework: "vue" }
    };
    {
      ctxOptions.datetimeFormats = _datetimeFormats.value;
      ctxOptions.numberFormats = _numberFormats.value;
      ctxOptions.__datetimeFormatters = isPlainObject$1(_context) ? _context.__datetimeFormatters : void 0;
      ctxOptions.__numberFormatters = isPlainObject$1(_context) ? _context.__numberFormatters : void 0;
    }
    return createCoreContext(ctxOptions);
  }
  _context = getCoreContext();
  updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
  function trackReactivityValues() {
    return [
      _locale.value,
      _fallbackLocale.value,
      _messages.value,
      _datetimeFormats.value,
      _numberFormats.value
    ];
  }
  const locale = computed({
    get: () => _locale.value,
    set: (val) => {
      _locale.value = val;
      _context.locale = _locale.value;
    }
  });
  const fallbackLocale = computed({
    get: () => _fallbackLocale.value,
    set: (val) => {
      _fallbackLocale.value = val;
      _context.fallbackLocale = _fallbackLocale.value;
      updateFallbackLocale(_context, _locale.value, val);
    }
  });
  const messages = computed(() => _messages.value);
  const datetimeFormats = /* @__PURE__ */ computed(() => _datetimeFormats.value);
  const numberFormats = /* @__PURE__ */ computed(() => _numberFormats.value);
  function getPostTranslationHandler() {
    return isFunction$1(_postTranslation) ? _postTranslation : null;
  }
  function setPostTranslationHandler(handler) {
    _postTranslation = handler;
    _context.postTranslation = handler;
  }
  function getMissingHandler() {
    return _missing;
  }
  function setMissingHandler(handler) {
    if (handler !== null) {
      _runtimeMissing = defineCoreMissingHandler(handler);
    }
    _missing = handler;
    _context.missing = _runtimeMissing;
  }
  function wrapWithDeps(fn, argumentParser, warnType, fallbackSuccess, fallbackFail, successCondition) {
    trackReactivityValues();
    let ret;
    if (__INTLIFY_PROD_DEVTOOLS__) {
      try {
        setAdditionalMeta(getMetaInfo());
        ret = fn(_context);
      } finally {
        setAdditionalMeta(null);
      }
    } else {
      ret = fn(_context);
    }
    if (isNumber$1(ret) && ret === NOT_REOSLVED) {
      const [key, arg2] = argumentParser();
      return __root && _fallbackRoot ? fallbackSuccess(__root) : fallbackFail(key);
    } else if (successCondition(ret)) {
      return ret;
    } else {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_RETURN_TYPE);
    }
  }
  function t(...args) {
    return wrapWithDeps((context) => Reflect.apply(translate, null, [context, ...args]), () => parseTranslateArgs(...args), "translate", (root2) => Reflect.apply(root2.t, root2, [...args]), (key) => key, (val) => isString$1(val));
  }
  function rt(...args) {
    const [arg1, arg2, arg3] = args;
    if (arg3 && !isObject$1(arg3)) {
      throw createI18nError(I18nErrorCodes.INVALID_ARGUMENT);
    }
    return t(...[arg1, arg2, assign({ resolvedMessage: true }, arg3 || {})]);
  }
  function d(...args) {
    return wrapWithDeps((context) => Reflect.apply(datetime, null, [context, ...args]), () => parseDateTimeArgs(...args), "datetime format", (root2) => Reflect.apply(root2.d, root2, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$1(val));
  }
  function n(...args) {
    return wrapWithDeps((context) => Reflect.apply(number, null, [context, ...args]), () => parseNumberArgs(...args), "number format", (root2) => Reflect.apply(root2.n, root2, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$1(val));
  }
  function normalize(values) {
    return values.map((val) => isString$1(val) ? createVNode(Text, null, val, 0) : val);
  }
  const interpolate = (val) => val;
  const processor = {
    normalize,
    interpolate,
    type: "vnode"
  };
  function transrateVNode(...args) {
    return wrapWithDeps((context) => {
      let ret;
      const _context2 = context;
      try {
        _context2.processor = processor;
        ret = Reflect.apply(translate, null, [_context2, ...args]);
      } finally {
        _context2.processor = null;
      }
      return ret;
    }, () => parseTranslateArgs(...args), "translate", (root2) => root2[TransrateVNodeSymbol](...args), (key) => [createVNode(Text, null, key, 0)], (val) => isArray$1(val));
  }
  function numberParts(...args) {
    return wrapWithDeps((context) => Reflect.apply(number, null, [context, ...args]), () => parseNumberArgs(...args), "number format", (root2) => root2[NumberPartsSymbol](...args), () => [], (val) => isString$1(val) || isArray$1(val));
  }
  function datetimeParts(...args) {
    return wrapWithDeps((context) => Reflect.apply(datetime, null, [context, ...args]), () => parseDateTimeArgs(...args), "datetime format", (root2) => root2[DatetimePartsSymbol](...args), () => [], (val) => isString$1(val) || isArray$1(val));
  }
  function setPluralRules(rules) {
    _pluralRules = rules;
    _context.pluralRules = _pluralRules;
  }
  function te(key, locale2) {
    const targetLocale = isString$1(locale2) ? locale2 : _locale.value;
    const message = getLocaleMessage(targetLocale);
    return _context.messageResolver(message, key) !== null;
  }
  function resolveMessages(key) {
    let messages2 = null;
    const locales = fallbackWithLocaleChain(_context, _fallbackLocale.value, _locale.value);
    for (let i = 0; i < locales.length; i++) {
      const targetLocaleMessages = _messages.value[locales[i]] || {};
      const messageValue = _context.messageResolver(targetLocaleMessages, key);
      if (messageValue != null) {
        messages2 = messageValue;
        break;
      }
    }
    return messages2;
  }
  function tm(key) {
    const messages2 = resolveMessages(key);
    return messages2 != null ? messages2 : __root ? __root.tm(key) || {} : {};
  }
  function getLocaleMessage(locale2) {
    return _messages.value[locale2] || {};
  }
  function setLocaleMessage(locale2, message) {
    _messages.value[locale2] = message;
    _context.messages = _messages.value;
  }
  function mergeLocaleMessage(locale2, message) {
    _messages.value[locale2] = _messages.value[locale2] || {};
    deepCopy(message, _messages.value[locale2]);
    _context.messages = _messages.value;
  }
  function getDateTimeFormat(locale2) {
    return _datetimeFormats.value[locale2] || {};
  }
  function setDateTimeFormat(locale2, format) {
    _datetimeFormats.value[locale2] = format;
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format);
  }
  function mergeDateTimeFormat(locale2, format) {
    _datetimeFormats.value[locale2] = assign(_datetimeFormats.value[locale2] || {}, format);
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format);
  }
  function getNumberFormat(locale2) {
    return _numberFormats.value[locale2] || {};
  }
  function setNumberFormat(locale2, format) {
    _numberFormats.value[locale2] = format;
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format);
  }
  function mergeNumberFormat(locale2, format) {
    _numberFormats.value[locale2] = assign(_numberFormats.value[locale2] || {}, format);
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format);
  }
  composerID++;
  if (__root) {
    watch(__root.locale, (val) => {
      if (_inheritLocale) {
        _locale.value = val;
        _context.locale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
    watch(__root.fallbackLocale, (val) => {
      if (_inheritLocale) {
        _fallbackLocale.value = val;
        _context.fallbackLocale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
  }
  const composer = {
    id: composerID,
    locale,
    fallbackLocale,
    get inheritLocale() {
      return _inheritLocale;
    },
    set inheritLocale(val) {
      _inheritLocale = val;
      if (val && __root) {
        _locale.value = __root.locale.value;
        _fallbackLocale.value = __root.fallbackLocale.value;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    },
    get availableLocales() {
      return Object.keys(_messages.value).sort();
    },
    messages,
    get modifiers() {
      return _modifiers;
    },
    get pluralRules() {
      return _pluralRules || {};
    },
    get isGlobal() {
      return _isGlobal;
    },
    get missingWarn() {
      return _missingWarn;
    },
    set missingWarn(val) {
      _missingWarn = val;
      _context.missingWarn = _missingWarn;
    },
    get fallbackWarn() {
      return _fallbackWarn;
    },
    set fallbackWarn(val) {
      _fallbackWarn = val;
      _context.fallbackWarn = _fallbackWarn;
    },
    get fallbackRoot() {
      return _fallbackRoot;
    },
    set fallbackRoot(val) {
      _fallbackRoot = val;
    },
    get fallbackFormat() {
      return _fallbackFormat;
    },
    set fallbackFormat(val) {
      _fallbackFormat = val;
      _context.fallbackFormat = _fallbackFormat;
    },
    get warnHtmlMessage() {
      return _warnHtmlMessage;
    },
    set warnHtmlMessage(val) {
      _warnHtmlMessage = val;
      _context.warnHtmlMessage = val;
    },
    get escapeParameter() {
      return _escapeParameter;
    },
    set escapeParameter(val) {
      _escapeParameter = val;
      _context.escapeParameter = val;
    },
    t,
    getLocaleMessage,
    setLocaleMessage,
    mergeLocaleMessage,
    getPostTranslationHandler,
    setPostTranslationHandler,
    getMissingHandler,
    setMissingHandler,
    [SetPluralRulesSymbol]: setPluralRules
  };
  {
    composer.datetimeFormats = datetimeFormats;
    composer.numberFormats = numberFormats;
    composer.rt = rt;
    composer.te = te;
    composer.tm = tm;
    composer.d = d;
    composer.n = n;
    composer.getDateTimeFormat = getDateTimeFormat;
    composer.setDateTimeFormat = setDateTimeFormat;
    composer.mergeDateTimeFormat = mergeDateTimeFormat;
    composer.getNumberFormat = getNumberFormat;
    composer.setNumberFormat = setNumberFormat;
    composer.mergeNumberFormat = mergeNumberFormat;
    composer[InejctWithOption] = options.__injectWithOption;
    {
      composer[TransrateVNodeSymbol] = transrateVNode;
      composer[NumberPartsSymbol] = numberParts;
      composer[DatetimePartsSymbol] = datetimeParts;
    }
  }
  return composer;
}
const baseFormatProps = {
  tag: {
    type: [String, Object]
  },
  locale: {
    type: String
  },
  scope: {
    type: String,
    validator: (val) => val === "parent" || val === "global",
    default: "parent"
  },
  i18n: {
    type: Object
  }
};
const Translation = /* @__PURE__ */ defineComponent({
  name: "i18n-t",
  props: assign({
    keypath: {
      type: String,
      required: true
    },
    plural: {
      type: [Number, String],
      validator: (val) => isNumber$1(val) || !isNaN(val)
    }
  }, baseFormatProps),
  setup(props, context) {
    const { slots, attrs } = context;
    const i18n = props.i18n || useI18n({
      useScope: props.scope,
      __useComponent: true
    });
    const keys = Object.keys(slots).filter((key) => key !== "_");
    return () => {
      const options = {};
      if (props.locale) {
        options.locale = props.locale;
      }
      if (props.plural !== void 0) {
        options.plural = isString$1(props.plural) ? +props.plural : props.plural;
      }
      const arg = getInterpolateArg(context, keys);
      const children = i18n[TransrateVNodeSymbol](props.keypath, arg, options);
      const assignedAttrs = assign({}, attrs);
      const tag = isString$1(props.tag) || isObject$1(props.tag) ? props.tag : Fragment;
      return h(tag, assignedAttrs, children);
    };
  }
});
function getInterpolateArg({ slots }, keys) {
  if (keys.length === 1 && keys[0] === "default") {
    return slots.default ? slots.default() : [];
  } else {
    return keys.reduce((arg, key) => {
      const slot = slots[key];
      if (slot) {
        arg[key] = slot();
      }
      return arg;
    }, {});
  }
}
function renderFormatter(props, context, slotKeys, partFormatter) {
  const { slots, attrs } = context;
  return () => {
    const options = { part: true };
    let overrides = {};
    if (props.locale) {
      options.locale = props.locale;
    }
    if (isString$1(props.format)) {
      options.key = props.format;
    } else if (isObject$1(props.format)) {
      if (isString$1(props.format.key)) {
        options.key = props.format.key;
      }
      overrides = Object.keys(props.format).reduce((options2, prop) => {
        return slotKeys.includes(prop) ? assign({}, options2, { [prop]: props.format[prop] }) : options2;
      }, {});
    }
    const parts = partFormatter(...[props.value, options, overrides]);
    let children = [options.key];
    if (isArray$1(parts)) {
      children = parts.map((part, index) => {
        const slot = slots[part.type];
        return slot ? slot({ [part.type]: part.value, index, parts }) : [part.value];
      });
    } else if (isString$1(parts)) {
      children = [parts];
    }
    const assignedAttrs = assign({}, attrs);
    const tag = isString$1(props.tag) || isObject$1(props.tag) ? props.tag : Fragment;
    return h(tag, assignedAttrs, children);
  };
}
const NUMBER_FORMAT_KEYS = [
  "localeMatcher",
  "style",
  "unit",
  "unitDisplay",
  "currency",
  "currencyDisplay",
  "useGrouping",
  "numberingSystem",
  "minimumIntegerDigits",
  "minimumFractionDigits",
  "maximumFractionDigits",
  "minimumSignificantDigits",
  "maximumSignificantDigits",
  "notation",
  "formatMatcher"
];
const NumberFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-n",
  props: assign({
    value: {
      type: Number,
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n({ useScope: "parent", __useComponent: true });
    return renderFormatter(props, context, NUMBER_FORMAT_KEYS, (...args) => i18n[NumberPartsSymbol](...args));
  }
});
const DATETIME_FORMAT_KEYS = [
  "dateStyle",
  "timeStyle",
  "fractionalSecondDigits",
  "calendar",
  "dayPeriod",
  "numberingSystem",
  "localeMatcher",
  "timeZone",
  "hour12",
  "hourCycle",
  "formatMatcher",
  "weekday",
  "era",
  "year",
  "month",
  "day",
  "hour",
  "minute",
  "second",
  "timeZoneName"
];
const DatetimeFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-d",
  props: assign({
    value: {
      type: [Number, Date],
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n({ useScope: "parent", __useComponent: true });
    return renderFormatter(props, context, DATETIME_FORMAT_KEYS, (...args) => i18n[DatetimePartsSymbol](...args));
  }
});
function getComposer$2(i18n, instance) {
  const i18nInternal = i18n;
  if (i18n.mode === "composition") {
    return i18nInternal.__getInstance(instance) || i18n.global;
  } else {
    const vueI18n = i18nInternal.__getInstance(instance);
    return vueI18n != null ? vueI18n.__composer : i18n.global.__composer;
  }
}
function vTDirective(i18n) {
  const bind3 = (el, { instance, value, modifiers }) => {
    if (!instance || !instance.$) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const composer = getComposer$2(i18n, instance.$);
    const parsedValue = parseValue(value);
    el.textContent = Reflect.apply(composer.t, composer, [
      ...makeParams(parsedValue)
    ]);
  };
  return {
    beforeMount: bind3,
    beforeUpdate: bind3
  };
}
function parseValue(value) {
  if (isString$1(value)) {
    return { path: value };
  } else if (isPlainObject$1(value)) {
    if (!("path" in value)) {
      throw createI18nError(I18nErrorCodes.REQUIRED_VALUE, "path");
    }
    return value;
  } else {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
}
function makeParams(value) {
  const { path, locale, args, choice, plural } = value;
  const options = {};
  const named = args || {};
  if (isString$1(locale)) {
    options.locale = locale;
  }
  if (isNumber$1(choice)) {
    options.plural = choice;
  }
  if (isNumber$1(plural)) {
    options.plural = plural;
  }
  return [path, named, options];
}
function apply(app, i18n, ...options) {
  const pluginOptions = isPlainObject$1(options[0]) ? options[0] : {};
  const useI18nComponentName = !!pluginOptions.useI18nComponentName;
  const globalInstall = isBoolean(pluginOptions.globalInstall) ? pluginOptions.globalInstall : true;
  if (globalInstall) {
    app.component(!useI18nComponentName ? Translation.name : "i18n", Translation);
    app.component(NumberFormat.name, NumberFormat);
    app.component(DatetimeFormat.name, DatetimeFormat);
  }
  {
    app.directive("t", vTDirective(i18n));
  }
}
const I18nInjectionKey = /* @__PURE__ */ makeSymbol("global-vue-i18n");
function createI18n(options = {}, VueI18nLegacy) {
  const __globalInjection = !!options.globalInjection;
  const __instances = new Map();
  const __global = createGlobal(options);
  const symbol = makeSymbol("");
  function __getInstance(component) {
    return __instances.get(component) || null;
  }
  function __setInstance(component, instance) {
    __instances.set(component, instance);
  }
  function __deleteInstance(component) {
    __instances.delete(component);
  }
  {
    const i18n = {
      get mode() {
        return "composition";
      },
      async install(app, ...options2) {
        {
          app.__VUE_I18N_SYMBOL__ = symbol;
          app.provide(app.__VUE_I18N_SYMBOL__, i18n);
        }
        if (__globalInjection) {
          injectGlobalFields(app, i18n.global);
        }
        {
          apply(app, i18n, ...options2);
        }
      },
      get global() {
        return __global;
      },
      __instances,
      __getInstance,
      __setInstance,
      __deleteInstance
    };
    return i18n;
  }
}
function useI18n(options = {}) {
  const instance = getCurrentInstance();
  if (instance == null) {
    throw createI18nError(I18nErrorCodes.MUST_BE_CALL_SETUP_TOP);
  }
  if (!instance.isCE && instance.appContext.app != null && !instance.appContext.app.__VUE_I18N_SYMBOL__) {
    throw createI18nError(I18nErrorCodes.NOT_INSLALLED);
  }
  const i18n = getI18nInstance(instance);
  const global2 = getGlobalComposer(i18n);
  const componentOptions = getComponentOptions(instance);
  const scope = getScope(options, componentOptions);
  if (scope === "global") {
    adjustI18nResources(global2, options, componentOptions);
    return global2;
  }
  if (scope === "parent") {
    let composer2 = getComposer(i18n, instance, options.__useComponent);
    if (composer2 == null) {
      composer2 = global2;
    }
    return composer2;
  }
  if (i18n.mode === "legacy") {
    throw createI18nError(I18nErrorCodes.NOT_AVAILABLE_IN_LEGACY_MODE);
  }
  const i18nInternal = i18n;
  let composer = i18nInternal.__getInstance(instance);
  if (composer == null) {
    const composerOptions = assign({}, options);
    if ("__i18n" in componentOptions) {
      composerOptions.__i18n = componentOptions.__i18n;
    }
    if (global2) {
      composerOptions.__root = global2;
    }
    composer = createComposer(composerOptions);
    setupLifeCycle(i18nInternal, instance);
    i18nInternal.__setInstance(instance, composer);
  }
  return composer;
}
function createGlobal(options, legacyMode, VueI18nLegacy) {
  {
    return createComposer(options);
  }
}
function getI18nInstance(instance) {
  {
    const i18n = inject(!instance.isCE ? instance.appContext.app.__VUE_I18N_SYMBOL__ : I18nInjectionKey);
    if (!i18n) {
      throw createI18nError(!instance.isCE ? I18nErrorCodes.UNEXPECTED_ERROR : I18nErrorCodes.NOT_INSLALLED_WITH_PROVIDE);
    }
    return i18n;
  }
}
function getScope(options, componentOptions) {
  return isEmptyObject(options) ? "__i18n" in componentOptions ? "local" : "global" : !options.useScope ? "local" : options.useScope;
}
function getGlobalComposer(i18n) {
  return i18n.mode === "composition" ? i18n.global : i18n.global.__composer;
}
function adjustI18nResources(global2, options, componentOptions) {
  let messages = isObject$1(options.messages) ? options.messages : {};
  if ("__i18nGlobal" in componentOptions) {
    messages = getLocaleMessages(global2.locale.value, {
      messages,
      __i18n: componentOptions.__i18nGlobal
    });
  }
  const locales = Object.keys(messages);
  if (locales.length) {
    locales.forEach((locale) => {
      global2.mergeLocaleMessage(locale, messages[locale]);
    });
  }
  {
    if (isObject$1(options.datetimeFormats)) {
      const locales2 = Object.keys(options.datetimeFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeDateTimeFormat(locale, options.datetimeFormats[locale]);
        });
      }
    }
    if (isObject$1(options.numberFormats)) {
      const locales2 = Object.keys(options.numberFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeNumberFormat(locale, options.numberFormats[locale]);
        });
      }
    }
  }
}
function getComposer(i18n, target, useComponent = false) {
  let composer = null;
  const root2 = target.root;
  let current = target.parent;
  while (current != null) {
    const i18nInternal = i18n;
    if (i18n.mode === "composition") {
      composer = i18nInternal.__getInstance(current);
    }
    if (composer != null) {
      break;
    }
    if (root2 === current) {
      break;
    }
    current = current.parent;
  }
  return composer;
}
function setupLifeCycle(i18n, target, composer) {
  {
    onMounted(() => {
    }, target);
    onUnmounted(() => {
      i18n.__deleteInstance(target);
    }, target);
  }
}
const globalExportProps = [
  "locale",
  "fallbackLocale",
  "availableLocales"
];
const globalExportMethods = ["t", "rt", "d", "n", "tm"];
function injectGlobalFields(app, composer) {
  const i18n = Object.create(null);
  globalExportProps.forEach((prop) => {
    const desc = Object.getOwnPropertyDescriptor(composer, prop);
    if (!desc) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const wrap = isRef(desc.value) ? {
      get() {
        return desc.value.value;
      },
      set(val) {
        desc.value.value = val;
      }
    } : {
      get() {
        return desc.get && desc.get();
      }
    };
    Object.defineProperty(i18n, prop, wrap);
  });
  app.config.globalProperties.$i18n = i18n;
  globalExportMethods.forEach((method) => {
    const desc = Object.getOwnPropertyDescriptor(composer, method);
    if (!desc || !desc.value) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    Object.defineProperty(app.config.globalProperties, `$${method}`, desc);
  });
}
registerMessageResolver(resolveValue);
registerLocaleFallbacker(fallbackWithLocaleChain);
{
  initFeatureFlags();
}
if (__INTLIFY_PROD_DEVTOOLS__) {
  const target = getGlobalThis();
  target.__INTLIFY__ = true;
  setDevToolsHook(target.__INTLIFY_DEVTOOLS_GLOBAL_HOOK__);
}
var nprogress = { exports: {} };
/* NProgress, (c) 2013, 2014 Rico Sta. Cruz - http://ricostacruz.com/nprogress
 * @license MIT */
(function(module, exports) {
  (function(root2, factory) {
    {
      module.exports = factory();
    }
  })(commonjsGlobal, function() {
    var NProgress = {};
    NProgress.version = "0.2.0";
    var Settings = NProgress.settings = {
      minimum: 0.08,
      easing: "ease",
      positionUsing: "",
      speed: 200,
      trickle: true,
      trickleRate: 0.02,
      trickleSpeed: 800,
      showSpinner: true,
      barSelector: '[role="bar"]',
      spinnerSelector: '[role="spinner"]',
      parent: "body",
      template: '<div class="bar" role="bar"><div class="peg"></div></div><div class="spinner" role="spinner"><div class="spinner-icon"></div></div>'
    };
    NProgress.configure = function(options) {
      var key, value;
      for (key in options) {
        value = options[key];
        if (value !== void 0 && options.hasOwnProperty(key))
          Settings[key] = value;
      }
      return this;
    };
    NProgress.status = null;
    NProgress.set = function(n) {
      var started = NProgress.isStarted();
      n = clamp(n, Settings.minimum, 1);
      NProgress.status = n === 1 ? null : n;
      var progress = NProgress.render(!started), bar = progress.querySelector(Settings.barSelector), speed = Settings.speed, ease = Settings.easing;
      progress.offsetWidth;
      queue2(function(next) {
        if (Settings.positionUsing === "")
          Settings.positionUsing = NProgress.getPositioningCSS();
        css(bar, barPositionCSS(n, speed, ease));
        if (n === 1) {
          css(progress, {
            transition: "none",
            opacity: 1
          });
          progress.offsetWidth;
          setTimeout(function() {
            css(progress, {
              transition: "all " + speed + "ms linear",
              opacity: 0
            });
            setTimeout(function() {
              NProgress.remove();
              next();
            }, speed);
          }, speed);
        } else {
          setTimeout(next, speed);
        }
      });
      return this;
    };
    NProgress.isStarted = function() {
      return typeof NProgress.status === "number";
    };
    NProgress.start = function() {
      if (!NProgress.status)
        NProgress.set(0);
      var work = function() {
        setTimeout(function() {
          if (!NProgress.status)
            return;
          NProgress.trickle();
          work();
        }, Settings.trickleSpeed);
      };
      if (Settings.trickle)
        work();
      return this;
    };
    NProgress.done = function(force) {
      if (!force && !NProgress.status)
        return this;
      return NProgress.inc(0.3 + 0.5 * Math.random()).set(1);
    };
    NProgress.inc = function(amount) {
      var n = NProgress.status;
      if (!n) {
        return NProgress.start();
      } else {
        if (typeof amount !== "number") {
          amount = (1 - n) * clamp(Math.random() * n, 0.1, 0.95);
        }
        n = clamp(n + amount, 0, 0.994);
        return NProgress.set(n);
      }
    };
    NProgress.trickle = function() {
      return NProgress.inc(Math.random() * Settings.trickleRate);
    };
    (function() {
      var initial = 0, current = 0;
      NProgress.promise = function($promise) {
        if (!$promise || $promise.state() === "resolved") {
          return this;
        }
        if (current === 0) {
          NProgress.start();
        }
        initial++;
        current++;
        $promise.always(function() {
          current--;
          if (current === 0) {
            initial = 0;
            NProgress.done();
          } else {
            NProgress.set((initial - current) / initial);
          }
        });
        return this;
      };
    })();
    NProgress.render = function(fromStart) {
      if (NProgress.isRendered())
        return document.getElementById("nprogress");
      addClass(document.documentElement, "nprogress-busy");
      var progress = document.createElement("div");
      progress.id = "nprogress";
      progress.innerHTML = Settings.template;
      var bar = progress.querySelector(Settings.barSelector), perc = fromStart ? "-100" : toBarPerc(NProgress.status || 0), parent = document.querySelector(Settings.parent), spinner;
      css(bar, {
        transition: "all 0 linear",
        transform: "translate3d(" + perc + "%,0,0)"
      });
      if (!Settings.showSpinner) {
        spinner = progress.querySelector(Settings.spinnerSelector);
        spinner && removeElement(spinner);
      }
      if (parent != document.body) {
        addClass(parent, "nprogress-custom-parent");
      }
      parent.appendChild(progress);
      return progress;
    };
    NProgress.remove = function() {
      removeClass(document.documentElement, "nprogress-busy");
      removeClass(document.querySelector(Settings.parent), "nprogress-custom-parent");
      var progress = document.getElementById("nprogress");
      progress && removeElement(progress);
    };
    NProgress.isRendered = function() {
      return !!document.getElementById("nprogress");
    };
    NProgress.getPositioningCSS = function() {
      var bodyStyle = document.body.style;
      var vendorPrefix = "WebkitTransform" in bodyStyle ? "Webkit" : "MozTransform" in bodyStyle ? "Moz" : "msTransform" in bodyStyle ? "ms" : "OTransform" in bodyStyle ? "O" : "";
      if (vendorPrefix + "Perspective" in bodyStyle) {
        return "translate3d";
      } else if (vendorPrefix + "Transform" in bodyStyle) {
        return "translate";
      } else {
        return "margin";
      }
    };
    function clamp(n, min, max) {
      if (n < min)
        return min;
      if (n > max)
        return max;
      return n;
    }
    function toBarPerc(n) {
      return (-1 + n) * 100;
    }
    function barPositionCSS(n, speed, ease) {
      var barCSS;
      if (Settings.positionUsing === "translate3d") {
        barCSS = { transform: "translate3d(" + toBarPerc(n) + "%,0,0)" };
      } else if (Settings.positionUsing === "translate") {
        barCSS = { transform: "translate(" + toBarPerc(n) + "%,0)" };
      } else {
        barCSS = { "margin-left": toBarPerc(n) + "%" };
      }
      barCSS.transition = "all " + speed + "ms " + ease;
      return barCSS;
    }
    var queue2 = function() {
      var pending = [];
      function next() {
        var fn = pending.shift();
        if (fn) {
          fn(next);
        }
      }
      return function(fn) {
        pending.push(fn);
        if (pending.length == 1)
          next();
      };
    }();
    var css = function() {
      var cssPrefixes = ["Webkit", "O", "Moz", "ms"], cssProps = {};
      function camelCase(string) {
        return string.replace(/^-ms-/, "ms-").replace(/-([\da-z])/gi, function(match, letter) {
          return letter.toUpperCase();
        });
      }
      function getVendorProp(name) {
        var style = document.body.style;
        if (name in style)
          return name;
        var i = cssPrefixes.length, capName = name.charAt(0).toUpperCase() + name.slice(1), vendorName;
        while (i--) {
          vendorName = cssPrefixes[i] + capName;
          if (vendorName in style)
            return vendorName;
        }
        return name;
      }
      function getStyleProp(name) {
        name = camelCase(name);
        return cssProps[name] || (cssProps[name] = getVendorProp(name));
      }
      function applyCss(element, prop, value) {
        prop = getStyleProp(prop);
        element.style[prop] = value;
      }
      return function(element, properties) {
        var args = arguments, prop, value;
        if (args.length == 2) {
          for (prop in properties) {
            value = properties[prop];
            if (value !== void 0 && properties.hasOwnProperty(prop))
              applyCss(element, prop, value);
          }
        } else {
          applyCss(element, args[1], args[2]);
        }
      };
    }();
    function hasClass(element, name) {
      var list = typeof element == "string" ? element : classList(element);
      return list.indexOf(" " + name + " ") >= 0;
    }
    function addClass(element, name) {
      var oldList = classList(element), newList = oldList + name;
      if (hasClass(oldList, name))
        return;
      element.className = newList.substring(1);
    }
    function removeClass(element, name) {
      var oldList = classList(element), newList;
      if (!hasClass(element, name))
        return;
      newList = oldList.replace(" " + name + " ", " ");
      element.className = newList.substring(1, newList.length - 1);
    }
    function classList(element) {
      return (" " + (element.className || "") + " ").replace(/\s+/gi, " ");
    }
    function removeElement(element) {
      element && element.parentNode && element.parentNode.removeChild(element);
    }
    return NProgress;
  });
})(nprogress);
var vueScrollto = { exports: {} };
/*!
  * vue-scrollto v2.20.0
  * (c) 2019 Randjelovic Igor
  * @license MIT
  */
(function(module, exports) {
  (function(global2, factory) {
    module.exports = factory();
  })(commonjsGlobal, function() {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function(obj2) {
          return typeof obj2;
        };
      } else {
        _typeof = function(obj2) {
          return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        };
      }
      return _typeof(obj);
    }
    function _extends() {
      _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source2 = arguments[i];
          for (var key in source2) {
            if (Object.prototype.hasOwnProperty.call(source2, key)) {
              target[key] = source2[key];
            }
          }
        }
        return target;
      };
      return _extends.apply(this, arguments);
    }
    var NEWTON_ITERATIONS = 4;
    var NEWTON_MIN_SLOPE = 1e-3;
    var SUBDIVISION_PRECISION = 1e-7;
    var SUBDIVISION_MAX_ITERATIONS = 10;
    var kSplineTableSize = 11;
    var kSampleStepSize = 1 / (kSplineTableSize - 1);
    var float32ArraySupported = typeof Float32Array === "function";
    function A(aA1, aA2) {
      return 1 - 3 * aA2 + 3 * aA1;
    }
    function B(aA1, aA2) {
      return 3 * aA2 - 6 * aA1;
    }
    function C(aA1) {
      return 3 * aA1;
    }
    function calcBezier(aT, aA1, aA2) {
      return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT;
    }
    function getSlope(aT, aA1, aA2) {
      return 3 * A(aA1, aA2) * aT * aT + 2 * B(aA1, aA2) * aT + C(aA1);
    }
    function binarySubdivide(aX, aA, aB, mX1, mX2) {
      var currentX, currentT, i = 0;
      do {
        currentT = aA + (aB - aA) / 2;
        currentX = calcBezier(currentT, mX1, mX2) - aX;
        if (currentX > 0) {
          aB = currentT;
        } else {
          aA = currentT;
        }
      } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);
      return currentT;
    }
    function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
      for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
        var currentSlope = getSlope(aGuessT, mX1, mX2);
        if (currentSlope === 0) {
          return aGuessT;
        }
        var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
        aGuessT -= currentX / currentSlope;
      }
      return aGuessT;
    }
    function LinearEasing(x) {
      return x;
    }
    var src = function bezier(mX1, mY1, mX2, mY2) {
      if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) {
        throw new Error("bezier x values must be in [0, 1] range");
      }
      if (mX1 === mY1 && mX2 === mY2) {
        return LinearEasing;
      }
      var sampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
      for (var i = 0; i < kSplineTableSize; ++i) {
        sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
      }
      function getTForX(aX) {
        var intervalStart = 0;
        var currentSample = 1;
        var lastSample = kSplineTableSize - 1;
        for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
          intervalStart += kSampleStepSize;
        }
        --currentSample;
        var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
        var guessForT = intervalStart + dist * kSampleStepSize;
        var initialSlope = getSlope(guessForT, mX1, mX2);
        if (initialSlope >= NEWTON_MIN_SLOPE) {
          return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
        } else if (initialSlope === 0) {
          return guessForT;
        } else {
          return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
        }
      }
      return function BezierEasing(x) {
        if (x === 0) {
          return 0;
        }
        if (x === 1) {
          return 1;
        }
        return calcBezier(getTForX(x), mY1, mY2);
      };
    };
    var easings = {
      ease: [0.25, 0.1, 0.25, 1],
      linear: [0, 0, 1, 1],
      "ease-in": [0.42, 0, 1, 1],
      "ease-out": [0, 0, 0.58, 1],
      "ease-in-out": [0.42, 0, 0.58, 1]
    };
    var supportsPassive = false;
    try {
      var opts = Object.defineProperty({}, "passive", {
        get: function get2() {
          supportsPassive = true;
        }
      });
      window.addEventListener("test", null, opts);
    } catch (e) {
    }
    var _ = {
      $: function $(selector) {
        if (typeof selector !== "string") {
          return selector;
        }
        return document.querySelector(selector);
      },
      on: function on(element, events, handler) {
        var opts2 = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {
          passive: false
        };
        if (!(events instanceof Array)) {
          events = [events];
        }
        for (var i = 0; i < events.length; i++) {
          element.addEventListener(events[i], handler, supportsPassive ? opts2 : false);
        }
      },
      off: function off(element, events, handler) {
        if (!(events instanceof Array)) {
          events = [events];
        }
        for (var i = 0; i < events.length; i++) {
          element.removeEventListener(events[i], handler);
        }
      },
      cumulativeOffset: function cumulativeOffset(element) {
        var top = 0;
        var left = 0;
        do {
          top += element.offsetTop || 0;
          left += element.offsetLeft || 0;
          element = element.offsetParent;
        } while (element);
        return {
          top,
          left
        };
      }
    };
    var abortEvents = ["mousedown", "wheel", "DOMMouseScroll", "mousewheel", "keyup", "touchmove"];
    var defaults2 = {
      container: "body",
      duration: 500,
      lazy: true,
      easing: "ease",
      offset: 0,
      force: true,
      cancelable: true,
      onStart: false,
      onDone: false,
      onCancel: false,
      x: false,
      y: true
    };
    function setDefaults(options) {
      defaults2 = _extends({}, defaults2, options);
    }
    var scroller = function scroller2() {
      var element;
      var container;
      var duration;
      var easing;
      var lazy;
      var offset;
      var force;
      var cancelable;
      var onStart;
      var onDone;
      var onCancel;
      var x;
      var y;
      var initialX;
      var targetX;
      var initialY;
      var targetY;
      var diffX;
      var diffY;
      var abort;
      var cumulativeOffsetContainer;
      var cumulativeOffsetElement;
      var abortEv;
      var abortFn = function abortFn2(e) {
        if (!cancelable)
          return;
        abortEv = e;
        abort = true;
      };
      var easingFn;
      var timeStart;
      var timeElapsed;
      var progress;
      function scrollTop(container2) {
        var scrollTop2 = container2.scrollTop;
        if (container2.tagName.toLowerCase() === "body") {
          scrollTop2 = scrollTop2 || document.documentElement.scrollTop;
        }
        return scrollTop2;
      }
      function scrollLeft(container2) {
        var scrollLeft2 = container2.scrollLeft;
        if (container2.tagName.toLowerCase() === "body") {
          scrollLeft2 = scrollLeft2 || document.documentElement.scrollLeft;
        }
        return scrollLeft2;
      }
      function recalculateTargets() {
        cumulativeOffsetContainer = _.cumulativeOffset(container);
        cumulativeOffsetElement = _.cumulativeOffset(element);
        if (x) {
          targetX = cumulativeOffsetElement.left - cumulativeOffsetContainer.left + offset;
          diffX = targetX - initialX;
        }
        if (y) {
          targetY = cumulativeOffsetElement.top - cumulativeOffsetContainer.top + offset;
          diffY = targetY - initialY;
        }
      }
      function step(timestamp) {
        if (abort)
          return done();
        if (!timeStart)
          timeStart = timestamp;
        if (!lazy) {
          recalculateTargets();
        }
        timeElapsed = timestamp - timeStart;
        progress = Math.min(timeElapsed / duration, 1);
        progress = easingFn(progress);
        topLeft(container, initialY + diffY * progress, initialX + diffX * progress);
        timeElapsed < duration ? window.requestAnimationFrame(step) : done();
      }
      function done() {
        if (!abort)
          topLeft(container, targetY, targetX);
        timeStart = false;
        _.off(container, abortEvents, abortFn);
        if (abort && onCancel)
          onCancel(abortEv, element);
        if (!abort && onDone)
          onDone(element);
      }
      function topLeft(element2, top, left) {
        if (y)
          element2.scrollTop = top;
        if (x)
          element2.scrollLeft = left;
        if (element2.tagName.toLowerCase() === "body") {
          if (y)
            document.documentElement.scrollTop = top;
          if (x)
            document.documentElement.scrollLeft = left;
        }
      }
      function scrollTo(target, _duration) {
        var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        if (_typeof(_duration) === "object") {
          options = _duration;
        } else if (typeof _duration === "number") {
          options.duration = _duration;
        }
        element = _.$(target);
        if (!element) {
          return console.warn("[vue-scrollto warn]: Trying to scroll to an element that is not on the page: " + target);
        }
        container = _.$(options.container || defaults2.container);
        duration = options.hasOwnProperty("duration") ? options.duration : defaults2.duration;
        lazy = options.hasOwnProperty("lazy") ? options.lazy : defaults2.lazy;
        easing = options.easing || defaults2.easing;
        offset = options.hasOwnProperty("offset") ? options.offset : defaults2.offset;
        force = options.hasOwnProperty("force") ? options.force !== false : defaults2.force;
        cancelable = options.hasOwnProperty("cancelable") ? options.cancelable !== false : defaults2.cancelable;
        onStart = options.onStart || defaults2.onStart;
        onDone = options.onDone || defaults2.onDone;
        onCancel = options.onCancel || defaults2.onCancel;
        x = options.x === void 0 ? defaults2.x : options.x;
        y = options.y === void 0 ? defaults2.y : options.y;
        if (typeof offset === "function") {
          offset = offset(element, container);
        }
        initialX = scrollLeft(container);
        initialY = scrollTop(container);
        recalculateTargets();
        abort = false;
        if (!force) {
          var containerHeight = container.tagName.toLowerCase() === "body" ? document.documentElement.clientHeight || window.innerHeight : container.offsetHeight;
          var containerTop = initialY;
          var containerBottom = containerTop + containerHeight;
          var elementTop = targetY - offset;
          var elementBottom = elementTop + element.offsetHeight;
          if (elementTop >= containerTop && elementBottom <= containerBottom) {
            if (onDone)
              onDone(element);
            return;
          }
        }
        if (onStart)
          onStart(element);
        if (!diffY && !diffX) {
          if (onDone)
            onDone(element);
          return;
        }
        if (typeof easing === "string") {
          easing = easings[easing] || easings["ease"];
        }
        easingFn = src.apply(src, easing);
        _.on(container, abortEvents, abortFn, {
          passive: true
        });
        window.requestAnimationFrame(step);
        return function() {
          abortEv = null;
          abort = true;
        };
      }
      return scrollTo;
    };
    var _scroller = scroller();
    var bindings = [];
    function deleteBinding(el) {
      for (var i = 0; i < bindings.length; ++i) {
        if (bindings[i].el === el) {
          bindings.splice(i, 1);
          return true;
        }
      }
      return false;
    }
    function findBinding(el) {
      for (var i = 0; i < bindings.length; ++i) {
        if (bindings[i].el === el) {
          return bindings[i];
        }
      }
    }
    function getBinding(el) {
      var binding = findBinding(el);
      if (binding) {
        return binding;
      }
      bindings.push(binding = {
        el,
        binding: {}
      });
      return binding;
    }
    function handleClick(e) {
      var ctx = getBinding(this).binding;
      if (!ctx.value)
        return;
      e.preventDefault();
      if (typeof ctx.value === "string") {
        return _scroller(ctx.value);
      }
      _scroller(ctx.value.el || ctx.value.element, ctx.value);
    }
    var directiveHooks = {
      bind: function bind3(el, binding) {
        getBinding(el).binding = binding;
        _.on(el, "click", handleClick);
      },
      unbind: function unbind(el) {
        deleteBinding(el);
        _.off(el, "click", handleClick);
      },
      update: function update(el, binding) {
        getBinding(el).binding = binding;
      }
    };
    var VueScrollTo2 = {
      bind: directiveHooks.bind,
      unbind: directiveHooks.unbind,
      update: directiveHooks.update,
      beforeMount: directiveHooks.bind,
      unmounted: directiveHooks.unbind,
      updated: directiveHooks.update,
      scrollTo: _scroller,
      bindings
    };
    var install = function install2(Vue, options) {
      if (options)
        setDefaults(options);
      Vue.directive("scroll-to", VueScrollTo2);
      var properties = Vue.config.globalProperties || Vue.prototype;
      properties.$scrollTo = VueScrollTo2.scrollTo;
    };
    if (typeof window !== "undefined" && window.Vue) {
      window.VueScrollTo = VueScrollTo2;
      window.VueScrollTo.setDefaults = setDefaults;
      window.VueScrollTo.scroller = scroller;
      if (window.Vue.use)
        window.Vue.use(install);
    }
    VueScrollTo2.install = install;
    return VueScrollTo2;
  });
})(vueScrollto);
var VueScrollTo = vueScrollto.exports;
var uikit = { exports: {} };
/*! UIkit 3.10.1 | https://www.getuikit.com | (c) 2014 - 2022 YOOtheme | MIT License */
(function(module, exports) {
  (function(global2, factory) {
    module.exports = factory();
  })(commonjsGlobal, function() {
    var objPrototype = Object.prototype;
    var hasOwnProperty2 = objPrototype.hasOwnProperty;
    function hasOwn2(obj2, key2) {
      return hasOwnProperty2.call(obj2, key2);
    }
    var hyphenateRe = /\B([A-Z])/g;
    var hyphenate2 = memoize(function(str) {
      return str.replace(hyphenateRe, "-$1").toLowerCase();
    });
    var camelizeRe = /-(\w)/g;
    var camelize2 = memoize(function(str) {
      return str.replace(camelizeRe, toUpper);
    });
    var ucfirst = memoize(function(str) {
      return str.length ? toUpper(null, str.charAt(0)) + str.slice(1) : "";
    });
    function toUpper(_, c) {
      return c ? c.toUpperCase() : "";
    }
    var strPrototype = String.prototype;
    var startsWithFn = strPrototype.startsWith || function(search) {
      return this.lastIndexOf(search, 0) === 0;
    };
    function startsWith(str, search) {
      return startsWithFn.call(str, search);
    }
    var endsWithFn = strPrototype.endsWith || function(search) {
      return this.substr(-search.length) === search;
    };
    function endsWith(str, search) {
      return endsWithFn.call(str, search);
    }
    var arrPrototype = Array.prototype;
    var includesFn = function(search, i) {
      return !!~this.indexOf(search, i);
    };
    var includesStr = strPrototype.includes || includesFn;
    var includesArray = arrPrototype.includes || includesFn;
    function includes(obj2, search) {
      return obj2 && (isString2(obj2) ? includesStr : includesArray).call(obj2, search);
    }
    var findIndexFn = arrPrototype.findIndex || function(predicate) {
      var arguments$1 = arguments;
      for (var i = 0; i < this.length; i++) {
        if (predicate.call(arguments$1[1], this[i], i, this)) {
          return i;
        }
      }
      return -1;
    };
    function findIndex(array, predicate) {
      return findIndexFn.call(array, predicate);
    }
    var isArray2 = Array.isArray;
    function isFunction2(obj2) {
      return typeof obj2 === "function";
    }
    function isObject2(obj2) {
      return obj2 !== null && typeof obj2 === "object";
    }
    var toString3 = objPrototype.toString;
    function isPlainObject2(obj2) {
      return toString3.call(obj2) === "[object Object]";
    }
    function isWindow(obj2) {
      return isObject2(obj2) && obj2 === obj2.window;
    }
    function isDocument(obj2) {
      return nodeType(obj2) === 9;
    }
    function isNode(obj2) {
      return nodeType(obj2) >= 1;
    }
    function isElement(obj2) {
      return nodeType(obj2) === 1;
    }
    function nodeType(obj2) {
      return !isWindow(obj2) && isObject2(obj2) && obj2.nodeType;
    }
    function isBoolean2(value) {
      return typeof value === "boolean";
    }
    function isString2(value) {
      return typeof value === "string";
    }
    function isNumber2(value) {
      return typeof value === "number";
    }
    function isNumeric(value) {
      return isNumber2(value) || isString2(value) && !isNaN(value - parseFloat(value));
    }
    function isEmpty(obj2) {
      return !(isArray2(obj2) ? obj2.length : isObject2(obj2) ? Object.keys(obj2).length : false);
    }
    function isUndefined2(value) {
      return value === void 0;
    }
    function toBoolean(value) {
      return isBoolean2(value) ? value : value === "true" || value === "1" || value === "" ? true : value === "false" || value === "0" ? false : value;
    }
    function toNumber2(value) {
      var number2 = Number(value);
      return isNaN(number2) ? false : number2;
    }
    function toFloat(value) {
      return parseFloat(value) || 0;
    }
    var toArray = Array.from || function(value) {
      return arrPrototype.slice.call(value);
    };
    function toNode(element) {
      return toNodes(element)[0];
    }
    function toNodes(element) {
      return element && (isNode(element) ? [element] : toArray(element).filter(isNode)) || [];
    }
    function toWindow(element) {
      if (isWindow(element)) {
        return element;
      }
      element = toNode(element);
      return element ? (isDocument(element) ? element : element.ownerDocument).defaultView : window;
    }
    function toMs2(time) {
      return !time ? 0 : endsWith(time, "ms") ? toFloat(time) : toFloat(time) * 1e3;
    }
    function isEqual(value, other) {
      return value === other || isObject2(value) && isObject2(other) && Object.keys(value).length === Object.keys(other).length && each(value, function(val, key2) {
        return val === other[key2];
      });
    }
    function swap(value, a, b) {
      return value.replace(new RegExp(a + "|" + b, "g"), function(match2) {
        return match2 === a ? b : a;
      });
    }
    var assign2 = Object.assign || function(target) {
      var args = [], len = arguments.length - 1;
      while (len-- > 0)
        args[len] = arguments[len + 1];
      target = Object(target);
      for (var i = 0; i < args.length; i++) {
        var source2 = args[i];
        if (source2 !== null) {
          for (var key2 in source2) {
            if (hasOwn2(source2, key2)) {
              target[key2] = source2[key2];
            }
          }
        }
      }
      return target;
    };
    function last(array) {
      return array[array.length - 1];
    }
    function each(obj2, cb) {
      for (var key2 in obj2) {
        if (cb(obj2[key2], key2) === false) {
          return false;
        }
      }
      return true;
    }
    function sortBy$1(array, prop) {
      return array.slice().sort(function(ref2, ref$1) {
        var propA = ref2[prop];
        if (propA === void 0)
          propA = 0;
        var propB = ref$1[prop];
        if (propB === void 0)
          propB = 0;
        return propA > propB ? 1 : propB > propA ? -1 : 0;
      });
    }
    function uniqueBy(array, prop) {
      var seen = new Set();
      return array.filter(function(ref2) {
        var check = ref2[prop];
        return seen.has(check) ? false : seen.add(check) || true;
      });
    }
    function clamp(number2, min, max) {
      if (min === void 0)
        min = 0;
      if (max === void 0)
        max = 1;
      return Math.min(Math.max(toNumber2(number2) || 0, min), max);
    }
    function noop2() {
    }
    function intersectRect() {
      var rects = [], len = arguments.length;
      while (len--)
        rects[len] = arguments[len];
      return [["bottom", "top"], ["right", "left"]].every(function(ref2) {
        var minProp = ref2[0];
        var maxProp = ref2[1];
        return Math.min.apply(Math, rects.map(function(ref3) {
          var min = ref3[minProp];
          return min;
        })) - Math.max.apply(Math, rects.map(function(ref3) {
          var max = ref3[maxProp];
          return max;
        })) > 0;
      });
    }
    function pointInRect(point, rect) {
      return point.x <= rect.right && point.x >= rect.left && point.y <= rect.bottom && point.y >= rect.top;
    }
    var Dimensions = {
      ratio: function(dimensions2, prop, value) {
        var obj2;
        var aProp = prop === "width" ? "height" : "width";
        return obj2 = {}, obj2[aProp] = dimensions2[prop] ? Math.round(value * dimensions2[aProp] / dimensions2[prop]) : dimensions2[aProp], obj2[prop] = value, obj2;
      },
      contain: function(dimensions2, maxDimensions) {
        var this$1$1 = this;
        dimensions2 = assign2({}, dimensions2);
        each(dimensions2, function(_, prop) {
          return dimensions2 = dimensions2[prop] > maxDimensions[prop] ? this$1$1.ratio(dimensions2, prop, maxDimensions[prop]) : dimensions2;
        });
        return dimensions2;
      },
      cover: function(dimensions2, maxDimensions) {
        var this$1$1 = this;
        dimensions2 = this.contain(dimensions2, maxDimensions);
        each(dimensions2, function(_, prop) {
          return dimensions2 = dimensions2[prop] < maxDimensions[prop] ? this$1$1.ratio(dimensions2, prop, maxDimensions[prop]) : dimensions2;
        });
        return dimensions2;
      }
    };
    function getIndex(i, elements, current, finite) {
      if (current === void 0)
        current = 0;
      if (finite === void 0)
        finite = false;
      elements = toNodes(elements);
      var length = elements.length;
      i = isNumeric(i) ? toNumber2(i) : i === "next" ? current + 1 : i === "previous" ? current - 1 : elements.indexOf(toNode(i));
      if (finite) {
        return clamp(i, 0, length - 1);
      }
      i %= length;
      return i < 0 ? i + length : i;
    }
    function memoize(fn) {
      var cache2 = Object.create(null);
      return function(key2) {
        return cache2[key2] || (cache2[key2] = fn(key2));
      };
    }
    function attr(element, name, value) {
      if (isObject2(name)) {
        for (var key2 in name) {
          attr(element, key2, name[key2]);
        }
        return;
      }
      if (isUndefined2(value)) {
        element = toNode(element);
        return element && element.getAttribute(name);
      } else {
        toNodes(element).forEach(function(element2) {
          if (isFunction2(value)) {
            value = value.call(element2, attr(element2, name));
          }
          if (value === null) {
            removeAttr(element2, name);
          } else {
            element2.setAttribute(name, value);
          }
        });
      }
    }
    function hasAttr(element, name) {
      return toNodes(element).some(function(element2) {
        return element2.hasAttribute(name);
      });
    }
    function removeAttr(element, name) {
      element = toNodes(element);
      name.split(" ").forEach(function(name2) {
        return element.forEach(function(element2) {
          return element2.hasAttribute(name2) && element2.removeAttribute(name2);
        });
      });
    }
    function data2(element, attribute) {
      for (var i = 0, attrs = [attribute, "data-" + attribute]; i < attrs.length; i++) {
        if (hasAttr(element, attrs[i])) {
          return attr(element, attrs[i]);
        }
      }
    }
    var inBrowser = typeof window !== "undefined";
    var isIE = inBrowser && /msie|trident/i.test(window.navigator.userAgent);
    var isRtl = inBrowser && attr(document.documentElement, "dir") === "rtl";
    var hasTouchEvents = inBrowser && "ontouchstart" in window;
    var hasPointerEvents = inBrowser && window.PointerEvent;
    var hasTouch = inBrowser && (hasTouchEvents || window.DocumentTouch && document instanceof DocumentTouch || navigator.maxTouchPoints);
    var pointerDown = hasPointerEvents ? "pointerdown" : hasTouchEvents ? "touchstart" : "mousedown";
    var pointerMove = hasPointerEvents ? "pointermove" : hasTouchEvents ? "touchmove" : "mousemove";
    var pointerUp = hasPointerEvents ? "pointerup" : hasTouchEvents ? "touchend" : "mouseup";
    var pointerEnter = hasPointerEvents ? "pointerenter" : hasTouchEvents ? "" : "mouseenter";
    var pointerLeave = hasPointerEvents ? "pointerleave" : hasTouchEvents ? "" : "mouseleave";
    var pointerCancel = hasPointerEvents ? "pointercancel" : "touchcancel";
    var voidElements = {
      area: true,
      base: true,
      br: true,
      col: true,
      embed: true,
      hr: true,
      img: true,
      input: true,
      keygen: true,
      link: true,
      menuitem: true,
      meta: true,
      param: true,
      source: true,
      track: true,
      wbr: true
    };
    function isVoidElement(element) {
      return toNodes(element).some(function(element2) {
        return voidElements[element2.tagName.toLowerCase()];
      });
    }
    function isVisible(element) {
      return toNodes(element).some(function(element2) {
        return element2.offsetWidth || element2.offsetHeight || element2.getClientRects().length;
      });
    }
    var selInput = "input,select,textarea,button";
    function isInput(element) {
      return toNodes(element).some(function(element2) {
        return matches(element2, selInput);
      });
    }
    var selFocusable = selInput + ",a[href],[tabindex]";
    function isFocusable(element) {
      return matches(element, selFocusable);
    }
    function parent(element) {
      element = toNode(element);
      return element && isElement(element.parentNode) && element.parentNode;
    }
    function filter$1(element, selector) {
      return toNodes(element).filter(function(element2) {
        return matches(element2, selector);
      });
    }
    var elProto = inBrowser ? Element.prototype : {};
    var matchesFn = elProto.matches || elProto.webkitMatchesSelector || elProto.msMatchesSelector || noop2;
    function matches(element, selector) {
      return toNodes(element).some(function(element2) {
        return matchesFn.call(element2, selector);
      });
    }
    var closestFn = elProto.closest || function(selector) {
      var ancestor = this;
      do {
        if (matches(ancestor, selector)) {
          return ancestor;
        }
      } while (ancestor = parent(ancestor));
    };
    function closest(element, selector) {
      if (startsWith(selector, ">")) {
        selector = selector.slice(1);
      }
      return isElement(element) ? closestFn.call(element, selector) : toNodes(element).map(function(element2) {
        return closest(element2, selector);
      }).filter(Boolean);
    }
    function within(element, selector) {
      return !isString2(selector) ? element === selector || (isDocument(selector) ? selector.documentElement : toNode(selector)).contains(toNode(element)) : matches(element, selector) || !!closest(element, selector);
    }
    function parents(element, selector) {
      var elements = [];
      while (element = parent(element)) {
        if (!selector || matches(element, selector)) {
          elements.push(element);
        }
      }
      return elements;
    }
    function children(element, selector) {
      element = toNode(element);
      var children2 = element ? toNodes(element.children) : [];
      return selector ? filter$1(children2, selector) : children2;
    }
    function index(element, ref2) {
      return ref2 ? toNodes(element).indexOf(toNode(ref2)) : children(parent(element)).indexOf(element);
    }
    function query(selector, context) {
      return find(selector, getContext(selector, context));
    }
    function queryAll(selector, context) {
      return findAll(selector, getContext(selector, context));
    }
    function getContext(selector, context) {
      if (context === void 0)
        context = document;
      return isString2(selector) && isContextSelector(selector) || isDocument(context) ? context : context.ownerDocument;
    }
    function find(selector, context) {
      return toNode(_query(selector, context, "querySelector"));
    }
    function findAll(selector, context) {
      return toNodes(_query(selector, context, "querySelectorAll"));
    }
    function _query(selector, context, queryFn) {
      if (context === void 0)
        context = document;
      if (!selector || !isString2(selector)) {
        return selector;
      }
      selector = selector.replace(contextSanitizeRe, "$1 *");
      if (isContextSelector(selector)) {
        selector = splitSelector(selector).map(function(selector2) {
          var ctx = context;
          if (selector2[0] === "!") {
            var selectors = selector2.substr(1).trim().split(" ");
            ctx = closest(parent(context), selectors[0]);
            selector2 = selectors.slice(1).join(" ").trim();
          }
          if (selector2[0] === "-") {
            var selectors$1 = selector2.substr(1).trim().split(" ");
            var prev = (ctx || context).previousElementSibling;
            ctx = matches(prev, selector2.substr(1)) ? prev : null;
            selector2 = selectors$1.slice(1).join(" ");
          }
          if (!ctx) {
            return null;
          }
          return domPath(ctx) + " " + selector2;
        }).filter(Boolean).join(",");
        context = document;
      }
      try {
        return context[queryFn](selector);
      } catch (e) {
        return null;
      }
    }
    var contextSelectorRe = /(^|[^\\],)\s*[!>+~-]/;
    var contextSanitizeRe = /([!>+~-])(?=\s+[!>+~-]|\s*$)/g;
    var isContextSelector = memoize(function(selector) {
      return selector.match(contextSelectorRe);
    });
    var selectorRe = /.*?[^\\](?:,|$)/g;
    var splitSelector = memoize(function(selector) {
      return selector.match(selectorRe).map(function(selector2) {
        return selector2.replace(/,$/, "").trim();
      });
    });
    function domPath(element) {
      var names = [];
      while (element.parentNode) {
        var id = attr(element, "id");
        if (id) {
          names.unshift("#" + escape(id));
          break;
        } else {
          var tagName = element.tagName;
          if (tagName !== "HTML") {
            tagName += ":nth-child(" + (index(element) + 1) + ")";
          }
          names.unshift(tagName);
          element = element.parentNode;
        }
      }
      return names.join(" > ");
    }
    var escapeFn = inBrowser && window.CSS && CSS.escape || function(css2) {
      return css2.replace(/([^\x7f-\uFFFF\w-])/g, function(match2) {
        return "\\" + match2;
      });
    };
    function escape(css2) {
      return isString2(css2) ? escapeFn.call(null, css2) : "";
    }
    function on() {
      var args = [], len = arguments.length;
      while (len--)
        args[len] = arguments[len];
      var ref2 = getArgs(args);
      var targets = ref2[0];
      var type = ref2[1];
      var selector = ref2[2];
      var listener = ref2[3];
      var useCapture = ref2[4];
      targets = toEventTargets(targets);
      if (listener.length > 1) {
        listener = detail(listener);
      }
      if (useCapture && useCapture.self) {
        listener = selfFilter(listener);
      }
      if (selector) {
        listener = delegate(selector, listener);
      }
      useCapture = useCaptureFilter(useCapture);
      type.split(" ").forEach(function(type2) {
        return targets.forEach(function(target) {
          return target.addEventListener(type2, listener, useCapture);
        });
      });
      return function() {
        return off(targets, type, listener, useCapture);
      };
    }
    function off(targets, type, listener, useCapture) {
      if (useCapture === void 0)
        useCapture = false;
      useCapture = useCaptureFilter(useCapture);
      targets = toEventTargets(targets);
      type.split(" ").forEach(function(type2) {
        return targets.forEach(function(target) {
          return target.removeEventListener(type2, listener, useCapture);
        });
      });
    }
    function once() {
      var args = [], len = arguments.length;
      while (len--)
        args[len] = arguments[len];
      var ref2 = getArgs(args);
      var element = ref2[0];
      var type = ref2[1];
      var selector = ref2[2];
      var listener = ref2[3];
      var useCapture = ref2[4];
      var condition = ref2[5];
      var off2 = on(element, type, selector, function(e) {
        var result = !condition || condition(e);
        if (result) {
          off2();
          listener(e, result);
        }
      }, useCapture);
      return off2;
    }
    function trigger2(targets, event, detail2) {
      return toEventTargets(targets).reduce(function(notCanceled, target) {
        return notCanceled && target.dispatchEvent(createEvent(event, true, true, detail2));
      }, true);
    }
    function createEvent(e, bubbles, cancelable, detail2) {
      if (bubbles === void 0)
        bubbles = true;
      if (cancelable === void 0)
        cancelable = false;
      if (isString2(e)) {
        var event = document.createEvent("CustomEvent");
        event.initCustomEvent(e, bubbles, cancelable, detail2);
        e = event;
      }
      return e;
    }
    function getArgs(args) {
      if (isFunction2(args[2])) {
        args.splice(2, 0, false);
      }
      return args;
    }
    function delegate(selector, listener) {
      var this$1$1 = this;
      return function(e) {
        var current = selector[0] === ">" ? findAll(selector, e.currentTarget).reverse().filter(function(element) {
          return within(e.target, element);
        })[0] : closest(e.target, selector);
        if (current) {
          e.current = current;
          listener.call(this$1$1, e);
        }
      };
    }
    function detail(listener) {
      return function(e) {
        return isArray2(e.detail) ? listener.apply(void 0, [e].concat(e.detail)) : listener(e);
      };
    }
    function selfFilter(listener) {
      return function(e) {
        if (e.target === e.currentTarget || e.target === e.current) {
          return listener.call(null, e);
        }
      };
    }
    function useCaptureFilter(options) {
      return options && isIE && !isBoolean2(options) ? !!options.capture : options;
    }
    function isEventTarget(target) {
      return target && "addEventListener" in target;
    }
    function toEventTarget(target) {
      return isEventTarget(target) ? target : toNode(target);
    }
    function toEventTargets(target) {
      return isArray2(target) ? target.map(toEventTarget).filter(Boolean) : isString2(target) ? findAll(target) : isEventTarget(target) ? [target] : toNodes(target);
    }
    function isTouch(e) {
      return e.pointerType === "touch" || !!e.touches;
    }
    function getEventPos(e) {
      var touches = e.touches;
      var changedTouches = e.changedTouches;
      var ref2 = touches && touches[0] || changedTouches && changedTouches[0] || e;
      var x = ref2.clientX;
      var y = ref2.clientY;
      return { x, y };
    }
    var Promise$1 = inBrowser && window.Promise || PromiseFn;
    var Deferred = function() {
      var this$1$1 = this;
      this.promise = new Promise$1(function(resolve2, reject) {
        this$1$1.reject = reject;
        this$1$1.resolve = resolve2;
      });
    };
    var RESOLVED = 0;
    var REJECTED = 1;
    var PENDING = 2;
    var async = inBrowser && window.setImmediate || setTimeout;
    function PromiseFn(executor) {
      this.state = PENDING;
      this.value = void 0;
      this.deferred = [];
      var promise = this;
      try {
        executor(function(x) {
          promise.resolve(x);
        }, function(r) {
          promise.reject(r);
        });
      } catch (e) {
        promise.reject(e);
      }
    }
    PromiseFn.reject = function(r) {
      return new PromiseFn(function(resolve2, reject) {
        reject(r);
      });
    };
    PromiseFn.resolve = function(x) {
      return new PromiseFn(function(resolve2, reject) {
        resolve2(x);
      });
    };
    PromiseFn.all = function all2(iterable) {
      return new PromiseFn(function(resolve2, reject) {
        var result = [];
        var count = 0;
        if (iterable.length === 0) {
          resolve2(result);
        }
        function resolver(i2) {
          return function(x) {
            result[i2] = x;
            count += 1;
            if (count === iterable.length) {
              resolve2(result);
            }
          };
        }
        for (var i = 0; i < iterable.length; i += 1) {
          PromiseFn.resolve(iterable[i]).then(resolver(i), reject);
        }
      });
    };
    PromiseFn.race = function race(iterable) {
      return new PromiseFn(function(resolve2, reject) {
        for (var i = 0; i < iterable.length; i += 1) {
          PromiseFn.resolve(iterable[i]).then(resolve2, reject);
        }
      });
    };
    var p2 = PromiseFn.prototype;
    p2.resolve = function resolve2(x) {
      var promise = this;
      if (promise.state === PENDING) {
        if (x === promise) {
          throw new TypeError("Promise settled with itself.");
        }
        var called = false;
        try {
          var then = x && x.then;
          if (x !== null && isObject2(x) && isFunction2(then)) {
            then.call(x, function(x2) {
              if (!called) {
                promise.resolve(x2);
              }
              called = true;
            }, function(r) {
              if (!called) {
                promise.reject(r);
              }
              called = true;
            });
            return;
          }
        } catch (e) {
          if (!called) {
            promise.reject(e);
          }
          return;
        }
        promise.state = RESOLVED;
        promise.value = x;
        promise.notify();
      }
    };
    p2.reject = function reject(reason) {
      var promise = this;
      if (promise.state === PENDING) {
        if (reason === promise) {
          throw new TypeError("Promise settled with itself.");
        }
        promise.state = REJECTED;
        promise.value = reason;
        promise.notify();
      }
    };
    p2.notify = function notify() {
      var this$1$1 = this;
      async(function() {
        if (this$1$1.state !== PENDING) {
          while (this$1$1.deferred.length) {
            var ref2 = this$1$1.deferred.shift();
            var onResolved = ref2[0];
            var onRejected = ref2[1];
            var resolve2 = ref2[2];
            var reject = ref2[3];
            try {
              if (this$1$1.state === RESOLVED) {
                if (isFunction2(onResolved)) {
                  resolve2(onResolved.call(void 0, this$1$1.value));
                } else {
                  resolve2(this$1$1.value);
                }
              } else if (this$1$1.state === REJECTED) {
                if (isFunction2(onRejected)) {
                  resolve2(onRejected.call(void 0, this$1$1.value));
                } else {
                  reject(this$1$1.value);
                }
              }
            } catch (e) {
              reject(e);
            }
          }
        }
      });
    };
    p2.then = function then(onResolved, onRejected) {
      var this$1$1 = this;
      return new PromiseFn(function(resolve2, reject) {
        this$1$1.deferred.push([onResolved, onRejected, resolve2, reject]);
        this$1$1.notify();
      });
    };
    p2.catch = function(onRejected) {
      return this.then(void 0, onRejected);
    };
    function ajax(url, options) {
      var env = assign2({
        data: null,
        method: "GET",
        headers: {},
        xhr: new XMLHttpRequest(),
        beforeSend: noop2,
        responseType: ""
      }, options);
      return Promise$1.resolve().then(function() {
        return env.beforeSend(env);
      }).then(function() {
        return send(url, env);
      });
    }
    function send(url, env) {
      return new Promise$1(function(resolve2, reject) {
        var xhr2 = env.xhr;
        for (var prop in env) {
          if (prop in xhr2) {
            try {
              xhr2[prop] = env[prop];
            } catch (e) {
            }
          }
        }
        xhr2.open(env.method.toUpperCase(), url);
        for (var header in env.headers) {
          xhr2.setRequestHeader(header, env.headers[header]);
        }
        on(xhr2, "load", function() {
          if (xhr2.status === 0 || xhr2.status >= 200 && xhr2.status < 300 || xhr2.status === 304) {
            if (env.responseType === "json" && isString2(xhr2.response)) {
              xhr2 = assign2(copyXhr(xhr2), { response: JSON.parse(xhr2.response) });
            }
            resolve2(xhr2);
          } else {
            reject(assign2(Error(xhr2.statusText), {
              xhr: xhr2,
              status: xhr2.status
            }));
          }
        });
        on(xhr2, "error", function() {
          return reject(assign2(Error("Network Error"), { xhr: xhr2 }));
        });
        on(xhr2, "timeout", function() {
          return reject(assign2(Error("Network Timeout"), { xhr: xhr2 }));
        });
        xhr2.send(env.data);
      });
    }
    function getImage(src, srcset, sizes) {
      return new Promise$1(function(resolve2, reject) {
        var img2 = new Image();
        img2.onerror = function(e) {
          return reject(e);
        };
        img2.onload = function() {
          return resolve2(img2);
        };
        sizes && (img2.sizes = sizes);
        srcset && (img2.srcset = srcset);
        img2.src = src;
      });
    }
    function copyXhr(source2) {
      var target = {};
      for (var key2 in source2) {
        target[key2] = source2[key2];
      }
      return target;
    }
    function ready(fn) {
      if (document.readyState !== "loading") {
        fn();
        return;
      }
      once(document, "DOMContentLoaded", fn);
    }
    function empty(element) {
      element = $(element);
      element.innerHTML = "";
      return element;
    }
    function html(parent2, html2) {
      parent2 = $(parent2);
      return isUndefined2(html2) ? parent2.innerHTML : append(parent2.hasChildNodes() ? empty(parent2) : parent2, html2);
    }
    function prepend(parent2, element) {
      parent2 = $(parent2);
      if (parent2.hasChildNodes()) {
        return insertNodes(element, function(element2) {
          return parent2.insertBefore(element2, parent2.firstChild);
        });
      } else {
        return append(parent2, element);
      }
    }
    function append(parent2, element) {
      parent2 = $(parent2);
      return insertNodes(element, function(element2) {
        return parent2.appendChild(element2);
      });
    }
    function before(ref2, element) {
      ref2 = $(ref2);
      return insertNodes(element, function(element2) {
        return ref2.parentNode.insertBefore(element2, ref2);
      });
    }
    function after(ref2, element) {
      ref2 = $(ref2);
      return insertNodes(element, function(element2) {
        return ref2.nextSibling ? before(ref2.nextSibling, element2) : append(ref2.parentNode, element2);
      });
    }
    function insertNodes(element, fn) {
      element = isString2(element) ? fragment(element) : element;
      return element ? "length" in element ? toNodes(element).map(fn) : fn(element) : null;
    }
    function remove$1(element) {
      toNodes(element).forEach(function(element2) {
        return element2.parentNode && element2.parentNode.removeChild(element2);
      });
    }
    function wrapAll(element, structure) {
      structure = toNode(before(element, structure));
      while (structure.firstChild) {
        structure = structure.firstChild;
      }
      append(structure, element);
      return structure;
    }
    function wrapInner(element, structure) {
      return toNodes(toNodes(element).map(function(element2) {
        return element2.hasChildNodes ? wrapAll(toNodes(element2.childNodes), structure) : append(element2, structure);
      }));
    }
    function unwrap(element) {
      toNodes(element).map(parent).filter(function(value, index2, self2) {
        return self2.indexOf(value) === index2;
      }).forEach(function(parent2) {
        before(parent2, parent2.childNodes);
        remove$1(parent2);
      });
    }
    var fragmentRe = /^\s*<(\w+|!)[^>]*>/;
    var singleTagRe = /^<(\w+)\s*\/?>(?:<\/\1>)?$/;
    function fragment(html2) {
      var matches2 = singleTagRe.exec(html2);
      if (matches2) {
        return document.createElement(matches2[1]);
      }
      var container = document.createElement("div");
      if (fragmentRe.test(html2)) {
        container.insertAdjacentHTML("beforeend", html2.trim());
      } else {
        container.textContent = html2;
      }
      return container.childNodes.length > 1 ? toNodes(container.childNodes) : container.firstChild;
    }
    function apply$1(node, fn) {
      if (!isElement(node)) {
        return;
      }
      fn(node);
      node = node.firstElementChild;
      while (node) {
        var next = node.nextElementSibling;
        apply$1(node, fn);
        node = next;
      }
    }
    function $(selector, context) {
      return isHtml(selector) ? toNode(fragment(selector)) : find(selector, context);
    }
    function $$(selector, context) {
      return isHtml(selector) ? toNodes(fragment(selector)) : findAll(selector, context);
    }
    function isHtml(str) {
      return isString2(str) && (str[0] === "<" || str.match(/^\s*</));
    }
    function addClass(element) {
      var args = [], len = arguments.length - 1;
      while (len-- > 0)
        args[len] = arguments[len + 1];
      apply2(element, args, "add");
    }
    function removeClass(element) {
      var args = [], len = arguments.length - 1;
      while (len-- > 0)
        args[len] = arguments[len + 1];
      apply2(element, args, "remove");
    }
    function removeClasses(element, cls) {
      attr(element, "class", function(value) {
        return (value || "").replace(new RegExp("\\b" + cls + "\\b", "g"), "");
      });
    }
    function replaceClass(element) {
      var args = [], len = arguments.length - 1;
      while (len-- > 0)
        args[len] = arguments[len + 1];
      args[0] && removeClass(element, args[0]);
      args[1] && addClass(element, args[1]);
    }
    function hasClass(element, cls) {
      var assign3;
      assign3 = getClasses(cls), cls = assign3[0];
      var nodes = toNodes(element);
      for (var n = 0; n < nodes.length; n++) {
        if (cls && nodes[n].classList.contains(cls)) {
          return true;
        }
      }
      return false;
    }
    function toggleClass(element, cls, force) {
      cls = getClasses(cls);
      var nodes = toNodes(element);
      for (var n = 0; n < nodes.length; n++) {
        var list = nodes[n].classList;
        for (var i = 0; i < cls.length; i++) {
          if (isUndefined2(force)) {
            list.toggle(cls[i]);
          } else if (supports.Force) {
            list.toggle(cls[i], !!force);
          } else {
            list[force ? "add" : "remove"](cls[i]);
          }
        }
      }
    }
    function apply2(element, args, fn) {
      var ref2;
      args = args.reduce(function(args2, arg) {
        return args2.concat(getClasses(arg));
      }, []);
      var nodes = toNodes(element);
      var loop = function(n2) {
        if (supports.Multiple) {
          (ref2 = nodes[n2].classList)[fn].apply(ref2, args);
        } else {
          args.forEach(function(cls) {
            return nodes[n2].classList[fn](cls);
          });
        }
      };
      for (var n = 0; n < nodes.length; n++)
        loop(n);
    }
    function getClasses(str) {
      return String(str).split(/\s|,/).filter(Boolean);
    }
    var supports = {
      get Multiple() {
        return this.get("Multiple");
      },
      get Force() {
        return this.get("Force");
      },
      get: function(key2) {
        var ref2 = document.createElement("_");
        var classList = ref2.classList;
        classList.add("a", "b");
        classList.toggle("c", false);
        supports = {
          Multiple: classList.contains("b"),
          Force: !classList.contains("c")
        };
        return supports[key2];
      }
    };
    var cssNumber = {
      "animation-iteration-count": true,
      "column-count": true,
      "fill-opacity": true,
      "flex-grow": true,
      "flex-shrink": true,
      "font-weight": true,
      "line-height": true,
      "opacity": true,
      "order": true,
      "orphans": true,
      "stroke-dasharray": true,
      "stroke-dashoffset": true,
      "widows": true,
      "z-index": true,
      "zoom": true
    };
    function css(element, property, value, priority) {
      if (priority === void 0)
        priority = "";
      return toNodes(element).map(function(element2) {
        if (isString2(property)) {
          property = propName(property);
          if (isUndefined2(value)) {
            return getStyle(element2, property);
          } else if (!value && !isNumber2(value)) {
            element2.style.removeProperty(property);
          } else {
            element2.style.setProperty(property, isNumeric(value) && !cssNumber[property] ? value + "px" : value, priority);
          }
        } else if (isArray2(property)) {
          var styles = getStyles(element2);
          return property.reduce(function(props2, property2) {
            props2[property2] = styles[propName(property2)];
            return props2;
          }, {});
        } else if (isObject2(property)) {
          priority = value;
          each(property, function(value2, property2) {
            return css(element2, property2, value2, priority);
          });
        }
        return element2;
      })[0];
    }
    function getStyles(element, pseudoElt) {
      return toWindow(element).getComputedStyle(element, pseudoElt);
    }
    function getStyle(element, property, pseudoElt) {
      return getStyles(element, pseudoElt)[property];
    }
    var parseCssVar = memoize(function(name) {
      var element = append(document.documentElement, fragment("<div>"));
      addClass(element, "uk-" + name);
      var value = getStyle(element, "content", ":before");
      remove$1(element);
      return value;
    });
    var propertyRe = /^\s*(["'])?(.*?)\1\s*$/;
    function getCssVar(name) {
      return (isIE ? parseCssVar(name) : getStyles(document.documentElement).getPropertyValue("--uk-" + name)).replace(propertyRe, "$2");
    }
    var propName = memoize(function(name) {
      return vendorPropName(name);
    });
    var cssPrefixes = ["webkit", "moz", "ms"];
    function vendorPropName(name) {
      name = hyphenate2(name);
      var ref2 = document.documentElement;
      var style = ref2.style;
      if (name in style) {
        return name;
      }
      var i = cssPrefixes.length, prefixedName;
      while (i--) {
        prefixedName = "-" + cssPrefixes[i] + "-" + name;
        if (prefixedName in style) {
          return prefixedName;
        }
      }
    }
    function transition(element, props2, duration, timing) {
      if (duration === void 0)
        duration = 400;
      if (timing === void 0)
        timing = "linear";
      return Promise$1.all(toNodes(element).map(function(element2) {
        return new Promise$1(function(resolve2, reject) {
          for (var name in props2) {
            var value = css(element2, name);
            if (value === "") {
              css(element2, name, value);
            }
          }
          var timer = setTimeout(function() {
            return trigger2(element2, "transitionend");
          }, duration);
          once(element2, "transitionend transitioncanceled", function(ref2) {
            var type = ref2.type;
            clearTimeout(timer);
            removeClass(element2, "uk-transition");
            css(element2, {
              transitionProperty: "",
              transitionDuration: "",
              transitionTimingFunction: ""
            });
            type === "transitioncanceled" ? reject() : resolve2(element2);
          }, { self: true });
          addClass(element2, "uk-transition");
          css(element2, assign2({
            transitionProperty: Object.keys(props2).map(propName).join(","),
            transitionDuration: duration + "ms",
            transitionTimingFunction: timing
          }, props2));
        });
      }));
    }
    var Transition2 = {
      start: transition,
      stop: function(element) {
        trigger2(element, "transitionend");
        return Promise$1.resolve();
      },
      cancel: function(element) {
        trigger2(element, "transitioncanceled");
      },
      inProgress: function(element) {
        return hasClass(element, "uk-transition");
      }
    };
    var animationPrefix = "uk-animation-";
    function animate$1(element, animation, duration, origin, out) {
      if (duration === void 0)
        duration = 200;
      return Promise$1.all(toNodes(element).map(function(element2) {
        return new Promise$1(function(resolve2, reject) {
          trigger2(element2, "animationcanceled");
          var timer = setTimeout(function() {
            return trigger2(element2, "animationend");
          }, duration);
          once(element2, "animationend animationcanceled", function(ref2) {
            var type = ref2.type;
            clearTimeout(timer);
            type === "animationcanceled" ? reject() : resolve2(element2);
            css(element2, "animationDuration", "");
            removeClasses(element2, animationPrefix + "\\S*");
          }, { self: true });
          css(element2, "animationDuration", duration + "ms");
          addClass(element2, animation, animationPrefix + (out ? "leave" : "enter"));
          if (startsWith(animation, animationPrefix)) {
            origin && addClass(element2, "uk-transform-origin-" + origin);
            out && addClass(element2, animationPrefix + "reverse");
          }
        });
      }));
    }
    var inProgress = new RegExp(animationPrefix + "(enter|leave)");
    var Animation = {
      in: animate$1,
      out: function(element, animation, duration, origin) {
        return animate$1(element, animation, duration, origin, true);
      },
      inProgress: function(element) {
        return inProgress.test(attr(element, "class"));
      },
      cancel: function(element) {
        trigger2(element, "animationcanceled");
      }
    };
    var dirs$1 = {
      width: ["left", "right"],
      height: ["top", "bottom"]
    };
    function dimensions(element) {
      var rect = isElement(element) ? toNode(element).getBoundingClientRect() : { height: height(element), width: width(element), top: 0, left: 0 };
      return {
        height: rect.height,
        width: rect.width,
        top: rect.top,
        left: rect.left,
        bottom: rect.top + rect.height,
        right: rect.left + rect.width
      };
    }
    function offset(element, coordinates) {
      var currentOffset = dimensions(element);
      if (element) {
        var ref2 = toWindow(element);
        var pageYOffset = ref2.pageYOffset;
        var pageXOffset = ref2.pageXOffset;
        var offsetBy = { height: pageYOffset, width: pageXOffset };
        for (var dir in dirs$1) {
          for (var i in dirs$1[dir]) {
            currentOffset[dirs$1[dir][i]] += offsetBy[dir];
          }
        }
      }
      if (!coordinates) {
        return currentOffset;
      }
      var pos = css(element, "position");
      each(css(element, ["left", "top"]), function(value, prop) {
        return css(element, prop, coordinates[prop] - currentOffset[prop] + toFloat(pos === "absolute" && value === "auto" ? position(element)[prop] : value));
      });
    }
    function position(element) {
      var ref2 = offset(element);
      var top = ref2.top;
      var left = ref2.left;
      var ref$1 = toNode(element);
      var ref$1_ownerDocument = ref$1.ownerDocument;
      var body = ref$1_ownerDocument.body;
      var documentElement = ref$1_ownerDocument.documentElement;
      var offsetParent = ref$1.offsetParent;
      var parent2 = offsetParent || documentElement;
      while (parent2 && (parent2 === body || parent2 === documentElement) && css(parent2, "position") === "static") {
        parent2 = parent2.parentNode;
      }
      if (isElement(parent2)) {
        var parentOffset = offset(parent2);
        top -= parentOffset.top + toFloat(css(parent2, "borderTopWidth"));
        left -= parentOffset.left + toFloat(css(parent2, "borderLeftWidth"));
      }
      return {
        top: top - toFloat(css(element, "marginTop")),
        left: left - toFloat(css(element, "marginLeft"))
      };
    }
    function offsetPosition(element) {
      var offset2 = [0, 0];
      element = toNode(element);
      do {
        offset2[0] += element.offsetTop;
        offset2[1] += element.offsetLeft;
        if (css(element, "position") === "fixed") {
          var win = toWindow(element);
          offset2[0] += win.pageYOffset;
          offset2[1] += win.pageXOffset;
          return offset2;
        }
      } while (element = element.offsetParent);
      return offset2;
    }
    var height = dimension("height");
    var width = dimension("width");
    function dimension(prop) {
      var propName2 = ucfirst(prop);
      return function(element, value) {
        if (isUndefined2(value)) {
          if (isWindow(element)) {
            return element["inner" + propName2];
          }
          if (isDocument(element)) {
            var doc2 = element.documentElement;
            return Math.max(doc2["offset" + propName2], doc2["scroll" + propName2]);
          }
          element = toNode(element);
          value = css(element, prop);
          value = value === "auto" ? element["offset" + propName2] : toFloat(value) || 0;
          return value - boxModelAdjust(element, prop);
        } else {
          return css(element, prop, !value && value !== 0 ? "" : +value + boxModelAdjust(element, prop) + "px");
        }
      };
    }
    function boxModelAdjust(element, prop, sizing) {
      if (sizing === void 0)
        sizing = "border-box";
      return css(element, "boxSizing") === sizing ? dirs$1[prop].map(ucfirst).reduce(function(value, prop2) {
        return value + toFloat(css(element, "padding" + prop2)) + toFloat(css(element, "border" + prop2 + "Width"));
      }, 0) : 0;
    }
    function flipPosition(pos) {
      for (var dir in dirs$1) {
        for (var i in dirs$1[dir]) {
          if (dirs$1[dir][i] === pos) {
            return dirs$1[dir][1 - i];
          }
        }
      }
      return pos;
    }
    function toPx(value, property, element) {
      if (property === void 0)
        property = "width";
      if (element === void 0)
        element = window;
      return isNumeric(value) ? +value : endsWith(value, "vh") ? percent(height(toWindow(element)), value) : endsWith(value, "vw") ? percent(width(toWindow(element)), value) : endsWith(value, "%") ? percent(dimensions(element)[property], value) : toFloat(value);
    }
    function percent(base, value) {
      return base * toFloat(value) / 100;
    }
    var fastdom = {
      reads: [],
      writes: [],
      read: function(task) {
        this.reads.push(task);
        scheduleFlush();
        return task;
      },
      write: function(task) {
        this.writes.push(task);
        scheduleFlush();
        return task;
      },
      clear: function(task) {
        remove2(this.reads, task);
        remove2(this.writes, task);
      },
      flush
    };
    function flush(recursion) {
      if (recursion === void 0)
        recursion = 1;
      runTasks(fastdom.reads);
      runTasks(fastdom.writes.splice(0));
      fastdom.scheduled = false;
      if (fastdom.reads.length || fastdom.writes.length) {
        scheduleFlush(recursion + 1);
      }
    }
    var RECURSION_LIMIT = 4;
    function scheduleFlush(recursion) {
      if (fastdom.scheduled) {
        return;
      }
      fastdom.scheduled = true;
      if (recursion && recursion < RECURSION_LIMIT) {
        Promise$1.resolve().then(function() {
          return flush(recursion);
        });
      } else {
        requestAnimationFrame(function() {
          return flush();
        });
      }
    }
    function runTasks(tasks) {
      var task;
      while (task = tasks.shift()) {
        try {
          task();
        } catch (e) {
          console.error(e);
        }
      }
    }
    function remove2(array, item) {
      var index2 = array.indexOf(item);
      return ~index2 && array.splice(index2, 1);
    }
    function MouseTracker() {
    }
    MouseTracker.prototype = {
      positions: [],
      init: function() {
        var this$1$1 = this;
        this.positions = [];
        var position2;
        this.unbind = on(document, "mousemove", function(e) {
          return position2 = getEventPos(e);
        });
        this.interval = setInterval(function() {
          if (!position2) {
            return;
          }
          this$1$1.positions.push(position2);
          if (this$1$1.positions.length > 5) {
            this$1$1.positions.shift();
          }
        }, 50);
      },
      cancel: function() {
        this.unbind && this.unbind();
        this.interval && clearInterval(this.interval);
      },
      movesTo: function(target) {
        if (this.positions.length < 2) {
          return false;
        }
        var p3 = target.getBoundingClientRect();
        var left = p3.left;
        var right = p3.right;
        var top = p3.top;
        var bottom = p3.bottom;
        var ref2 = this.positions;
        var prevPosition = ref2[0];
        var position2 = last(this.positions);
        var path = [prevPosition, position2];
        if (pointInRect(position2, p3)) {
          return false;
        }
        var diagonals = [[{ x: left, y: top }, { x: right, y: bottom }], [{ x: left, y: bottom }, { x: right, y: top }]];
        return diagonals.some(function(diagonal) {
          var intersection = intersect(path, diagonal);
          return intersection && pointInRect(intersection, p3);
        });
      }
    };
    function intersect(ref2, ref$1) {
      var ref_0 = ref2[0];
      var x1 = ref_0.x;
      var y1 = ref_0.y;
      var ref_1 = ref2[1];
      var x2 = ref_1.x;
      var y2 = ref_1.y;
      var ref$1_0 = ref$1[0];
      var x3 = ref$1_0.x;
      var y3 = ref$1_0.y;
      var ref$1_1 = ref$1[1];
      var x4 = ref$1_1.x;
      var y4 = ref$1_1.y;
      var denominator = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
      if (denominator === 0) {
        return false;
      }
      var ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denominator;
      if (ua < 0) {
        return false;
      }
      return { x: x1 + ua * (x2 - x1), y: y1 + ua * (y2 - y1) };
    }
    var strats = {};
    strats.events = strats.created = strats.beforeConnect = strats.connected = strats.beforeDisconnect = strats.disconnected = strats.destroy = concatStrat;
    strats.args = function(parentVal, childVal) {
      return childVal !== false && concatStrat(childVal || parentVal);
    };
    strats.update = function(parentVal, childVal) {
      return sortBy$1(concatStrat(parentVal, isFunction2(childVal) ? { read: childVal } : childVal), "order");
    };
    strats.props = function(parentVal, childVal) {
      if (isArray2(childVal)) {
        childVal = childVal.reduce(function(value, key2) {
          value[key2] = String;
          return value;
        }, {});
      }
      return strats.methods(parentVal, childVal);
    };
    strats.computed = strats.methods = function(parentVal, childVal) {
      return childVal ? parentVal ? assign2({}, parentVal, childVal) : childVal : parentVal;
    };
    strats.data = function(parentVal, childVal, vm) {
      if (!vm) {
        if (!childVal) {
          return parentVal;
        }
        if (!parentVal) {
          return childVal;
        }
        return function(vm2) {
          return mergeFnData(parentVal, childVal, vm2);
        };
      }
      return mergeFnData(parentVal, childVal, vm);
    };
    function mergeFnData(parentVal, childVal, vm) {
      return strats.computed(isFunction2(parentVal) ? parentVal.call(vm, vm) : parentVal, isFunction2(childVal) ? childVal.call(vm, vm) : childVal);
    }
    function concatStrat(parentVal, childVal) {
      parentVal = parentVal && !isArray2(parentVal) ? [parentVal] : parentVal;
      return childVal ? parentVal ? parentVal.concat(childVal) : isArray2(childVal) ? childVal : [childVal] : parentVal;
    }
    function defaultStrat(parentVal, childVal) {
      return isUndefined2(childVal) ? parentVal : childVal;
    }
    function mergeOptions2(parent2, child, vm) {
      var options = {};
      if (isFunction2(child)) {
        child = child.options;
      }
      if (child.extends) {
        parent2 = mergeOptions2(parent2, child.extends, vm);
      }
      if (child.mixins) {
        for (var i = 0, l = child.mixins.length; i < l; i++) {
          parent2 = mergeOptions2(parent2, child.mixins[i], vm);
        }
      }
      for (var key2 in parent2) {
        mergeKey(key2);
      }
      for (var key$1 in child) {
        if (!hasOwn2(parent2, key$1)) {
          mergeKey(key$1);
        }
      }
      function mergeKey(key3) {
        options[key3] = (strats[key3] || defaultStrat)(parent2[key3], child[key3], vm);
      }
      return options;
    }
    function parseOptions(options, args) {
      var obj2;
      if (args === void 0)
        args = [];
      try {
        return !options ? {} : startsWith(options, "{") ? JSON.parse(options) : args.length && !includes(options, ":") ? (obj2 = {}, obj2[args[0]] = options, obj2) : options.split(";").reduce(function(options2, option) {
          var ref2 = option.split(/:(.*)/);
          var key2 = ref2[0];
          var value = ref2[1];
          if (key2 && !isUndefined2(value)) {
            options2[key2.trim()] = value.trim();
          }
          return options2;
        }, {});
      } catch (e) {
        return {};
      }
    }
    function play(el) {
      if (isIFrame(el)) {
        call(el, { func: "playVideo", method: "play" });
      }
      if (isHTML5(el)) {
        try {
          el.play().catch(noop2);
        } catch (e) {
        }
      }
    }
    function pause(el) {
      if (isIFrame(el)) {
        call(el, { func: "pauseVideo", method: "pause" });
      }
      if (isHTML5(el)) {
        el.pause();
      }
    }
    function mute(el) {
      if (isIFrame(el)) {
        call(el, { func: "mute", method: "setVolume", value: 0 });
      }
      if (isHTML5(el)) {
        el.muted = true;
      }
    }
    function isVideo(el) {
      return isHTML5(el) || isIFrame(el);
    }
    function isHTML5(el) {
      return el && el.tagName === "VIDEO";
    }
    function isIFrame(el) {
      return el && el.tagName === "IFRAME" && (isYoutube(el) || isVimeo(el));
    }
    function isYoutube(el) {
      return !!el.src.match(/\/\/.*?youtube(-nocookie)?\.[a-z]+\/(watch\?v=[^&\s]+|embed)|youtu\.be\/.*/);
    }
    function isVimeo(el) {
      return !!el.src.match(/vimeo\.com\/video\/.*/);
    }
    function call(el, cmd) {
      enableApi(el).then(function() {
        return post(el, cmd);
      });
    }
    function post(el, cmd) {
      try {
        el.contentWindow.postMessage(JSON.stringify(assign2({ event: "command" }, cmd)), "*");
      } catch (e) {
      }
    }
    var stateKey$1 = "_ukPlayer";
    var counter = 0;
    function enableApi(el) {
      if (el[stateKey$1]) {
        return el[stateKey$1];
      }
      var youtube = isYoutube(el);
      var vimeo = isVimeo(el);
      var id = ++counter;
      var poller;
      return el[stateKey$1] = new Promise$1(function(resolve2) {
        youtube && once(el, "load", function() {
          var listener = function() {
            return post(el, { event: "listening", id });
          };
          poller = setInterval(listener, 100);
          listener();
        });
        once(window, "message", resolve2, false, function(ref2) {
          var data3 = ref2.data;
          try {
            data3 = JSON.parse(data3);
            return data3 && (youtube && data3.id === id && data3.event === "onReady" || vimeo && Number(data3.player_id) === id);
          } catch (e) {
          }
        });
        el.src = "" + el.src + (includes(el.src, "?") ? "&" : "?") + (youtube ? "enablejsapi=1" : "api=1&player_id=" + id);
      }).then(function() {
        return clearInterval(poller);
      });
    }
    function isInView(element, offsetTop, offsetLeft) {
      if (offsetTop === void 0)
        offsetTop = 0;
      if (offsetLeft === void 0)
        offsetLeft = 0;
      if (!isVisible(element)) {
        return false;
      }
      return intersectRect.apply(void 0, scrollParents(element).map(function(parent2) {
        var ref2 = offset(getViewport$1(parent2));
        var top = ref2.top;
        var left = ref2.left;
        var bottom = ref2.bottom;
        var right = ref2.right;
        return {
          top: top - offsetTop,
          left: left - offsetLeft,
          bottom: bottom + offsetTop,
          right: right + offsetLeft
        };
      }).concat(offset(element)));
    }
    function scrollTop(element, top) {
      if (isWindow(element) || isDocument(element)) {
        element = getScrollingElement(element);
      } else {
        element = toNode(element);
      }
      element.scrollTop = top;
    }
    function scrollIntoView(element, ref2) {
      if (ref2 === void 0)
        ref2 = {};
      var offsetBy = ref2.offset;
      if (offsetBy === void 0)
        offsetBy = 0;
      var parents2 = isVisible(element) ? scrollParents(element) : [];
      return parents2.reduce(function(fn, scrollElement, i) {
        var scrollTop2 = scrollElement.scrollTop;
        var scrollHeight = scrollElement.scrollHeight;
        var offsetHeight = scrollElement.offsetHeight;
        var maxScroll = scrollHeight - getViewportClientHeight(scrollElement);
        var ref3 = offset(parents2[i - 1] || element);
        var elHeight = ref3.height;
        var elTop = ref3.top;
        var top = Math.ceil(elTop - offset(getViewport$1(scrollElement)).top - offsetBy + scrollTop2);
        if (offsetBy > 0 && offsetHeight < elHeight + offsetBy) {
          top += offsetBy;
        } else {
          offsetBy = 0;
        }
        if (top > maxScroll) {
          offsetBy -= top - maxScroll;
          top = maxScroll;
        } else if (top < 0) {
          offsetBy -= top;
          top = 0;
        }
        return function() {
          return scrollTo(scrollElement, top - scrollTop2).then(fn);
        };
      }, function() {
        return Promise$1.resolve();
      })();
      function scrollTo(element2, top) {
        return new Promise$1(function(resolve2) {
          var scroll2 = element2.scrollTop;
          var duration = getDuration(Math.abs(top));
          var start = Date.now();
          (function step() {
            var percent2 = ease2(clamp((Date.now() - start) / duration));
            scrollTop(element2, scroll2 + top * percent2);
            if (percent2 === 1) {
              resolve2();
            } else {
              requestAnimationFrame(step);
            }
          })();
        });
      }
      function getDuration(dist) {
        return 40 * Math.pow(dist, 0.375);
      }
      function ease2(k) {
        return 0.5 * (1 - Math.cos(Math.PI * k));
      }
    }
    function scrolledOver(element, heightOffset) {
      if (heightOffset === void 0)
        heightOffset = 0;
      if (!isVisible(element)) {
        return 0;
      }
      var ref2 = scrollParents(element, /auto|scroll/, true);
      var scrollElement = ref2[0];
      var scrollHeight = scrollElement.scrollHeight;
      var scrollTop2 = scrollElement.scrollTop;
      var clientHeight = getViewportClientHeight(scrollElement);
      var viewportTop = offsetPosition(element)[0] - scrollTop2 - offsetPosition(scrollElement)[0];
      var viewportDist = Math.min(clientHeight, viewportTop + scrollTop2);
      var top = viewportTop - viewportDist;
      var dist = Math.min(element.offsetHeight + heightOffset + viewportDist, scrollHeight - (viewportTop + scrollTop2), scrollHeight - clientHeight);
      return clamp(-1 * top / dist);
    }
    function scrollParents(element, overflowRe, scrollable) {
      if (overflowRe === void 0)
        overflowRe = /auto|scroll|hidden/;
      if (scrollable === void 0)
        scrollable = false;
      var scrollEl = getScrollingElement(element);
      var ancestors = parents(element).reverse();
      ancestors = ancestors.slice(ancestors.indexOf(scrollEl) + 1);
      var fixedIndex = findIndex(ancestors, function(el) {
        return css(el, "position") === "fixed";
      });
      if (~fixedIndex) {
        ancestors = ancestors.slice(fixedIndex);
      }
      return [scrollEl].concat(ancestors.filter(function(parent2) {
        return overflowRe.test(css(parent2, "overflow")) && (!scrollable || parent2.scrollHeight > getViewportClientHeight(parent2));
      })).reverse();
    }
    function getViewport$1(scrollElement) {
      return scrollElement === getScrollingElement(scrollElement) ? window : scrollElement;
    }
    function getViewportClientHeight(scrollElement) {
      return (scrollElement === getScrollingElement(scrollElement) ? document.documentElement : scrollElement).clientHeight;
    }
    function getScrollingElement(element) {
      var ref2 = toWindow(element);
      var document2 = ref2.document;
      return document2.scrollingElement || document2.documentElement;
    }
    var dirs = {
      width: ["x", "left", "right"],
      height: ["y", "top", "bottom"]
    };
    function positionAt(element, target, elAttach, targetAttach, elOffset, targetOffset, flip, boundary) {
      elAttach = getPos(elAttach);
      targetAttach = getPos(targetAttach);
      var flipped = { element: elAttach, target: targetAttach };
      if (!element || !target) {
        return flipped;
      }
      var dim = offset(element);
      var targetDim = offset(target);
      var position2 = targetDim;
      moveTo(position2, elAttach, dim, -1);
      moveTo(position2, targetAttach, targetDim, 1);
      elOffset = getOffsets(elOffset, dim.width, dim.height);
      targetOffset = getOffsets(targetOffset, targetDim.width, targetDim.height);
      elOffset["x"] += targetOffset["x"];
      elOffset["y"] += targetOffset["y"];
      position2.left += elOffset["x"];
      position2.top += elOffset["y"];
      if (flip) {
        var boundaries = scrollParents(element).map(getViewport$1);
        if (boundary && !includes(boundaries, boundary)) {
          boundaries.unshift(boundary);
        }
        boundaries = boundaries.map(function(el) {
          return offset(el);
        });
        each(dirs, function(ref2, prop) {
          var dir = ref2[0];
          var align = ref2[1];
          var alignFlip = ref2[2];
          if (!(flip === true || includes(flip, dir))) {
            return;
          }
          boundaries.some(function(boundary2) {
            var elemOffset = elAttach[dir] === align ? -dim[prop] : elAttach[dir] === alignFlip ? dim[prop] : 0;
            var targetOffset2 = targetAttach[dir] === align ? targetDim[prop] : targetAttach[dir] === alignFlip ? -targetDim[prop] : 0;
            if (position2[align] < boundary2[align] || position2[align] + dim[prop] > boundary2[alignFlip]) {
              var centerOffset = dim[prop] / 2;
              var centerTargetOffset = targetAttach[dir] === "center" ? -targetDim[prop] / 2 : 0;
              return elAttach[dir] === "center" && (apply3(centerOffset, centerTargetOffset) || apply3(-centerOffset, -centerTargetOffset)) || apply3(elemOffset, targetOffset2);
            }
            function apply3(elemOffset2, targetOffset3) {
              var newVal = toFloat((position2[align] + elemOffset2 + targetOffset3 - elOffset[dir] * 2).toFixed(4));
              if (newVal >= boundary2[align] && newVal + dim[prop] <= boundary2[alignFlip]) {
                position2[align] = newVal;
                ["element", "target"].forEach(function(el) {
                  flipped[el][dir] = !elemOffset2 ? flipped[el][dir] : flipped[el][dir] === dirs[prop][1] ? dirs[prop][2] : dirs[prop][1];
                });
                return true;
              }
            }
          });
        });
      }
      offset(element, position2);
      return flipped;
    }
    function moveTo(position2, attach, dim, factor) {
      each(dirs, function(ref2, prop) {
        var dir = ref2[0];
        var align = ref2[1];
        var alignFlip = ref2[2];
        if (attach[dir] === alignFlip) {
          position2[align] += dim[prop] * factor;
        } else if (attach[dir] === "center") {
          position2[align] += dim[prop] * factor / 2;
        }
      });
    }
    function getPos(pos) {
      var x = /left|center|right/;
      var y = /top|center|bottom/;
      pos = (pos || "").split(" ");
      if (pos.length === 1) {
        pos = x.test(pos[0]) ? pos.concat("center") : y.test(pos[0]) ? ["center"].concat(pos) : ["center", "center"];
      }
      return {
        x: x.test(pos[0]) ? pos[0] : "center",
        y: y.test(pos[1]) ? pos[1] : "center"
      };
    }
    function getOffsets(offsets, width2, height2) {
      var ref2 = (offsets || "").split(" ");
      var x = ref2[0];
      var y = ref2[1];
      return {
        x: x ? toFloat(x) * (endsWith(x, "%") ? width2 / 100 : 1) : 0,
        y: y ? toFloat(y) * (endsWith(y, "%") ? height2 / 100 : 1) : 0
      };
    }
    var util = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      ajax,
      getImage,
      transition,
      Transition: Transition2,
      animate: animate$1,
      Animation,
      attr,
      hasAttr,
      removeAttr,
      data: data2,
      addClass,
      removeClass,
      removeClasses,
      replaceClass,
      hasClass,
      toggleClass,
      dimensions,
      offset,
      position,
      offsetPosition,
      height,
      width,
      boxModelAdjust,
      flipPosition,
      toPx,
      ready,
      empty,
      html,
      prepend,
      append,
      before,
      after,
      remove: remove$1,
      wrapAll,
      wrapInner,
      unwrap,
      fragment,
      apply: apply$1,
      $,
      $$,
      inBrowser,
      isIE,
      isRtl,
      hasTouch,
      pointerDown,
      pointerMove,
      pointerUp,
      pointerEnter,
      pointerLeave,
      pointerCancel,
      on,
      off,
      once,
      trigger: trigger2,
      createEvent,
      toEventTargets,
      isTouch,
      getEventPos,
      fastdom,
      isVoidElement,
      isVisible,
      selInput,
      isInput,
      selFocusable,
      isFocusable,
      parent,
      filter: filter$1,
      matches,
      closest,
      within,
      parents,
      children,
      index,
      hasOwn: hasOwn2,
      hyphenate: hyphenate2,
      camelize: camelize2,
      ucfirst,
      startsWith,
      endsWith,
      includes,
      findIndex,
      isArray: isArray2,
      isFunction: isFunction2,
      isObject: isObject2,
      isPlainObject: isPlainObject2,
      isWindow,
      isDocument,
      isNode,
      isElement,
      isBoolean: isBoolean2,
      isString: isString2,
      isNumber: isNumber2,
      isNumeric,
      isEmpty,
      isUndefined: isUndefined2,
      toBoolean,
      toNumber: toNumber2,
      toFloat,
      toArray,
      toNode,
      toNodes,
      toWindow,
      toMs: toMs2,
      isEqual,
      swap,
      assign: assign2,
      last,
      each,
      sortBy: sortBy$1,
      uniqueBy,
      clamp,
      noop: noop2,
      intersectRect,
      pointInRect,
      Dimensions,
      getIndex,
      memoize,
      MouseTracker,
      mergeOptions: mergeOptions2,
      parseOptions,
      play,
      pause,
      mute,
      isVideo,
      positionAt,
      Promise: Promise$1,
      Deferred,
      query,
      queryAll,
      find,
      findAll,
      escape,
      css,
      getCssVar,
      propName,
      isInView,
      scrollTop,
      scrollIntoView,
      scrolledOver,
      scrollParents,
      getViewport: getViewport$1,
      getViewportClientHeight
    });
    function globalAPI(UIkit3) {
      var DATA = UIkit3.data;
      UIkit3.use = function(plugin) {
        if (plugin.installed) {
          return;
        }
        plugin.call(null, this);
        plugin.installed = true;
        return this;
      };
      UIkit3.mixin = function(mixin, component) {
        component = (isString2(component) ? UIkit3.component(component) : component) || this;
        component.options = mergeOptions2(component.options, mixin);
      };
      UIkit3.extend = function(options) {
        options = options || {};
        var Super = this;
        var Sub = function UIkitComponent(options2) {
          this._init(options2);
        };
        Sub.prototype = Object.create(Super.prototype);
        Sub.prototype.constructor = Sub;
        Sub.options = mergeOptions2(Super.options, options);
        Sub.super = Super;
        Sub.extend = Super.extend;
        return Sub;
      };
      UIkit3.update = function(element, e) {
        element = element ? toNode(element) : document.body;
        parents(element).reverse().forEach(function(element2) {
          return update(element2[DATA], e);
        });
        apply$1(element, function(element2) {
          return update(element2[DATA], e);
        });
      };
      var container;
      Object.defineProperty(UIkit3, "container", {
        get: function() {
          return container || document.body;
        },
        set: function(element) {
          container = $(element);
        }
      });
      function update(data3, e) {
        if (!data3) {
          return;
        }
        for (var name in data3) {
          if (data3[name]._connected) {
            data3[name]._callUpdate(e);
          }
        }
      }
    }
    function hooksAPI(UIkit3) {
      UIkit3.prototype._callHook = function(hook) {
        var this$1$1 = this;
        var handlers = this.$options[hook];
        if (handlers) {
          handlers.forEach(function(handler) {
            return handler.call(this$1$1);
          });
        }
      };
      UIkit3.prototype._callConnected = function() {
        if (this._connected) {
          return;
        }
        this._data = {};
        this._computeds = {};
        this._initProps();
        this._callHook("beforeConnect");
        this._connected = true;
        this._initEvents();
        this._initObservers();
        this._callHook("connected");
        this._callUpdate();
      };
      UIkit3.prototype._callDisconnected = function() {
        if (!this._connected) {
          return;
        }
        this._callHook("beforeDisconnect");
        this._disconnectObservers();
        this._unbindEvents();
        this._callHook("disconnected");
        this._connected = false;
        delete this._watch;
      };
      UIkit3.prototype._callUpdate = function(e) {
        var this$1$1 = this;
        if (e === void 0)
          e = "update";
        if (!this._connected) {
          return;
        }
        if (e === "update" || e === "resize") {
          this._callWatches();
        }
        if (!this.$options.update) {
          return;
        }
        if (!this._updates) {
          this._updates = new Set();
          fastdom.read(function() {
            if (this$1$1._connected) {
              runUpdates.call(this$1$1, this$1$1._updates);
            }
            delete this$1$1._updates;
          });
        }
        this._updates.add(e.type || e);
      };
      UIkit3.prototype._callWatches = function() {
        var this$1$1 = this;
        if (this._watch) {
          return;
        }
        var initial = !hasOwn2(this, "_watch");
        this._watch = fastdom.read(function() {
          if (this$1$1._connected) {
            runWatches.call(this$1$1, initial);
          }
          this$1$1._watch = null;
        });
      };
      function runUpdates(types) {
        var this$1$1 = this;
        var updates = this.$options.update;
        var loop = function(i2) {
          var ref2 = updates[i2];
          var read = ref2.read;
          var write = ref2.write;
          var events = ref2.events;
          if (!types.has("update") && (!events || !events.some(function(type) {
            return types.has(type);
          }))) {
            return;
          }
          var result = void 0;
          if (read) {
            result = read.call(this$1$1, this$1$1._data, types);
            if (result && isPlainObject2(result)) {
              assign2(this$1$1._data, result);
            }
          }
          if (write && result !== false) {
            fastdom.write(function() {
              return write.call(this$1$1, this$1$1._data, types);
            });
          }
        };
        for (var i = 0; i < updates.length; i++)
          loop(i);
      }
      function runWatches(initial) {
        var ref2 = this;
        var computed2 = ref2.$options.computed;
        var _computeds = ref2._computeds;
        for (var key2 in computed2) {
          var hasPrev = hasOwn2(_computeds, key2);
          var prev = _computeds[key2];
          delete _computeds[key2];
          var ref$1 = computed2[key2];
          var watch2 = ref$1.watch;
          var immediate = ref$1.immediate;
          if (watch2 && (initial && immediate || hasPrev && !isEqual(prev, this[key2]))) {
            watch2.call(this, this[key2], prev);
          }
        }
      }
    }
    function stateAPI(UIkit3) {
      var uid2 = 0;
      UIkit3.prototype._init = function(options) {
        options = options || {};
        options.data = normalizeData(options, this.constructor.options);
        this.$options = mergeOptions2(this.constructor.options, options, this);
        this.$el = null;
        this.$props = {};
        this._uid = uid2++;
        this._initData();
        this._initMethods();
        this._initComputeds();
        this._callHook("created");
        if (options.el) {
          this.$mount(options.el);
        }
      };
      UIkit3.prototype._initData = function() {
        var ref2 = this.$options;
        var data3 = ref2.data;
        if (data3 === void 0)
          data3 = {};
        for (var key2 in data3) {
          this.$props[key2] = this[key2] = data3[key2];
        }
      };
      UIkit3.prototype._initMethods = function() {
        var ref2 = this.$options;
        var methods = ref2.methods;
        if (methods) {
          for (var key2 in methods) {
            this[key2] = methods[key2].bind(this);
          }
        }
      };
      UIkit3.prototype._initComputeds = function() {
        var ref2 = this.$options;
        var computed2 = ref2.computed;
        this._computeds = {};
        if (computed2) {
          for (var key2 in computed2) {
            registerComputed(this, key2, computed2[key2]);
          }
        }
      };
      UIkit3.prototype._initProps = function(props2) {
        var key2;
        props2 = props2 || getProps2(this.$options, this.$name);
        for (key2 in props2) {
          if (!isUndefined2(props2[key2])) {
            this.$props[key2] = props2[key2];
          }
        }
        var exclude = [this.$options.computed, this.$options.methods];
        for (key2 in this.$props) {
          if (key2 in props2 && notIn(exclude, key2)) {
            this[key2] = this.$props[key2];
          }
        }
      };
      UIkit3.prototype._initEvents = function() {
        var this$1$1 = this;
        this._events = [];
        var ref2 = this.$options;
        var events = ref2.events;
        if (events) {
          events.forEach(function(event) {
            if (hasOwn2(event, "handler")) {
              registerEvent(this$1$1, event);
            } else {
              for (var key2 in event) {
                registerEvent(this$1$1, event[key2], key2);
              }
            }
          });
        }
      };
      UIkit3.prototype._unbindEvents = function() {
        this._events.forEach(function(unbind) {
          return unbind();
        });
        delete this._events;
      };
      UIkit3.prototype._initObservers = function() {
        this._observers = [
          initChildListObserver(this),
          initPropsObserver(this)
        ];
      };
      UIkit3.prototype._disconnectObservers = function() {
        this._observers.forEach(function(observer) {
          return observer && observer.disconnect();
        });
      };
      function getProps2(opts, name) {
        var data$1 = {};
        var args = opts.args;
        if (args === void 0)
          args = [];
        var props2 = opts.props;
        if (props2 === void 0)
          props2 = {};
        var el = opts.el;
        if (!props2) {
          return data$1;
        }
        for (var key2 in props2) {
          var prop = hyphenate2(key2);
          var value = data2(el, prop);
          if (isUndefined2(value)) {
            continue;
          }
          value = props2[key2] === Boolean && value === "" ? true : coerce(props2[key2], value);
          if (prop === "target" && (!value || startsWith(value, "_"))) {
            continue;
          }
          data$1[key2] = value;
        }
        var options = parseOptions(data2(el, name), args);
        for (var key$1 in options) {
          var prop$1 = camelize2(key$1);
          if (props2[prop$1] !== void 0) {
            data$1[prop$1] = coerce(props2[prop$1], options[key$1]);
          }
        }
        return data$1;
      }
      function registerComputed(component, key2, cb) {
        Object.defineProperty(component, key2, {
          enumerable: true,
          get: function() {
            var _computeds = component._computeds;
            var $props = component.$props;
            var $el = component.$el;
            if (!hasOwn2(_computeds, key2)) {
              _computeds[key2] = (cb.get || cb).call(component, $props, $el);
            }
            return _computeds[key2];
          },
          set: function(value) {
            var _computeds = component._computeds;
            _computeds[key2] = cb.set ? cb.set.call(component, value) : value;
            if (isUndefined2(_computeds[key2])) {
              delete _computeds[key2];
            }
          }
        });
      }
      function registerEvent(component, event, key2) {
        if (!isPlainObject2(event)) {
          event = { name: key2, handler: event };
        }
        var name = event.name;
        var el = event.el;
        var handler = event.handler;
        var capture = event.capture;
        var passive = event.passive;
        var delegate2 = event.delegate;
        var filter2 = event.filter;
        var self2 = event.self;
        el = isFunction2(el) ? el.call(component) : el || component.$el;
        if (isArray2(el)) {
          el.forEach(function(el2) {
            return registerEvent(component, assign2({}, event, { el: el2 }), key2);
          });
          return;
        }
        if (!el || filter2 && !filter2.call(component)) {
          return;
        }
        component._events.push(on(el, name, !delegate2 ? null : isString2(delegate2) ? delegate2 : delegate2.call(component), isString2(handler) ? component[handler] : handler.bind(component), { passive, capture, self: self2 }));
      }
      function notIn(options, key2) {
        return options.every(function(arr) {
          return !arr || !hasOwn2(arr, key2);
        });
      }
      function coerce(type, value) {
        if (type === Boolean) {
          return toBoolean(value);
        } else if (type === Number) {
          return toNumber2(value);
        } else if (type === "list") {
          return toList(value);
        }
        return type ? type(value) : value;
      }
      function toList(value) {
        return isArray2(value) ? value : isString2(value) ? value.split(/,(?![^(]*\))/).map(function(value2) {
          return isNumeric(value2) ? toNumber2(value2) : toBoolean(value2.trim());
        }) : [value];
      }
      function normalizeData(ref2, ref$1) {
        var data3 = ref2.data;
        var args = ref$1.args;
        var props2 = ref$1.props;
        if (props2 === void 0)
          props2 = {};
        data3 = isArray2(data3) ? !isEmpty(args) ? data3.slice(0, args.length).reduce(function(data4, value, index2) {
          if (isPlainObject2(value)) {
            assign2(data4, value);
          } else {
            data4[args[index2]] = value;
          }
          return data4;
        }, {}) : void 0 : data3;
        if (data3) {
          for (var key2 in data3) {
            if (isUndefined2(data3[key2])) {
              delete data3[key2];
            } else {
              data3[key2] = props2[key2] ? coerce(props2[key2], data3[key2]) : data3[key2];
            }
          }
        }
        return data3;
      }
      function initChildListObserver(component) {
        var ref2 = component.$options;
        var el = ref2.el;
        var observer = new MutationObserver(function() {
          return component.$emit();
        });
        observer.observe(el, {
          childList: true,
          subtree: true
        });
        return observer;
      }
      function initPropsObserver(component) {
        var $name = component.$name;
        var $options = component.$options;
        var $props = component.$props;
        var attrs = $options.attrs;
        var props2 = $options.props;
        var el = $options.el;
        if (!props2 || attrs === false) {
          return;
        }
        var attributes = isArray2(attrs) ? attrs : Object.keys(props2);
        var filter2 = attributes.map(function(key2) {
          return hyphenate2(key2);
        }).concat($name);
        var observer = new MutationObserver(function(records) {
          var data3 = getProps2($options, $name);
          if (records.some(function(ref2) {
            var attributeName = ref2.attributeName;
            var prop = attributeName.replace("data-", "");
            return (prop === $name ? attributes : [camelize2(prop), camelize2(attributeName)]).some(function(prop2) {
              return !isUndefined2(data3[prop2]) && data3[prop2] !== $props[prop2];
            });
          })) {
            component.$reset();
          }
        });
        observer.observe(el, {
          attributes: true,
          attributeFilter: filter2.concat(filter2.map(function(key2) {
            return "data-" + key2;
          }))
        });
        return observer;
      }
    }
    function instanceAPI(UIkit3) {
      var DATA = UIkit3.data;
      UIkit3.prototype.$create = function(component, element, data3) {
        return UIkit3[component](element, data3);
      };
      UIkit3.prototype.$mount = function(el) {
        var ref2 = this.$options;
        var name = ref2.name;
        if (!el[DATA]) {
          el[DATA] = {};
        }
        if (el[DATA][name]) {
          return;
        }
        el[DATA][name] = this;
        this.$el = this.$options.el = this.$options.el || el;
        if (within(el, document)) {
          this._callConnected();
        }
      };
      UIkit3.prototype.$reset = function() {
        this._callDisconnected();
        this._callConnected();
      };
      UIkit3.prototype.$destroy = function(removeEl) {
        if (removeEl === void 0)
          removeEl = false;
        var ref2 = this.$options;
        var el = ref2.el;
        var name = ref2.name;
        if (el) {
          this._callDisconnected();
        }
        this._callHook("destroy");
        if (!el || !el[DATA]) {
          return;
        }
        delete el[DATA][name];
        if (!isEmpty(el[DATA])) {
          delete el[DATA];
        }
        if (removeEl) {
          remove$1(this.$el);
        }
      };
      UIkit3.prototype.$emit = function(e) {
        this._callUpdate(e);
      };
      UIkit3.prototype.$update = function(element, e) {
        if (element === void 0)
          element = this.$el;
        UIkit3.update(element, e);
      };
      UIkit3.prototype.$getComponent = UIkit3.getComponent;
      var componentName = memoize(function(name) {
        return UIkit3.prefix + hyphenate2(name);
      });
      Object.defineProperties(UIkit3.prototype, {
        $container: Object.getOwnPropertyDescriptor(UIkit3, "container"),
        $name: {
          get: function() {
            return componentName(this.$options.name);
          }
        }
      });
    }
    function componentAPI(UIkit3) {
      var DATA = UIkit3.data;
      var components2 = {};
      UIkit3.component = function(name, options) {
        var id = hyphenate2(name);
        name = camelize2(id);
        if (!options) {
          if (isPlainObject2(components2[name])) {
            components2[name] = UIkit3.extend(components2[name]);
          }
          return components2[name];
        }
        UIkit3[name] = function(element, data3) {
          var i = arguments.length, argsArray = Array(i);
          while (i--)
            argsArray[i] = arguments[i];
          var component = UIkit3.component(name);
          return component.options.functional ? new component({ data: isPlainObject2(element) ? element : [].concat(argsArray) }) : !element ? init(element) : $$(element).map(init)[0];
          function init(element2) {
            var instance = UIkit3.getComponent(element2, name);
            if (instance) {
              if (data3) {
                instance.$destroy();
              } else {
                return instance;
              }
            }
            return new component({ el: element2, data: data3 });
          }
        };
        var opt = isPlainObject2(options) ? assign2({}, options) : options.options;
        opt.name = name;
        if (opt.install) {
          opt.install(UIkit3, opt, name);
        }
        if (UIkit3._initialized && !opt.functional) {
          fastdom.read(function() {
            return UIkit3[name]("[uk-" + id + "],[data-uk-" + id + "]");
          });
        }
        return components2[name] = isPlainObject2(options) ? opt : options;
      };
      UIkit3.getComponents = function(element) {
        return element && element[DATA] || {};
      };
      UIkit3.getComponent = function(element, name) {
        return UIkit3.getComponents(element)[name];
      };
      UIkit3.connect = function(node) {
        if (node[DATA]) {
          for (var name in node[DATA]) {
            node[DATA][name]._callConnected();
          }
        }
        for (var i = 0; i < node.attributes.length; i++) {
          var name$1 = getComponentName2(node.attributes[i].name);
          if (name$1 && name$1 in components2) {
            UIkit3[name$1](node);
          }
        }
      };
      UIkit3.disconnect = function(node) {
        for (var name in node[DATA]) {
          node[DATA][name]._callDisconnected();
        }
      };
    }
    var getComponentName2 = memoize(function(attribute) {
      return startsWith(attribute, "uk-") || startsWith(attribute, "data-uk-") ? camelize2(attribute.replace("data-uk-", "").replace("uk-", "")) : false;
    });
    var UIkit2 = function(options) {
      this._init(options);
    };
    UIkit2.util = util;
    UIkit2.data = "__uikit__";
    UIkit2.prefix = "uk-";
    UIkit2.options = {};
    UIkit2.version = "3.10.1";
    globalAPI(UIkit2);
    hooksAPI(UIkit2);
    stateAPI(UIkit2);
    componentAPI(UIkit2);
    instanceAPI(UIkit2);
    function Core(UIkit3) {
      if (!inBrowser) {
        return;
      }
      var pendingResize;
      var handleResize = function() {
        if (pendingResize) {
          return;
        }
        pendingResize = true;
        fastdom.write(function() {
          return pendingResize = false;
        });
        UIkit3.update(null, "resize");
      };
      on(window, "load resize", handleResize);
      on(document, "loadedmetadata load", handleResize, true);
      if ("ResizeObserver" in window) {
        new ResizeObserver(handleResize).observe(document.documentElement);
      }
      var pending;
      on(window, "scroll", function(e) {
        if (pending) {
          return;
        }
        pending = true;
        fastdom.write(function() {
          return pending = false;
        });
        UIkit3.update(null, e.type);
      }, { passive: true, capture: true });
      var started = 0;
      on(document, "animationstart", function(ref2) {
        var target = ref2.target;
        if ((css(target, "animationName") || "").match(/^uk-.*(left|right)/)) {
          started++;
          css(document.documentElement, "overflowX", "hidden");
          setTimeout(function() {
            if (!--started) {
              css(document.documentElement, "overflowX", "");
            }
          }, toMs2(css(target, "animationDuration")) + 100);
        }
      }, true);
      on(document, pointerDown, function(e) {
        if (!isTouch(e)) {
          return;
        }
        var pos = getEventPos(e);
        var target = "tagName" in e.target ? e.target : parent(e.target);
        once(document, pointerUp + " " + pointerCancel + " scroll", function(e2) {
          var ref2 = getEventPos(e2);
          var x = ref2.x;
          var y = ref2.y;
          if (e2.type !== "scroll" && target && x && Math.abs(pos.x - x) > 100 || y && Math.abs(pos.y - y) > 100) {
            setTimeout(function() {
              trigger2(target, "swipe");
              trigger2(target, "swipe" + swipeDirection(pos.x, pos.y, x, y));
            });
          }
        });
      }, { passive: true });
    }
    function swipeDirection(x1, y1, x2, y2) {
      return Math.abs(x1 - x2) >= Math.abs(y1 - y2) ? x1 - x2 > 0 ? "Left" : "Right" : y1 - y2 > 0 ? "Up" : "Down";
    }
    function boot(UIkit3) {
      var connect = UIkit3.connect;
      var disconnect = UIkit3.disconnect;
      if (!inBrowser || !window.MutationObserver) {
        return;
      }
      fastdom.read(function() {
        if (document.body) {
          apply$1(document.body, connect);
        }
        new MutationObserver(function(records) {
          return records.forEach(applyChildListMutation);
        }).observe(document, {
          childList: true,
          subtree: true
        });
        new MutationObserver(function(records) {
          return records.forEach(applyAttributeMutation);
        }).observe(document, {
          attributes: true,
          subtree: true
        });
        UIkit3._initialized = true;
      });
      function applyChildListMutation(ref2) {
        var addedNodes = ref2.addedNodes;
        var removedNodes = ref2.removedNodes;
        for (var i = 0; i < addedNodes.length; i++) {
          apply$1(addedNodes[i], connect);
        }
        for (var i$1 = 0; i$1 < removedNodes.length; i$1++) {
          apply$1(removedNodes[i$1], disconnect);
        }
      }
      function applyAttributeMutation(ref2) {
        var target = ref2.target;
        var attributeName = ref2.attributeName;
        var name = getComponentName2(attributeName);
        if (!name || !(name in UIkit3)) {
          return;
        }
        if (hasAttr(target, attributeName)) {
          UIkit3[name](target);
          return;
        }
        var component = UIkit3.getComponent(target, name);
        if (component) {
          component.$destroy();
        }
      }
    }
    var Class = {
      connected: function() {
        !hasClass(this.$el, this.$name) && addClass(this.$el, this.$name);
      }
    };
    var Togglable = {
      props: {
        cls: Boolean,
        animation: "list",
        duration: Number,
        origin: String,
        transition: String
      },
      data: {
        cls: false,
        animation: [false],
        duration: 200,
        origin: false,
        transition: "linear",
        clsEnter: "uk-togglabe-enter",
        clsLeave: "uk-togglabe-leave",
        initProps: {
          overflow: "",
          height: "",
          paddingTop: "",
          paddingBottom: "",
          marginTop: "",
          marginBottom: ""
        },
        hideProps: {
          overflow: "hidden",
          height: 0,
          paddingTop: 0,
          paddingBottom: 0,
          marginTop: 0,
          marginBottom: 0
        }
      },
      computed: {
        hasAnimation: function(ref2) {
          var animation = ref2.animation;
          return !!animation[0];
        },
        hasTransition: function(ref2) {
          var animation = ref2.animation;
          return this.hasAnimation && animation[0] === true;
        }
      },
      methods: {
        toggleElement: function(targets, toggle2, animate2) {
          var this$1$1 = this;
          return new Promise$1(function(resolve2) {
            return Promise$1.all(toNodes(targets).map(function(el) {
              var show = isBoolean2(toggle2) ? toggle2 : !this$1$1.isToggled(el);
              if (!trigger2(el, "before" + (show ? "show" : "hide"), [this$1$1])) {
                return Promise$1.reject();
              }
              var promise = (isFunction2(animate2) ? animate2 : animate2 === false || !this$1$1.hasAnimation ? this$1$1._toggle : this$1$1.hasTransition ? toggleHeight(this$1$1) : toggleAnimation(this$1$1))(el, show);
              var cls = show ? this$1$1.clsEnter : this$1$1.clsLeave;
              addClass(el, cls);
              trigger2(el, show ? "show" : "hide", [this$1$1]);
              var done = function() {
                removeClass(el, cls);
                trigger2(el, show ? "shown" : "hidden", [this$1$1]);
                this$1$1.$update(el);
              };
              return promise ? promise.then(done, function() {
                removeClass(el, cls);
                return Promise$1.reject();
              }) : done();
            })).then(resolve2, noop2);
          });
        },
        isToggled: function(el) {
          var assign3;
          if (el === void 0)
            el = this.$el;
          assign3 = toNodes(el), el = assign3[0];
          return hasClass(el, this.clsEnter) ? true : hasClass(el, this.clsLeave) ? false : this.cls ? hasClass(el, this.cls.split(" ")[0]) : isVisible(el);
        },
        _toggle: function(el, toggled) {
          if (!el) {
            return;
          }
          toggled = Boolean(toggled);
          var changed;
          if (this.cls) {
            changed = includes(this.cls, " ") || toggled !== hasClass(el, this.cls);
            changed && toggleClass(el, this.cls, includes(this.cls, " ") ? void 0 : toggled);
          } else {
            changed = toggled === el.hidden;
            changed && (el.hidden = !toggled);
          }
          $$("[autofocus]", el).some(function(el2) {
            return isVisible(el2) ? el2.focus() || true : el2.blur();
          });
          if (changed) {
            trigger2(el, "toggled", [toggled, this]);
            this.$update(el);
          }
        }
      }
    };
    function toggleHeight(ref2) {
      var isToggled = ref2.isToggled;
      var duration = ref2.duration;
      var initProps2 = ref2.initProps;
      var hideProps = ref2.hideProps;
      var transition2 = ref2.transition;
      var _toggle = ref2._toggle;
      return function(el, show) {
        var inProgress2 = Transition2.inProgress(el);
        var inner = el.hasChildNodes ? toFloat(css(el.firstElementChild, "marginTop")) + toFloat(css(el.lastElementChild, "marginBottom")) : 0;
        var currentHeight = isVisible(el) ? height(el) + (inProgress2 ? 0 : inner) : 0;
        Transition2.cancel(el);
        if (!isToggled(el)) {
          _toggle(el, true);
        }
        height(el, "");
        fastdom.flush();
        var endHeight = height(el) + (inProgress2 ? 0 : inner);
        height(el, currentHeight);
        return (show ? Transition2.start(el, assign2({}, initProps2, { overflow: "hidden", height: endHeight }), Math.round(duration * (1 - currentHeight / endHeight)), transition2) : Transition2.start(el, hideProps, Math.round(duration * (currentHeight / endHeight)), transition2).then(function() {
          return _toggle(el, false);
        })).then(function() {
          return css(el, initProps2);
        });
      };
    }
    function toggleAnimation(cmp) {
      return function(el, show) {
        Animation.cancel(el);
        var animation = cmp.animation;
        var duration = cmp.duration;
        var _toggle = cmp._toggle;
        if (show) {
          _toggle(el, true);
          return Animation.in(el, animation[0], duration, cmp.origin);
        }
        return Animation.out(el, animation[1] || animation[0], duration, cmp.origin).then(function() {
          return _toggle(el, false);
        });
      };
    }
    var Accordion = {
      mixins: [Class, Togglable],
      props: {
        targets: String,
        active: null,
        collapsible: Boolean,
        multiple: Boolean,
        toggle: String,
        content: String,
        transition: String,
        offset: Number
      },
      data: {
        targets: "> *",
        active: false,
        animation: [true],
        collapsible: true,
        multiple: false,
        clsOpen: "uk-open",
        toggle: "> .uk-accordion-title",
        content: "> .uk-accordion-content",
        transition: "ease",
        offset: 0
      },
      computed: {
        items: {
          get: function(ref2, $el) {
            var targets = ref2.targets;
            return $$(targets, $el);
          },
          watch: function(items, prev) {
            var this$1$1 = this;
            items.forEach(function(el) {
              return hide($(this$1$1.content, el), !hasClass(el, this$1$1.clsOpen));
            });
            if (prev || hasClass(items, this.clsOpen)) {
              return;
            }
            var active2 = this.active !== false && items[Number(this.active)] || !this.collapsible && items[0];
            if (active2) {
              this.toggle(active2, false);
            }
          },
          immediate: true
        },
        toggles: function(ref2) {
          var toggle2 = ref2.toggle;
          return this.items.map(function(item) {
            return $(toggle2, item);
          });
        }
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.targets + " " + this.$props.toggle;
          },
          handler: function(e) {
            e.preventDefault();
            this.toggle(index(this.toggles, e.current));
          }
        }
      ],
      methods: {
        toggle: function(item, animate2) {
          var this$1$1 = this;
          var items = [this.items[getIndex(item, this.items)]];
          var activeItems = filter$1(this.items, "." + this.clsOpen);
          if (!this.multiple && !includes(activeItems, items[0])) {
            items = items.concat(activeItems);
          }
          if (!this.collapsible && activeItems.length < 2 && !filter$1(items, ":not(." + this.clsOpen + ")").length) {
            return;
          }
          items.forEach(function(el) {
            return this$1$1.toggleElement(el, !hasClass(el, this$1$1.clsOpen), function(el2, show) {
              toggleClass(el2, this$1$1.clsOpen, show);
              attr($(this$1$1.$props.toggle, el2), "aria-expanded", show);
              var content = $("" + (el2._wrapper ? "> * " : "") + this$1$1.content, el2);
              if (animate2 === false || !this$1$1.hasTransition) {
                hide(content, !show);
                return;
              }
              if (!el2._wrapper) {
                el2._wrapper = wrapAll(content, "<div" + (show ? " hidden" : "") + ">");
              }
              hide(content, false);
              return toggleHeight(this$1$1)(el2._wrapper, show).then(function() {
                hide(content, !show);
                delete el2._wrapper;
                unwrap(content);
                if (show) {
                  var toggle2 = $(this$1$1.$props.toggle, el2);
                  if (!isInView(toggle2)) {
                    scrollIntoView(toggle2, { offset: this$1$1.offset });
                  }
                }
              });
            });
          });
        }
      }
    };
    function hide(el, hide2) {
      el && (el.hidden = hide2);
    }
    var alert = {
      mixins: [Class, Togglable],
      args: "animation",
      props: {
        close: String
      },
      data: {
        animation: [true],
        selClose: ".uk-alert-close",
        duration: 150,
        hideProps: assign2({ opacity: 0 }, Togglable.data.hideProps)
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.selClose;
          },
          handler: function(e) {
            e.preventDefault();
            this.close();
          }
        }
      ],
      methods: {
        close: function() {
          var this$1$1 = this;
          this.toggleElement(this.$el).then(function() {
            return this$1$1.$destroy(true);
          });
        }
      }
    };
    var Video = {
      args: "autoplay",
      props: {
        automute: Boolean,
        autoplay: Boolean
      },
      data: {
        automute: false,
        autoplay: true
      },
      computed: {
        inView: function(ref2) {
          var autoplay = ref2.autoplay;
          return autoplay === "inview";
        }
      },
      connected: function() {
        if (this.inView && !hasAttr(this.$el, "preload")) {
          this.$el.preload = "none";
        }
        if (this.automute) {
          mute(this.$el);
        }
      },
      update: {
        read: function() {
          if (!isVideo(this.$el)) {
            return false;
          }
          return {
            visible: isVisible(this.$el) && css(this.$el, "visibility") !== "hidden",
            inView: this.inView && isInView(this.$el)
          };
        },
        write: function(ref2) {
          var visible = ref2.visible;
          var inView2 = ref2.inView;
          if (!visible || this.inView && !inView2) {
            pause(this.$el);
          } else if (this.autoplay === true || this.inView && inView2) {
            play(this.$el);
          }
        },
        events: ["resize", "scroll"]
      }
    };
    var cover = {
      mixins: [Video],
      props: {
        width: Number,
        height: Number
      },
      data: {
        automute: true
      },
      update: {
        read: function() {
          var el = this.$el;
          var ref2 = getPositionedParent(el) || parent(el);
          var height2 = ref2.offsetHeight;
          var width2 = ref2.offsetWidth;
          var dim = Dimensions.cover({
            width: this.width || el.naturalWidth || el.videoWidth || el.clientWidth,
            height: this.height || el.naturalHeight || el.videoHeight || el.clientHeight
          }, {
            width: width2 + (width2 % 2 ? 1 : 0),
            height: height2 + (height2 % 2 ? 1 : 0)
          });
          if (!dim.width || !dim.height) {
            return false;
          }
          return dim;
        },
        write: function(ref2) {
          var height2 = ref2.height;
          var width2 = ref2.width;
          css(this.$el, { height: height2, width: width2 });
        },
        events: ["resize"]
      }
    };
    function getPositionedParent(el) {
      while (el = parent(el)) {
        if (css(el, "position") !== "static") {
          return el;
        }
      }
    }
    var Container = {
      props: {
        container: Boolean
      },
      data: {
        container: true
      },
      computed: {
        container: function(ref2) {
          var container = ref2.container;
          return container === true && this.$container || container && $(container);
        }
      }
    };
    var Position = {
      props: {
        pos: String,
        offset: null,
        flip: Boolean,
        clsPos: String
      },
      data: {
        pos: "bottom-" + (isRtl ? "right" : "left"),
        flip: true,
        offset: false,
        clsPos: ""
      },
      computed: {
        pos: function(ref2) {
          var pos = ref2.pos;
          return pos.split("-").concat("center").slice(0, 2);
        },
        dir: function() {
          return this.pos[0];
        },
        align: function() {
          return this.pos[1];
        }
      },
      methods: {
        positionAt: function(element, target, boundary) {
          removeClasses(element, this.clsPos + "-(top|bottom|left|right)(-[a-z]+)?");
          var ref2 = this;
          var offset$1 = ref2.offset;
          var axis = this.getAxis();
          if (!isNumeric(offset$1)) {
            var node = $(offset$1);
            offset$1 = node ? offset(node)[axis === "x" ? "left" : "top"] - offset(target)[axis === "x" ? "right" : "bottom"] : 0;
          }
          var ref$1 = positionAt(element, target, axis === "x" ? flipPosition(this.dir) + " " + this.align : this.align + " " + flipPosition(this.dir), axis === "x" ? this.dir + " " + this.align : this.align + " " + this.dir, axis === "x" ? "" + (this.dir === "left" ? -offset$1 : offset$1) : " " + (this.dir === "top" ? -offset$1 : offset$1), null, this.flip, boundary).target;
          var x = ref$1.x;
          var y = ref$1.y;
          this.dir = axis === "x" ? x : y;
          this.align = axis === "x" ? y : x;
          toggleClass(element, this.clsPos + "-" + this.dir + "-" + this.align, this.offset === false);
        },
        getAxis: function() {
          return this.dir === "top" || this.dir === "bottom" ? "y" : "x";
        }
      }
    };
    var active$1;
    var drop = {
      mixins: [Container, Position, Togglable],
      args: "pos",
      props: {
        mode: "list",
        toggle: Boolean,
        boundary: Boolean,
        boundaryAlign: Boolean,
        delayShow: Number,
        delayHide: Number,
        clsDrop: String
      },
      data: {
        mode: ["click", "hover"],
        toggle: "- *",
        boundary: true,
        boundaryAlign: false,
        delayShow: 0,
        delayHide: 800,
        clsDrop: false,
        animation: ["uk-animation-fade"],
        cls: "uk-open",
        container: false
      },
      computed: {
        boundary: function(ref2, $el) {
          var boundary = ref2.boundary;
          return boundary === true ? window : query(boundary, $el);
        },
        clsDrop: function(ref2) {
          var clsDrop = ref2.clsDrop;
          return clsDrop || "uk-" + this.$options.name;
        },
        clsPos: function() {
          return this.clsDrop;
        }
      },
      created: function() {
        this.tracker = new MouseTracker();
      },
      connected: function() {
        addClass(this.$el, this.clsDrop);
        if (this.toggle && !this.target) {
          this.target = this.$create("toggle", query(this.toggle, this.$el), {
            target: this.$el,
            mode: this.mode
          }).$el;
          attr(this.target, "aria-haspopup", true);
        }
      },
      disconnected: function() {
        if (this.isActive()) {
          active$1 = null;
        }
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return "." + this.clsDrop + "-close";
          },
          handler: function(e) {
            e.preventDefault();
            this.hide(false);
          }
        },
        {
          name: "click",
          delegate: function() {
            return 'a[href^="#"]';
          },
          handler: function(ref2) {
            var defaultPrevented = ref2.defaultPrevented;
            var hash = ref2.current.hash;
            if (!defaultPrevented && hash && !within(hash, this.$el)) {
              this.hide(false);
            }
          }
        },
        {
          name: "beforescroll",
          handler: function() {
            this.hide(false);
          }
        },
        {
          name: "toggle",
          self: true,
          handler: function(e, toggle2) {
            e.preventDefault();
            if (this.isToggled()) {
              this.hide(false);
            } else {
              this.show(toggle2.$el, false);
            }
          }
        },
        {
          name: "toggleshow",
          self: true,
          handler: function(e, toggle2) {
            e.preventDefault();
            this.show(toggle2.$el);
          }
        },
        {
          name: "togglehide",
          self: true,
          handler: function(e) {
            e.preventDefault();
            if (!matches(this.$el, ":focus,:hover")) {
              this.hide();
            }
          }
        },
        {
          name: pointerEnter + " focusin",
          filter: function() {
            return includes(this.mode, "hover");
          },
          handler: function(e) {
            if (!isTouch(e)) {
              this.clearTimers();
            }
          }
        },
        {
          name: pointerLeave + " focusout",
          filter: function() {
            return includes(this.mode, "hover");
          },
          handler: function(e) {
            if (!isTouch(e) && e.relatedTarget) {
              this.hide();
            }
          }
        },
        {
          name: "toggled",
          self: true,
          handler: function(e, toggled) {
            if (!toggled) {
              return;
            }
            this.clearTimers();
            this.position();
          }
        },
        {
          name: "show",
          self: true,
          handler: function() {
            var this$1$1 = this;
            active$1 = this;
            this.tracker.init();
            once(this.$el, "hide", on(document, pointerDown, function(ref2) {
              var target = ref2.target;
              return !within(target, this$1$1.$el) && once(document, pointerUp + " " + pointerCancel + " scroll", function(ref3) {
                var defaultPrevented = ref3.defaultPrevented;
                var type = ref3.type;
                var newTarget = ref3.target;
                if (!defaultPrevented && type === pointerUp && target === newTarget && !(this$1$1.target && within(target, this$1$1.target))) {
                  this$1$1.hide(false);
                }
              }, true);
            }), { self: true });
            once(this.$el, "hide", on(document, "keydown", function(e) {
              if (e.keyCode === 27) {
                this$1$1.hide(false);
              }
            }), { self: true });
          }
        },
        {
          name: "beforehide",
          self: true,
          handler: function() {
            this.clearTimers();
          }
        },
        {
          name: "hide",
          handler: function(ref2) {
            var target = ref2.target;
            if (this.$el !== target) {
              active$1 = active$1 === null && within(target, this.$el) && this.isToggled() ? this : active$1;
              return;
            }
            active$1 = this.isActive() ? null : active$1;
            this.tracker.cancel();
          }
        }
      ],
      update: {
        write: function() {
          if (this.isToggled() && !hasClass(this.$el, this.clsEnter)) {
            this.position();
          }
        },
        events: ["resize"]
      },
      methods: {
        show: function(target, delay) {
          var this$1$1 = this;
          if (target === void 0)
            target = this.target;
          if (delay === void 0)
            delay = true;
          if (this.isToggled() && target && this.target && target !== this.target) {
            this.hide(false);
          }
          this.target = target;
          this.clearTimers();
          if (this.isActive()) {
            return;
          }
          if (active$1) {
            if (delay && active$1.isDelaying) {
              this.showTimer = setTimeout(this.show, 10);
              return;
            }
            var prev;
            while (active$1 && prev !== active$1 && !within(this.$el, active$1.$el)) {
              prev = active$1;
              active$1.hide(false);
            }
          }
          if (this.container && parent(this.$el) !== this.container) {
            append(this.container, this.$el);
          }
          this.showTimer = setTimeout(function() {
            return this$1$1.toggleElement(this$1$1.$el, true);
          }, delay && this.delayShow || 0);
        },
        hide: function(delay) {
          var this$1$1 = this;
          if (delay === void 0)
            delay = true;
          var hide2 = function() {
            return this$1$1.toggleElement(this$1$1.$el, false, false);
          };
          this.clearTimers();
          this.isDelaying = getPositionedElements(this.$el).some(function(el) {
            return this$1$1.tracker.movesTo(el);
          });
          if (delay && this.isDelaying) {
            this.hideTimer = setTimeout(this.hide, 50);
          } else if (delay && this.delayHide) {
            this.hideTimer = setTimeout(hide2, this.delayHide);
          } else {
            hide2();
          }
        },
        clearTimers: function() {
          clearTimeout(this.showTimer);
          clearTimeout(this.hideTimer);
          this.showTimer = null;
          this.hideTimer = null;
          this.isDelaying = false;
        },
        isActive: function() {
          return active$1 === this;
        },
        position: function() {
          removeClass(this.$el, this.clsDrop + "-stack");
          toggleClass(this.$el, this.clsDrop + "-boundary", this.boundaryAlign);
          var boundary = offset(this.boundary);
          var alignTo = this.boundaryAlign ? boundary : offset(this.target);
          if (this.align === "justify") {
            var prop = this.getAxis() === "y" ? "width" : "height";
            css(this.$el, prop, alignTo[prop]);
          } else if (this.boundary && this.$el.offsetWidth > Math.max(boundary.right - alignTo.left, alignTo.right - boundary.left)) {
            addClass(this.$el, this.clsDrop + "-stack");
          }
          this.positionAt(this.$el, this.boundaryAlign ? this.boundary : this.target, this.boundary);
        }
      }
    };
    function getPositionedElements(el) {
      var result = [];
      apply$1(el, function(el2) {
        return css(el2, "position") !== "static" && result.push(el2);
      });
      return result;
    }
    var formCustom = {
      mixins: [Class],
      args: "target",
      props: {
        target: Boolean
      },
      data: {
        target: false
      },
      computed: {
        input: function(_, $el) {
          return $(selInput, $el);
        },
        state: function() {
          return this.input.nextElementSibling;
        },
        target: function(ref2, $el) {
          var target = ref2.target;
          return target && (target === true && parent(this.input) === $el && this.input.nextElementSibling || query(target, $el));
        }
      },
      update: function() {
        var ref2 = this;
        var target = ref2.target;
        var input = ref2.input;
        if (!target) {
          return;
        }
        var option;
        var prop = isInput(target) ? "value" : "textContent";
        var prev = target[prop];
        var value = input.files && input.files[0] ? input.files[0].name : matches(input, "select") && (option = $$("option", input).filter(function(el) {
          return el.selected;
        })[0]) ? option.textContent : input.value;
        if (prev !== value) {
          target[prop] = value;
        }
      },
      events: [
        {
          name: "change",
          handler: function() {
            this.$update();
          }
        },
        {
          name: "reset",
          el: function() {
            return closest(this.$el, "form");
          },
          handler: function() {
            this.$update();
          }
        }
      ]
    };
    var gif = {
      update: {
        read: function(data3) {
          var inview = isInView(this.$el);
          if (!inview || data3.isInView === inview) {
            return false;
          }
          data3.isInView = inview;
        },
        write: function() {
          this.$el.src = "" + this.$el.src;
        },
        events: ["scroll", "resize"]
      }
    };
    var Margin = {
      props: {
        margin: String,
        firstColumn: Boolean
      },
      data: {
        margin: "uk-margin-small-top",
        firstColumn: "uk-first-column"
      },
      update: {
        read: function() {
          var rows = getRows(this.$el.children);
          return {
            rows,
            columns: getColumns(rows)
          };
        },
        write: function(ref2) {
          var columns = ref2.columns;
          var rows = ref2.rows;
          for (var i = 0; i < rows.length; i++) {
            for (var j = 0; j < rows[i].length; j++) {
              toggleClass(rows[i][j], this.margin, i !== 0);
              toggleClass(rows[i][j], this.firstColumn, !!~columns[0].indexOf(rows[i][j]));
            }
          }
        },
        events: ["resize"]
      }
    };
    function getRows(items) {
      return sortBy(items, "top", "bottom");
    }
    function getColumns(rows) {
      var columns = [];
      for (var i = 0; i < rows.length; i++) {
        var sorted = sortBy(rows[i], "left", "right");
        for (var j = 0; j < sorted.length; j++) {
          columns[j] = !columns[j] ? sorted[j] : columns[j].concat(sorted[j]);
        }
      }
      return isRtl ? columns.reverse() : columns;
    }
    function sortBy(items, startProp, endProp) {
      var sorted = [[]];
      for (var i = 0; i < items.length; i++) {
        var el = items[i];
        if (!isVisible(el)) {
          continue;
        }
        var dim = getOffset(el);
        for (var j = sorted.length - 1; j >= 0; j--) {
          var current = sorted[j];
          if (!current[0]) {
            current.push(el);
            break;
          }
          var startDim = void 0;
          if (current[0].offsetParent === el.offsetParent) {
            startDim = getOffset(current[0]);
          } else {
            dim = getOffset(el, true);
            startDim = getOffset(current[0], true);
          }
          if (dim[startProp] >= startDim[endProp] - 1 && dim[startProp] !== startDim[startProp]) {
            sorted.push([el]);
            break;
          }
          if (dim[endProp] - 1 > startDim[startProp] || dim[startProp] === startDim[startProp]) {
            current.push(el);
            break;
          }
          if (j === 0) {
            sorted.unshift([el]);
            break;
          }
        }
      }
      return sorted;
    }
    function getOffset(element, offset2) {
      var assign3;
      if (offset2 === void 0)
        offset2 = false;
      var offsetTop = element.offsetTop;
      var offsetLeft = element.offsetLeft;
      var offsetHeight = element.offsetHeight;
      var offsetWidth = element.offsetWidth;
      if (offset2) {
        assign3 = offsetPosition(element), offsetTop = assign3[0], offsetLeft = assign3[1];
      }
      return {
        top: offsetTop,
        left: offsetLeft,
        bottom: offsetTop + offsetHeight,
        right: offsetLeft + offsetWidth
      };
    }
    var grid = {
      extends: Margin,
      mixins: [Class],
      name: "grid",
      props: {
        masonry: Boolean,
        parallax: Number
      },
      data: {
        margin: "uk-grid-margin",
        clsStack: "uk-grid-stack",
        masonry: false,
        parallax: 0
      },
      connected: function() {
        this.masonry && addClass(this.$el, "uk-flex-top uk-flex-wrap-top");
      },
      update: [
        {
          write: function(ref2) {
            var columns = ref2.columns;
            toggleClass(this.$el, this.clsStack, columns.length < 2);
          },
          events: ["resize"]
        },
        {
          read: function(data3) {
            var columns = data3.columns;
            var rows = data3.rows;
            if (!columns.length || !this.masonry && !this.parallax || positionedAbsolute(this.$el)) {
              data3.translates = false;
              return false;
            }
            var translates = false;
            var nodes = children(this.$el);
            var columnHeights = getColumnHeights(columns);
            var margin = getMarginTop(nodes, this.margin) * (rows.length - 1);
            var elHeight = Math.max.apply(Math, columnHeights) + margin;
            if (this.masonry) {
              columns = columns.map(function(column) {
                return sortBy$1(column, "offsetTop");
              });
              translates = getTranslates(rows, columns);
            }
            var padding = Math.abs(this.parallax);
            if (padding) {
              padding = columnHeights.reduce(function(newPadding, hgt, i) {
                return Math.max(newPadding, hgt + margin + (i % 2 ? padding : padding / 8) - elHeight);
              }, 0);
            }
            return { padding, columns, translates, height: translates ? elHeight : "" };
          },
          write: function(ref2) {
            var height2 = ref2.height;
            var padding = ref2.padding;
            css(this.$el, "paddingBottom", padding || "");
            height2 !== false && css(this.$el, "height", height2);
          },
          events: ["resize"]
        },
        {
          read: function(ref2) {
            var height$1 = ref2.height;
            if (positionedAbsolute(this.$el)) {
              return false;
            }
            return {
              scrolled: this.parallax ? scrolledOver(this.$el, height$1 ? height$1 - height(this.$el) : 0) * Math.abs(this.parallax) : false
            };
          },
          write: function(ref2) {
            var columns = ref2.columns;
            var scrolled = ref2.scrolled;
            var translates = ref2.translates;
            if (scrolled === false && !translates) {
              return;
            }
            columns.forEach(function(column, i) {
              return column.forEach(function(el, j) {
                return css(el, "transform", !scrolled && !translates ? "" : "translateY(" + ((translates && -translates[i][j]) + (scrolled ? i % 2 ? scrolled : scrolled / 8 : 0)) + "px)");
              });
            });
          },
          events: ["scroll", "resize"]
        }
      ]
    };
    function positionedAbsolute(el) {
      return children(el).some(function(el2) {
        return css(el2, "position") === "absolute";
      });
    }
    function getTranslates(rows, columns) {
      var rowHeights = rows.map(function(row) {
        return Math.max.apply(Math, row.map(function(el) {
          return el.offsetHeight;
        }));
      });
      return columns.map(function(elements) {
        var prev = 0;
        return elements.map(function(element, row) {
          return prev += row ? rowHeights[row - 1] - elements[row - 1].offsetHeight : 0;
        });
      });
    }
    function getMarginTop(nodes, cls) {
      var ref2 = nodes.filter(function(el) {
        return hasClass(el, cls);
      });
      var node = ref2[0];
      return toFloat(node ? css(node, "marginTop") : css(nodes[0], "paddingLeft"));
    }
    function getColumnHeights(columns) {
      return columns.map(function(column) {
        return column.reduce(function(sum, el) {
          return sum + el.offsetHeight;
        }, 0);
      });
    }
    var FlexBug = isIE ? {
      props: {
        selMinHeight: String
      },
      data: {
        selMinHeight: false,
        forceHeight: false
      },
      computed: {
        elements: function(ref2, $el) {
          var selMinHeight = ref2.selMinHeight;
          return selMinHeight ? $$(selMinHeight, $el) : [$el];
        }
      },
      update: [
        {
          read: function() {
            css(this.elements, "height", "");
          },
          order: -5,
          events: ["resize"]
        },
        {
          write: function() {
            var this$1$1 = this;
            this.elements.forEach(function(el) {
              var height2 = toFloat(css(el, "minHeight"));
              if (height2 && (this$1$1.forceHeight || Math.round(height2 + boxModelAdjust(el, "height", "content-box")) >= el.offsetHeight)) {
                css(el, "height", height2);
              }
            });
          },
          order: 5,
          events: ["resize"]
        }
      ]
    } : {};
    var heightMatch = {
      mixins: [FlexBug],
      args: "target",
      props: {
        target: String,
        row: Boolean
      },
      data: {
        target: "> *",
        row: true,
        forceHeight: true
      },
      computed: {
        elements: function(ref2, $el) {
          var target = ref2.target;
          return $$(target, $el);
        }
      },
      update: {
        read: function() {
          return {
            rows: (this.row ? getRows(this.elements) : [this.elements]).map(match$1)
          };
        },
        write: function(ref2) {
          var rows = ref2.rows;
          rows.forEach(function(ref3) {
            var heights = ref3.heights;
            var elements = ref3.elements;
            return elements.forEach(function(el, i) {
              return css(el, "minHeight", heights[i]);
            });
          });
        },
        events: ["resize"]
      }
    };
    function match$1(elements) {
      if (elements.length < 2) {
        return { heights: [""], elements };
      }
      var heights = elements.map(getHeight);
      var max = Math.max.apply(Math, heights);
      var hasMinHeight = elements.some(function(el) {
        return el.style.minHeight;
      });
      var hasShrunk = elements.some(function(el, i) {
        return !el.style.minHeight && heights[i] < max;
      });
      if (hasMinHeight && hasShrunk) {
        css(elements, "minHeight", "");
        heights = elements.map(getHeight);
        max = Math.max.apply(Math, heights);
      }
      heights = elements.map(function(el, i) {
        return heights[i] === max && toFloat(el.style.minHeight).toFixed(2) !== max.toFixed(2) ? "" : max;
      });
      return { heights, elements };
    }
    function getHeight(element) {
      var style = false;
      if (!isVisible(element)) {
        style = element.style.display;
        css(element, "display", "block", "important");
      }
      var height2 = dimensions(element).height - boxModelAdjust(element, "height", "content-box");
      if (style !== false) {
        css(element, "display", style);
      }
      return height2;
    }
    var heightViewport = {
      mixins: [FlexBug],
      props: {
        expand: Boolean,
        offsetTop: Boolean,
        offsetBottom: Boolean,
        minHeight: Number
      },
      data: {
        expand: false,
        offsetTop: false,
        offsetBottom: false,
        minHeight: 0
      },
      update: {
        read: function(ref2) {
          var prev = ref2.minHeight;
          if (!isVisible(this.$el)) {
            return false;
          }
          var minHeight = "";
          var box = boxModelAdjust(this.$el, "height", "content-box");
          if (this.expand) {
            minHeight = height(window) - (dimensions(document.documentElement).height - dimensions(this.$el).height) - box || "";
          } else {
            minHeight = "calc(100vh";
            if (this.offsetTop) {
              var ref$1 = offset(this.$el);
              var top = ref$1.top;
              minHeight += top > 0 && top < height(window) / 2 ? " - " + top + "px" : "";
            }
            if (this.offsetBottom === true) {
              minHeight += " - " + dimensions(this.$el.nextElementSibling).height + "px";
            } else if (isNumeric(this.offsetBottom)) {
              minHeight += " - " + this.offsetBottom + "vh";
            } else if (this.offsetBottom && endsWith(this.offsetBottom, "px")) {
              minHeight += " - " + toFloat(this.offsetBottom) + "px";
            } else if (isString2(this.offsetBottom)) {
              minHeight += " - " + dimensions(query(this.offsetBottom, this.$el)).height + "px";
            }
            minHeight += (box ? " - " + box + "px" : "") + ")";
          }
          return { minHeight, prev };
        },
        write: function(ref2) {
          var minHeight = ref2.minHeight;
          var prev = ref2.prev;
          css(this.$el, { minHeight });
          if (minHeight !== prev) {
            this.$update(this.$el, "resize");
          }
          if (this.minHeight && toFloat(css(this.$el, "minHeight")) < this.minHeight) {
            css(this.$el, "minHeight", this.minHeight);
          }
        },
        events: ["resize"]
      }
    };
    var SVG = {
      args: "src",
      props: {
        id: Boolean,
        icon: String,
        src: String,
        style: String,
        width: Number,
        height: Number,
        ratio: Number,
        class: String,
        strokeAnimation: Boolean,
        focusable: Boolean,
        attributes: "list"
      },
      data: {
        ratio: 1,
        include: ["style", "class", "focusable"],
        class: "",
        strokeAnimation: false
      },
      beforeConnect: function() {
        this.class += " uk-svg";
      },
      connected: function() {
        var this$1$1 = this;
        var assign3;
        if (!this.icon && includes(this.src, "#")) {
          assign3 = this.src.split("#"), this.src = assign3[0], this.icon = assign3[1];
        }
        this.svg = this.getSvg().then(function(el) {
          if (this$1$1._connected) {
            var svg = insertSVG(el, this$1$1.$el);
            if (this$1$1.svgEl && svg !== this$1$1.svgEl) {
              remove$1(this$1$1.svgEl);
            }
            this$1$1.applyAttributes(svg, el);
            this$1$1.$emit();
            return this$1$1.svgEl = svg;
          }
        }, noop2);
      },
      disconnected: function() {
        var this$1$1 = this;
        this.svg.then(function(svg) {
          if (!this$1$1._connected) {
            if (isVoidElement(this$1$1.$el)) {
              this$1$1.$el.hidden = false;
            }
            remove$1(svg);
            this$1$1.svgEl = null;
          }
        });
        this.svg = null;
      },
      update: {
        read: function() {
          return !!(this.strokeAnimation && this.svgEl && isVisible(this.svgEl));
        },
        write: function() {
          applyAnimation(this.svgEl);
        },
        type: ["resize"]
      },
      methods: {
        getSvg: function() {
          var this$1$1 = this;
          return loadSVG(this.src).then(function(svg) {
            return parseSVG(svg, this$1$1.icon) || Promise$1.reject("SVG not found.");
          });
        },
        applyAttributes: function(el, ref2) {
          var this$1$1 = this;
          for (var prop in this.$options.props) {
            if (includes(this.include, prop) && prop in this) {
              attr(el, prop, this[prop]);
            }
          }
          for (var attribute in this.attributes) {
            var ref$1 = this.attributes[attribute].split(":", 2);
            var prop$1 = ref$1[0];
            var value = ref$1[1];
            attr(el, prop$1, value);
          }
          if (!this.id) {
            removeAttr(el, "id");
          }
          var props2 = ["width", "height"];
          var dimensions2 = props2.map(function(prop2) {
            return this$1$1[prop2];
          });
          if (!dimensions2.some(function(val) {
            return val;
          })) {
            dimensions2 = props2.map(function(prop2) {
              return attr(ref2, prop2);
            });
          }
          var viewBox = attr(ref2, "viewBox");
          if (viewBox && !dimensions2.some(function(val) {
            return val;
          })) {
            dimensions2 = viewBox.split(" ").slice(2);
          }
          dimensions2.forEach(function(val, i) {
            return attr(el, props2[i], toFloat(val) * this$1$1.ratio || null);
          });
        }
      }
    };
    var loadSVG = memoize(function(src) {
      return new Promise$1(function(resolve2, reject) {
        if (!src) {
          reject();
          return;
        }
        if (startsWith(src, "data:")) {
          resolve2(decodeURIComponent(src.split(",")[1]));
        } else {
          ajax(src).then(function(xhr2) {
            return resolve2(xhr2.response);
          }, function() {
            return reject("SVG not found.");
          });
        }
      });
    });
    function parseSVG(svg, icon) {
      if (icon && includes(svg, "<symbol")) {
        svg = parseSymbols(svg, icon) || svg;
      }
      svg = $(svg.substr(svg.indexOf("<svg")));
      return svg && svg.hasChildNodes() && svg;
    }
    var symbolRe = /<symbol([^]*?id=(['"])(.+?)\2[^]*?<\/)symbol>/g;
    var symbols = {};
    function parseSymbols(svg, icon) {
      if (!symbols[svg]) {
        symbols[svg] = {};
        symbolRe.lastIndex = 0;
        var match2;
        while (match2 = symbolRe.exec(svg)) {
          symbols[svg][match2[3]] = '<svg xmlns="http://www.w3.org/2000/svg"' + match2[1] + "svg>";
        }
      }
      return symbols[svg][icon];
    }
    function applyAnimation(el) {
      var length = getMaxPathLength(el);
      if (length) {
        el.style.setProperty("--uk-animation-stroke", length);
      }
    }
    function getMaxPathLength(el) {
      return Math.ceil(Math.max.apply(Math, [0].concat($$("[stroke]", el).map(function(stroke) {
        try {
          return stroke.getTotalLength();
        } catch (e) {
          return 0;
        }
      }))));
    }
    function insertSVG(el, root2) {
      if (isVoidElement(root2) || root2.tagName === "CANVAS") {
        root2.hidden = true;
        var next = root2.nextElementSibling;
        return equals(el, next) ? next : after(root2, el);
      }
      var last2 = root2.lastElementChild;
      return equals(el, last2) ? last2 : append(root2, el);
    }
    function equals(el, other) {
      return isSVG(el) && isSVG(other) && innerHTML(el) === innerHTML(other);
    }
    function isSVG(el) {
      return el && el.tagName === "svg";
    }
    function innerHTML(el) {
      return (el.innerHTML || new XMLSerializer().serializeToString(el).replace(/<svg.*?>(.*?)<\/svg>/g, "$1")).replace(/\s/g, "");
    }
    var closeIcon = '<svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><line fill="none" stroke="#000" stroke-width="1.1" x1="1" y1="1" x2="13" y2="13"/><line fill="none" stroke="#000" stroke-width="1.1" x1="13" y1="1" x2="1" y2="13"/></svg>';
    var closeLarge = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><line fill="none" stroke="#000" stroke-width="1.4" x1="1" y1="1" x2="19" y2="19"/><line fill="none" stroke="#000" stroke-width="1.4" x1="19" y1="1" x2="1" y2="19"/></svg>';
    var marker = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><rect x="9" y="4" width="1" height="11"/><rect x="4" y="9" width="11" height="1"/></svg>';
    var navbarToggleIcon = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><rect y="9" width="20" height="2"/><rect y="3" width="20" height="2"/><rect y="15" width="20" height="2"/></svg>';
    var overlayIcon = '<svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"><rect x="19" y="0" width="1" height="40"/><rect x="0" y="19" width="40" height="1"/></svg>';
    var paginationNext = '<svg width="7" height="12" viewBox="0 0 7 12" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="1.2" points="1 1 6 6 1 11"/></svg>';
    var paginationPrevious = '<svg width="7" height="12" viewBox="0 0 7 12" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="1.2" points="6 1 1 6 6 11"/></svg>';
    var searchIcon = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><circle fill="none" stroke="#000" stroke-width="1.1" cx="9" cy="9" r="7"/><path fill="none" stroke="#000" stroke-width="1.1" d="M14,14 L18,18 L14,14 Z"/></svg>';
    var searchLarge = '<svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"><circle fill="none" stroke="#000" stroke-width="1.8" cx="17.5" cy="17.5" r="16.5"/><line fill="none" stroke="#000" stroke-width="1.8" x1="38" y1="39" x2="29" y2="30"/></svg>';
    var searchNavbar = '<svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><circle fill="none" stroke="#000" stroke-width="1.1" cx="10.5" cy="10.5" r="9.5"/><line fill="none" stroke="#000" stroke-width="1.1" x1="23" y1="23" x2="17" y2="17"/></svg>';
    var slidenavNext = '<svg width="14" height="24" viewBox="0 0 14 24" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="1.4" points="1.225,23 12.775,12 1.225,1 "/></svg>';
    var slidenavNextLarge = '<svg width="25" height="40" viewBox="0 0 25 40" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="2" points="4.002,38.547 22.527,20.024 4,1.5 "/></svg>';
    var slidenavPrevious = '<svg width="14" height="24" viewBox="0 0 14 24" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="1.4" points="12.775,1 1.225,12 12.775,23 "/></svg>';
    var slidenavPreviousLarge = '<svg width="25" height="40" viewBox="0 0 25 40" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="2" points="20.527,1.5 2,20.024 20.525,38.547 "/></svg>';
    var spinner = '<svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg"><circle fill="none" stroke="#000" cx="15" cy="15" r="14"/></svg>';
    var totop = '<svg width="18" height="10" viewBox="0 0 18 10" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" stroke-width="1.2" points="1 9 9 1 17 9 "/></svg>';
    var icons = {
      spinner,
      totop,
      marker,
      "close-icon": closeIcon,
      "close-large": closeLarge,
      "navbar-toggle-icon": navbarToggleIcon,
      "overlay-icon": overlayIcon,
      "pagination-next": paginationNext,
      "pagination-previous": paginationPrevious,
      "search-icon": searchIcon,
      "search-large": searchLarge,
      "search-navbar": searchNavbar,
      "slidenav-next": slidenavNext,
      "slidenav-next-large": slidenavNextLarge,
      "slidenav-previous": slidenavPrevious,
      "slidenav-previous-large": slidenavPreviousLarge
    };
    var Icon = {
      install: install$3,
      extends: SVG,
      args: "icon",
      props: ["icon"],
      data: {
        include: ["focusable"]
      },
      isIcon: true,
      beforeConnect: function() {
        addClass(this.$el, "uk-icon");
      },
      methods: {
        getSvg: function() {
          var icon = getIcon(this.icon);
          if (!icon) {
            return Promise$1.reject("Icon not found.");
          }
          return Promise$1.resolve(icon);
        }
      }
    };
    var IconComponent = {
      args: false,
      extends: Icon,
      data: function(vm) {
        return {
          icon: hyphenate2(vm.constructor.options.name)
        };
      },
      beforeConnect: function() {
        addClass(this.$el, this.$name);
      }
    };
    var Slidenav = {
      extends: IconComponent,
      beforeConnect: function() {
        addClass(this.$el, "uk-slidenav");
      },
      computed: {
        icon: function(ref2, $el) {
          var icon = ref2.icon;
          return hasClass($el, "uk-slidenav-large") ? icon + "-large" : icon;
        }
      }
    };
    var Search = {
      extends: IconComponent,
      computed: {
        icon: function(ref2, $el) {
          var icon = ref2.icon;
          return hasClass($el, "uk-search-icon") && parents($el, ".uk-search-large").length ? "search-large" : parents($el, ".uk-search-navbar").length ? "search-navbar" : icon;
        }
      }
    };
    var Close = {
      extends: IconComponent,
      computed: {
        icon: function() {
          return "close-" + (hasClass(this.$el, "uk-close-large") ? "large" : "icon");
        }
      }
    };
    var Spinner = {
      extends: IconComponent,
      connected: function() {
        var this$1$1 = this;
        this.svg.then(function(svg) {
          return svg && this$1$1.ratio !== 1 && css($("circle", svg), "strokeWidth", 1 / this$1$1.ratio);
        });
      }
    };
    var parsed = {};
    function install$3(UIkit3) {
      UIkit3.icon.add = function(name, svg) {
        var obj2;
        var added = isString2(name) ? (obj2 = {}, obj2[name] = svg, obj2) : name;
        each(added, function(svg2, name2) {
          icons[name2] = svg2;
          delete parsed[name2];
        });
        if (UIkit3._initialized) {
          apply$1(document.body, function(el) {
            return each(UIkit3.getComponents(el), function(cmp) {
              cmp.$options.isIcon && cmp.icon in added && cmp.$reset();
            });
          });
        }
      };
    }
    function getIcon(icon) {
      if (!icons[icon]) {
        return null;
      }
      if (!parsed[icon]) {
        parsed[icon] = $((icons[applyRtl(icon)] || icons[icon]).trim());
      }
      return parsed[icon].cloneNode(true);
    }
    function applyRtl(icon) {
      return isRtl ? swap(swap(icon, "left", "right"), "previous", "next") : icon;
    }
    var img = {
      args: "dataSrc",
      props: {
        dataSrc: String,
        dataSrcset: Boolean,
        sizes: String,
        width: Number,
        height: Number,
        offsetTop: String,
        offsetLeft: String,
        target: String
      },
      data: {
        dataSrc: "",
        dataSrcset: false,
        sizes: false,
        width: false,
        height: false,
        offsetTop: "50vh",
        offsetLeft: "50vw",
        target: false
      },
      computed: {
        cacheKey: function(ref2) {
          var dataSrc = ref2.dataSrc;
          return this.$name + "." + dataSrc;
        },
        width: function(ref2) {
          var width2 = ref2.width;
          var dataWidth = ref2.dataWidth;
          return width2 || dataWidth;
        },
        height: function(ref2) {
          var height2 = ref2.height;
          var dataHeight = ref2.dataHeight;
          return height2 || dataHeight;
        },
        sizes: function(ref2) {
          var sizes = ref2.sizes;
          var dataSizes = ref2.dataSizes;
          return sizes || dataSizes;
        },
        isImg: function(_, $el) {
          return isImg($el);
        },
        target: {
          get: function(ref2) {
            var target = ref2.target;
            return [this.$el].concat(queryAll(target, this.$el));
          },
          watch: function() {
            this.observe();
          }
        },
        offsetTop: function(ref2) {
          var offsetTop = ref2.offsetTop;
          return toPx(offsetTop, "height");
        },
        offsetLeft: function(ref2) {
          var offsetLeft = ref2.offsetLeft;
          return toPx(offsetLeft, "width");
        }
      },
      connected: function() {
        if (!window.IntersectionObserver) {
          setSrcAttrs(this.$el, this.dataSrc, this.dataSrcset, this.sizes);
          return;
        }
        if (storage[this.cacheKey]) {
          setSrcAttrs(this.$el, storage[this.cacheKey], this.dataSrcset, this.sizes);
        } else if (this.isImg && this.width && this.height) {
          setSrcAttrs(this.$el, getPlaceholderImage(this.width, this.height, this.sizes));
        }
        this.observer = new IntersectionObserver(this.load, {
          rootMargin: this.offsetTop + "px " + this.offsetLeft + "px"
        });
        requestAnimationFrame(this.observe);
      },
      disconnected: function() {
        this.observer && this.observer.disconnect();
      },
      update: {
        read: function(ref2) {
          var this$1$1 = this;
          var image = ref2.image;
          if (!this.observer) {
            return false;
          }
          if (!image && document.readyState === "complete") {
            this.load(this.observer.takeRecords());
          }
          if (this.isImg) {
            return false;
          }
          image && image.then(function(img2) {
            return img2 && img2.currentSrc !== "" && setSrcAttrs(this$1$1.$el, currentSrc(img2));
          });
        },
        write: function(data3) {
          if (this.dataSrcset && window.devicePixelRatio !== 1) {
            var bgSize = css(this.$el, "backgroundSize");
            if (bgSize.match(/^(auto\s?)+$/) || toFloat(bgSize) === data3.bgSize) {
              data3.bgSize = getSourceSize(this.dataSrcset, this.sizes);
              css(this.$el, "backgroundSize", data3.bgSize + "px");
            }
          }
        },
        events: ["resize"]
      },
      methods: {
        load: function(entries) {
          var this$1$1 = this;
          if (!entries.some(function(entry) {
            return isUndefined2(entry.isIntersecting) || entry.isIntersecting;
          })) {
            return;
          }
          this._data.image = getImage(this.dataSrc, this.dataSrcset, this.sizes).then(function(img2) {
            setSrcAttrs(this$1$1.$el, currentSrc(img2), img2.srcset, img2.sizes);
            storage[this$1$1.cacheKey] = currentSrc(img2);
            return img2;
          }, function(e) {
            return trigger2(this$1$1.$el, new e.constructor(e.type, e));
          });
          this.observer.disconnect();
        },
        observe: function() {
          var this$1$1 = this;
          if (this._connected && !this._data.image) {
            this.target.forEach(function(el) {
              return this$1$1.observer.observe(el);
            });
          }
        }
      }
    };
    function setSrcAttrs(el, src, srcset, sizes) {
      if (isImg(el)) {
        var set2 = function(prop, val) {
          return val && val !== el[prop] && (el[prop] = val);
        };
        set2("sizes", sizes);
        set2("srcset", srcset);
        set2("src", src);
      } else if (src) {
        var change = !includes(el.style.backgroundImage, src);
        if (change) {
          css(el, "backgroundImage", "url(" + escape(src) + ")");
          trigger2(el, createEvent("load", false));
        }
      }
    }
    function getPlaceholderImage(width2, height2, sizes) {
      var assign3;
      if (sizes) {
        assign3 = Dimensions.ratio({ width: width2, height: height2 }, "width", toPx(sizesToPixel(sizes))), width2 = assign3.width, height2 = assign3.height;
      }
      return 'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="' + width2 + '" height="' + height2 + '"></svg>';
    }
    var sizesRe = /\s*(.*?)\s*(\w+|calc\(.*?\))\s*(?:,|$)/g;
    function sizesToPixel(sizes) {
      var matches2;
      sizesRe.lastIndex = 0;
      while (matches2 = sizesRe.exec(sizes)) {
        if (!matches2[1] || window.matchMedia(matches2[1]).matches) {
          matches2 = evaluateSize(matches2[2]);
          break;
        }
      }
      return matches2 || "100vw";
    }
    var sizeRe = /\d+(?:\w+|%)/g;
    var additionRe = /[+-]?(\d+)/g;
    function evaluateSize(size2) {
      return startsWith(size2, "calc") ? size2.slice(5, -1).replace(sizeRe, function(size3) {
        return toPx(size3);
      }).replace(/ /g, "").match(additionRe).reduce(function(a, b) {
        return a + +b;
      }, 0) : size2;
    }
    var srcSetRe = /\s+\d+w\s*(?:,|$)/g;
    function getSourceSize(srcset, sizes) {
      var srcSize = toPx(sizesToPixel(sizes));
      var descriptors = (srcset.match(srcSetRe) || []).map(toFloat).sort(function(a, b) {
        return a - b;
      });
      return descriptors.filter(function(size2) {
        return size2 >= srcSize;
      })[0] || descriptors.pop() || "";
    }
    function isImg(el) {
      return el.tagName === "IMG";
    }
    function currentSrc(el) {
      return el.currentSrc || el.src;
    }
    var key = "__test__";
    var storage;
    try {
      storage = window.sessionStorage || {};
      storage[key] = 1;
      delete storage[key];
    } catch (e) {
      storage = {};
    }
    var Media = {
      props: {
        media: Boolean
      },
      data: {
        media: false
      },
      computed: {
        matchMedia: function() {
          var media = toMedia(this.media);
          return !media || window.matchMedia(media).matches;
        }
      }
    };
    function toMedia(value) {
      if (isString2(value)) {
        if (value[0] === "@") {
          var name = "breakpoint-" + value.substr(1);
          value = toFloat(getCssVar(name));
        } else if (isNaN(value)) {
          return value;
        }
      }
      return value && !isNaN(value) ? "(min-width: " + value + "px)" : false;
    }
    var leader = {
      mixins: [Class, Media],
      props: {
        fill: String
      },
      data: {
        fill: "",
        clsWrapper: "uk-leader-fill",
        clsHide: "uk-leader-hide",
        attrFill: "data-fill"
      },
      computed: {
        fill: function(ref2) {
          var fill = ref2.fill;
          return fill || getCssVar("leader-fill-content");
        }
      },
      connected: function() {
        var assign3;
        assign3 = wrapInner(this.$el, '<span class="' + this.clsWrapper + '">'), this.wrapper = assign3[0];
      },
      disconnected: function() {
        unwrap(this.wrapper.childNodes);
      },
      update: {
        read: function(ref2) {
          var changed = ref2.changed;
          var width2 = ref2.width;
          var prev = width2;
          width2 = Math.floor(this.$el.offsetWidth / 2);
          return {
            width: width2,
            fill: this.fill,
            changed: changed || prev !== width2,
            hide: !this.matchMedia
          };
        },
        write: function(data3) {
          toggleClass(this.wrapper, this.clsHide, data3.hide);
          if (data3.changed) {
            data3.changed = false;
            attr(this.wrapper, this.attrFill, new Array(data3.width).join(data3.fill));
          }
        },
        events: ["resize"]
      }
    };
    var active = [];
    var Modal = {
      mixins: [Class, Container, Togglable],
      props: {
        selPanel: String,
        selClose: String,
        escClose: Boolean,
        bgClose: Boolean,
        stack: Boolean
      },
      data: {
        cls: "uk-open",
        escClose: true,
        bgClose: true,
        overlay: true,
        stack: false
      },
      computed: {
        panel: function(ref2, $el) {
          var selPanel = ref2.selPanel;
          return $(selPanel, $el);
        },
        transitionElement: function() {
          return this.panel;
        },
        bgClose: function(ref2) {
          var bgClose = ref2.bgClose;
          return bgClose && this.panel;
        }
      },
      beforeDisconnect: function() {
        if (includes(active, this)) {
          this.toggleElement(this.$el, false, false);
        }
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.selClose;
          },
          handler: function(e) {
            e.preventDefault();
            this.hide();
          }
        },
        {
          name: "toggle",
          self: true,
          handler: function(e, toggle2) {
            if (e.defaultPrevented) {
              return;
            }
            e.preventDefault();
            if (this.isToggled() === includes(active, this)) {
              this.toggle();
            }
          }
        },
        {
          name: "beforeshow",
          self: true,
          handler: function(e) {
            if (includes(active, this)) {
              return false;
            }
            if (!this.stack && active.length) {
              Promise$1.all(active.map(function(modal2) {
                return modal2.hide();
              })).then(this.show);
              e.preventDefault();
            } else {
              active.push(this);
            }
          }
        },
        {
          name: "show",
          self: true,
          handler: function() {
            var this$1$1 = this;
            var docEl = document.documentElement;
            if (width(window) > docEl.clientWidth && this.overlay) {
              css(document.body, "overflowY", "scroll");
            }
            if (this.stack) {
              css(this.$el, "zIndex", toFloat(css(this.$el, "zIndex")) + active.length);
            }
            addClass(docEl, this.clsPage);
            if (this.bgClose) {
              once(this.$el, "hide", on(document, pointerDown, function(ref2) {
                var target = ref2.target;
                if (last(active) !== this$1$1 || this$1$1.overlay && !within(target, this$1$1.$el) || within(target, this$1$1.panel)) {
                  return;
                }
                once(document, pointerUp + " " + pointerCancel + " scroll", function(ref3) {
                  var defaultPrevented = ref3.defaultPrevented;
                  var type = ref3.type;
                  var newTarget = ref3.target;
                  if (!defaultPrevented && type === pointerUp && target === newTarget) {
                    this$1$1.hide();
                  }
                }, true);
              }), { self: true });
            }
            if (this.escClose) {
              once(this.$el, "hide", on(document, "keydown", function(e) {
                if (e.keyCode === 27 && last(active) === this$1$1) {
                  this$1$1.hide();
                }
              }), { self: true });
            }
          }
        },
        {
          name: "shown",
          self: true,
          handler: function() {
            if (!isFocusable(this.$el)) {
              attr(this.$el, "tabindex", "-1");
            }
            if (!$(":focus", this.$el)) {
              this.$el.focus();
            }
          }
        },
        {
          name: "hidden",
          self: true,
          handler: function() {
            var this$1$1 = this;
            if (includes(active, this)) {
              active.splice(active.indexOf(this), 1);
            }
            if (!active.length) {
              css(document.body, "overflowY", "");
            }
            css(this.$el, "zIndex", "");
            if (!active.some(function(modal2) {
              return modal2.clsPage === this$1$1.clsPage;
            })) {
              removeClass(document.documentElement, this.clsPage);
            }
          }
        }
      ],
      methods: {
        toggle: function() {
          return this.isToggled() ? this.hide() : this.show();
        },
        show: function() {
          var this$1$1 = this;
          if (this.container && parent(this.$el) !== this.container) {
            append(this.container, this.$el);
            return new Promise$1(function(resolve2) {
              return requestAnimationFrame(function() {
                return this$1$1.show().then(resolve2);
              });
            });
          }
          return this.toggleElement(this.$el, true, animate(this));
        },
        hide: function() {
          return this.toggleElement(this.$el, false, animate(this));
        }
      }
    };
    function animate(ref2) {
      var transitionElement = ref2.transitionElement;
      var _toggle = ref2._toggle;
      return function(el, show) {
        return new Promise$1(function(resolve2, reject) {
          return once(el, "show hide", function() {
            el._reject && el._reject();
            el._reject = reject;
            _toggle(el, show);
            var off2 = once(transitionElement, "transitionstart", function() {
              once(transitionElement, "transitionend transitioncancel", resolve2, { self: true });
              clearTimeout(timer);
            }, { self: true });
            var timer = setTimeout(function() {
              off2();
              resolve2();
            }, toMs2(css(transitionElement, "transitionDuration")));
          });
        }).then(function() {
          return delete el._reject;
        });
      };
    }
    var modal = {
      install: install$2,
      mixins: [Modal],
      data: {
        clsPage: "uk-modal-page",
        selPanel: ".uk-modal-dialog",
        selClose: ".uk-modal-close, .uk-modal-close-default, .uk-modal-close-outside, .uk-modal-close-full"
      },
      events: [
        {
          name: "show",
          self: true,
          handler: function() {
            if (hasClass(this.panel, "uk-margin-auto-vertical")) {
              addClass(this.$el, "uk-flex");
            } else {
              css(this.$el, "display", "block");
            }
            height(this.$el);
          }
        },
        {
          name: "hidden",
          self: true,
          handler: function() {
            css(this.$el, "display", "");
            removeClass(this.$el, "uk-flex");
          }
        }
      ]
    };
    function install$2(ref2) {
      var modal2 = ref2.modal;
      modal2.dialog = function(content, options) {
        var dialog = modal2('<div class="uk-modal"> <div class="uk-modal-dialog">' + content + "</div> </div>", options);
        dialog.show();
        on(dialog.$el, "hidden", function() {
          return Promise$1.resolve().then(function() {
            return dialog.$destroy(true);
          });
        }, { self: true });
        return dialog;
      };
      modal2.alert = function(message, options) {
        return openDialog(function(ref3) {
          var labels = ref3.labels;
          return '<div class="uk-modal-body">' + (isString2(message) ? message : html(message)) + '</div> <div class="uk-modal-footer uk-text-right"> <button class="uk-button uk-button-primary uk-modal-close" autofocus>' + labels.ok + "</button> </div>";
        }, options, function(deferred) {
          return deferred.resolve();
        });
      };
      modal2.confirm = function(message, options) {
        return openDialog(function(ref3) {
          var labels = ref3.labels;
          return '<form> <div class="uk-modal-body">' + (isString2(message) ? message : html(message)) + '</div> <div class="uk-modal-footer uk-text-right"> <button class="uk-button uk-button-default uk-modal-close" type="button">' + labels.cancel + '</button> <button class="uk-button uk-button-primary" autofocus>' + labels.ok + "</button> </div> </form>";
        }, options, function(deferred) {
          return deferred.reject();
        });
      };
      modal2.prompt = function(message, value, options) {
        return openDialog(function(ref3) {
          var labels = ref3.labels;
          return '<form class="uk-form-stacked"> <div class="uk-modal-body"> <label>' + (isString2(message) ? message : html(message)) + '</label> <input class="uk-input" value="' + (value || "") + '" autofocus> </div> <div class="uk-modal-footer uk-text-right"> <button class="uk-button uk-button-default uk-modal-close" type="button">' + labels.cancel + '</button> <button class="uk-button uk-button-primary">' + labels.ok + "</button> </div> </form>";
        }, options, function(deferred) {
          return deferred.resolve(null);
        }, function(dialog) {
          return $("input", dialog.$el).value;
        });
      };
      modal2.labels = {
        ok: "Ok",
        cancel: "Cancel"
      };
      function openDialog(tmpl, options, hideFn, submitFn) {
        options = assign2({ bgClose: false, escClose: true, labels: modal2.labels }, options);
        var dialog = modal2.dialog(tmpl(options), options);
        var deferred = new Deferred();
        var resolved = false;
        on(dialog.$el, "submit", "form", function(e) {
          e.preventDefault();
          deferred.resolve(submitFn && submitFn(dialog));
          resolved = true;
          dialog.hide();
        });
        on(dialog.$el, "hide", function() {
          return !resolved && hideFn(deferred);
        });
        deferred.promise.dialog = dialog;
        return deferred.promise;
      }
    }
    var nav = {
      extends: Accordion,
      data: {
        targets: "> .uk-parent",
        toggle: "> a",
        content: "> ul"
      }
    };
    var navItem = ".uk-navbar-nav > li > a, .uk-navbar-item, .uk-navbar-toggle";
    var navbar = {
      mixins: [Class, Container, FlexBug],
      props: {
        dropdown: String,
        mode: "list",
        align: String,
        offset: Number,
        boundary: Boolean,
        boundaryAlign: Boolean,
        clsDrop: String,
        delayShow: Number,
        delayHide: Number,
        dropbar: Boolean,
        dropbarMode: String,
        dropbarAnchor: Boolean,
        duration: Number
      },
      data: {
        dropdown: navItem,
        align: isRtl ? "right" : "left",
        clsDrop: "uk-navbar-dropdown",
        mode: void 0,
        offset: void 0,
        delayShow: void 0,
        delayHide: void 0,
        boundaryAlign: void 0,
        flip: "x",
        boundary: true,
        dropbar: false,
        dropbarMode: "slide",
        dropbarAnchor: false,
        duration: 200,
        forceHeight: true,
        selMinHeight: navItem,
        container: false
      },
      computed: {
        boundary: function(ref2, $el) {
          var boundary = ref2.boundary;
          var boundaryAlign = ref2.boundaryAlign;
          return boundary === true || boundaryAlign ? $el : boundary;
        },
        dropbarAnchor: function(ref2, $el) {
          var dropbarAnchor = ref2.dropbarAnchor;
          return query(dropbarAnchor, $el);
        },
        pos: function(ref2) {
          var align = ref2.align;
          return "bottom-" + align;
        },
        dropbar: {
          get: function(ref2) {
            var dropbar = ref2.dropbar;
            if (!dropbar) {
              return null;
            }
            dropbar = this._dropbar || query(dropbar, this.$el) || $("+ .uk-navbar-dropbar", this.$el);
            return dropbar ? dropbar : this._dropbar = $("<div></div>");
          },
          watch: function(dropbar) {
            addClass(dropbar, "uk-navbar-dropbar");
          },
          immediate: true
        },
        dropContainer: function(_, $el) {
          return this.container || $el;
        },
        dropdowns: {
          get: function(ref2, $el) {
            var this$1$1 = this;
            var clsDrop = ref2.clsDrop;
            var dropdowns = $$("." + clsDrop, $el);
            if (this.dropContainer !== $el) {
              $$("." + clsDrop, this.dropContainer).forEach(function(el) {
                var dropdown = this$1$1.getDropdown(el);
                if (!includes(dropdowns, el) && dropdown && dropdown.target && within(dropdown.target, this$1$1.$el)) {
                  dropdowns.push(el);
                }
              });
            }
            return dropdowns;
          },
          watch: function(dropdowns) {
            var this$1$1 = this;
            this.$create("drop", dropdowns.filter(function(el) {
              return !this$1$1.getDropdown(el);
            }), assign2({}, this.$props, { boundary: this.boundary, pos: this.pos, offset: this.dropbar || this.offset }));
          },
          immediate: true
        },
        toggles: function(ref2, $el) {
          var dropdown = ref2.dropdown;
          return $$(dropdown, $el);
        }
      },
      disconnected: function() {
        this.dropbar && remove$1(this.dropbar);
        delete this._dropbar;
      },
      events: [
        {
          name: "mouseover focusin",
          delegate: function() {
            return this.dropdown;
          },
          handler: function(ref2) {
            var current = ref2.current;
            var active2 = this.getActive();
            if (active2 && includes(active2.mode, "hover") && active2.target && !within(active2.target, current) && !active2.tracker.movesTo(active2.$el)) {
              active2.hide(false);
            }
          }
        },
        {
          name: "keydown",
          delegate: function() {
            return this.dropdown;
          },
          handler: function(e) {
            var current = e.current;
            var keyCode = e.keyCode;
            var active2 = this.getActive();
            if (keyCode === keyMap.DOWN && hasAttr(current, "aria-expanded")) {
              e.preventDefault();
              if (!active2 || active2.target !== current) {
                current.click();
                once(this.dropContainer, "show", function(ref2) {
                  var target = ref2.target;
                  return focusFirstFocusableElement(target);
                });
              } else {
                focusFirstFocusableElement(active2.$el);
              }
            }
            handleNavItemNavigation(e, this.toggles, active2);
          }
        },
        {
          name: "keydown",
          el: function() {
            return this.dropContainer;
          },
          delegate: function() {
            return "." + this.clsDrop;
          },
          handler: function(e) {
            var current = e.current;
            var keyCode = e.keyCode;
            if (!includes(this.dropdowns, current)) {
              return;
            }
            var active2 = this.getActive();
            var elements = $$(selFocusable, current);
            var i = findIndex(elements, function(el) {
              return matches(el, ":focus");
            });
            if (keyCode === keyMap.UP) {
              e.preventDefault();
              if (i > 0) {
                elements[i - 1].focus();
              }
            }
            if (keyCode === keyMap.DOWN) {
              e.preventDefault();
              if (i < elements.length - 1) {
                elements[i + 1].focus();
              }
            }
            if (keyCode === keyMap.ESC) {
              active2 && active2.target && active2.target.focus();
            }
            handleNavItemNavigation(e, this.toggles, active2);
          }
        },
        {
          name: "mouseleave",
          el: function() {
            return this.dropbar;
          },
          filter: function() {
            return this.dropbar;
          },
          handler: function() {
            var active2 = this.getActive();
            if (active2 && includes(active2.mode, "hover") && !this.dropdowns.some(function(el) {
              return matches(el, ":hover");
            })) {
              active2.hide();
            }
          }
        },
        {
          name: "beforeshow",
          el: function() {
            return this.dropContainer;
          },
          filter: function() {
            return this.dropbar;
          },
          handler: function() {
            if (!parent(this.dropbar)) {
              after(this.dropbarAnchor || this.$el, this.dropbar);
            }
          }
        },
        {
          name: "show",
          el: function() {
            return this.dropContainer;
          },
          filter: function() {
            return this.dropbar;
          },
          handler: function(_, ref2) {
            var $el = ref2.$el;
            var dir = ref2.dir;
            if (!hasClass($el, this.clsDrop)) {
              return;
            }
            if (this.dropbarMode === "slide") {
              addClass(this.dropbar, "uk-navbar-dropbar-slide");
            }
            this.clsDrop && addClass($el, this.clsDrop + "-dropbar");
            if (dir === "bottom") {
              this.transitionTo($el.offsetHeight + toFloat(css($el, "marginTop")) + toFloat(css($el, "marginBottom")), $el);
            }
          }
        },
        {
          name: "beforehide",
          el: function() {
            return this.dropContainer;
          },
          filter: function() {
            return this.dropbar;
          },
          handler: function(e, ref2) {
            var $el = ref2.$el;
            var active2 = this.getActive();
            if (matches(this.dropbar, ":hover") && active2 && active2.$el === $el) {
              e.preventDefault();
            }
          }
        },
        {
          name: "hide",
          el: function() {
            return this.dropContainer;
          },
          filter: function() {
            return this.dropbar;
          },
          handler: function(_, ref2) {
            var $el = ref2.$el;
            if (!hasClass($el, this.clsDrop)) {
              return;
            }
            var active2 = this.getActive();
            if (!active2 || active2 && active2.$el === $el) {
              this.transitionTo(0);
            }
          }
        }
      ],
      methods: {
        getActive: function() {
          return active$1 && within(active$1.target, this.$el) && active$1;
        },
        transitionTo: function(newHeight, el) {
          var this$1$1 = this;
          var ref2 = this;
          var dropbar = ref2.dropbar;
          var oldHeight = isVisible(dropbar) ? height(dropbar) : 0;
          el = oldHeight < newHeight && el;
          css(el, "clip", "rect(0," + el.offsetWidth + "px," + oldHeight + "px,0)");
          height(dropbar, oldHeight);
          Transition2.cancel([el, dropbar]);
          return Promise$1.all([
            Transition2.start(dropbar, { height: newHeight }, this.duration),
            Transition2.start(el, { clip: "rect(0," + el.offsetWidth + "px," + newHeight + "px,0)" }, this.duration)
          ]).catch(noop2).then(function() {
            css(el, { clip: "" });
            this$1$1.$update(dropbar);
          });
        },
        getDropdown: function(el) {
          return this.$getComponent(el, "drop") || this.$getComponent(el, "dropdown");
        }
      }
    };
    function handleNavItemNavigation(e, toggles, active2) {
      var current = e.current;
      var keyCode = e.keyCode;
      var target = active2 && active2.target || current;
      var i = toggles.indexOf(target);
      if (keyCode === keyMap.LEFT && i > 0) {
        active2 && active2.hide(false);
        toggles[i - 1].focus();
      }
      if (keyCode === keyMap.RIGHT && i < toggles.length - 1) {
        active2 && active2.hide(false);
        toggles[i + 1].focus();
      }
      if (keyCode === keyMap.TAB) {
        target.focus();
        active2 && active2.hide(false);
      }
    }
    function focusFirstFocusableElement(el) {
      if (!$(":focus", el)) {
        var focusEl = $(selFocusable, el);
        if (focusEl) {
          focusEl.focus();
        }
      }
    }
    var keyMap = {
      TAB: 9,
      ESC: 27,
      LEFT: 37,
      UP: 38,
      RIGHT: 39,
      DOWN: 40
    };
    var offcanvas = {
      mixins: [Modal],
      args: "mode",
      props: {
        mode: String,
        flip: Boolean,
        overlay: Boolean
      },
      data: {
        mode: "slide",
        flip: false,
        overlay: false,
        clsPage: "uk-offcanvas-page",
        clsContainer: "uk-offcanvas-container",
        selPanel: ".uk-offcanvas-bar",
        clsFlip: "uk-offcanvas-flip",
        clsContainerAnimation: "uk-offcanvas-container-animation",
        clsSidebarAnimation: "uk-offcanvas-bar-animation",
        clsMode: "uk-offcanvas",
        clsOverlay: "uk-offcanvas-overlay",
        selClose: ".uk-offcanvas-close",
        container: false
      },
      computed: {
        clsFlip: function(ref2) {
          var flip = ref2.flip;
          var clsFlip = ref2.clsFlip;
          return flip ? clsFlip : "";
        },
        clsOverlay: function(ref2) {
          var overlay = ref2.overlay;
          var clsOverlay = ref2.clsOverlay;
          return overlay ? clsOverlay : "";
        },
        clsMode: function(ref2) {
          var mode = ref2.mode;
          var clsMode = ref2.clsMode;
          return clsMode + "-" + mode;
        },
        clsSidebarAnimation: function(ref2) {
          var mode = ref2.mode;
          var clsSidebarAnimation = ref2.clsSidebarAnimation;
          return mode === "none" || mode === "reveal" ? "" : clsSidebarAnimation;
        },
        clsContainerAnimation: function(ref2) {
          var mode = ref2.mode;
          var clsContainerAnimation = ref2.clsContainerAnimation;
          return mode !== "push" && mode !== "reveal" ? "" : clsContainerAnimation;
        },
        transitionElement: function(ref2) {
          var mode = ref2.mode;
          return mode === "reveal" ? parent(this.panel) : this.panel;
        }
      },
      update: {
        read: function() {
          if (this.isToggled() && !isVisible(this.$el)) {
            this.hide();
          }
        },
        events: ["resize"]
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return 'a[href^="#"]';
          },
          handler: function(ref2) {
            var hash = ref2.current.hash;
            var defaultPrevented = ref2.defaultPrevented;
            if (!defaultPrevented && hash && $(hash, document.body)) {
              this.hide();
            }
          }
        },
        {
          name: "touchstart",
          passive: true,
          el: function() {
            return this.panel;
          },
          handler: function(ref2) {
            var targetTouches = ref2.targetTouches;
            if (targetTouches.length === 1) {
              this.clientY = targetTouches[0].clientY;
            }
          }
        },
        {
          name: "touchmove",
          self: true,
          passive: false,
          filter: function() {
            return this.overlay;
          },
          handler: function(e) {
            e.cancelable && e.preventDefault();
          }
        },
        {
          name: "touchmove",
          passive: false,
          el: function() {
            return this.panel;
          },
          handler: function(e) {
            if (e.targetTouches.length !== 1) {
              return;
            }
            var clientY = e.targetTouches[0].clientY - this.clientY;
            var ref2 = this.panel;
            var scrollTop2 = ref2.scrollTop;
            var scrollHeight = ref2.scrollHeight;
            var clientHeight = ref2.clientHeight;
            if (clientHeight >= scrollHeight || scrollTop2 === 0 && clientY > 0 || scrollHeight - scrollTop2 <= clientHeight && clientY < 0) {
              e.cancelable && e.preventDefault();
            }
          }
        },
        {
          name: "show",
          self: true,
          handler: function() {
            if (this.mode === "reveal" && !hasClass(parent(this.panel), this.clsMode)) {
              wrapAll(this.panel, "<div>");
              addClass(parent(this.panel), this.clsMode);
            }
            css(document.documentElement, "overflowY", this.overlay ? "hidden" : "");
            addClass(document.body, this.clsContainer, this.clsFlip);
            css(document.body, "touch-action", "pan-y pinch-zoom");
            css(this.$el, "display", "block");
            addClass(this.$el, this.clsOverlay);
            addClass(this.panel, this.clsSidebarAnimation, this.mode !== "reveal" ? this.clsMode : "");
            height(document.body);
            addClass(document.body, this.clsContainerAnimation);
            this.clsContainerAnimation && suppressUserScale();
          }
        },
        {
          name: "hide",
          self: true,
          handler: function() {
            removeClass(document.body, this.clsContainerAnimation);
            css(document.body, "touch-action", "");
          }
        },
        {
          name: "hidden",
          self: true,
          handler: function() {
            this.clsContainerAnimation && resumeUserScale();
            if (this.mode === "reveal") {
              unwrap(this.panel);
            }
            removeClass(this.panel, this.clsSidebarAnimation, this.clsMode);
            removeClass(this.$el, this.clsOverlay);
            css(this.$el, "display", "");
            removeClass(document.body, this.clsContainer, this.clsFlip);
            css(document.documentElement, "overflowY", "");
          }
        },
        {
          name: "swipeLeft swipeRight",
          handler: function(e) {
            if (this.isToggled() && endsWith(e.type, "Left") ^ this.flip) {
              this.hide();
            }
          }
        }
      ]
    };
    function suppressUserScale() {
      getViewport().content += ",user-scalable=0";
    }
    function resumeUserScale() {
      var viewport = getViewport();
      viewport.content = viewport.content.replace(/,user-scalable=0$/, "");
    }
    function getViewport() {
      return $('meta[name="viewport"]', document.head) || append(document.head, '<meta name="viewport">');
    }
    var overflowAuto = {
      mixins: [Class],
      props: {
        selContainer: String,
        selContent: String,
        minHeight: Number
      },
      data: {
        selContainer: ".uk-modal",
        selContent: ".uk-modal-dialog",
        minHeight: 150
      },
      computed: {
        container: function(ref2, $el) {
          var selContainer = ref2.selContainer;
          return closest($el, selContainer);
        },
        content: function(ref2, $el) {
          var selContent = ref2.selContent;
          return closest($el, selContent);
        }
      },
      connected: function() {
        css(this.$el, "minHeight", this.minHeight);
      },
      update: {
        read: function() {
          if (!this.content || !this.container || !isVisible(this.$el)) {
            return false;
          }
          return {
            current: toFloat(css(this.$el, "maxHeight")),
            max: Math.max(this.minHeight, height(this.container) - (dimensions(this.content).height - height(this.$el)))
          };
        },
        write: function(ref2) {
          var current = ref2.current;
          var max = ref2.max;
          css(this.$el, "maxHeight", max);
          if (Math.round(current) !== Math.round(max)) {
            trigger2(this.$el, "resize");
          }
        },
        events: ["resize"]
      }
    };
    var responsive = {
      props: ["width", "height"],
      connected: function() {
        addClass(this.$el, "uk-responsive-width");
      },
      update: {
        read: function() {
          return isVisible(this.$el) && this.width && this.height ? { width: width(parent(this.$el)), height: this.height } : false;
        },
        write: function(dim) {
          height(this.$el, Dimensions.contain({
            height: this.height,
            width: this.width
          }, dim).height);
        },
        events: ["resize"]
      }
    };
    var scroll = {
      props: {
        offset: Number
      },
      data: {
        offset: 0
      },
      methods: {
        scrollTo: function(el) {
          var this$1$1 = this;
          el = el && $(el) || document.body;
          if (trigger2(this.$el, "beforescroll", [this, el])) {
            scrollIntoView(el, { offset: this.offset }).then(function() {
              return trigger2(this$1$1.$el, "scrolled", [this$1$1, el]);
            });
          }
        }
      },
      events: {
        click: function(e) {
          if (e.defaultPrevented) {
            return;
          }
          e.preventDefault();
          this.scrollTo("#" + escape(decodeURIComponent((this.$el.hash || "").substr(1))));
        }
      }
    };
    var stateKey = "_ukScrollspy";
    var scrollspy = {
      args: "cls",
      props: {
        cls: String,
        target: String,
        hidden: Boolean,
        offsetTop: Number,
        offsetLeft: Number,
        repeat: Boolean,
        delay: Number
      },
      data: function() {
        return {
          cls: false,
          target: false,
          hidden: true,
          offsetTop: 0,
          offsetLeft: 0,
          repeat: false,
          delay: 0,
          inViewClass: "uk-scrollspy-inview"
        };
      },
      computed: {
        elements: {
          get: function(ref2, $el) {
            var target = ref2.target;
            return target ? $$(target, $el) : [$el];
          },
          watch: function(elements) {
            if (this.hidden) {
              css(filter$1(elements, ":not(." + this.inViewClass + ")"), "visibility", "hidden");
            }
          },
          immediate: true
        }
      },
      disconnected: function() {
        var this$1$1 = this;
        this.elements.forEach(function(el) {
          removeClass(el, this$1$1.inViewClass, el[stateKey] ? el[stateKey].cls : "");
          delete el[stateKey];
        });
      },
      update: [
        {
          read: function(data$1) {
            var this$1$1 = this;
            if (!data$1.update) {
              Promise$1.resolve().then(function() {
                this$1$1.$emit();
                data$1.update = true;
              });
              return false;
            }
            this.elements.forEach(function(el) {
              if (!el[stateKey]) {
                el[stateKey] = { cls: data2(el, "uk-scrollspy-class") || this$1$1.cls };
              }
              el[stateKey].show = isInView(el, this$1$1.offsetTop, this$1$1.offsetLeft);
            });
          },
          write: function(data3) {
            var this$1$1 = this;
            this.elements.forEach(function(el) {
              var state = el[stateKey];
              if (state.show && !state.inview && !state.queued) {
                state.queued = true;
                data3.promise = (data3.promise || Promise$1.resolve()).then(function() {
                  return new Promise$1(function(resolve2) {
                    return setTimeout(resolve2, this$1$1.delay);
                  });
                }).then(function() {
                  this$1$1.toggle(el, true);
                  setTimeout(function() {
                    state.queued = false;
                    this$1$1.$emit();
                  }, 300);
                });
              } else if (!state.show && state.inview && !state.queued && this$1$1.repeat) {
                this$1$1.toggle(el, false);
              }
            });
          },
          events: ["scroll", "resize"]
        }
      ],
      methods: {
        toggle: function(el, inview) {
          var state = el[stateKey];
          state.off && state.off();
          css(el, "visibility", !inview && this.hidden ? "hidden" : "");
          toggleClass(el, this.inViewClass, inview);
          toggleClass(el, state.cls);
          if (/\buk-animation-/.test(state.cls)) {
            state.off = once(el, "animationcancel animationend", function() {
              return removeClasses(el, "uk-animation-[\\w-]+");
            });
          }
          trigger2(el, inview ? "inview" : "outview");
          state.inview = inview;
          this.$update(el);
        }
      }
    };
    var scrollspyNav = {
      props: {
        cls: String,
        closest: String,
        scroll: Boolean,
        overflow: Boolean,
        offset: Number
      },
      data: {
        cls: "uk-active",
        closest: false,
        scroll: false,
        overflow: true,
        offset: 0
      },
      computed: {
        links: {
          get: function(_, $el) {
            return $$('a[href^="#"]', $el).filter(function(el) {
              return el.hash;
            });
          },
          watch: function(links) {
            if (this.scroll) {
              this.$create("scroll", links, { offset: this.offset || 0 });
            }
          },
          immediate: true
        },
        targets: function() {
          return $$(this.links.map(function(el) {
            return escape(el.hash).substr(1);
          }).join(","));
        },
        elements: function(ref2) {
          var selector = ref2.closest;
          return closest(this.links, selector || "*");
        }
      },
      update: [
        {
          read: function() {
            var this$1$1 = this;
            var ref2 = this.targets;
            var length = ref2.length;
            if (!length || !isVisible(this.$el)) {
              return false;
            }
            var ref$1 = scrollParents(this.targets, /auto|scroll/, true);
            var scrollElement = ref$1[0];
            var scrollTop2 = scrollElement.scrollTop;
            var scrollHeight = scrollElement.scrollHeight;
            var max = scrollHeight - getViewportClientHeight(scrollElement);
            var active2 = false;
            if (scrollTop2 === max) {
              active2 = length - 1;
            } else {
              this.targets.every(function(el, i) {
                if (offset(el).top - offset(getViewport$1(scrollElement)).top - this$1$1.offset <= 0) {
                  active2 = i;
                  return true;
                }
              });
              if (active2 === false && this.overflow) {
                active2 = 0;
              }
            }
            return { active: active2 };
          },
          write: function(ref2) {
            var active2 = ref2.active;
            var changed = active2 !== false && !hasClass(this.elements[active2], this.cls);
            this.links.forEach(function(el) {
              return el.blur();
            });
            removeClass(this.elements, this.cls);
            addClass(this.elements[active2], this.cls);
            if (changed) {
              trigger2(this.$el, "active", [active2, this.elements[active2]]);
            }
          },
          events: ["scroll", "resize"]
        }
      ]
    };
    var sticky = {
      mixins: [Class, Media],
      props: {
        top: null,
        bottom: Boolean,
        offset: String,
        animation: String,
        clsActive: String,
        clsInactive: String,
        clsFixed: String,
        clsBelow: String,
        selTarget: String,
        widthElement: Boolean,
        showOnUp: Boolean,
        targetOffset: Number
      },
      data: {
        top: 0,
        bottom: false,
        offset: 0,
        animation: "",
        clsActive: "uk-active",
        clsInactive: "",
        clsFixed: "uk-sticky-fixed",
        clsBelow: "uk-sticky-below",
        selTarget: "",
        widthElement: false,
        showOnUp: false,
        targetOffset: false
      },
      computed: {
        offset: function(ref2) {
          var offset2 = ref2.offset;
          return toPx(offset2);
        },
        selTarget: function(ref2, $el) {
          var selTarget = ref2.selTarget;
          return selTarget && $(selTarget, $el) || $el;
        },
        widthElement: function(ref2, $el) {
          var widthElement = ref2.widthElement;
          return query(widthElement, $el) || this.placeholder;
        },
        isActive: {
          get: function() {
            return hasClass(this.selTarget, this.clsActive);
          },
          set: function(value) {
            if (value && !this.isActive) {
              replaceClass(this.selTarget, this.clsInactive, this.clsActive);
              trigger2(this.$el, "active");
            } else if (!value && !hasClass(this.selTarget, this.clsInactive)) {
              replaceClass(this.selTarget, this.clsActive, this.clsInactive);
              trigger2(this.$el, "inactive");
            }
          }
        }
      },
      connected: function() {
        this.placeholder = $("+ .uk-sticky-placeholder", this.$el) || $('<div class="uk-sticky-placeholder"></div>');
        this.isFixed = false;
        this.isActive = false;
      },
      disconnected: function() {
        if (this.isFixed) {
          this.hide();
          removeClass(this.selTarget, this.clsInactive);
        }
        remove$1(this.placeholder);
        this.placeholder = null;
        this.widthElement = null;
      },
      events: [
        {
          name: "load hashchange popstate",
          el: function() {
            return window;
          },
          handler: function() {
            var this$1$1 = this;
            if (!(this.targetOffset !== false && location.hash && window.pageYOffset > 0)) {
              return;
            }
            var target = $(location.hash);
            if (target) {
              fastdom.read(function() {
                var ref2 = offset(target);
                var top = ref2.top;
                var elTop = offset(this$1$1.$el).top;
                var elHeight = this$1$1.$el.offsetHeight;
                if (this$1$1.isFixed && elTop + elHeight >= top && elTop <= top + target.offsetHeight) {
                  scrollTop(window, top - elHeight - (isNumeric(this$1$1.targetOffset) ? this$1$1.targetOffset : 0) - this$1$1.offset);
                }
              });
            }
          }
        }
      ],
      update: [
        {
          read: function(ref2, types) {
            var height$1 = ref2.height;
            this.inactive = !this.matchMedia || !isVisible(this.$el);
            if (this.inactive) {
              return false;
            }
            if (this.isActive && types.has("resize")) {
              this.hide();
              height$1 = this.$el.offsetHeight;
              this.show();
            }
            height$1 = this.isActive ? height$1 : this.$el.offsetHeight;
            if (height$1 + this.offset > height(window)) {
              this.inactive = true;
              return false;
            }
            var referenceElement = this.isFixed ? this.placeholder : this.$el;
            this.topOffset = offset(referenceElement).top;
            this.bottomOffset = this.topOffset + height$1;
            this.offsetParentTop = offset(referenceElement.offsetParent).top;
            var bottom = parseProp("bottom", this);
            this.top = Math.max(toFloat(parseProp("top", this)), this.topOffset) - this.offset;
            this.bottom = bottom && bottom - this.$el.offsetHeight;
            this.width = dimensions(isVisible(this.widthElement) ? this.widthElement : this.$el).width;
            return {
              height: height$1,
              top: offsetPosition(this.placeholder)[0],
              margins: css(this.$el, ["marginTop", "marginBottom", "marginLeft", "marginRight"])
            };
          },
          write: function(ref2) {
            var height2 = ref2.height;
            var margins = ref2.margins;
            var ref$1 = this;
            var placeholder = ref$1.placeholder;
            css(placeholder, assign2({ height: height2 }, margins));
            if (!within(placeholder, document)) {
              after(this.$el, placeholder);
              placeholder.hidden = true;
            }
            this.isActive = !!this.isActive;
          },
          events: ["resize"]
        },
        {
          read: function(ref2) {
            var scroll2 = ref2.scroll;
            if (scroll2 === void 0)
              scroll2 = 0;
            this.scroll = window.pageYOffset;
            return {
              dir: scroll2 <= this.scroll ? "down" : "up",
              scroll: this.scroll
            };
          },
          write: function(data3, types) {
            var this$1$1 = this;
            var now2 = Date.now();
            var isScrollUpdate = types.has("scroll");
            var initTimestamp = data3.initTimestamp;
            if (initTimestamp === void 0)
              initTimestamp = 0;
            var dir = data3.dir;
            var lastDir = data3.lastDir;
            var lastScroll = data3.lastScroll;
            var scroll2 = data3.scroll;
            var top = data3.top;
            data3.lastScroll = scroll2;
            if (scroll2 < 0 || scroll2 === lastScroll && isScrollUpdate || this.showOnUp && !isScrollUpdate && !this.isFixed) {
              return;
            }
            if (now2 - initTimestamp > 300 || dir !== lastDir) {
              data3.initScroll = scroll2;
              data3.initTimestamp = now2;
            }
            data3.lastDir = dir;
            if (this.showOnUp && !this.isFixed && Math.abs(data3.initScroll - scroll2) <= 30 && Math.abs(lastScroll - scroll2) <= 10) {
              return;
            }
            if (this.inactive || scroll2 < this.top || this.showOnUp && (scroll2 <= this.top || dir === "down" && isScrollUpdate || dir === "up" && !this.isFixed && scroll2 <= this.bottomOffset)) {
              if (!this.isFixed) {
                if (Animation.inProgress(this.$el) && top > scroll2) {
                  Animation.cancel(this.$el);
                  this.hide();
                }
                return;
              }
              this.isFixed = false;
              if (this.animation && scroll2 > this.topOffset) {
                Animation.cancel(this.$el);
                Animation.out(this.$el, this.animation).then(function() {
                  return this$1$1.hide();
                }, noop2);
              } else {
                this.hide();
              }
            } else if (this.isFixed) {
              this.update();
            } else if (this.animation) {
              Animation.cancel(this.$el);
              this.show();
              Animation.in(this.$el, this.animation).catch(noop2);
            } else {
              this.show();
            }
          },
          events: ["resize", "scroll"]
        }
      ],
      methods: {
        show: function() {
          this.isFixed = true;
          this.update();
          this.placeholder.hidden = false;
        },
        hide: function() {
          this.isActive = false;
          removeClass(this.$el, this.clsFixed, this.clsBelow);
          css(this.$el, { position: "", top: "", width: "" });
          this.placeholder.hidden = true;
        },
        update: function() {
          var active2 = this.top !== 0 || this.scroll > this.top;
          var top = Math.max(0, this.offset);
          var position2 = "fixed";
          if (isNumeric(this.bottom) && this.scroll > this.bottom - this.offset) {
            top = this.bottom - this.offsetParentTop;
            position2 = "absolute";
          }
          css(this.$el, {
            position: position2,
            top: top + "px",
            width: this.width
          });
          this.isActive = active2;
          toggleClass(this.$el, this.clsBelow, this.scroll > this.bottomOffset);
          addClass(this.$el, this.clsFixed);
        }
      }
    };
    function parseProp(prop, ref2) {
      var $props = ref2.$props;
      var $el = ref2.$el;
      var propOffset = ref2[prop + "Offset"];
      var value = $props[prop];
      if (!value) {
        return;
      }
      if (isString2(value) && value.match(/^-?\d/)) {
        return propOffset + toPx(value);
      } else {
        return offset(value === true ? parent($el) : query(value, $el)).bottom;
      }
    }
    var Switcher = {
      mixins: [Togglable],
      args: "connect",
      props: {
        connect: String,
        toggle: String,
        itemNav: String,
        active: Number,
        swiping: Boolean
      },
      data: {
        connect: "~.uk-switcher",
        toggle: "> * > :first-child",
        itemNav: false,
        active: 0,
        swiping: true,
        cls: "uk-active",
        attrItem: "uk-switcher-item"
      },
      computed: {
        connects: {
          get: function(ref2, $el) {
            var connect = ref2.connect;
            return queryAll(connect, $el);
          },
          watch: function(connects) {
            var this$1$1 = this;
            if (this.swiping) {
              css(connects, "touch-action", "pan-y pinch-zoom");
            }
            var index2 = this.index();
            this.connects.forEach(function(el) {
              return children(el).forEach(function(child, i) {
                return toggleClass(child, this$1$1.cls, i === index2);
              });
            });
          },
          immediate: true
        },
        toggles: {
          get: function(ref2, $el) {
            var toggle2 = ref2.toggle;
            return $$(toggle2, $el).filter(function(el) {
              return !matches(el, ".uk-disabled *, .uk-disabled, [disabled]");
            });
          },
          watch: function(toggles) {
            var active2 = this.index();
            this.show(~active2 ? active2 : toggles[this.active] || toggles[0]);
          },
          immediate: true
        },
        children: function() {
          var this$1$1 = this;
          return children(this.$el).filter(function(child) {
            return this$1$1.toggles.some(function(toggle2) {
              return within(toggle2, child);
            });
          });
        }
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.toggle;
          },
          handler: function(e) {
            e.preventDefault();
            this.show(e.current);
          }
        },
        {
          name: "click",
          el: function() {
            return this.connects.concat(this.itemNav ? queryAll(this.itemNav, this.$el) : []);
          },
          delegate: function() {
            return "[" + this.attrItem + "],[data-" + this.attrItem + "]";
          },
          handler: function(e) {
            e.preventDefault();
            this.show(data2(e.current, this.attrItem));
          }
        },
        {
          name: "swipeRight swipeLeft",
          filter: function() {
            return this.swiping;
          },
          el: function() {
            return this.connects;
          },
          handler: function(ref2) {
            var type = ref2.type;
            this.show(endsWith(type, "Left") ? "next" : "previous");
          }
        }
      ],
      methods: {
        index: function() {
          var this$1$1 = this;
          return findIndex(this.children, function(el) {
            return hasClass(el, this$1$1.cls);
          });
        },
        show: function(item) {
          var this$1$1 = this;
          var prev = this.index();
          var next = getIndex(this.children[getIndex(item, this.toggles, prev)], children(this.$el));
          if (prev === next) {
            return;
          }
          this.children.forEach(function(child, i) {
            toggleClass(child, this$1$1.cls, next === i);
            attr(this$1$1.toggles[i], "aria-expanded", next === i);
          });
          this.connects.forEach(function(ref2) {
            var children2 = ref2.children;
            return this$1$1.toggleElement(toNodes(children2).filter(function(child) {
              return hasClass(child, this$1$1.cls);
            }), false, prev >= 0).then(function() {
              return this$1$1.toggleElement(children2[next], true, prev >= 0);
            });
          });
        }
      }
    };
    var tab = {
      mixins: [Class],
      extends: Switcher,
      props: {
        media: Boolean
      },
      data: {
        media: 960,
        attrItem: "uk-tab-item"
      },
      connected: function() {
        var cls = hasClass(this.$el, "uk-tab-left") ? "uk-tab-left" : hasClass(this.$el, "uk-tab-right") ? "uk-tab-right" : false;
        if (cls) {
          this.$create("toggle", this.$el, { cls, mode: "media", media: this.media });
        }
      }
    };
    var KEY_SPACE = 32;
    var toggle = {
      mixins: [Media, Togglable],
      args: "target",
      props: {
        href: String,
        target: null,
        mode: "list",
        queued: Boolean
      },
      data: {
        href: false,
        target: false,
        mode: "click",
        queued: true
      },
      connected: function() {
        if (!includes(this.mode, "media") && !isFocusable(this.$el)) {
          attr(this.$el, "tabindex", "0");
        }
      },
      computed: {
        target: {
          get: function(ref2, $el) {
            var href = ref2.href;
            var target = ref2.target;
            target = queryAll(target || href, $el);
            return target.length && target || [$el];
          },
          watch: function() {
            this.updateAria();
          },
          immediate: true
        }
      },
      events: [
        {
          name: pointerDown,
          filter: function() {
            return includes(this.mode, "hover");
          },
          handler: function(e) {
            var this$1$1 = this;
            if (!isTouch(e) || this._showState) {
              return;
            }
            trigger2(this.$el, "focus");
            once(document, pointerDown, function() {
              return trigger2(this$1$1.$el, "blur");
            }, true, function(e2) {
              return !within(e2.target, this$1$1.$el);
            });
            if (includes(this.mode, "click")) {
              this._preventClick = true;
            }
          }
        },
        {
          name: pointerEnter + " " + pointerLeave + " focus blur",
          filter: function() {
            return includes(this.mode, "hover");
          },
          handler: function(e) {
            if (isTouch(e)) {
              return;
            }
            var show = includes([pointerEnter, "focus"], e.type);
            var expanded = attr(this.$el, "aria-expanded");
            if (!show && (e.type === pointerLeave && matches(this.$el, ":focus") || e.type === "blur" && matches(this.$el, ":hover"))) {
              return;
            }
            if (this._showState && show === (expanded !== this._showState)) {
              if (!show) {
                this._showState = null;
              }
              return;
            }
            this._showState = show ? expanded : null;
            this.toggle("toggle" + (show ? "show" : "hide"));
          }
        },
        {
          name: "keydown",
          filter: function() {
            return includes(this.mode, "click") && this.$el.tagName !== "INPUT";
          },
          handler: function(e) {
            if (e.keyCode === KEY_SPACE) {
              e.preventDefault();
              this.$el.click();
            }
          }
        },
        {
          name: "click",
          filter: function() {
            return includes(this.mode, "click");
          },
          handler: function(e) {
            if (this._preventClick) {
              return this._preventClick = null;
            }
            var link;
            if (closest(e.target, 'a[href="#"], a[href=""]') || (link = closest(e.target, "a[href]")) && (attr(this.$el, "aria-expanded") !== "true" || link.hash && matches(this.target, link.hash))) {
              e.preventDefault();
            }
            this.toggle();
          }
        },
        {
          name: "toggled",
          self: true,
          el: function() {
            return this.target;
          },
          handler: function(e, toggled) {
            if (e.target === this.target[0]) {
              this.updateAria(toggled);
            }
          }
        }
      ],
      update: {
        read: function() {
          return includes(this.mode, "media") && this.media ? { match: this.matchMedia } : false;
        },
        write: function(ref2) {
          var match2 = ref2.match;
          var toggled = this.isToggled(this.target);
          if (match2 ? !toggled : toggled) {
            this.toggle();
          }
        },
        events: ["resize"]
      },
      methods: {
        toggle: function(type) {
          var this$1$1 = this;
          if (!trigger2(this.target, type || "toggle", [this])) {
            return;
          }
          if (!this.queued) {
            return this.toggleElement(this.target);
          }
          var leaving = this.target.filter(function(el) {
            return hasClass(el, this$1$1.clsLeave);
          });
          if (leaving.length) {
            this.target.forEach(function(el) {
              var isLeaving = includes(leaving, el);
              this$1$1.toggleElement(el, isLeaving, isLeaving);
            });
            return;
          }
          var toggled = this.target.filter(this.isToggled);
          this.toggleElement(toggled, false).then(function() {
            return this$1$1.toggleElement(this$1$1.target.filter(function(el) {
              return !includes(toggled, el);
            }), true);
          });
        },
        updateAria: function(toggled) {
          if (includes(this.mode, "media")) {
            return;
          }
          attr(this.$el, "aria-expanded", isBoolean2(toggled) ? toggled : this.isToggled(this.target));
        }
      }
    };
    var components$1 = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      Accordion,
      Alert: alert,
      Cover: cover,
      Drop: drop,
      Dropdown: drop,
      FormCustom: formCustom,
      Gif: gif,
      Grid: grid,
      HeightMatch: heightMatch,
      HeightViewport: heightViewport,
      Icon,
      Img: img,
      Leader: leader,
      Margin,
      Modal: modal,
      Nav: nav,
      Navbar: navbar,
      Offcanvas: offcanvas,
      OverflowAuto: overflowAuto,
      Responsive: responsive,
      Scroll: scroll,
      Scrollspy: scrollspy,
      ScrollspyNav: scrollspyNav,
      Sticky: sticky,
      Svg: SVG,
      Switcher,
      Tab: tab,
      Toggle: toggle,
      Video,
      Close,
      Spinner,
      SlidenavNext: Slidenav,
      SlidenavPrevious: Slidenav,
      SearchIcon: Search,
      Marker: IconComponent,
      NavbarToggleIcon: IconComponent,
      OverlayIcon: IconComponent,
      PaginationNext: IconComponent,
      PaginationPrevious: IconComponent,
      Totop: IconComponent
    });
    each(components$1, function(component, name) {
      return UIkit2.component(name, component);
    });
    UIkit2.use(Core);
    boot(UIkit2);
    var countdown = {
      mixins: [Class],
      props: {
        date: String,
        clsWrapper: String
      },
      data: {
        date: "",
        clsWrapper: ".uk-countdown-%unit%"
      },
      computed: {
        date: function(ref2) {
          var date = ref2.date;
          return Date.parse(date);
        },
        days: function(ref2, $el) {
          var clsWrapper = ref2.clsWrapper;
          return $(clsWrapper.replace("%unit%", "days"), $el);
        },
        hours: function(ref2, $el) {
          var clsWrapper = ref2.clsWrapper;
          return $(clsWrapper.replace("%unit%", "hours"), $el);
        },
        minutes: function(ref2, $el) {
          var clsWrapper = ref2.clsWrapper;
          return $(clsWrapper.replace("%unit%", "minutes"), $el);
        },
        seconds: function(ref2, $el) {
          var clsWrapper = ref2.clsWrapper;
          return $(clsWrapper.replace("%unit%", "seconds"), $el);
        },
        units: function() {
          var this$1$1 = this;
          return ["days", "hours", "minutes", "seconds"].filter(function(unit) {
            return this$1$1[unit];
          });
        }
      },
      connected: function() {
        this.start();
      },
      disconnected: function() {
        var this$1$1 = this;
        this.stop();
        this.units.forEach(function(unit) {
          return empty(this$1$1[unit]);
        });
      },
      events: [
        {
          name: "visibilitychange",
          el: function() {
            return document;
          },
          handler: function() {
            if (document.hidden) {
              this.stop();
            } else {
              this.start();
            }
          }
        }
      ],
      update: {
        write: function() {
          var this$1$1 = this;
          var timespan = getTimeSpan(this.date);
          if (timespan.total <= 0) {
            this.stop();
            timespan.days = timespan.hours = timespan.minutes = timespan.seconds = 0;
          }
          this.units.forEach(function(unit) {
            var digits = String(Math.floor(timespan[unit]));
            digits = digits.length < 2 ? "0" + digits : digits;
            var el = this$1$1[unit];
            if (el.textContent !== digits) {
              digits = digits.split("");
              if (digits.length !== el.children.length) {
                html(el, digits.map(function() {
                  return "<span></span>";
                }).join(""));
              }
              digits.forEach(function(digit, i) {
                return el.children[i].textContent = digit;
              });
            }
          });
        }
      },
      methods: {
        start: function() {
          this.stop();
          if (this.date && this.units.length) {
            this.$update();
            this.timer = setInterval(this.$update, 1e3);
          }
        },
        stop: function() {
          if (this.timer) {
            clearInterval(this.timer);
            this.timer = null;
          }
        }
      }
    };
    function getTimeSpan(date) {
      var total = date - Date.now();
      return {
        total,
        seconds: total / 1e3 % 60,
        minutes: total / 1e3 / 60 % 60,
        hours: total / 1e3 / 60 / 60 % 24,
        days: total / 1e3 / 60 / 60 / 24
      };
    }
    var clsLeave = "uk-transition-leave";
    var clsEnter = "uk-transition-enter";
    function fade(action, target, duration, stagger) {
      if (stagger === void 0)
        stagger = 0;
      var index2 = transitionIndex(target, true);
      var propsIn = { opacity: 1 };
      var propsOut = { opacity: 0 };
      var wrapIndexFn = function(fn) {
        return function() {
          return index2 === transitionIndex(target) ? fn() : Promise$1.reject();
        };
      };
      var leaveFn = wrapIndexFn(function() {
        addClass(target, clsLeave);
        return Promise$1.all(getTransitionNodes(target).map(function(child, i) {
          return new Promise$1(function(resolve2) {
            return setTimeout(function() {
              return Transition2.start(child, propsOut, duration / 2, "ease").then(resolve2);
            }, i * stagger);
          });
        })).then(function() {
          return removeClass(target, clsLeave);
        });
      });
      var enterFn = wrapIndexFn(function() {
        var oldHeight = height(target);
        addClass(target, clsEnter);
        action();
        css(children(target), { opacity: 0 });
        return new Promise$1(function(resolve2) {
          return requestAnimationFrame(function() {
            var nodes = children(target);
            var newHeight = height(target);
            css(target, "alignContent", "flex-start");
            height(target, oldHeight);
            var transitionNodes = getTransitionNodes(target);
            css(nodes, propsOut);
            var transitions = transitionNodes.map(function(child, i) {
              return new Promise$1(function(resolve3) {
                return setTimeout(function() {
                  return Transition2.start(child, propsIn, duration / 2, "ease").then(resolve3);
                }, i * stagger);
              });
            });
            if (oldHeight !== newHeight) {
              transitions.push(Transition2.start(target, { height: newHeight }, duration / 2 + transitionNodes.length * stagger, "ease"));
            }
            Promise$1.all(transitions).then(function() {
              removeClass(target, clsEnter);
              if (index2 === transitionIndex(target)) {
                css(target, { height: "", alignContent: "" });
                css(nodes, { opacity: "" });
                delete target.dataset.transition;
              }
              resolve2();
            });
          });
        });
      });
      return hasClass(target, clsLeave) ? waitTransitionend(target).then(enterFn) : hasClass(target, clsEnter) ? waitTransitionend(target).then(leaveFn).then(enterFn) : leaveFn().then(enterFn);
    }
    function transitionIndex(target, next) {
      if (next) {
        target.dataset.transition = 1 + transitionIndex(target);
      }
      return toNumber2(target.dataset.transition) || 0;
    }
    function waitTransitionend(target) {
      return Promise$1.all(children(target).filter(Transition2.inProgress).map(function(el) {
        return new Promise$1(function(resolve2) {
          return once(el, "transitionend transitioncanceled", resolve2);
        });
      }));
    }
    function getTransitionNodes(target) {
      return getRows(children(target)).reduce(function(nodes, row) {
        return nodes.concat(sortBy$1(row.filter(function(el) {
          return isInView(el);
        }), "offsetLeft"));
      }, []);
    }
    function slide(action, target, duration) {
      return new Promise$1(function(resolve2) {
        return requestAnimationFrame(function() {
          var nodes = children(target);
          var currentProps = nodes.map(function(el) {
            return getProps(el, true);
          });
          var targetProps = css(target, ["height", "padding"]);
          Transition2.cancel(target);
          nodes.forEach(Transition2.cancel);
          reset2(target);
          action();
          nodes = nodes.concat(children(target).filter(function(el) {
            return !includes(nodes, el);
          }));
          Promise$1.resolve().then(function() {
            fastdom.flush();
            var targetPropsTo = css(target, ["height", "padding"]);
            var ref2 = getTransitionProps(target, nodes, currentProps);
            var propsTo = ref2[0];
            var propsFrom = ref2[1];
            nodes.forEach(function(el, i) {
              return propsFrom[i] && css(el, propsFrom[i]);
            });
            css(target, assign2({ display: "block" }, targetProps));
            requestAnimationFrame(function() {
              var transitions = nodes.map(function(el, i) {
                return parent(el) === target && Transition2.start(el, propsTo[i], duration, "ease");
              }).concat(Transition2.start(target, targetPropsTo, duration, "ease"));
              Promise$1.all(transitions).then(function() {
                nodes.forEach(function(el, i) {
                  return parent(el) === target && css(el, "display", propsTo[i].opacity === 0 ? "none" : "");
                });
                reset2(target);
              }, noop2).then(resolve2);
            });
          });
        });
      });
    }
    function getProps(el, opacity) {
      var zIndex = css(el, "zIndex");
      return isVisible(el) ? assign2({
        display: "",
        opacity: opacity ? css(el, "opacity") : "0",
        pointerEvents: "none",
        position: "absolute",
        zIndex: zIndex === "auto" ? index(el) : zIndex
      }, getPositionWithMargin(el)) : false;
    }
    function getTransitionProps(target, nodes, currentProps) {
      var propsTo = nodes.map(function(el, i) {
        return parent(el) && i in currentProps ? currentProps[i] ? isVisible(el) ? getPositionWithMargin(el) : { opacity: 0 } : { opacity: isVisible(el) ? 1 : 0 } : false;
      });
      var propsFrom = propsTo.map(function(props2, i) {
        var from = parent(nodes[i]) === target && (currentProps[i] || getProps(nodes[i]));
        if (!from) {
          return false;
        }
        if (!props2) {
          delete from.opacity;
        } else if (!("opacity" in props2)) {
          var opacity = from.opacity;
          if (opacity % 1) {
            props2.opacity = 1;
          } else {
            delete from.opacity;
          }
        }
        return from;
      });
      return [propsTo, propsFrom];
    }
    function reset2(el) {
      css(el.children, {
        height: "",
        left: "",
        opacity: "",
        pointerEvents: "",
        position: "",
        top: "",
        marginTop: "",
        marginLeft: "",
        transform: "",
        width: "",
        zIndex: ""
      });
      css(el, { height: "", display: "", padding: "" });
    }
    function getPositionWithMargin(el) {
      var ref2 = offset(el);
      var height2 = ref2.height;
      var width2 = ref2.width;
      var ref$1 = position(el);
      var top = ref$1.top;
      var left = ref$1.left;
      var ref$2 = css(el, ["marginTop", "marginLeft"]);
      var marginLeft = ref$2.marginLeft;
      var marginTop = ref$2.marginTop;
      return { top, left, height: height2, width: width2, marginLeft, marginTop, transform: "" };
    }
    var Animate = {
      props: {
        duration: Number,
        animation: Boolean
      },
      data: {
        duration: 150,
        animation: "slide"
      },
      methods: {
        animate: function(action, target) {
          var this$1$1 = this;
          if (target === void 0)
            target = this.$el;
          var name = this.animation;
          var animationFn = name === "fade" ? fade : name === "delayed-fade" ? function() {
            var args = [], len = arguments.length;
            while (len--)
              args[len] = arguments[len];
            return fade.apply(void 0, args.concat([40]));
          } : name ? slide : function() {
            action();
            return Promise$1.resolve();
          };
          return animationFn(action, target, this.duration).then(function() {
            return this$1$1.$update(target, "resize");
          }, noop2);
        }
      }
    };
    var filter = {
      mixins: [Animate],
      args: "target",
      props: {
        target: Boolean,
        selActive: Boolean
      },
      data: {
        target: null,
        selActive: false,
        attrItem: "uk-filter-control",
        cls: "uk-active",
        duration: 250
      },
      computed: {
        toggles: {
          get: function(ref2, $el) {
            var attrItem = ref2.attrItem;
            return $$("[" + attrItem + "],[data-" + attrItem + "]", $el);
          },
          watch: function() {
            var this$1$1 = this;
            this.updateState();
            if (this.selActive !== false) {
              var actives = $$(this.selActive, this.$el);
              this.toggles.forEach(function(el) {
                return toggleClass(el, this$1$1.cls, includes(actives, el));
              });
            }
          },
          immediate: true
        },
        children: {
          get: function(ref2, $el) {
            var target = ref2.target;
            return $$(target + " > *", $el);
          },
          watch: function(list, old) {
            if (old && !isEqualList(list, old)) {
              this.updateState();
            }
          },
          immediate: true
        }
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return "[" + this.attrItem + "],[data-" + this.attrItem + "]";
          },
          handler: function(e) {
            e.preventDefault();
            this.apply(e.current);
          }
        }
      ],
      methods: {
        apply: function(el) {
          var prevState = this.getState();
          var newState = mergeState(el, this.attrItem, this.getState());
          if (!isEqualState(prevState, newState)) {
            this.setState(newState);
          }
        },
        getState: function() {
          var this$1$1 = this;
          return this.toggles.filter(function(item) {
            return hasClass(item, this$1$1.cls);
          }).reduce(function(state, el) {
            return mergeState(el, this$1$1.attrItem, state);
          }, { filter: { "": "" }, sort: [] });
        },
        setState: function(state, animate2) {
          var this$1$1 = this;
          if (animate2 === void 0)
            animate2 = true;
          state = assign2({ filter: { "": "" }, sort: [] }, state);
          trigger2(this.$el, "beforeFilter", [this, state]);
          this.toggles.forEach(function(el) {
            return toggleClass(el, this$1$1.cls, !!matchFilter(el, this$1$1.attrItem, state));
          });
          Promise$1.all($$(this.target, this.$el).map(function(target) {
            var filterFn = function() {
              applyState(state, target, children(target));
              this$1$1.$update(this$1$1.$el);
            };
            return animate2 ? this$1$1.animate(filterFn, target) : filterFn();
          })).then(function() {
            return trigger2(this$1$1.$el, "afterFilter", [this$1$1]);
          });
        },
        updateState: function() {
          var this$1$1 = this;
          fastdom.write(function() {
            return this$1$1.setState(this$1$1.getState(), false);
          });
        }
      }
    };
    function getFilter(el, attr2) {
      return parseOptions(data2(el, attr2), ["filter"]);
    }
    function isEqualState(stateA, stateB) {
      return ["filter", "sort"].every(function(prop) {
        return isEqual(stateA[prop], stateB[prop]);
      });
    }
    function applyState(state, target, children2) {
      var selector = getSelector(state);
      children2.forEach(function(el) {
        return css(el, "display", selector && !matches(el, selector) ? "none" : "");
      });
      var ref2 = state.sort;
      var sort = ref2[0];
      var order = ref2[1];
      if (sort) {
        var sorted = sortItems(children2, sort, order);
        if (!isEqual(sorted, children2)) {
          append(target, sorted);
        }
      }
    }
    function mergeState(el, attr2, state) {
      var filterBy = getFilter(el, attr2);
      var filter2 = filterBy.filter;
      var group = filterBy.group;
      var sort = filterBy.sort;
      var order = filterBy.order;
      if (order === void 0)
        order = "asc";
      if (filter2 || isUndefined2(sort)) {
        if (group) {
          if (filter2) {
            delete state.filter[""];
            state.filter[group] = filter2;
          } else {
            delete state.filter[group];
            if (isEmpty(state.filter) || "" in state.filter) {
              state.filter = { "": filter2 || "" };
            }
          }
        } else {
          state.filter = { "": filter2 || "" };
        }
      }
      if (!isUndefined2(sort)) {
        state.sort = [sort, order];
      }
      return state;
    }
    function matchFilter(el, attr2, ref2) {
      var stateFilter = ref2.filter;
      if (stateFilter === void 0)
        stateFilter = { "": "" };
      var ref_sort = ref2.sort;
      var stateSort = ref_sort[0];
      var stateOrder = ref_sort[1];
      var ref$1 = getFilter(el, attr2);
      var filter2 = ref$1.filter;
      if (filter2 === void 0)
        filter2 = "";
      var group = ref$1.group;
      if (group === void 0)
        group = "";
      var sort = ref$1.sort;
      var order = ref$1.order;
      if (order === void 0)
        order = "asc";
      return isUndefined2(sort) ? group in stateFilter && filter2 === stateFilter[group] || !filter2 && group && !(group in stateFilter) && !stateFilter[""] : stateSort === sort && stateOrder === order;
    }
    function isEqualList(listA, listB) {
      return listA.length === listB.length && listA.every(function(el) {
        return ~listB.indexOf(el);
      });
    }
    function getSelector(ref2) {
      var filter2 = ref2.filter;
      var selector = "";
      each(filter2, function(value) {
        return selector += value || "";
      });
      return selector;
    }
    function sortItems(nodes, sort, order) {
      return assign2([], nodes).sort(function(a, b) {
        return data2(a, sort).localeCompare(data2(b, sort), void 0, { numeric: true }) * (order === "asc" || -1);
      });
    }
    var Animations$2 = {
      slide: {
        show: function(dir) {
          return [
            { transform: translate2(dir * -100) },
            { transform: translate2() }
          ];
        },
        percent: function(current) {
          return translated(current);
        },
        translate: function(percent2, dir) {
          return [
            { transform: translate2(dir * -100 * percent2) },
            { transform: translate2(dir * 100 * (1 - percent2)) }
          ];
        }
      }
    };
    function translated(el) {
      return Math.abs(css(el, "transform").split(",")[4] / el.offsetWidth) || 0;
    }
    function translate2(value, unit) {
      if (value === void 0)
        value = 0;
      if (unit === void 0)
        unit = "%";
      value += value ? unit : "";
      return isIE ? "translateX(" + value + ")" : "translate3d(" + value + ", 0, 0)";
    }
    function scale3d(value) {
      return "scale3d(" + value + ", " + value + ", 1)";
    }
    var Animations$1 = assign2({}, Animations$2, {
      fade: {
        show: function() {
          return [
            { opacity: 0 },
            { opacity: 1 }
          ];
        },
        percent: function(current) {
          return 1 - css(current, "opacity");
        },
        translate: function(percent2) {
          return [
            { opacity: 1 - percent2 },
            { opacity: percent2 }
          ];
        }
      },
      scale: {
        show: function() {
          return [
            { opacity: 0, transform: scale3d(1 - 0.2) },
            { opacity: 1, transform: scale3d(1) }
          ];
        },
        percent: function(current) {
          return 1 - css(current, "opacity");
        },
        translate: function(percent2) {
          return [
            { opacity: 1 - percent2, transform: scale3d(1 - 0.2 * percent2) },
            { opacity: percent2, transform: scale3d(1 - 0.2 + 0.2 * percent2) }
          ];
        }
      }
    });
    function Transitioner$1(prev, next, dir, ref2) {
      var animation = ref2.animation;
      var easing = ref2.easing;
      var percent2 = animation.percent;
      var translate3 = animation.translate;
      var show = animation.show;
      if (show === void 0)
        show = noop2;
      var props2 = show(dir);
      var deferred = new Deferred();
      return {
        dir,
        show: function(duration, percent3, linear) {
          var this$1$1 = this;
          if (percent3 === void 0)
            percent3 = 0;
          var timing = linear ? "linear" : easing;
          duration -= Math.round(duration * clamp(percent3, -1, 1));
          this.translate(percent3);
          triggerUpdate$1(next, "itemin", { percent: percent3, duration, timing, dir });
          triggerUpdate$1(prev, "itemout", { percent: 1 - percent3, duration, timing, dir });
          Promise$1.all([
            Transition2.start(next, props2[1], duration, timing),
            Transition2.start(prev, props2[0], duration, timing)
          ]).then(function() {
            this$1$1.reset();
            deferred.resolve();
          }, noop2);
          return deferred.promise;
        },
        cancel: function() {
          Transition2.cancel([next, prev]);
        },
        reset: function() {
          for (var prop in props2[0]) {
            css([next, prev], prop, "");
          }
        },
        forward: function(duration, percent3) {
          if (percent3 === void 0)
            percent3 = this.percent();
          Transition2.cancel([next, prev]);
          return this.show(duration, percent3, true);
        },
        translate: function(percent3) {
          this.reset();
          var props3 = translate3(percent3, dir);
          css(next, props3[1]);
          css(prev, props3[0]);
          triggerUpdate$1(next, "itemtranslatein", { percent: percent3, dir });
          triggerUpdate$1(prev, "itemtranslateout", { percent: 1 - percent3, dir });
        },
        percent: function() {
          return percent2(prev || next, next, dir);
        },
        getDistance: function() {
          return prev && prev.offsetWidth;
        }
      };
    }
    function triggerUpdate$1(el, type, data3) {
      trigger2(el, createEvent(type, false, false, data3));
    }
    var SliderAutoplay = {
      props: {
        autoplay: Boolean,
        autoplayInterval: Number,
        pauseOnHover: Boolean
      },
      data: {
        autoplay: false,
        autoplayInterval: 7e3,
        pauseOnHover: true
      },
      connected: function() {
        this.autoplay && this.startAutoplay();
      },
      disconnected: function() {
        this.stopAutoplay();
      },
      update: function() {
        attr(this.slides, "tabindex", "-1");
      },
      events: [
        {
          name: "visibilitychange",
          el: function() {
            return document;
          },
          filter: function() {
            return this.autoplay;
          },
          handler: function() {
            if (document.hidden) {
              this.stopAutoplay();
            } else {
              this.startAutoplay();
            }
          }
        }
      ],
      methods: {
        startAutoplay: function() {
          var this$1$1 = this;
          this.stopAutoplay();
          this.interval = setInterval(function() {
            return (!this$1$1.draggable || !$(":focus", this$1$1.$el)) && (!this$1$1.pauseOnHover || !matches(this$1$1.$el, ":hover")) && !this$1$1.stack.length && this$1$1.show("next");
          }, this.autoplayInterval);
        },
        stopAutoplay: function() {
          this.interval && clearInterval(this.interval);
        }
      }
    };
    var SliderDrag = {
      props: {
        draggable: Boolean
      },
      data: {
        draggable: true,
        threshold: 10
      },
      created: function() {
        var this$1$1 = this;
        ["start", "move", "end"].forEach(function(key2) {
          var fn = this$1$1[key2];
          this$1$1[key2] = function(e) {
            var pos = getEventPos(e).x * (isRtl ? -1 : 1);
            this$1$1.prevPos = pos !== this$1$1.pos ? this$1$1.pos : this$1$1.prevPos;
            this$1$1.pos = pos;
            fn(e);
          };
        });
      },
      events: [
        {
          name: pointerDown,
          delegate: function() {
            return this.selSlides;
          },
          handler: function(e) {
            if (!this.draggable || !isTouch(e) && hasTextNodesOnly(e.target) || closest(e.target, selInput) || e.button > 0 || this.length < 2) {
              return;
            }
            this.start(e);
          }
        },
        {
          name: "dragstart",
          handler: function(e) {
            e.preventDefault();
          }
        }
      ],
      methods: {
        start: function() {
          this.drag = this.pos;
          if (this._transitioner) {
            this.percent = this._transitioner.percent();
            this.drag += this._transitioner.getDistance() * this.percent * this.dir;
            this._transitioner.cancel();
            this._transitioner.translate(this.percent);
            this.dragging = true;
            this.stack = [];
          } else {
            this.prevIndex = this.index;
          }
          on(document, pointerMove, this.move, { passive: false });
          on(document, pointerUp + " " + pointerCancel + " input", this.end, true);
          css(this.list, "userSelect", "none");
        },
        move: function(e) {
          var this$1$1 = this;
          var distance = this.pos - this.drag;
          if (distance === 0 || this.prevPos === this.pos || !this.dragging && Math.abs(distance) < this.threshold) {
            return;
          }
          css(this.list, "pointerEvents", "none");
          e.cancelable && e.preventDefault();
          this.dragging = true;
          this.dir = distance < 0 ? 1 : -1;
          var ref2 = this;
          var slides = ref2.slides;
          var ref$1 = this;
          var prevIndex = ref$1.prevIndex;
          var dis = Math.abs(distance);
          var nextIndex = this.getIndex(prevIndex + this.dir, prevIndex);
          var width2 = this._getDistance(prevIndex, nextIndex) || slides[prevIndex].offsetWidth;
          while (nextIndex !== prevIndex && dis > width2) {
            this.drag -= width2 * this.dir;
            prevIndex = nextIndex;
            dis -= width2;
            nextIndex = this.getIndex(prevIndex + this.dir, prevIndex);
            width2 = this._getDistance(prevIndex, nextIndex) || slides[prevIndex].offsetWidth;
          }
          this.percent = dis / width2;
          var prev = slides[prevIndex];
          var next = slides[nextIndex];
          var changed = this.index !== nextIndex;
          var edge = prevIndex === nextIndex;
          var itemShown;
          [this.index, this.prevIndex].filter(function(i) {
            return !includes([nextIndex, prevIndex], i);
          }).forEach(function(i) {
            trigger2(slides[i], "itemhidden", [this$1$1]);
            if (edge) {
              itemShown = true;
              this$1$1.prevIndex = prevIndex;
            }
          });
          if (this.index === prevIndex && this.prevIndex !== prevIndex || itemShown) {
            trigger2(slides[this.index], "itemshown", [this]);
          }
          if (changed) {
            this.prevIndex = prevIndex;
            this.index = nextIndex;
            !edge && trigger2(prev, "beforeitemhide", [this]);
            trigger2(next, "beforeitemshow", [this]);
          }
          this._transitioner = this._translate(Math.abs(this.percent), prev, !edge && next);
          if (changed) {
            !edge && trigger2(prev, "itemhide", [this]);
            trigger2(next, "itemshow", [this]);
          }
        },
        end: function() {
          off(document, pointerMove, this.move, { passive: false });
          off(document, pointerUp + " " + pointerCancel + " input", this.end, true);
          if (this.dragging) {
            this.dragging = null;
            if (this.index === this.prevIndex) {
              this.percent = 1 - this.percent;
              this.dir *= -1;
              this._show(false, this.index, true);
              this._transitioner = null;
            } else {
              var dirChange = (isRtl ? this.dir * (isRtl ? 1 : -1) : this.dir) < 0 === this.prevPos > this.pos;
              this.index = dirChange ? this.index : this.prevIndex;
              if (dirChange) {
                this.percent = 1 - this.percent;
              }
              this.show(this.dir > 0 && !dirChange || this.dir < 0 && dirChange ? "next" : "previous", true);
            }
          }
          css(this.list, { userSelect: "", pointerEvents: "" });
          this.drag = this.percent = null;
        }
      }
    };
    function hasTextNodesOnly(el) {
      return !el.children.length && el.childNodes.length;
    }
    var SliderNav = {
      data: {
        selNav: false
      },
      computed: {
        nav: function(ref2, $el) {
          var selNav = ref2.selNav;
          return $(selNav, $el);
        },
        selNavItem: function(ref2) {
          var attrItem = ref2.attrItem;
          return "[" + attrItem + "],[data-" + attrItem + "]";
        },
        navItems: function(_, $el) {
          return $$(this.selNavItem, $el);
        }
      },
      update: {
        write: function() {
          var this$1$1 = this;
          if (this.nav && this.length !== this.nav.children.length) {
            html(this.nav, this.slides.map(function(_, i) {
              return "<li " + this$1$1.attrItem + '="' + i + '"><a href></a></li>';
            }).join(""));
          }
          this.navItems.concat(this.nav).forEach(function(el) {
            return el && (el.hidden = !this$1$1.maxIndex);
          });
          this.updateNav();
        },
        events: ["resize"]
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.selNavItem;
          },
          handler: function(e) {
            e.preventDefault();
            this.show(data2(e.current, this.attrItem));
          }
        },
        {
          name: "itemshow",
          handler: "updateNav"
        }
      ],
      methods: {
        updateNav: function() {
          var this$1$1 = this;
          var i = this.getValidIndex();
          this.navItems.forEach(function(el) {
            var cmd = data2(el, this$1$1.attrItem);
            toggleClass(el, this$1$1.clsActive, toNumber2(cmd) === i);
            toggleClass(el, "uk-invisible", this$1$1.finite && (cmd === "previous" && i === 0 || cmd === "next" && i >= this$1$1.maxIndex));
          });
        }
      }
    };
    var Slider = {
      mixins: [SliderAutoplay, SliderDrag, SliderNav],
      props: {
        clsActivated: Boolean,
        easing: String,
        index: Number,
        finite: Boolean,
        velocity: Number,
        selSlides: String
      },
      data: function() {
        return {
          easing: "ease",
          finite: false,
          velocity: 1,
          index: 0,
          prevIndex: -1,
          stack: [],
          percent: 0,
          clsActive: "uk-active",
          clsActivated: false,
          Transitioner: false,
          transitionOptions: {}
        };
      },
      connected: function() {
        this.prevIndex = -1;
        this.index = this.getValidIndex(this.$props.index);
        this.stack = [];
      },
      disconnected: function() {
        removeClass(this.slides, this.clsActive);
      },
      computed: {
        duration: function(ref2, $el) {
          var velocity = ref2.velocity;
          return speedUp($el.offsetWidth / velocity);
        },
        list: function(ref2, $el) {
          var selList = ref2.selList;
          return $(selList, $el);
        },
        maxIndex: function() {
          return this.length - 1;
        },
        selSlides: function(ref2) {
          var selList = ref2.selList;
          var selSlides = ref2.selSlides;
          return selList + " " + (selSlides || "> *");
        },
        slides: {
          get: function() {
            return $$(this.selSlides, this.$el);
          },
          watch: function() {
            this.$reset();
          }
        },
        length: function() {
          return this.slides.length;
        }
      },
      events: {
        itemshown: function() {
          this.$update(this.list);
        }
      },
      methods: {
        show: function(index2, force) {
          var this$1$1 = this;
          if (force === void 0)
            force = false;
          if (this.dragging || !this.length) {
            return;
          }
          var ref2 = this;
          var stack2 = ref2.stack;
          var queueIndex = force ? 0 : stack2.length;
          var reset3 = function() {
            stack2.splice(queueIndex, 1);
            if (stack2.length) {
              this$1$1.show(stack2.shift(), true);
            }
          };
          stack2[force ? "unshift" : "push"](index2);
          if (!force && stack2.length > 1) {
            if (stack2.length === 2) {
              this._transitioner.forward(Math.min(this.duration, 200));
            }
            return;
          }
          var prevIndex = this.getIndex(this.index);
          var prev = hasClass(this.slides, this.clsActive) && this.slides[prevIndex];
          var nextIndex = this.getIndex(index2, this.index);
          var next = this.slides[nextIndex];
          if (prev === next) {
            reset3();
            return;
          }
          this.dir = getDirection(index2, prevIndex);
          this.prevIndex = prevIndex;
          this.index = nextIndex;
          if (prev && !trigger2(prev, "beforeitemhide", [this]) || !trigger2(next, "beforeitemshow", [this, prev])) {
            this.index = this.prevIndex;
            reset3();
            return;
          }
          var promise = this._show(prev, next, force).then(function() {
            prev && trigger2(prev, "itemhidden", [this$1$1]);
            trigger2(next, "itemshown", [this$1$1]);
            return new Promise$1(function(resolve2) {
              fastdom.write(function() {
                stack2.shift();
                if (stack2.length) {
                  this$1$1.show(stack2.shift(), true);
                } else {
                  this$1$1._transitioner = null;
                }
                resolve2();
              });
            });
          });
          prev && trigger2(prev, "itemhide", [this]);
          trigger2(next, "itemshow", [this]);
          return promise;
        },
        getIndex: function(index2, prev) {
          if (index2 === void 0)
            index2 = this.index;
          if (prev === void 0)
            prev = this.index;
          return clamp(getIndex(index2, this.slides, prev, this.finite), 0, this.maxIndex);
        },
        getValidIndex: function(index2, prevIndex) {
          if (index2 === void 0)
            index2 = this.index;
          if (prevIndex === void 0)
            prevIndex = this.prevIndex;
          return this.getIndex(index2, prevIndex);
        },
        _show: function(prev, next, force) {
          this._transitioner = this._getTransitioner(prev, next, this.dir, assign2({
            easing: force ? next.offsetWidth < 600 ? "cubic-bezier(0.25, 0.46, 0.45, 0.94)" : "cubic-bezier(0.165, 0.84, 0.44, 1)" : this.easing
          }, this.transitionOptions));
          if (!force && !prev) {
            this._translate(1);
            return Promise$1.resolve();
          }
          var ref2 = this.stack;
          var length = ref2.length;
          return this._transitioner[length > 1 ? "forward" : "show"](length > 1 ? Math.min(this.duration, 75 + 75 / (length - 1)) : this.duration, this.percent);
        },
        _getDistance: function(prev, next) {
          return this._getTransitioner(prev, prev !== next && next).getDistance();
        },
        _translate: function(percent2, prev, next) {
          if (prev === void 0)
            prev = this.prevIndex;
          if (next === void 0)
            next = this.index;
          var transitioner = this._getTransitioner(prev !== next ? prev : false, next);
          transitioner.translate(percent2);
          return transitioner;
        },
        _getTransitioner: function(prev, next, dir, options) {
          if (prev === void 0)
            prev = this.prevIndex;
          if (next === void 0)
            next = this.index;
          if (dir === void 0)
            dir = this.dir || 1;
          if (options === void 0)
            options = this.transitionOptions;
          return new this.Transitioner(isNumber2(prev) ? this.slides[prev] : prev, isNumber2(next) ? this.slides[next] : next, dir * (isRtl ? -1 : 1), options);
        }
      }
    };
    function getDirection(index2, prevIndex) {
      return index2 === "next" ? 1 : index2 === "previous" ? -1 : index2 < prevIndex ? -1 : 1;
    }
    function speedUp(x) {
      return 0.5 * x + 300;
    }
    var Slideshow = {
      mixins: [Slider],
      props: {
        animation: String
      },
      data: {
        animation: "slide",
        clsActivated: "uk-transition-active",
        Animations: Animations$2,
        Transitioner: Transitioner$1
      },
      computed: {
        animation: function(ref2) {
          var animation = ref2.animation;
          var Animations2 = ref2.Animations;
          return assign2(Animations2[animation] || Animations2.slide, { name: animation });
        },
        transitionOptions: function() {
          return { animation: this.animation };
        }
      },
      events: {
        "itemshow itemhide itemshown itemhidden": function(ref2) {
          var target = ref2.target;
          this.$update(target);
        },
        beforeitemshow: function(ref2) {
          var target = ref2.target;
          addClass(target, this.clsActive);
        },
        itemshown: function(ref2) {
          var target = ref2.target;
          addClass(target, this.clsActivated);
        },
        itemhidden: function(ref2) {
          var target = ref2.target;
          removeClass(target, this.clsActive, this.clsActivated);
        }
      }
    };
    var LightboxPanel = {
      mixins: [Container, Modal, Togglable, Slideshow],
      functional: true,
      props: {
        delayControls: Number,
        preload: Number,
        videoAutoplay: Boolean,
        template: String
      },
      data: function() {
        return {
          preload: 1,
          videoAutoplay: false,
          delayControls: 3e3,
          items: [],
          cls: "uk-open",
          clsPage: "uk-lightbox-page",
          selList: ".uk-lightbox-items",
          attrItem: "uk-lightbox-item",
          selClose: ".uk-close-large",
          selCaption: ".uk-lightbox-caption",
          pauseOnHover: false,
          velocity: 2,
          Animations: Animations$1,
          template: '<div class="uk-lightbox uk-overflow-hidden"> <ul class="uk-lightbox-items"></ul> <div class="uk-lightbox-toolbar uk-position-top uk-text-right uk-transition-slide-top uk-transition-opaque"> <button class="uk-lightbox-toolbar-icon uk-close-large" type="button" uk-close></button> </div> <a class="uk-lightbox-button uk-position-center-left uk-position-medium uk-transition-fade" href uk-slidenav-previous uk-lightbox-item="previous"></a> <a class="uk-lightbox-button uk-position-center-right uk-position-medium uk-transition-fade" href uk-slidenav-next uk-lightbox-item="next"></a> <div class="uk-lightbox-toolbar uk-lightbox-caption uk-position-bottom uk-text-center uk-transition-slide-bottom uk-transition-opaque"></div> </div>'
        };
      },
      created: function() {
        var $el = $(this.template);
        var list = $(this.selList, $el);
        this.items.forEach(function() {
          return append(list, "<li>");
        });
        this.$mount(append(this.container, $el));
      },
      computed: {
        caption: function(ref2, $el) {
          var selCaption = ref2.selCaption;
          return $(selCaption, $el);
        }
      },
      events: [
        {
          name: pointerMove + " " + pointerDown + " keydown",
          handler: "showControls"
        },
        {
          name: "click",
          self: true,
          delegate: function() {
            return this.selSlides;
          },
          handler: function(e) {
            if (e.defaultPrevented) {
              return;
            }
            this.hide();
          }
        },
        {
          name: "shown",
          self: true,
          handler: function() {
            this.showControls();
          }
        },
        {
          name: "hide",
          self: true,
          handler: function() {
            this.hideControls();
            removeClass(this.slides, this.clsActive);
            Transition2.stop(this.slides);
          }
        },
        {
          name: "hidden",
          self: true,
          handler: function() {
            this.$destroy(true);
          }
        },
        {
          name: "keyup",
          el: function() {
            return document;
          },
          handler: function(e) {
            if (!this.isToggled(this.$el) || !this.draggable) {
              return;
            }
            switch (e.keyCode) {
              case 37:
                this.show("previous");
                break;
              case 39:
                this.show("next");
                break;
            }
          }
        },
        {
          name: "beforeitemshow",
          handler: function(e) {
            if (this.isToggled()) {
              return;
            }
            this.draggable = false;
            e.preventDefault();
            this.toggleElement(this.$el, true, false);
            this.animation = Animations$1["scale"];
            removeClass(e.target, this.clsActive);
            this.stack.splice(1, 0, this.index);
          }
        },
        {
          name: "itemshow",
          handler: function() {
            html(this.caption, this.getItem().caption || "");
            for (var j = -this.preload; j <= this.preload; j++) {
              this.loadItem(this.index + j);
            }
          }
        },
        {
          name: "itemshown",
          handler: function() {
            this.draggable = this.$props.draggable;
          }
        },
        {
          name: "itemload",
          handler: function(_, item) {
            var this$1$1 = this;
            var src = item.source;
            var type = item.type;
            var alt = item.alt;
            if (alt === void 0)
              alt = "";
            var poster = item.poster;
            var attrs = item.attrs;
            if (attrs === void 0)
              attrs = {};
            this.setItem(item, "<span uk-spinner></span>");
            if (!src) {
              return;
            }
            var matches2;
            var iframeAttrs = {
              frameborder: "0",
              allow: "autoplay",
              allowfullscreen: "",
              style: "max-width: 100%; box-sizing: border-box;",
              "uk-responsive": "",
              "uk-video": "" + this.videoAutoplay
            };
            if (type === "image" || src.match(/\.(avif|jpe?g|a?png|gif|svg|webp)($|\?)/i)) {
              getImage(src, attrs.srcset, attrs.size).then(function(ref2) {
                var width2 = ref2.width;
                var height2 = ref2.height;
                return this$1$1.setItem(item, createEl("img", assign2({ src, width: width2, height: height2, alt }, attrs)));
              }, function() {
                return this$1$1.setError(item);
              });
            } else if (type === "video" || src.match(/\.(mp4|webm|ogv)($|\?)/i)) {
              var video = createEl("video", assign2({
                src,
                poster,
                controls: "",
                playsinline: "",
                "uk-video": "" + this.videoAutoplay
              }, attrs));
              on(video, "loadedmetadata", function() {
                attr(video, { width: video.videoWidth, height: video.videoHeight });
                this$1$1.setItem(item, video);
              });
              on(video, "error", function() {
                return this$1$1.setError(item);
              });
            } else if (type === "iframe" || src.match(/\.(html|php)($|\?)/i)) {
              this.setItem(item, createEl("iframe", assign2({
                src,
                frameborder: "0",
                allowfullscreen: "",
                class: "uk-lightbox-iframe"
              }, attrs)));
            } else if (matches2 = src.match(/\/\/(?:.*?youtube(-nocookie)?\..*?[?&]v=|youtu\.be\/)([\w-]{11})[&?]?(.*)?/)) {
              this.setItem(item, createEl("iframe", assign2({
                src: "https://www.youtube" + (matches2[1] || "") + ".com/embed/" + matches2[2] + (matches2[3] ? "?" + matches2[3] : ""),
                width: 1920,
                height: 1080
              }, iframeAttrs, attrs)));
            } else if (matches2 = src.match(/\/\/.*?vimeo\.[a-z]+\/(\d+)[&?]?(.*)?/)) {
              ajax("https://vimeo.com/api/oembed.json?maxwidth=1920&url=" + encodeURI(src), {
                responseType: "json",
                withCredentials: false
              }).then(function(ref2) {
                var ref_response = ref2.response;
                var height2 = ref_response.height;
                var width2 = ref_response.width;
                return this$1$1.setItem(item, createEl("iframe", assign2({
                  src: "https://player.vimeo.com/video/" + matches2[1] + (matches2[2] ? "?" + matches2[2] : ""),
                  width: width2,
                  height: height2
                }, iframeAttrs, attrs)));
              }, function() {
                return this$1$1.setError(item);
              });
            }
          }
        }
      ],
      methods: {
        loadItem: function(index2) {
          if (index2 === void 0)
            index2 = this.index;
          var item = this.getItem(index2);
          if (!this.getSlide(item).childElementCount) {
            trigger2(this.$el, "itemload", [item]);
          }
        },
        getItem: function(index2) {
          if (index2 === void 0)
            index2 = this.index;
          return this.items[getIndex(index2, this.slides)];
        },
        setItem: function(item, content) {
          trigger2(this.$el, "itemloaded", [this, html(this.getSlide(item), content)]);
        },
        getSlide: function(item) {
          return this.slides[this.items.indexOf(item)];
        },
        setError: function(item) {
          this.setItem(item, '<span uk-icon="icon: bolt; ratio: 2"></span>');
        },
        showControls: function() {
          clearTimeout(this.controlsTimer);
          this.controlsTimer = setTimeout(this.hideControls, this.delayControls);
          addClass(this.$el, "uk-active", "uk-transition-active");
        },
        hideControls: function() {
          removeClass(this.$el, "uk-active", "uk-transition-active");
        }
      }
    };
    function createEl(tag, attrs) {
      var el = fragment("<" + tag + ">");
      attr(el, attrs);
      return el;
    }
    var lightbox = {
      install: install$1,
      props: { toggle: String },
      data: { toggle: "a" },
      computed: {
        toggles: {
          get: function(ref2, $el) {
            var toggle2 = ref2.toggle;
            return $$(toggle2, $el);
          },
          watch: function() {
            this.hide();
          }
        }
      },
      disconnected: function() {
        this.hide();
      },
      events: [
        {
          name: "click",
          delegate: function() {
            return this.toggle + ":not(.uk-disabled)";
          },
          handler: function(e) {
            e.preventDefault();
            this.show(e.current);
          }
        }
      ],
      methods: {
        show: function(index2) {
          var this$1$1 = this;
          var items = uniqueBy(this.toggles.map(toItem), "source");
          if (isElement(index2)) {
            var ref2 = toItem(index2);
            var source2 = ref2.source;
            index2 = findIndex(items, function(ref3) {
              var src = ref3.source;
              return source2 === src;
            });
          }
          this.panel = this.panel || this.$create("lightboxPanel", assign2({}, this.$props, { items }));
          on(this.panel.$el, "hidden", function() {
            return this$1$1.panel = false;
          });
          return this.panel.show(index2);
        },
        hide: function() {
          return this.panel && this.panel.hide();
        }
      }
    };
    function install$1(UIkit3, Lightbox) {
      if (!UIkit3.lightboxPanel) {
        UIkit3.component("lightboxPanel", LightboxPanel);
      }
      assign2(Lightbox.props, UIkit3.component("lightboxPanel").options.props);
    }
    function toItem(el) {
      var item = {};
      ["href", "caption", "type", "poster", "alt", "attrs"].forEach(function(attr2) {
        item[attr2 === "href" ? "source" : attr2] = data2(el, attr2);
      });
      item.attrs = parseOptions(item.attrs);
      return item;
    }
    var obj$1;
    var notification = {
      mixins: [Container],
      functional: true,
      args: ["message", "status"],
      data: {
        message: "",
        status: "",
        timeout: 5e3,
        group: null,
        pos: "top-center",
        clsContainer: "uk-notification",
        clsClose: "uk-notification-close",
        clsMsg: "uk-notification-message"
      },
      install,
      computed: {
        marginProp: function(ref2) {
          var pos = ref2.pos;
          return "margin" + (startsWith(pos, "top") ? "Top" : "Bottom");
        },
        startProps: function() {
          var obj2;
          return obj2 = { opacity: 0 }, obj2[this.marginProp] = -this.$el.offsetHeight, obj2;
        }
      },
      created: function() {
        var container = $("." + this.clsContainer + "-" + this.pos, this.container) || append(this.container, '<div class="' + this.clsContainer + " " + this.clsContainer + "-" + this.pos + '" style="display: block"></div>');
        this.$mount(append(container, '<div class="' + this.clsMsg + (this.status ? " " + this.clsMsg + "-" + this.status : "") + '"> <a href class="' + this.clsClose + '" data-uk-close></a> <div>' + this.message + "</div> </div>"));
      },
      connected: function() {
        var this$1$1 = this;
        var obj2;
        var margin = toFloat(css(this.$el, this.marginProp));
        Transition2.start(css(this.$el, this.startProps), (obj2 = { opacity: 1 }, obj2[this.marginProp] = margin, obj2)).then(function() {
          if (this$1$1.timeout) {
            this$1$1.timer = setTimeout(this$1$1.close, this$1$1.timeout);
          }
        });
      },
      events: (obj$1 = {
        click: function(e) {
          if (closest(e.target, 'a[href="#"],a[href=""]')) {
            e.preventDefault();
          }
          this.close();
        }
      }, obj$1[pointerEnter] = function() {
        if (this.timer) {
          clearTimeout(this.timer);
        }
      }, obj$1[pointerLeave] = function() {
        if (this.timeout) {
          this.timer = setTimeout(this.close, this.timeout);
        }
      }, obj$1),
      methods: {
        close: function(immediate) {
          var this$1$1 = this;
          var removeFn = function(el) {
            var container = parent(el);
            trigger2(el, "close", [this$1$1]);
            remove$1(el);
            if (container && !container.hasChildNodes()) {
              remove$1(container);
            }
          };
          if (this.timer) {
            clearTimeout(this.timer);
          }
          if (immediate) {
            removeFn(this.$el);
          } else {
            Transition2.start(this.$el, this.startProps).then(removeFn);
          }
        }
      }
    };
    function install(UIkit3) {
      UIkit3.notification.closeAll = function(group, immediate) {
        apply$1(document.body, function(el) {
          var notification2 = UIkit3.getComponent(el, "notification");
          if (notification2 && (!group || group === notification2.group)) {
            notification2.close(immediate);
          }
        });
      };
    }
    var props = ["x", "y", "bgx", "bgy", "rotate", "scale", "color", "backgroundColor", "borderColor", "opacity", "blur", "hue", "grayscale", "invert", "saturate", "sepia", "fopacity", "stroke"];
    var Parallax = {
      mixins: [Media],
      props: props.reduce(function(props2, prop) {
        props2[prop] = "list";
        return props2;
      }, {}),
      data: props.reduce(function(data3, prop) {
        data3[prop] = void 0;
        return data3;
      }, {}),
      computed: {
        props: function(properties, $el) {
          var this$1$1 = this;
          return props.reduce(function(props2, prop) {
            if (isUndefined2(properties[prop])) {
              return props2;
            }
            var isColor = prop.match(/color/i);
            var isCssProp = isColor || prop === "opacity";
            var pos, bgPos, diff;
            var steps = properties[prop].slice();
            if (isCssProp) {
              css($el, prop, "");
            }
            if (steps.length < 2) {
              steps.unshift((prop === "scale" ? 1 : isCssProp ? css($el, prop) : 0) || 0);
            }
            var unit = getUnit(steps);
            if (isColor) {
              var ref2 = $el.style;
              var color = ref2.color;
              steps = steps.map(function(step) {
                return parseColor($el, step);
              });
              $el.style.color = color;
            } else if (startsWith(prop, "bg")) {
              var attr2 = prop === "bgy" ? "height" : "width";
              steps = steps.map(function(step) {
                return toPx(step, attr2, this$1$1.$el);
              });
              css($el, "background-position-" + prop[2], "");
              bgPos = css($el, "backgroundPosition").split(" ")[prop[2] === "x" ? 0 : 1];
              if (this$1$1.covers) {
                var min = Math.min.apply(Math, steps);
                var max = Math.max.apply(Math, steps);
                var down = steps.indexOf(min) < steps.indexOf(max);
                diff = max - min;
                steps = steps.map(function(step) {
                  return step - (down ? min : max);
                });
                pos = (down ? -diff : 0) + "px";
              } else {
                pos = bgPos;
              }
            } else {
              steps = steps.map(toFloat);
            }
            if (prop === "stroke") {
              if (!steps.some(function(step) {
                return step;
              })) {
                return props2;
              }
              var length = getMaxPathLength(this$1$1.$el);
              css($el, "strokeDasharray", length);
              if (unit === "%") {
                steps = steps.map(function(step) {
                  return step * length / 100;
                });
              }
              steps = steps.reverse();
              prop = "strokeDashoffset";
            }
            props2[prop] = { steps, unit, pos, bgPos, diff };
            return props2;
          }, {});
        },
        bgProps: function() {
          var this$1$1 = this;
          return ["bgx", "bgy"].filter(function(bg) {
            return bg in this$1$1.props;
          });
        },
        covers: function(_, $el) {
          return covers($el);
        }
      },
      disconnected: function() {
        delete this._image;
      },
      update: {
        read: function(data3) {
          var this$1$1 = this;
          if (!this.matchMedia) {
            return;
          }
          if (!data3.image && this.covers && this.bgProps.length) {
            var src = css(this.$el, "backgroundImage").replace(/^none|url\(["']?(.+?)["']?\)$/, "$1");
            if (src) {
              var img2 = new Image();
              img2.src = src;
              data3.image = img2;
              if (!img2.naturalWidth) {
                img2.onload = function() {
                  return this$1$1.$update();
                };
              }
            }
          }
          var image = data3.image;
          if (!image || !image.naturalWidth) {
            return;
          }
          var dimEl = {
            width: this.$el.offsetWidth,
            height: this.$el.offsetHeight
          };
          var dimImage = {
            width: image.naturalWidth,
            height: image.naturalHeight
          };
          var dim = Dimensions.cover(dimImage, dimEl);
          this.bgProps.forEach(function(prop) {
            var ref2 = this$1$1.props[prop];
            var diff = ref2.diff;
            var bgPos = ref2.bgPos;
            var steps = ref2.steps;
            var attr2 = prop === "bgy" ? "height" : "width";
            var span = dim[attr2] - dimEl[attr2];
            if (span < diff) {
              dimEl[attr2] = dim[attr2] + diff - span;
            } else if (span > diff) {
              var posPercentage = dimEl[attr2] / toPx(bgPos, attr2, this$1$1.$el);
              if (posPercentage) {
                this$1$1.props[prop].steps = steps.map(function(step) {
                  return step - (span - diff) / posPercentage;
                });
              }
            }
            dim = Dimensions.cover(dimImage, dimEl);
          });
          data3.dim = dim;
        },
        write: function(ref2) {
          var dim = ref2.dim;
          if (!this.matchMedia) {
            css(this.$el, { backgroundSize: "", backgroundRepeat: "" });
            return;
          }
          dim && css(this.$el, {
            backgroundSize: dim.width + "px " + dim.height + "px",
            backgroundRepeat: "no-repeat"
          });
        },
        events: ["resize"]
      },
      methods: {
        reset: function() {
          var this$1$1 = this;
          each(this.getCss(0), function(_, prop) {
            return css(this$1$1.$el, prop, "");
          });
        },
        getCss: function(percent2) {
          var ref2 = this;
          var props2 = ref2.props;
          return Object.keys(props2).reduce(function(css2, prop) {
            var ref3 = props2[prop];
            var steps = ref3.steps;
            var unit = ref3.unit;
            var pos = ref3.pos;
            var value = getValue2(steps, percent2);
            switch (prop) {
              case "x":
              case "y": {
                unit = unit || "px";
                css2.transform += " translate" + ucfirst(prop) + "(" + toFloat(value).toFixed(unit === "px" ? 0 : 2) + unit + ")";
                break;
              }
              case "rotate":
                unit = unit || "deg";
                css2.transform += " rotate(" + (value + unit) + ")";
                break;
              case "scale":
                css2.transform += " scale(" + value + ")";
                break;
              case "bgy":
              case "bgx":
                css2["background-position-" + prop[2]] = "calc(" + pos + " + " + value + "px)";
                break;
              case "color":
              case "backgroundColor":
              case "borderColor": {
                var ref$1 = getStep(steps, percent2);
                var start = ref$1[0];
                var end = ref$1[1];
                var p3 = ref$1[2];
                css2[prop] = "rgba(" + start.map(function(value2, i) {
                  value2 += p3 * (end[i] - value2);
                  return i === 3 ? toFloat(value2) : parseInt(value2, 10);
                }).join(",") + ")";
                break;
              }
              case "blur":
                unit = unit || "px";
                css2.filter += " blur(" + (value + unit) + ")";
                break;
              case "hue":
                unit = unit || "deg";
                css2.filter += " hue-rotate(" + (value + unit) + ")";
                break;
              case "fopacity":
                unit = unit || "%";
                css2.filter += " opacity(" + (value + unit) + ")";
                break;
              case "grayscale":
              case "invert":
              case "saturate":
              case "sepia":
                unit = unit || "%";
                css2.filter += " " + prop + "(" + (value + unit) + ")";
                break;
              default:
                css2[prop] = value;
            }
            return css2;
          }, { transform: "", filter: "" });
        }
      }
    };
    function parseColor(el, color) {
      return css(css(el, "color", color), "color").split(/[(),]/g).slice(1, -1).concat(1).slice(0, 4).map(toFloat);
    }
    function getStep(steps, percent2) {
      var count = steps.length - 1;
      var index2 = Math.min(Math.floor(count * percent2), count - 1);
      var step = steps.slice(index2, index2 + 2);
      step.push(percent2 === 1 ? 1 : percent2 % (1 / count) * count);
      return step;
    }
    function getValue2(steps, percent2, digits) {
      if (digits === void 0)
        digits = 2;
      var ref2 = getStep(steps, percent2);
      var start = ref2[0];
      var end = ref2[1];
      var p3 = ref2[2];
      return (isNumber2(start) ? start + Math.abs(start - end) * p3 * (start < end ? 1 : -1) : +end).toFixed(digits);
    }
    function getUnit(steps) {
      return steps.reduce(function(unit, step) {
        return isString2(step) && step.replace(/-|\d/g, "").trim() || unit;
      }, "");
    }
    function covers(el) {
      var ref2 = el.style;
      var backgroundSize = ref2.backgroundSize;
      var covers2 = css(css(el, "backgroundSize", ""), "backgroundSize") === "cover";
      el.style.backgroundSize = backgroundSize;
      return covers2;
    }
    var parallax = {
      mixins: [Parallax],
      props: {
        target: String,
        viewport: Number,
        easing: Number
      },
      data: {
        target: false,
        viewport: 1,
        easing: 1
      },
      computed: {
        target: function(ref2, $el) {
          var target = ref2.target;
          return getOffsetElement(target && query(target, $el) || $el);
        }
      },
      update: {
        read: function(ref2, types) {
          var percent2 = ref2.percent;
          if (!types.has("scroll")) {
            percent2 = false;
          }
          if (!this.matchMedia) {
            return;
          }
          var prev = percent2;
          percent2 = ease(scrolledOver(this.target) / (this.viewport || 1), this.easing);
          return {
            percent: percent2,
            style: prev !== percent2 ? this.getCss(percent2) : false
          };
        },
        write: function(ref2) {
          var style = ref2.style;
          if (!this.matchMedia) {
            this.reset();
            return;
          }
          style && css(this.$el, style);
        },
        events: ["scroll", "resize"]
      }
    };
    function ease(percent2, easing) {
      return clamp(percent2 * (1 - (easing - easing * percent2)));
    }
    function getOffsetElement(el) {
      return el ? "offsetTop" in el ? el : getOffsetElement(parent(el)) : document.body;
    }
    var SliderReactive = {
      update: {
        write: function() {
          if (this.stack.length || this.dragging) {
            return;
          }
          var index2 = this.getValidIndex(this.index);
          if (!~this.prevIndex || this.index !== index2) {
            this.show(index2);
          }
        },
        events: ["resize"]
      }
    };
    function Transitioner(prev, next, dir, ref2) {
      var center = ref2.center;
      var easing = ref2.easing;
      var list = ref2.list;
      var deferred = new Deferred();
      var from = prev ? getLeft(prev, list, center) : getLeft(next, list, center) + dimensions(next).width * dir;
      var to = next ? getLeft(next, list, center) : from + dimensions(prev).width * dir * (isRtl ? -1 : 1);
      return {
        dir,
        show: function(duration, percent2, linear) {
          if (percent2 === void 0)
            percent2 = 0;
          var timing = linear ? "linear" : easing;
          duration -= Math.round(duration * clamp(percent2, -1, 1));
          this.translate(percent2);
          percent2 = prev ? percent2 : clamp(percent2, 0, 1);
          triggerUpdate(this.getItemIn(), "itemin", { percent: percent2, duration, timing, dir });
          prev && triggerUpdate(this.getItemIn(true), "itemout", { percent: 1 - percent2, duration, timing, dir });
          Transition2.start(list, { transform: translate2(-to * (isRtl ? -1 : 1), "px") }, duration, timing).then(deferred.resolve, noop2);
          return deferred.promise;
        },
        cancel: function() {
          Transition2.cancel(list);
        },
        reset: function() {
          css(list, "transform", "");
        },
        forward: function(duration, percent2) {
          if (percent2 === void 0)
            percent2 = this.percent();
          Transition2.cancel(list);
          return this.show(duration, percent2, true);
        },
        translate: function(percent2) {
          var distance = this.getDistance() * dir * (isRtl ? -1 : 1);
          css(list, "transform", translate2(clamp(-to + (distance - distance * percent2), -getWidth(list), dimensions(list).width) * (isRtl ? -1 : 1), "px"));
          var actives = this.getActives();
          var itemIn = this.getItemIn();
          var itemOut = this.getItemIn(true);
          percent2 = prev ? clamp(percent2, -1, 1) : 0;
          children(list).forEach(function(slide2) {
            var isActive = includes(actives, slide2);
            var isIn2 = slide2 === itemIn;
            var isOut = slide2 === itemOut;
            var translateIn = isIn2 || !isOut && (isActive || dir * (isRtl ? -1 : 1) === -1 ^ getElLeft(slide2, list) > getElLeft(prev || next));
            triggerUpdate(slide2, "itemtranslate" + (translateIn ? "in" : "out"), {
              dir,
              percent: isOut ? 1 - percent2 : isIn2 ? percent2 : isActive ? 1 : 0
            });
          });
        },
        percent: function() {
          return Math.abs((css(list, "transform").split(",")[4] * (isRtl ? -1 : 1) + from) / (to - from));
        },
        getDistance: function() {
          return Math.abs(to - from);
        },
        getItemIn: function(out) {
          if (out === void 0)
            out = false;
          var actives = this.getActives();
          var nextActives = inView(list, getLeft(next || prev, list, center));
          if (out) {
            var temp = actives;
            actives = nextActives;
            nextActives = temp;
          }
          return nextActives[findIndex(nextActives, function(el) {
            return !includes(actives, el);
          })];
        },
        getActives: function() {
          return inView(list, getLeft(prev || next, list, center));
        }
      };
    }
    function getLeft(el, list, center) {
      var left = getElLeft(el, list);
      return center ? left - centerEl(el, list) : Math.min(left, getMax(list));
    }
    function getMax(list) {
      return Math.max(0, getWidth(list) - dimensions(list).width);
    }
    function getWidth(list) {
      return children(list).reduce(function(right, el) {
        return dimensions(el).width + right;
      }, 0);
    }
    function centerEl(el, list) {
      return dimensions(list).width / 2 - dimensions(el).width / 2;
    }
    function getElLeft(el, list) {
      return el && (position(el).left + (isRtl ? dimensions(el).width - dimensions(list).width : 0)) * (isRtl ? -1 : 1) || 0;
    }
    function inView(list, listLeft) {
      listLeft -= 1;
      var listWidth = dimensions(list).width;
      var listRight = listLeft + listWidth + 2;
      return children(list).filter(function(slide2) {
        var slideLeft = getElLeft(slide2, list);
        var slideRight = slideLeft + Math.min(dimensions(slide2).width, listWidth);
        return slideLeft >= listLeft && slideRight <= listRight;
      });
    }
    function triggerUpdate(el, type, data3) {
      trigger2(el, createEvent(type, false, false, data3));
    }
    var slider = {
      mixins: [Class, Slider, SliderReactive],
      props: {
        center: Boolean,
        sets: Boolean
      },
      data: {
        center: false,
        sets: false,
        attrItem: "uk-slider-item",
        selList: ".uk-slider-items",
        selNav: ".uk-slider-nav",
        clsContainer: "uk-slider-container",
        Transitioner
      },
      computed: {
        avgWidth: function() {
          return getWidth(this.list) / this.length;
        },
        finite: function(ref2) {
          var finite = ref2.finite;
          return finite || Math.ceil(getWidth(this.list)) < dimensions(this.list).width + getMaxElWidth(this.list) + this.center;
        },
        maxIndex: function() {
          if (!this.finite || this.center && !this.sets) {
            return this.length - 1;
          }
          if (this.center) {
            return last(this.sets);
          }
          var lft = 0;
          var max = getMax(this.list);
          var index2 = findIndex(this.slides, function(el) {
            if (lft >= max) {
              return true;
            }
            lft += dimensions(el).width;
          });
          return ~index2 ? index2 : this.length - 1;
        },
        sets: function(ref2) {
          var this$1$1 = this;
          var sets = ref2.sets;
          if (!sets) {
            return;
          }
          var width2 = dimensions(this.list).width / (this.center ? 2 : 1);
          var left = 0;
          var leftCenter = width2;
          var slideLeft = 0;
          sets = sortBy$1(this.slides, "offsetLeft").reduce(function(sets2, slide2, i) {
            var slideWidth = dimensions(slide2).width;
            var slideRight = slideLeft + slideWidth;
            if (slideRight > left) {
              if (!this$1$1.center && i > this$1$1.maxIndex) {
                i = this$1$1.maxIndex;
              }
              if (!includes(sets2, i)) {
                var cmp = this$1$1.slides[i + 1];
                if (this$1$1.center && cmp && slideWidth < leftCenter - dimensions(cmp).width / 2) {
                  leftCenter -= slideWidth;
                } else {
                  leftCenter = width2;
                  sets2.push(i);
                  left = slideLeft + width2 + (this$1$1.center ? slideWidth / 2 : 0);
                }
              }
            }
            slideLeft += slideWidth;
            return sets2;
          }, []);
          return !isEmpty(sets) && sets;
        },
        transitionOptions: function() {
          return {
            center: this.center,
            list: this.list
          };
        }
      },
      connected: function() {
        toggleClass(this.$el, this.clsContainer, !$("." + this.clsContainer, this.$el));
      },
      update: {
        write: function() {
          var this$1$1 = this;
          this.navItems.forEach(function(el) {
            var index2 = toNumber2(data2(el, this$1$1.attrItem));
            if (index2 !== false) {
              el.hidden = !this$1$1.maxIndex || index2 > this$1$1.maxIndex || this$1$1.sets && !includes(this$1$1.sets, index2);
            }
          });
          if (this.length && !this.dragging && !this.stack.length) {
            this.reorder();
            this._translate(1);
          }
          var actives = this._getTransitioner(this.index).getActives();
          this.slides.forEach(function(slide2) {
            return toggleClass(slide2, this$1$1.clsActive, includes(actives, slide2));
          });
          if (this.clsActivated && (!this.sets || includes(this.sets, toFloat(this.index)))) {
            this.slides.forEach(function(slide2) {
              return toggleClass(slide2, this$1$1.clsActivated || "", includes(actives, slide2));
            });
          }
        },
        events: ["resize"]
      },
      events: {
        beforeitemshow: function(e) {
          if (!this.dragging && this.sets && this.stack.length < 2 && !includes(this.sets, this.index)) {
            this.index = this.getValidIndex();
          }
          var diff = Math.abs(this.index - this.prevIndex + (this.dir > 0 && this.index < this.prevIndex || this.dir < 0 && this.index > this.prevIndex ? (this.maxIndex + 1) * this.dir : 0));
          if (!this.dragging && diff > 1) {
            for (var i = 0; i < diff; i++) {
              this.stack.splice(1, 0, this.dir > 0 ? "next" : "previous");
            }
            e.preventDefault();
            return;
          }
          var index2 = this.dir < 0 || !this.slides[this.prevIndex] ? this.index : this.prevIndex;
          this.duration = speedUp(this.avgWidth / this.velocity) * (dimensions(this.slides[index2]).width / this.avgWidth);
          this.reorder();
        },
        itemshow: function() {
          if (~this.prevIndex) {
            addClass(this._getTransitioner().getItemIn(), this.clsActive);
          }
        }
      },
      methods: {
        reorder: function() {
          var this$1$1 = this;
          if (this.finite) {
            css(this.slides, "order", "");
            return;
          }
          var index2 = this.dir > 0 && this.slides[this.prevIndex] ? this.prevIndex : this.index;
          this.slides.forEach(function(slide3, i) {
            return css(slide3, "order", this$1$1.dir > 0 && i < index2 ? 1 : this$1$1.dir < 0 && i >= this$1$1.index ? -1 : "");
          });
          if (!this.center) {
            return;
          }
          var next = this.slides[index2];
          var width2 = dimensions(this.list).width / 2 - dimensions(next).width / 2;
          var j = 0;
          while (width2 > 0) {
            var slideIndex = this.getIndex(--j + index2, index2);
            var slide2 = this.slides[slideIndex];
            css(slide2, "order", slideIndex > index2 ? -2 : -1);
            width2 -= dimensions(slide2).width;
          }
        },
        getValidIndex: function(index2, prevIndex) {
          if (index2 === void 0)
            index2 = this.index;
          if (prevIndex === void 0)
            prevIndex = this.prevIndex;
          index2 = this.getIndex(index2, prevIndex);
          if (!this.sets) {
            return index2;
          }
          var prev;
          do {
            if (includes(this.sets, index2)) {
              return index2;
            }
            prev = index2;
            index2 = this.getIndex(index2 + this.dir, prevIndex);
          } while (index2 !== prev);
          return index2;
        }
      }
    };
    function getMaxElWidth(list) {
      return Math.max.apply(Math, [0].concat(children(list).map(function(el) {
        return dimensions(el).width;
      })));
    }
    var sliderParallax = {
      mixins: [Parallax],
      data: {
        selItem: "!li"
      },
      computed: {
        item: function(ref2, $el) {
          var selItem = ref2.selItem;
          return query(selItem, $el);
        }
      },
      events: [
        {
          name: "itemin itemout",
          self: true,
          el: function() {
            return this.item;
          },
          handler: function(ref2) {
            var this$1$1 = this;
            var type = ref2.type;
            var ref_detail = ref2.detail;
            var percent2 = ref_detail.percent;
            var duration = ref_detail.duration;
            var timing = ref_detail.timing;
            var dir = ref_detail.dir;
            fastdom.read(function() {
              var propsFrom = this$1$1.getCss(getCurrentPercent(type, dir, percent2));
              var propsTo = this$1$1.getCss(isIn(type) ? 0.5 : dir > 0 ? 1 : 0);
              fastdom.write(function() {
                css(this$1$1.$el, propsFrom);
                Transition2.start(this$1$1.$el, propsTo, duration, timing).catch(noop2);
              });
            });
          }
        },
        {
          name: "transitioncanceled transitionend",
          self: true,
          el: function() {
            return this.item;
          },
          handler: function() {
            Transition2.cancel(this.$el);
          }
        },
        {
          name: "itemtranslatein itemtranslateout",
          self: true,
          el: function() {
            return this.item;
          },
          handler: function(ref2) {
            var this$1$1 = this;
            var type = ref2.type;
            var ref_detail = ref2.detail;
            var percent2 = ref_detail.percent;
            var dir = ref_detail.dir;
            fastdom.read(function() {
              var props2 = this$1$1.getCss(getCurrentPercent(type, dir, percent2));
              fastdom.write(function() {
                return css(this$1$1.$el, props2);
              });
            });
          }
        }
      ]
    };
    function isIn(type) {
      return endsWith(type, "in");
    }
    function getCurrentPercent(type, dir, percent2) {
      percent2 /= 2;
      return isIn(type) ^ dir < 0 ? percent2 : 1 - percent2;
    }
    var Animations = assign2({}, Animations$2, {
      fade: {
        show: function() {
          return [
            { opacity: 0, zIndex: 0 },
            { zIndex: -1 }
          ];
        },
        percent: function(current) {
          return 1 - css(current, "opacity");
        },
        translate: function(percent2) {
          return [
            { opacity: 1 - percent2, zIndex: 0 },
            { zIndex: -1 }
          ];
        }
      },
      scale: {
        show: function() {
          return [
            { opacity: 0, transform: scale3d(1 + 0.5), zIndex: 0 },
            { zIndex: -1 }
          ];
        },
        percent: function(current) {
          return 1 - css(current, "opacity");
        },
        translate: function(percent2) {
          return [
            { opacity: 1 - percent2, transform: scale3d(1 + 0.5 * percent2), zIndex: 0 },
            { zIndex: -1 }
          ];
        }
      },
      pull: {
        show: function(dir) {
          return dir < 0 ? [
            { transform: translate2(30), zIndex: -1 },
            { transform: translate2(), zIndex: 0 }
          ] : [
            { transform: translate2(-100), zIndex: 0 },
            { transform: translate2(), zIndex: -1 }
          ];
        },
        percent: function(current, next, dir) {
          return dir < 0 ? 1 - translated(next) : translated(current);
        },
        translate: function(percent2, dir) {
          return dir < 0 ? [
            { transform: translate2(30 * percent2), zIndex: -1 },
            { transform: translate2(-100 * (1 - percent2)), zIndex: 0 }
          ] : [
            { transform: translate2(-percent2 * 100), zIndex: 0 },
            { transform: translate2(30 * (1 - percent2)), zIndex: -1 }
          ];
        }
      },
      push: {
        show: function(dir) {
          return dir < 0 ? [
            { transform: translate2(100), zIndex: 0 },
            { transform: translate2(), zIndex: -1 }
          ] : [
            { transform: translate2(-30), zIndex: -1 },
            { transform: translate2(), zIndex: 0 }
          ];
        },
        percent: function(current, next, dir) {
          return dir > 0 ? 1 - translated(next) : translated(current);
        },
        translate: function(percent2, dir) {
          return dir < 0 ? [
            { transform: translate2(percent2 * 100), zIndex: 0 },
            { transform: translate2(-30 * (1 - percent2)), zIndex: -1 }
          ] : [
            { transform: translate2(-30 * percent2), zIndex: -1 },
            { transform: translate2(100 * (1 - percent2)), zIndex: 0 }
          ];
        }
      }
    });
    var slideshow = {
      mixins: [Class, Slideshow, SliderReactive],
      props: {
        ratio: String,
        minHeight: Number,
        maxHeight: Number
      },
      data: {
        ratio: "16:9",
        minHeight: false,
        maxHeight: false,
        selList: ".uk-slideshow-items",
        attrItem: "uk-slideshow-item",
        selNav: ".uk-slideshow-nav",
        Animations
      },
      update: {
        read: function() {
          if (!this.list) {
            return false;
          }
          var ref2 = this.ratio.split(":").map(Number);
          var width2 = ref2[0];
          var height2 = ref2[1];
          height2 = height2 * this.list.offsetWidth / width2 || 0;
          if (this.minHeight) {
            height2 = Math.max(this.minHeight, height2);
          }
          if (this.maxHeight) {
            height2 = Math.min(this.maxHeight, height2);
          }
          return { height: height2 - boxModelAdjust(this.list, "height", "content-box") };
        },
        write: function(ref2) {
          var height2 = ref2.height;
          height2 > 0 && css(this.list, "minHeight", height2);
        },
        events: ["resize"]
      }
    };
    var sortable = {
      mixins: [Class, Animate],
      props: {
        group: String,
        threshold: Number,
        clsItem: String,
        clsPlaceholder: String,
        clsDrag: String,
        clsDragState: String,
        clsBase: String,
        clsNoDrag: String,
        clsEmpty: String,
        clsCustom: String,
        handle: String
      },
      data: {
        group: false,
        threshold: 5,
        clsItem: "uk-sortable-item",
        clsPlaceholder: "uk-sortable-placeholder",
        clsDrag: "uk-sortable-drag",
        clsDragState: "uk-drag",
        clsBase: "uk-sortable",
        clsNoDrag: "uk-sortable-nodrag",
        clsEmpty: "uk-sortable-empty",
        clsCustom: "",
        handle: false,
        pos: {}
      },
      created: function() {
        var this$1$1 = this;
        ["init", "start", "move", "end"].forEach(function(key2) {
          var fn = this$1$1[key2];
          this$1$1[key2] = function(e) {
            assign2(this$1$1.pos, getEventPos(e));
            fn(e);
          };
        });
      },
      events: {
        name: pointerDown,
        passive: false,
        handler: "init"
      },
      computed: {
        target: function() {
          return (this.$el.tBodies || [this.$el])[0];
        },
        items: function() {
          return children(this.target);
        },
        isEmpty: {
          get: function() {
            return isEmpty(this.items);
          },
          watch: function(empty2) {
            toggleClass(this.target, this.clsEmpty, empty2);
          },
          immediate: true
        },
        handles: {
          get: function(ref2, el) {
            var handle = ref2.handle;
            return handle ? $$(handle, el) : this.items;
          },
          watch: function(handles, prev) {
            css(prev, { touchAction: "", userSelect: "" });
            css(handles, { touchAction: hasTouch ? "none" : "", userSelect: "none" });
          },
          immediate: true
        }
      },
      update: {
        write: function(data3) {
          if (!this.drag || !parent(this.placeholder)) {
            return;
          }
          var ref2 = this;
          var ref_pos = ref2.pos;
          var x = ref_pos.x;
          var y = ref_pos.y;
          var ref_origin = ref2.origin;
          var offsetTop = ref_origin.offsetTop;
          var offsetLeft = ref_origin.offsetLeft;
          var placeholder = ref2.placeholder;
          css(this.drag, {
            top: y - offsetTop,
            left: x - offsetLeft
          });
          var sortable2 = this.getSortable(document.elementFromPoint(x, y));
          if (!sortable2) {
            return;
          }
          var items = sortable2.items;
          if (items.some(Transition2.inProgress)) {
            return;
          }
          var target = findTarget(items, { x, y });
          if (items.length && (!target || target === placeholder)) {
            return;
          }
          var previous = this.getSortable(placeholder);
          var insertTarget = findInsertTarget(sortable2.target, target, placeholder, x, y, sortable2 === previous && data3.moved !== target);
          if (insertTarget === false) {
            return;
          }
          if (insertTarget && placeholder === insertTarget) {
            return;
          }
          if (sortable2 !== previous) {
            previous.remove(placeholder);
            data3.moved = target;
          } else {
            delete data3.moved;
          }
          sortable2.insert(placeholder, insertTarget);
          this.touched.add(sortable2);
        },
        events: ["move"]
      },
      methods: {
        init: function(e) {
          var target = e.target;
          var button = e.button;
          var defaultPrevented = e.defaultPrevented;
          var ref2 = this.items.filter(function(el) {
            return within(target, el);
          });
          var placeholder = ref2[0];
          if (!placeholder || defaultPrevented || button > 0 || isInput(target) || within(target, "." + this.clsNoDrag) || this.handle && !within(target, this.handle)) {
            return;
          }
          e.preventDefault();
          this.touched = new Set([this]);
          this.placeholder = placeholder;
          this.origin = assign2({ target, index: index(placeholder) }, this.pos);
          on(document, pointerMove, this.move);
          on(document, pointerUp, this.end);
          if (!this.threshold) {
            this.start(e);
          }
        },
        start: function(e) {
          this.drag = appendDrag(this.$container, this.placeholder);
          var ref2 = this.placeholder.getBoundingClientRect();
          var left = ref2.left;
          var top = ref2.top;
          assign2(this.origin, { offsetLeft: this.pos.x - left, offsetTop: this.pos.y - top });
          addClass(this.drag, this.clsDrag, this.clsCustom);
          addClass(this.placeholder, this.clsPlaceholder);
          addClass(this.items, this.clsItem);
          addClass(document.documentElement, this.clsDragState);
          trigger2(this.$el, "start", [this, this.placeholder]);
          trackScroll(this.pos);
          this.move(e);
        },
        move: function(e) {
          if (this.drag) {
            this.$emit("move");
          } else if (Math.abs(this.pos.x - this.origin.x) > this.threshold || Math.abs(this.pos.y - this.origin.y) > this.threshold) {
            this.start(e);
          }
        },
        end: function() {
          var this$1$1 = this;
          off(document, pointerMove, this.move);
          off(document, pointerUp, this.end);
          off(window, "scroll", this.scroll);
          if (!this.drag) {
            return;
          }
          untrackScroll();
          var sortable2 = this.getSortable(this.placeholder);
          if (this === sortable2) {
            if (this.origin.index !== index(this.placeholder)) {
              trigger2(this.$el, "moved", [this, this.placeholder]);
            }
          } else {
            trigger2(sortable2.$el, "added", [sortable2, this.placeholder]);
            trigger2(this.$el, "removed", [this, this.placeholder]);
          }
          trigger2(this.$el, "stop", [this, this.placeholder]);
          remove$1(this.drag);
          this.drag = null;
          this.touched.forEach(function(ref2) {
            var clsPlaceholder = ref2.clsPlaceholder;
            var clsItem = ref2.clsItem;
            return this$1$1.touched.forEach(function(sortable3) {
              return removeClass(sortable3.items, clsPlaceholder, clsItem);
            });
          });
          this.touched = null;
          removeClass(document.documentElement, this.clsDragState);
        },
        insert: function(element, target) {
          var this$1$1 = this;
          addClass(this.items, this.clsItem);
          var insert = function() {
            return target ? before(target, element) : append(this$1$1.target, element);
          };
          this.animate(insert);
        },
        remove: function(element) {
          if (!within(element, this.target)) {
            return;
          }
          this.animate(function() {
            return remove$1(element);
          });
        },
        getSortable: function(element) {
          do {
            var sortable2 = this.$getComponent(element, "sortable");
            if (sortable2 && (sortable2 === this || this.group !== false && sortable2.group === this.group)) {
              return sortable2;
            }
          } while (element = parent(element));
        }
      }
    };
    var trackTimer;
    function trackScroll(pos) {
      var last2 = Date.now();
      trackTimer = setInterval(function() {
        var x = pos.x;
        var y = pos.y;
        y += window.pageYOffset;
        var dist = (Date.now() - last2) * 0.3;
        last2 = Date.now();
        scrollParents(document.elementFromPoint(x, pos.y), /auto|scroll/).reverse().some(function(scrollEl) {
          var scroll2 = scrollEl.scrollTop;
          var scrollHeight = scrollEl.scrollHeight;
          var ref2 = offset(getViewport$1(scrollEl));
          var top = ref2.top;
          var bottom = ref2.bottom;
          var height2 = ref2.height;
          if (top < y && top + 35 > y) {
            scroll2 -= dist;
          } else if (bottom > y && bottom - 35 < y) {
            scroll2 += dist;
          } else {
            return;
          }
          if (scroll2 > 0 && scroll2 < scrollHeight - height2) {
            scrollTop(scrollEl, scroll2);
            return true;
          }
        });
      }, 15);
    }
    function untrackScroll() {
      clearInterval(trackTimer);
    }
    function appendDrag(container, element) {
      var clone = append(container, element.outerHTML.replace(/(^<)(?:li|tr)|(?:li|tr)(\/>$)/g, "$1div$2"));
      css(clone, "margin", "0", "important");
      css(clone, assign2({
        boxSizing: "border-box",
        width: element.offsetWidth,
        height: element.offsetHeight
      }, css(element, ["paddingLeft", "paddingRight", "paddingTop", "paddingBottom"])));
      height(clone.firstElementChild, height(element.firstElementChild));
      return clone;
    }
    function findTarget(items, point) {
      return items[findIndex(items, function(item) {
        return pointInRect(point, item.getBoundingClientRect());
      })];
    }
    function findInsertTarget(list, target, placeholder, x, y, sameList) {
      if (!children(list).length) {
        return;
      }
      var rect = target.getBoundingClientRect();
      if (!sameList) {
        if (!isHorizontal(list, placeholder)) {
          return y < rect.top + rect.height / 2 ? target : target.nextElementSibling;
        }
        return target;
      }
      var placeholderRect = placeholder.getBoundingClientRect();
      var sameRow = linesIntersect([rect.top, rect.bottom], [placeholderRect.top, placeholderRect.bottom]);
      var pointerPos = sameRow ? x : y;
      var lengthProp = sameRow ? "width" : "height";
      var startProp = sameRow ? "left" : "top";
      var endProp = sameRow ? "right" : "bottom";
      var diff = placeholderRect[lengthProp] < rect[lengthProp] ? rect[lengthProp] - placeholderRect[lengthProp] : 0;
      if (placeholderRect[startProp] < rect[startProp]) {
        if (diff && pointerPos < rect[startProp] + diff) {
          return false;
        }
        return target.nextElementSibling;
      }
      if (diff && pointerPos > rect[endProp] - diff) {
        return false;
      }
      return target;
    }
    function isHorizontal(list, placeholder) {
      var single = children(list).length === 1;
      if (single) {
        append(list, placeholder);
      }
      var items = children(list);
      var isHorizontal2 = items.some(function(el, i) {
        var rectA = el.getBoundingClientRect();
        return items.slice(i + 1).some(function(el2) {
          var rectB = el2.getBoundingClientRect();
          return !linesIntersect([rectA.left, rectA.right], [rectB.left, rectB.right]);
        });
      });
      if (single) {
        remove$1(placeholder);
      }
      return isHorizontal2;
    }
    function linesIntersect(lineA, lineB) {
      return lineA[1] > lineB[0] && lineB[1] > lineA[0];
    }
    var obj;
    var tooltip = {
      mixins: [Container, Togglable, Position],
      args: "title",
      props: {
        delay: Number,
        title: String
      },
      data: {
        pos: "top",
        title: "",
        delay: 0,
        animation: ["uk-animation-scale-up"],
        duration: 100,
        cls: "uk-active",
        clsPos: "uk-tooltip"
      },
      beforeConnect: function() {
        this._hasTitle = hasAttr(this.$el, "title");
        attr(this.$el, "title", "");
        this.updateAria(false);
        makeFocusable(this.$el);
      },
      disconnected: function() {
        this.hide();
        attr(this.$el, "title", this._hasTitle ? this.title : null);
      },
      methods: {
        show: function() {
          var this$1$1 = this;
          if (this.isToggled(this.tooltip || null) || !this.title) {
            return;
          }
          this._unbind = once(document, "show keydown " + pointerDown, this.hide, false, function(e) {
            return e.type === pointerDown && !within(e.target, this$1$1.$el) || e.type === "keydown" && e.keyCode === 27 || e.type === "show" && e.detail[0] !== this$1$1 && e.detail[0].$name === this$1$1.$name;
          });
          clearTimeout(this.showTimer);
          this.showTimer = setTimeout(this._show, this.delay);
        },
        hide: function() {
          var this$1$1 = this;
          if (matches(this.$el, "input:focus")) {
            return;
          }
          clearTimeout(this.showTimer);
          if (!this.isToggled(this.tooltip || null)) {
            return;
          }
          this.toggleElement(this.tooltip, false, false).then(function() {
            remove$1(this$1$1.tooltip);
            this$1$1.tooltip = null;
            this$1$1._unbind();
          });
        },
        _show: function() {
          var this$1$1 = this;
          this.tooltip = append(this.container, '<div class="' + this.clsPos + '"> <div class="' + this.clsPos + '-inner">' + this.title + "</div> </div>");
          on(this.tooltip, "toggled", function(e, toggled) {
            this$1$1.updateAria(toggled);
            if (!toggled) {
              return;
            }
            this$1$1.positionAt(this$1$1.tooltip, this$1$1.$el);
            this$1$1.origin = this$1$1.getAxis() === "y" ? flipPosition(this$1$1.dir) + "-" + this$1$1.align : this$1$1.align + "-" + flipPosition(this$1$1.dir);
          });
          this.toggleElement(this.tooltip, true);
        },
        updateAria: function(toggled) {
          attr(this.$el, "aria-expanded", toggled);
        }
      },
      events: (obj = {
        focus: "show",
        blur: "hide"
      }, obj[pointerEnter + " " + pointerLeave] = function(e) {
        if (!isTouch(e)) {
          this[e.type === pointerEnter ? "show" : "hide"]();
        }
      }, obj[pointerDown] = function(e) {
        if (isTouch(e)) {
          this.show();
        }
      }, obj)
    };
    function makeFocusable(el) {
      if (!isFocusable(el)) {
        attr(el, "tabindex", "0");
      }
    }
    var upload = {
      props: {
        allow: String,
        clsDragover: String,
        concurrent: Number,
        maxSize: Number,
        method: String,
        mime: String,
        msgInvalidMime: String,
        msgInvalidName: String,
        msgInvalidSize: String,
        multiple: Boolean,
        name: String,
        params: Object,
        type: String,
        url: String
      },
      data: {
        allow: false,
        clsDragover: "uk-dragover",
        concurrent: 1,
        maxSize: 0,
        method: "POST",
        mime: false,
        msgInvalidMime: "Invalid File Type: %s",
        msgInvalidName: "Invalid File Name: %s",
        msgInvalidSize: "Invalid File Size: %s Kilobytes Max",
        multiple: false,
        name: "files[]",
        params: {},
        type: "",
        url: "",
        abort: noop2,
        beforeAll: noop2,
        beforeSend: noop2,
        complete: noop2,
        completeAll: noop2,
        error: noop2,
        fail: noop2,
        load: noop2,
        loadEnd: noop2,
        loadStart: noop2,
        progress: noop2
      },
      events: {
        change: function(e) {
          if (!matches(e.target, 'input[type="file"]')) {
            return;
          }
          e.preventDefault();
          if (e.target.files) {
            this.upload(e.target.files);
          }
          e.target.value = "";
        },
        drop: function(e) {
          stop(e);
          var transfer = e.dataTransfer;
          if (!transfer || !transfer.files) {
            return;
          }
          removeClass(this.$el, this.clsDragover);
          this.upload(transfer.files);
        },
        dragenter: function(e) {
          stop(e);
        },
        dragover: function(e) {
          stop(e);
          addClass(this.$el, this.clsDragover);
        },
        dragleave: function(e) {
          stop(e);
          removeClass(this.$el, this.clsDragover);
        }
      },
      methods: {
        upload: function(files) {
          var this$1$1 = this;
          if (!files.length) {
            return;
          }
          trigger2(this.$el, "upload", [files]);
          for (var i = 0; i < files.length; i++) {
            if (this.maxSize && this.maxSize * 1e3 < files[i].size) {
              this.fail(this.msgInvalidSize.replace("%s", this.maxSize));
              return;
            }
            if (this.allow && !match(this.allow, files[i].name)) {
              this.fail(this.msgInvalidName.replace("%s", this.allow));
              return;
            }
            if (this.mime && !match(this.mime, files[i].type)) {
              this.fail(this.msgInvalidMime.replace("%s", this.mime));
              return;
            }
          }
          if (!this.multiple) {
            files = [files[0]];
          }
          this.beforeAll(this, files);
          var chunks = chunk(files, this.concurrent);
          var upload2 = function(files2) {
            var data3 = new FormData();
            files2.forEach(function(file) {
              return data3.append(this$1$1.name, file);
            });
            for (var key2 in this$1$1.params) {
              data3.append(key2, this$1$1.params[key2]);
            }
            ajax(this$1$1.url, {
              data: data3,
              method: this$1$1.method,
              responseType: this$1$1.type,
              beforeSend: function(env) {
                var xhr2 = env.xhr;
                xhr2.upload && on(xhr2.upload, "progress", this$1$1.progress);
                ["loadStart", "load", "loadEnd", "abort"].forEach(function(type) {
                  return on(xhr2, type.toLowerCase(), this$1$1[type]);
                });
                return this$1$1.beforeSend(env);
              }
            }).then(function(xhr2) {
              this$1$1.complete(xhr2);
              if (chunks.length) {
                upload2(chunks.shift());
              } else {
                this$1$1.completeAll(xhr2);
              }
            }, function(e) {
              return this$1$1.error(e);
            });
          };
          upload2(chunks.shift());
        }
      }
    };
    function match(pattern, path) {
      return path.match(new RegExp("^" + pattern.replace(/\//g, "\\/").replace(/\*\*/g, "(\\/[^\\/]+)*").replace(/\*/g, "[^\\/]+").replace(/((?!\\))\?/g, "$1.") + "$", "i"));
    }
    function chunk(files, size2) {
      var chunks = [];
      for (var i = 0; i < files.length; i += size2) {
        var chunk2 = [];
        for (var j = 0; j < size2; j++) {
          chunk2.push(files[i + j]);
        }
        chunks.push(chunk2);
      }
      return chunks;
    }
    function stop(e) {
      e.preventDefault();
      e.stopPropagation();
    }
    var components = /* @__PURE__ */ Object.freeze({
      __proto__: null,
      Countdown: countdown,
      Filter: filter,
      Lightbox: lightbox,
      LightboxPanel,
      Notification: notification,
      Parallax: parallax,
      Slider: slider,
      SliderParallax: sliderParallax,
      Slideshow: slideshow,
      SlideshowParallax: sliderParallax,
      Sortable: sortable,
      Tooltip: tooltip,
      Upload: upload
    });
    each(components, function(component, name) {
      return UIkit2.component(name, component);
    });
    return UIkit2;
  });
})(uikit);
var UIkit = uikit.exports;
var axios$2 = { exports: {} };
var bind$2 = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};
var bind$1 = bind$2;
var toString = Object.prototype.toString;
function isArray(val) {
  return toString.call(val) === "[object Array]";
}
function isUndefined(val) {
  return typeof val === "undefined";
}
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && typeof val.constructor.isBuffer === "function" && val.constructor.isBuffer(val);
}
function isArrayBuffer(val) {
  return toString.call(val) === "[object ArrayBuffer]";
}
function isFormData(val) {
  return typeof FormData !== "undefined" && val instanceof FormData;
}
function isArrayBufferView(val) {
  var result;
  if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
    result = ArrayBuffer.isView(val);
  } else {
    result = val && val.buffer && val.buffer instanceof ArrayBuffer;
  }
  return result;
}
function isString(val) {
  return typeof val === "string";
}
function isNumber(val) {
  return typeof val === "number";
}
function isObject(val) {
  return val !== null && typeof val === "object";
}
function isPlainObject(val) {
  if (toString.call(val) !== "[object Object]") {
    return false;
  }
  var prototype = Object.getPrototypeOf(val);
  return prototype === null || prototype === Object.prototype;
}
function isDate(val) {
  return toString.call(val) === "[object Date]";
}
function isFile(val) {
  return toString.call(val) === "[object File]";
}
function isBlob(val) {
  return toString.call(val) === "[object Blob]";
}
function isFunction(val) {
  return toString.call(val) === "[object Function]";
}
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}
function isURLSearchParams(val) {
  return typeof URLSearchParams !== "undefined" && val instanceof URLSearchParams;
}
function trim(str) {
  return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, "");
}
function isStandardBrowserEnv() {
  if (typeof navigator !== "undefined" && (navigator.product === "ReactNative" || navigator.product === "NativeScript" || navigator.product === "NS")) {
    return false;
  }
  return typeof window !== "undefined" && typeof document !== "undefined";
}
function forEach(obj, fn) {
  if (obj === null || typeof obj === "undefined") {
    return;
  }
  if (typeof obj !== "object") {
    obj = [obj];
  }
  if (isArray(obj)) {
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}
function merge() {
  var result = {};
  function assignValue(val, key) {
    if (isPlainObject(result[key]) && isPlainObject(val)) {
      result[key] = merge(result[key], val);
    } else if (isPlainObject(val)) {
      result[key] = merge({}, val);
    } else if (isArray(val)) {
      result[key] = val.slice();
    } else {
      result[key] = val;
    }
  }
  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === "function") {
      a[key] = bind$1(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}
function stripBOM(content) {
  if (content.charCodeAt(0) === 65279) {
    content = content.slice(1);
  }
  return content;
}
var utils$d = {
  isArray,
  isArrayBuffer,
  isBuffer,
  isFormData,
  isArrayBufferView,
  isString,
  isNumber,
  isObject,
  isPlainObject,
  isUndefined,
  isDate,
  isFile,
  isBlob,
  isFunction,
  isStream,
  isURLSearchParams,
  isStandardBrowserEnv,
  forEach,
  merge,
  extend,
  trim,
  stripBOM
};
var utils$c = utils$d;
function encode(val) {
  return encodeURIComponent(val).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
}
var buildURL$2 = function buildURL(url, params, paramsSerializer) {
  if (!params) {
    return url;
  }
  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils$c.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];
    utils$c.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === "undefined") {
        return;
      }
      if (utils$c.isArray(val)) {
        key = key + "[]";
      } else {
        val = [val];
      }
      utils$c.forEach(val, function parseValue2(v) {
        if (utils$c.isDate(v)) {
          v = v.toISOString();
        } else if (utils$c.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + "=" + encode(v));
      });
    });
    serializedParams = parts.join("&");
  }
  if (serializedParams) {
    var hashmarkIndex = url.indexOf("#");
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }
    url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
  }
  return url;
};
var utils$b = utils$d;
function InterceptorManager$1() {
  this.handlers = [];
}
InterceptorManager$1.prototype.use = function use(fulfilled, rejected, options) {
  this.handlers.push({
    fulfilled,
    rejected,
    synchronous: options ? options.synchronous : false,
    runWhen: options ? options.runWhen : null
  });
  return this.handlers.length - 1;
};
InterceptorManager$1.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};
InterceptorManager$1.prototype.forEach = function forEach2(fn) {
  utils$b.forEach(this.handlers, function forEachHandler(h2) {
    if (h2 !== null) {
      fn(h2);
    }
  });
};
var InterceptorManager_1 = InterceptorManager$1;
var utils$a = utils$d;
var normalizeHeaderName$1 = function normalizeHeaderName(headers, normalizedName) {
  utils$a.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};
var enhanceError$2 = function enhanceError(error, config, code2, request2, response) {
  error.config = config;
  if (code2) {
    error.code = code2;
  }
  error.request = request2;
  error.response = response;
  error.isAxiosError = true;
  error.toJSON = function toJSON() {
    return {
      message: this.message,
      name: this.name,
      description: this.description,
      number: this.number,
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      config: this.config,
      code: this.code,
      status: this.response && this.response.status ? this.response.status : null
    };
  };
  return error;
};
var enhanceError$1 = enhanceError$2;
var createError$2 = function createError(message, config, code2, request2, response) {
  var error = new Error(message);
  return enhanceError$1(error, config, code2, request2, response);
};
var createError$1 = createError$2;
var settle$1 = function settle(resolve2, reject, response) {
  var validateStatus2 = response.config.validateStatus;
  if (!response.status || !validateStatus2 || validateStatus2(response.status)) {
    resolve2(response);
  } else {
    reject(createError$1("Request failed with status code " + response.status, response.config, null, response.request, response));
  }
};
var utils$9 = utils$d;
var cookies$1 = utils$9.isStandardBrowserEnv() ? function standardBrowserEnv() {
  return {
    write: function write(name, value, expires, path, domain, secure) {
      var cookie = [];
      cookie.push(name + "=" + encodeURIComponent(value));
      if (utils$9.isNumber(expires)) {
        cookie.push("expires=" + new Date(expires).toGMTString());
      }
      if (utils$9.isString(path)) {
        cookie.push("path=" + path);
      }
      if (utils$9.isString(domain)) {
        cookie.push("domain=" + domain);
      }
      if (secure === true) {
        cookie.push("secure");
      }
      document.cookie = cookie.join("; ");
    },
    read: function read(name) {
      var match = document.cookie.match(new RegExp("(^|;\\s*)(" + name + ")=([^;]*)"));
      return match ? decodeURIComponent(match[3]) : null;
    },
    remove: function remove2(name) {
      this.write(name, "", Date.now() - 864e5);
    }
  };
}() : function nonStandardBrowserEnv() {
  return {
    write: function write() {
    },
    read: function read() {
      return null;
    },
    remove: function remove2() {
    }
  };
}();
var isAbsoluteURL$1 = function isAbsoluteURL(url) {
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};
var combineURLs$1 = function combineURLs(baseURL, relativeURL) {
  return relativeURL ? baseURL.replace(/\/+$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
};
var isAbsoluteURL2 = isAbsoluteURL$1;
var combineURLs2 = combineURLs$1;
var buildFullPath$1 = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL2(requestedURL)) {
    return combineURLs2(baseURL, requestedURL);
  }
  return requestedURL;
};
var utils$8 = utils$d;
var ignoreDuplicateOf = [
  "age",
  "authorization",
  "content-length",
  "content-type",
  "etag",
  "expires",
  "from",
  "host",
  "if-modified-since",
  "if-unmodified-since",
  "last-modified",
  "location",
  "max-forwards",
  "proxy-authorization",
  "referer",
  "retry-after",
  "user-agent"
];
var parseHeaders$1 = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;
  if (!headers) {
    return parsed;
  }
  utils$8.forEach(headers.split("\n"), function parser(line) {
    i = line.indexOf(":");
    key = utils$8.trim(line.substr(0, i)).toLowerCase();
    val = utils$8.trim(line.substr(i + 1));
    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === "set-cookie") {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
      }
    }
  });
  return parsed;
};
var utils$7 = utils$d;
var isURLSameOrigin$1 = utils$7.isStandardBrowserEnv() ? function standardBrowserEnv2() {
  var msie = /(msie|trident)/i.test(navigator.userAgent);
  var urlParsingNode = document.createElement("a");
  var originURL;
  function resolveURL(url) {
    var href = url;
    if (msie) {
      urlParsingNode.setAttribute("href", href);
      href = urlParsingNode.href;
    }
    urlParsingNode.setAttribute("href", href);
    return {
      href: urlParsingNode.href,
      protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, "") : "",
      host: urlParsingNode.host,
      search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, "") : "",
      hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, "") : "",
      hostname: urlParsingNode.hostname,
      port: urlParsingNode.port,
      pathname: urlParsingNode.pathname.charAt(0) === "/" ? urlParsingNode.pathname : "/" + urlParsingNode.pathname
    };
  }
  originURL = resolveURL(window.location.href);
  return function isURLSameOrigin2(requestURL) {
    var parsed = utils$7.isString(requestURL) ? resolveURL(requestURL) : requestURL;
    return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
  };
}() : function nonStandardBrowserEnv2() {
  return function isURLSameOrigin2() {
    return true;
  };
}();
function Cancel$3(message) {
  this.message = message;
}
Cancel$3.prototype.toString = function toString2() {
  return "Cancel" + (this.message ? ": " + this.message : "");
};
Cancel$3.prototype.__CANCEL__ = true;
var Cancel_1 = Cancel$3;
var utils$6 = utils$d;
var settle2 = settle$1;
var cookies = cookies$1;
var buildURL$1 = buildURL$2;
var buildFullPath2 = buildFullPath$1;
var parseHeaders2 = parseHeaders$1;
var isURLSameOrigin = isURLSameOrigin$1;
var createError2 = createError$2;
var defaults$4 = defaults_1;
var Cancel$2 = Cancel_1;
var xhr = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve2, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;
    var responseType = config.responseType;
    var onCanceled;
    function done() {
      if (config.cancelToken) {
        config.cancelToken.unsubscribe(onCanceled);
      }
      if (config.signal) {
        config.signal.removeEventListener("abort", onCanceled);
      }
    }
    if (utils$6.isFormData(requestData)) {
      delete requestHeaders["Content-Type"];
    }
    var request2 = new XMLHttpRequest();
    if (config.auth) {
      var username = config.auth.username || "";
      var password = config.auth.password ? unescape(encodeURIComponent(config.auth.password)) : "";
      requestHeaders.Authorization = "Basic " + btoa(username + ":" + password);
    }
    var fullPath = buildFullPath2(config.baseURL, config.url);
    request2.open(config.method.toUpperCase(), buildURL$1(fullPath, config.params, config.paramsSerializer), true);
    request2.timeout = config.timeout;
    function onloadend() {
      if (!request2) {
        return;
      }
      var responseHeaders = "getAllResponseHeaders" in request2 ? parseHeaders2(request2.getAllResponseHeaders()) : null;
      var responseData = !responseType || responseType === "text" || responseType === "json" ? request2.responseText : request2.response;
      var response = {
        data: responseData,
        status: request2.status,
        statusText: request2.statusText,
        headers: responseHeaders,
        config,
        request: request2
      };
      settle2(function _resolve(value) {
        resolve2(value);
        done();
      }, function _reject(err) {
        reject(err);
        done();
      }, response);
      request2 = null;
    }
    if ("onloadend" in request2) {
      request2.onloadend = onloadend;
    } else {
      request2.onreadystatechange = function handleLoad() {
        if (!request2 || request2.readyState !== 4) {
          return;
        }
        if (request2.status === 0 && !(request2.responseURL && request2.responseURL.indexOf("file:") === 0)) {
          return;
        }
        setTimeout(onloadend);
      };
    }
    request2.onabort = function handleAbort() {
      if (!request2) {
        return;
      }
      reject(createError2("Request aborted", config, "ECONNABORTED", request2));
      request2 = null;
    };
    request2.onerror = function handleError2() {
      reject(createError2("Network Error", config, null, request2));
      request2 = null;
    };
    request2.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = "timeout of " + config.timeout + "ms exceeded";
      var transitional2 = config.transitional || defaults$4.transitional;
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError2(timeoutErrorMessage, config, transitional2.clarifyTimeoutError ? "ETIMEDOUT" : "ECONNABORTED", request2));
      request2 = null;
    };
    if (utils$6.isStandardBrowserEnv()) {
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ? cookies.read(config.xsrfCookieName) : void 0;
      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }
    if ("setRequestHeader" in request2) {
      utils$6.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === "undefined" && key.toLowerCase() === "content-type") {
          delete requestHeaders[key];
        } else {
          request2.setRequestHeader(key, val);
        }
      });
    }
    if (!utils$6.isUndefined(config.withCredentials)) {
      request2.withCredentials = !!config.withCredentials;
    }
    if (responseType && responseType !== "json") {
      request2.responseType = config.responseType;
    }
    if (typeof config.onDownloadProgress === "function") {
      request2.addEventListener("progress", config.onDownloadProgress);
    }
    if (typeof config.onUploadProgress === "function" && request2.upload) {
      request2.upload.addEventListener("progress", config.onUploadProgress);
    }
    if (config.cancelToken || config.signal) {
      onCanceled = function(cancel) {
        if (!request2) {
          return;
        }
        reject(!cancel || cancel && cancel.type ? new Cancel$2("canceled") : cancel);
        request2.abort();
        request2 = null;
      };
      config.cancelToken && config.cancelToken.subscribe(onCanceled);
      if (config.signal) {
        config.signal.aborted ? onCanceled() : config.signal.addEventListener("abort", onCanceled);
      }
    }
    if (!requestData) {
      requestData = null;
    }
    request2.send(requestData);
  });
};
var utils$5 = utils$d;
var normalizeHeaderName2 = normalizeHeaderName$1;
var enhanceError2 = enhanceError$2;
var DEFAULT_CONTENT_TYPE = {
  "Content-Type": "application/x-www-form-urlencoded"
};
function setContentTypeIfUnset(headers, value) {
  if (!utils$5.isUndefined(headers) && utils$5.isUndefined(headers["Content-Type"])) {
    headers["Content-Type"] = value;
  }
}
function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== "undefined") {
    adapter = xhr;
  } else if (typeof process !== "undefined" && Object.prototype.toString.call(process) === "[object process]") {
    adapter = xhr;
  }
  return adapter;
}
function stringifySafely(rawValue, parser, encoder) {
  if (utils$5.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return utils$5.trim(rawValue);
    } catch (e) {
      if (e.name !== "SyntaxError") {
        throw e;
      }
    }
  }
  return (encoder || JSON.stringify)(rawValue);
}
var defaults$3 = {
  transitional: {
    silentJSONParsing: true,
    forcedJSONParsing: true,
    clarifyTimeoutError: false
  },
  adapter: getDefaultAdapter(),
  transformRequest: [function transformRequest(data2, headers) {
    normalizeHeaderName2(headers, "Accept");
    normalizeHeaderName2(headers, "Content-Type");
    if (utils$5.isFormData(data2) || utils$5.isArrayBuffer(data2) || utils$5.isBuffer(data2) || utils$5.isStream(data2) || utils$5.isFile(data2) || utils$5.isBlob(data2)) {
      return data2;
    }
    if (utils$5.isArrayBufferView(data2)) {
      return data2.buffer;
    }
    if (utils$5.isURLSearchParams(data2)) {
      setContentTypeIfUnset(headers, "application/x-www-form-urlencoded;charset=utf-8");
      return data2.toString();
    }
    if (utils$5.isObject(data2) || headers && headers["Content-Type"] === "application/json") {
      setContentTypeIfUnset(headers, "application/json");
      return stringifySafely(data2);
    }
    return data2;
  }],
  transformResponse: [function transformResponse(data2) {
    var transitional2 = this.transitional || defaults$3.transitional;
    var silentJSONParsing = transitional2 && transitional2.silentJSONParsing;
    var forcedJSONParsing = transitional2 && transitional2.forcedJSONParsing;
    var strictJSONParsing = !silentJSONParsing && this.responseType === "json";
    if (strictJSONParsing || forcedJSONParsing && utils$5.isString(data2) && data2.length) {
      try {
        return JSON.parse(data2);
      } catch (e) {
        if (strictJSONParsing) {
          if (e.name === "SyntaxError") {
            throw enhanceError2(e, this, "E_JSON_PARSE");
          }
          throw e;
        }
      }
    }
    return data2;
  }],
  timeout: 0,
  xsrfCookieName: "XSRF-TOKEN",
  xsrfHeaderName: "X-XSRF-TOKEN",
  maxContentLength: -1,
  maxBodyLength: -1,
  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  },
  headers: {
    common: {
      "Accept": "application/json, text/plain, */*"
    }
  }
};
utils$5.forEach(["delete", "get", "head"], function forEachMethodNoData(method) {
  defaults$3.headers[method] = {};
});
utils$5.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
  defaults$3.headers[method] = utils$5.merge(DEFAULT_CONTENT_TYPE);
});
var defaults_1 = defaults$3;
var utils$4 = utils$d;
var defaults$2 = defaults_1;
var transformData$1 = function transformData(data2, headers, fns) {
  var context = this || defaults$2;
  utils$4.forEach(fns, function transform(fn) {
    data2 = fn.call(context, data2, headers);
  });
  return data2;
};
var isCancel$1 = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};
var utils$3 = utils$d;
var transformData2 = transformData$1;
var isCancel2 = isCancel$1;
var defaults$1 = defaults_1;
var Cancel$1 = Cancel_1;
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
  if (config.signal && config.signal.aborted) {
    throw new Cancel$1("canceled");
  }
}
var dispatchRequest$1 = function dispatchRequest(config) {
  throwIfCancellationRequested(config);
  config.headers = config.headers || {};
  config.data = transformData2.call(config, config.data, config.headers, config.transformRequest);
  config.headers = utils$3.merge(config.headers.common || {}, config.headers[config.method] || {}, config.headers);
  utils$3.forEach(["delete", "get", "head", "post", "put", "patch", "common"], function cleanHeaderConfig(method) {
    delete config.headers[method];
  });
  var adapter = config.adapter || defaults$1.adapter;
  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);
    response.data = transformData2.call(config, response.data, response.headers, config.transformResponse);
    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel2(reason)) {
      throwIfCancellationRequested(config);
      if (reason && reason.response) {
        reason.response.data = transformData2.call(config, reason.response.data, reason.response.headers, config.transformResponse);
      }
    }
    return Promise.reject(reason);
  });
};
var utils$2 = utils$d;
var mergeConfig$2 = function mergeConfig(config1, config2) {
  config2 = config2 || {};
  var config = {};
  function getMergedValue(target, source2) {
    if (utils$2.isPlainObject(target) && utils$2.isPlainObject(source2)) {
      return utils$2.merge(target, source2);
    } else if (utils$2.isPlainObject(source2)) {
      return utils$2.merge({}, source2);
    } else if (utils$2.isArray(source2)) {
      return source2.slice();
    }
    return source2;
  }
  function mergeDeepProperties(prop) {
    if (!utils$2.isUndefined(config2[prop])) {
      return getMergedValue(config1[prop], config2[prop]);
    } else if (!utils$2.isUndefined(config1[prop])) {
      return getMergedValue(void 0, config1[prop]);
    }
  }
  function valueFromConfig2(prop) {
    if (!utils$2.isUndefined(config2[prop])) {
      return getMergedValue(void 0, config2[prop]);
    }
  }
  function defaultToConfig2(prop) {
    if (!utils$2.isUndefined(config2[prop])) {
      return getMergedValue(void 0, config2[prop]);
    } else if (!utils$2.isUndefined(config1[prop])) {
      return getMergedValue(void 0, config1[prop]);
    }
  }
  function mergeDirectKeys(prop) {
    if (prop in config2) {
      return getMergedValue(config1[prop], config2[prop]);
    } else if (prop in config1) {
      return getMergedValue(void 0, config1[prop]);
    }
  }
  var mergeMap = {
    "url": valueFromConfig2,
    "method": valueFromConfig2,
    "data": valueFromConfig2,
    "baseURL": defaultToConfig2,
    "transformRequest": defaultToConfig2,
    "transformResponse": defaultToConfig2,
    "paramsSerializer": defaultToConfig2,
    "timeout": defaultToConfig2,
    "timeoutMessage": defaultToConfig2,
    "withCredentials": defaultToConfig2,
    "adapter": defaultToConfig2,
    "responseType": defaultToConfig2,
    "xsrfCookieName": defaultToConfig2,
    "xsrfHeaderName": defaultToConfig2,
    "onUploadProgress": defaultToConfig2,
    "onDownloadProgress": defaultToConfig2,
    "decompress": defaultToConfig2,
    "maxContentLength": defaultToConfig2,
    "maxBodyLength": defaultToConfig2,
    "transport": defaultToConfig2,
    "httpAgent": defaultToConfig2,
    "httpsAgent": defaultToConfig2,
    "cancelToken": defaultToConfig2,
    "socketPath": defaultToConfig2,
    "responseEncoding": defaultToConfig2,
    "validateStatus": mergeDirectKeys
  };
  utils$2.forEach(Object.keys(config1).concat(Object.keys(config2)), function computeConfigValue(prop) {
    var merge2 = mergeMap[prop] || mergeDeepProperties;
    var configValue = merge2(prop);
    utils$2.isUndefined(configValue) && merge2 !== mergeDirectKeys || (config[prop] = configValue);
  });
  return config;
};
var data = {
  "version": "0.22.0"
};
var VERSION = data.version;
var validators$1 = {};
["object", "boolean", "number", "function", "string", "symbol"].forEach(function(type, i) {
  validators$1[type] = function validator2(thing) {
    return typeof thing === type || "a" + (i < 1 ? "n " : " ") + type;
  };
});
var deprecatedWarnings = {};
validators$1.transitional = function transitional(validator2, version2, message) {
  function formatMessage(opt, desc) {
    return "[Axios v" + VERSION + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
  }
  return function(value, opt, opts) {
    if (validator2 === false) {
      throw new Error(formatMessage(opt, " has been removed" + (version2 ? " in " + version2 : "")));
    }
    if (version2 && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      console.warn(formatMessage(opt, " has been deprecated since v" + version2 + " and will be removed in the near future"));
    }
    return validator2 ? validator2(value, opt, opts) : true;
  };
};
function assertOptions(options, schema, allowUnknown) {
  if (typeof options !== "object") {
    throw new TypeError("options must be an object");
  }
  var keys = Object.keys(options);
  var i = keys.length;
  while (i-- > 0) {
    var opt = keys[i];
    var validator2 = schema[opt];
    if (validator2) {
      var value = options[opt];
      var result = value === void 0 || validator2(value, opt, options);
      if (result !== true) {
        throw new TypeError("option " + opt + " must be " + result);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw Error("Unknown option " + opt);
    }
  }
}
var validator$1 = {
  assertOptions,
  validators: validators$1
};
var utils$1 = utils$d;
var buildURL2 = buildURL$2;
var InterceptorManager = InterceptorManager_1;
var dispatchRequest2 = dispatchRequest$1;
var mergeConfig$1 = mergeConfig$2;
var validator = validator$1;
var validators = validator.validators;
function Axios$1(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}
Axios$1.prototype.request = function request(config) {
  if (typeof config === "string") {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }
  config = mergeConfig$1(this.defaults, config);
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = "get";
  }
  var transitional2 = config.transitional;
  if (transitional2 !== void 0) {
    validator.assertOptions(transitional2, {
      silentJSONParsing: validators.transitional(validators.boolean),
      forcedJSONParsing: validators.transitional(validators.boolean),
      clarifyTimeoutError: validators.transitional(validators.boolean)
    }, false);
  }
  var requestInterceptorChain = [];
  var synchronousRequestInterceptors = true;
  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config) === false) {
      return;
    }
    synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
    requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
  });
  var responseInterceptorChain = [];
  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
  });
  var promise;
  if (!synchronousRequestInterceptors) {
    var chain = [dispatchRequest2, void 0];
    Array.prototype.unshift.apply(chain, requestInterceptorChain);
    chain = chain.concat(responseInterceptorChain);
    promise = Promise.resolve(config);
    while (chain.length) {
      promise = promise.then(chain.shift(), chain.shift());
    }
    return promise;
  }
  var newConfig = config;
  while (requestInterceptorChain.length) {
    var onFulfilled = requestInterceptorChain.shift();
    var onRejected = requestInterceptorChain.shift();
    try {
      newConfig = onFulfilled(newConfig);
    } catch (error) {
      onRejected(error);
      break;
    }
  }
  try {
    promise = dispatchRequest2(newConfig);
  } catch (error) {
    return Promise.reject(error);
  }
  while (responseInterceptorChain.length) {
    promise = promise.then(responseInterceptorChain.shift(), responseInterceptorChain.shift());
  }
  return promise;
};
Axios$1.prototype.getUri = function getUri(config) {
  config = mergeConfig$1(this.defaults, config);
  return buildURL2(config.url, config.params, config.paramsSerializer).replace(/^\?/, "");
};
utils$1.forEach(["delete", "get", "head", "options"], function forEachMethodNoData2(method) {
  Axios$1.prototype[method] = function(url, config) {
    return this.request(mergeConfig$1(config || {}, {
      method,
      url,
      data: (config || {}).data
    }));
  };
});
utils$1.forEach(["post", "put", "patch"], function forEachMethodWithData2(method) {
  Axios$1.prototype[method] = function(url, data2, config) {
    return this.request(mergeConfig$1(config || {}, {
      method,
      url,
      data: data2
    }));
  };
});
var Axios_1 = Axios$1;
var Cancel = Cancel_1;
function CancelToken(executor) {
  if (typeof executor !== "function") {
    throw new TypeError("executor must be a function.");
  }
  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve2) {
    resolvePromise = resolve2;
  });
  var token = this;
  this.promise.then(function(cancel) {
    if (!token._listeners)
      return;
    var i;
    var l = token._listeners.length;
    for (i = 0; i < l; i++) {
      token._listeners[i](cancel);
    }
    token._listeners = null;
  });
  this.promise.then = function(onfulfilled) {
    var _resolve;
    var promise = new Promise(function(resolve2) {
      token.subscribe(resolve2);
      _resolve = resolve2;
    }).then(onfulfilled);
    promise.cancel = function reject() {
      token.unsubscribe(_resolve);
    };
    return promise;
  };
  executor(function cancel(message) {
    if (token.reason) {
      return;
    }
    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};
CancelToken.prototype.subscribe = function subscribe(listener) {
  if (this.reason) {
    listener(this.reason);
    return;
  }
  if (this._listeners) {
    this._listeners.push(listener);
  } else {
    this._listeners = [listener];
  }
};
CancelToken.prototype.unsubscribe = function unsubscribe(listener) {
  if (!this._listeners) {
    return;
  }
  var index = this._listeners.indexOf(listener);
  if (index !== -1) {
    this._listeners.splice(index, 1);
  }
};
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token,
    cancel
  };
};
var CancelToken_1 = CancelToken;
var spread = function spread2(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};
var isAxiosError = function isAxiosError2(payload) {
  return typeof payload === "object" && payload.isAxiosError === true;
};
var utils = utils$d;
var bind2 = bind$2;
var Axios = Axios_1;
var mergeConfig2 = mergeConfig$2;
var defaults = defaults_1;
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind2(Axios.prototype.request, context);
  utils.extend(instance, Axios.prototype, context);
  utils.extend(instance, context);
  instance.create = function create(instanceConfig) {
    return createInstance(mergeConfig2(defaultConfig, instanceConfig));
  };
  return instance;
}
var axios$1 = createInstance(defaults);
axios$1.Axios = Axios;
axios$1.Cancel = Cancel_1;
axios$1.CancelToken = CancelToken_1;
axios$1.isCancel = isCancel$1;
axios$1.VERSION = data.version;
axios$1.all = function all(promises) {
  return Promise.all(promises);
};
axios$1.spread = spread;
axios$1.isAxiosError = isAxiosError;
axios$2.exports = axios$1;
axios$2.exports.default = axios$1;
var axios = axios$2.exports;
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
var __assign = function() {
  __assign = Object.assign || function __assign2(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p2 in s)
        if (Object.prototype.hasOwnProperty.call(s, p2))
          t[p2] = s[p2];
    }
    return t;
  };
  return __assign.apply(this, arguments);
};
var NotyfNotification = function() {
  function NotyfNotification2(options) {
    this.options = options;
    this.listeners = {};
  }
  NotyfNotification2.prototype.on = function(eventType, cb) {
    var callbacks = this.listeners[eventType] || [];
    this.listeners[eventType] = callbacks.concat([cb]);
  };
  NotyfNotification2.prototype.triggerEvent = function(eventType, event) {
    var _this = this;
    var callbacks = this.listeners[eventType] || [];
    callbacks.forEach(function(cb) {
      return cb({ target: _this, event });
    });
  };
  return NotyfNotification2;
}();
var NotyfArrayEvent;
(function(NotyfArrayEvent2) {
  NotyfArrayEvent2[NotyfArrayEvent2["Add"] = 0] = "Add";
  NotyfArrayEvent2[NotyfArrayEvent2["Remove"] = 1] = "Remove";
})(NotyfArrayEvent || (NotyfArrayEvent = {}));
var NotyfArray = function() {
  function NotyfArray2() {
    this.notifications = [];
  }
  NotyfArray2.prototype.push = function(elem) {
    this.notifications.push(elem);
    this.updateFn(elem, NotyfArrayEvent.Add, this.notifications);
  };
  NotyfArray2.prototype.splice = function(index, num) {
    var elem = this.notifications.splice(index, num)[0];
    this.updateFn(elem, NotyfArrayEvent.Remove, this.notifications);
    return elem;
  };
  NotyfArray2.prototype.indexOf = function(elem) {
    return this.notifications.indexOf(elem);
  };
  NotyfArray2.prototype.onUpdate = function(fn) {
    this.updateFn = fn;
  };
  return NotyfArray2;
}();
var NotyfEvent;
(function(NotyfEvent2) {
  NotyfEvent2["Dismiss"] = "dismiss";
  NotyfEvent2["Click"] = "click";
})(NotyfEvent || (NotyfEvent = {}));
var DEFAULT_OPTIONS = {
  types: [
    {
      type: "success",
      className: "notyf__toast--success",
      backgroundColor: "#3dc763",
      icon: {
        className: "notyf__icon--success",
        tagName: "i"
      }
    },
    {
      type: "error",
      className: "notyf__toast--error",
      backgroundColor: "#ed3d3d",
      icon: {
        className: "notyf__icon--error",
        tagName: "i"
      }
    }
  ],
  duration: 2e3,
  ripple: true,
  position: {
    x: "right",
    y: "bottom"
  },
  dismissible: false
};
var NotyfView = function() {
  function NotyfView2() {
    this.notifications = [];
    this.events = {};
    this.X_POSITION_FLEX_MAP = {
      left: "flex-start",
      center: "center",
      right: "flex-end"
    };
    this.Y_POSITION_FLEX_MAP = {
      top: "flex-start",
      center: "center",
      bottom: "flex-end"
    };
    var docFrag = document.createDocumentFragment();
    var notyfContainer = this._createHTMLElement({ tagName: "div", className: "notyf" });
    docFrag.appendChild(notyfContainer);
    document.body.appendChild(docFrag);
    this.container = notyfContainer;
    this.animationEndEventName = this._getAnimationEndEventName();
    this._createA11yContainer();
  }
  NotyfView2.prototype.on = function(event, cb) {
    var _a;
    this.events = __assign(__assign({}, this.events), (_a = {}, _a[event] = cb, _a));
  };
  NotyfView2.prototype.update = function(notification, type) {
    if (type === NotyfArrayEvent.Add) {
      this.addNotification(notification);
    } else if (type === NotyfArrayEvent.Remove) {
      this.removeNotification(notification);
    }
  };
  NotyfView2.prototype.removeNotification = function(notification) {
    var _this = this;
    var renderedNotification = this._popRenderedNotification(notification);
    var node;
    if (!renderedNotification) {
      return;
    }
    node = renderedNotification.node;
    node.classList.add("notyf__toast--disappear");
    var handleEvent;
    node.addEventListener(this.animationEndEventName, handleEvent = function(event) {
      if (event.target === node) {
        node.removeEventListener(_this.animationEndEventName, handleEvent);
        _this.container.removeChild(node);
      }
    });
  };
  NotyfView2.prototype.addNotification = function(notification) {
    var node = this._renderNotification(notification);
    this.notifications.push({ notification, node });
    this._announce(notification.options.message || "Notification");
  };
  NotyfView2.prototype._renderNotification = function(notification) {
    var _a;
    var card = this._buildNotificationCard(notification);
    var className = notification.options.className;
    if (className) {
      (_a = card.classList).add.apply(_a, className.split(" "));
    }
    this.container.appendChild(card);
    return card;
  };
  NotyfView2.prototype._popRenderedNotification = function(notification) {
    var idx = -1;
    for (var i = 0; i < this.notifications.length && idx < 0; i++) {
      if (this.notifications[i].notification === notification) {
        idx = i;
      }
    }
    if (idx !== -1) {
      return this.notifications.splice(idx, 1)[0];
    }
    return;
  };
  NotyfView2.prototype.getXPosition = function(options) {
    var _a;
    return ((_a = options === null || options === void 0 ? void 0 : options.position) === null || _a === void 0 ? void 0 : _a.x) || "right";
  };
  NotyfView2.prototype.getYPosition = function(options) {
    var _a;
    return ((_a = options === null || options === void 0 ? void 0 : options.position) === null || _a === void 0 ? void 0 : _a.y) || "bottom";
  };
  NotyfView2.prototype.adjustContainerAlignment = function(options) {
    var align = this.X_POSITION_FLEX_MAP[this.getXPosition(options)];
    var justify = this.Y_POSITION_FLEX_MAP[this.getYPosition(options)];
    var style = this.container.style;
    style.setProperty("justify-content", justify);
    style.setProperty("align-items", align);
  };
  NotyfView2.prototype._buildNotificationCard = function(notification) {
    var _this = this;
    var options = notification.options;
    var iconOpts = options.icon;
    this.adjustContainerAlignment(options);
    var notificationElem = this._createHTMLElement({ tagName: "div", className: "notyf__toast" });
    var ripple = this._createHTMLElement({ tagName: "div", className: "notyf__ripple" });
    var wrapper = this._createHTMLElement({ tagName: "div", className: "notyf__wrapper" });
    var message = this._createHTMLElement({ tagName: "div", className: "notyf__message" });
    message.innerHTML = options.message || "";
    var mainColor = options.background || options.backgroundColor;
    if (iconOpts) {
      var iconContainer = this._createHTMLElement({ tagName: "div", className: "notyf__icon" });
      if (typeof iconOpts === "string" || iconOpts instanceof String)
        iconContainer.innerHTML = new String(iconOpts).valueOf();
      if (typeof iconOpts === "object") {
        var _a = iconOpts.tagName, tagName = _a === void 0 ? "i" : _a, className_1 = iconOpts.className, text = iconOpts.text, _b = iconOpts.color, color = _b === void 0 ? mainColor : _b;
        var iconElement = this._createHTMLElement({ tagName, className: className_1, text });
        if (color)
          iconElement.style.color = color;
        iconContainer.appendChild(iconElement);
      }
      wrapper.appendChild(iconContainer);
    }
    wrapper.appendChild(message);
    notificationElem.appendChild(wrapper);
    if (mainColor) {
      if (options.ripple) {
        ripple.style.background = mainColor;
        notificationElem.appendChild(ripple);
      } else {
        notificationElem.style.background = mainColor;
      }
    }
    if (options.dismissible) {
      var dismissWrapper = this._createHTMLElement({ tagName: "div", className: "notyf__dismiss" });
      var dismissButton = this._createHTMLElement({
        tagName: "button",
        className: "notyf__dismiss-btn"
      });
      dismissWrapper.appendChild(dismissButton);
      wrapper.appendChild(dismissWrapper);
      notificationElem.classList.add("notyf__toast--dismissible");
      dismissButton.addEventListener("click", function(event) {
        var _a2, _b2;
        (_b2 = (_a2 = _this.events)[NotyfEvent.Dismiss]) === null || _b2 === void 0 ? void 0 : _b2.call(_a2, { target: notification, event });
        event.stopPropagation();
      });
    }
    notificationElem.addEventListener("click", function(event) {
      var _a2, _b2;
      return (_b2 = (_a2 = _this.events)[NotyfEvent.Click]) === null || _b2 === void 0 ? void 0 : _b2.call(_a2, { target: notification, event });
    });
    var className = this.getYPosition(options) === "top" ? "upper" : "lower";
    notificationElem.classList.add("notyf__toast--" + className);
    return notificationElem;
  };
  NotyfView2.prototype._createHTMLElement = function(_a) {
    var tagName = _a.tagName, className = _a.className, text = _a.text;
    var elem = document.createElement(tagName);
    if (className) {
      elem.className = className;
    }
    elem.textContent = text || null;
    return elem;
  };
  NotyfView2.prototype._createA11yContainer = function() {
    var a11yContainer = this._createHTMLElement({ tagName: "div", className: "notyf-announcer" });
    a11yContainer.setAttribute("aria-atomic", "true");
    a11yContainer.setAttribute("aria-live", "polite");
    a11yContainer.style.border = "0";
    a11yContainer.style.clip = "rect(0 0 0 0)";
    a11yContainer.style.height = "1px";
    a11yContainer.style.margin = "-1px";
    a11yContainer.style.overflow = "hidden";
    a11yContainer.style.padding = "0";
    a11yContainer.style.position = "absolute";
    a11yContainer.style.width = "1px";
    a11yContainer.style.outline = "0";
    document.body.appendChild(a11yContainer);
    this.a11yContainer = a11yContainer;
  };
  NotyfView2.prototype._announce = function(message) {
    var _this = this;
    this.a11yContainer.textContent = "";
    setTimeout(function() {
      _this.a11yContainer.textContent = message;
    }, 100);
  };
  NotyfView2.prototype._getAnimationEndEventName = function() {
    var el = document.createElement("_fake");
    var transitions = {
      MozTransition: "animationend",
      OTransition: "oAnimationEnd",
      WebkitTransition: "webkitAnimationEnd",
      transition: "animationend"
    };
    var t;
    for (t in transitions) {
      if (el.style[t] !== void 0) {
        return transitions[t];
      }
    }
    return "animationend";
  };
  return NotyfView2;
}();
var Notyf = function() {
  function Notyf2(opts) {
    var _this = this;
    this.dismiss = this._removeNotification;
    this.notifications = new NotyfArray();
    this.view = new NotyfView();
    var types = this.registerTypes(opts);
    this.options = __assign(__assign({}, DEFAULT_OPTIONS), opts);
    this.options.types = types;
    this.notifications.onUpdate(function(elem, type) {
      return _this.view.update(elem, type);
    });
    this.view.on(NotyfEvent.Dismiss, function(_a) {
      var target = _a.target, event = _a.event;
      _this._removeNotification(target);
      target["triggerEvent"](NotyfEvent.Dismiss, event);
    });
    this.view.on(NotyfEvent.Click, function(_a) {
      var target = _a.target, event = _a.event;
      return target["triggerEvent"](NotyfEvent.Click, event);
    });
  }
  Notyf2.prototype.error = function(payload) {
    var options = this.normalizeOptions("error", payload);
    return this.open(options);
  };
  Notyf2.prototype.success = function(payload) {
    var options = this.normalizeOptions("success", payload);
    return this.open(options);
  };
  Notyf2.prototype.open = function(options) {
    var defaultOpts = this.options.types.find(function(_a) {
      var type = _a.type;
      return type === options.type;
    }) || {};
    var config = __assign(__assign({}, defaultOpts), options);
    this.assignProps(["ripple", "position", "dismissible"], config);
    var notification = new NotyfNotification(config);
    this._pushNotification(notification);
    return notification;
  };
  Notyf2.prototype.dismissAll = function() {
    while (this.notifications.splice(0, 1))
      ;
  };
  Notyf2.prototype.assignProps = function(props, config) {
    var _this = this;
    props.forEach(function(prop) {
      config[prop] = config[prop] == null ? _this.options[prop] : config[prop];
    });
  };
  Notyf2.prototype._pushNotification = function(notification) {
    var _this = this;
    this.notifications.push(notification);
    var duration = notification.options.duration !== void 0 ? notification.options.duration : this.options.duration;
    if (duration) {
      setTimeout(function() {
        return _this._removeNotification(notification);
      }, duration);
    }
  };
  Notyf2.prototype._removeNotification = function(notification) {
    var index = this.notifications.indexOf(notification);
    if (index !== -1) {
      this.notifications.splice(index, 1);
    }
  };
  Notyf2.prototype.normalizeOptions = function(type, payload) {
    var options = { type };
    if (typeof payload === "string") {
      options.message = payload;
    } else if (typeof payload === "object") {
      options = __assign(__assign({}, options), payload);
    }
    return options;
  };
  Notyf2.prototype.registerTypes = function(opts) {
    var incomingTypes = (opts && opts.types || []).slice();
    var finalDefaultTypes = DEFAULT_OPTIONS.types.map(function(defaultType) {
      var userTypeIdx = -1;
      incomingTypes.forEach(function(t, idx) {
        if (t.type === defaultType.type)
          userTypeIdx = idx;
      });
      var userType = userTypeIdx !== -1 ? incomingTypes.splice(userTypeIdx, 1)[0] : {};
      return __assign(__assign({}, defaultType), userType);
    });
    return finalDefaultTypes.concat(incomingTypes);
  };
  return Notyf2;
}();
export { mergeProps as $, createTextVNode as A, toDisplayString$1 as B, renderSlot as C, defineStore as D, useHead as E, Fragment as F, onMounted as G, createBlock as H, createRouter as I, createWebHistory as J, nprogress as K, axios as L, Module as M, provide as N, Notyf as O, createHead as P, createPinia as Q, RouterLink as R, createApp as S, RouterView as T, UIkit as U, VueScrollTo as V, resolveDynamicComponent as W, Transition as X, reactive as Y, renderList as Z, createCommentVNode as _, useRouter as a, pushScopeId as a0, popScopeId as a1, withScopeId as a2, toRefs as a3, watch as a4, nextTick as a5, onUnmounted as a6, isReactive as a7, getCurrentInstance as a8, isVNode as a9, render as aa, toHandlers as ab, onClickOutside as ac, normalizeProps as ad, guardReactiveProps as ae, useRoute as af, vModelText as ag, useI18n as ah, Teleport as ai, toRef as aj, inject as ak, onBeforeUnmount as al, warn$1 as am, readonly as an, markRaw as ao, commonjsGlobal as ap, vModelSelect as aq, resolveDirective as ar, defineAsyncComponent as as, watchPostEffect as at, getAugmentedNamespace as au, TransitionGroup as av, createSlots as aw, vShow as ax, _defineProperty as ay, createElementBlock as b, createI18n as c, defineComponent as d, createStaticVNode as e, useCssVars as f, normalizeStyle as g, computed as h, h as i, useMediaQuery as j, usePreferredDark as k, useWindowScroll as l, resolveComponent as m, normalizeClass as n, openBlock as o, createBaseVNode as p, withModifiers as q, ref as r, unref as s, createVNode as t, useStorage as u, withCtx as v, watchEffect as w, withDirectives as x, vModelCheckbox as y, isRef as z };
