import { d as defineComponent, a as useRouter, r as ref, o as openBlock, b as createElementBlock, af as useRoute, Y as reactive, E as useHead, G as onMounted, m as resolveComponent, p as createBaseVNode, t as createVNode, v as withCtx, F as Fragment, Z as renderList, H as createBlock, n as normalizeClass, B as toDisplayString, q as withModifiers, x as withDirectives, ag as vModelText, s as unref, A as createTextVNode, L as axios } from "./vendor.55da2271.js";
import { _ as _export_sfc, u as useUserSession, p as provideApi, N as NAME_ROUTE_POS, R as ROLES, b as _sfc_main$4, c as useNotyf } from "./index.6cd1bdc5.js";
import { _ as __unplugin_components_1 } from "./VControl.901448b0.js";
import { _ as _sfc_main$2 } from "./VField.b2ff2f2a.js";
import { _ as _sfc_main$3 } from "./VModal.12b66599.js";
import { M as MasterService } from "./masterService.3aad9dac.js";
import { u as useCompanySession, a as use } from "./mesaService.03478fb3.js";
var _imports_0$1 = "/isotipo-oficial.png";
var AnimatedLogo_vue_vue_type_style_index_0_scoped_true_lang = "";
const _hoisted_1$1 = {
  src: _imports_0$1,
  alt: "logo"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  props: {
    light: { type: Boolean, required: false }
  },
  setup(__props) {
    const router = useRouter();
    const isLoading = ref(false);
    router.beforeEach(() => {
      isLoading.value = true;
    });
    router.afterEach(() => {
      setTimeout(() => {
        isLoading.value = false;
      }, 200);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("img", _hoisted_1$1);
    };
  }
});
var __unplugin_components_0 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-427b10f0"]]);
var _imports_0 = "/assets/img-mozo.8146fe24.png";
var mozo_vue_vue_type_style_index_0_lang = "";
const _hoisted_1 = { class: "auth-wrapper-inner is-single" };
const _hoisted_2 = { class: "auth-nav" };
const _hoisted_3 = /* @__PURE__ */ createBaseVNode("div", { class: "left" }, null, -1);
const _hoisted_4 = { class: "center" };
const _hoisted_5 = /* @__PURE__ */ createBaseVNode("div", { class: "right" }, null, -1);
const _hoisted_6 = { class: "saas-billing-wrapper" };
const _hoisted_7 = { class: "plans-wrapper" };
const _hoisted_8 = { class: "left" };
const _hoisted_9 = { class: "inner-wrap" };
const _hoisted_10 = { class: "meta" };
const _hoisted_11 = { class: "columns is-multiline is-mobile" };
const _hoisted_12 = { class: "column is-12" };
const _hoisted_13 = { class: "single-form-wrap is-relative" };
const _hoisted_14 = { class: "inner-wrap" };
const _hoisted_15 = { class: "form-card" };
const _hoisted_16 = ["onSubmit"];
const _hoisted_17 = { class: "login-form" };
const _hoisted_18 = /* @__PURE__ */ createTextVNode(" Ingresar ");
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const isLoading = ref(false);
    const router = useRouter();
    const route = useRoute();
    const notif = useNotyf();
    const userSession = useUserSession();
    const companySession = useCompanySession();
    const redirect = route.query.redirect;
    const waiters = ref([]);
    const selectedWaiterEmail = ref("");
    const dialogPinAvailable = ref(false);
    const modalTitle = ref("Bienvenido");
    const user = reactive({
      email: "",
      password: "",
      domain: "",
      ssl: "https://"
    });
    if (userSession.url) {
      user.domain = userSession.url;
    }
    if (userSession.email) {
      user.email = userSession.email;
    }
    if (userSession.pwd && userSession.getRole() == "MOZO") {
      user.password = userSession.pwd;
    }
    const handleLogin = async () => {
      try {
        user.email = selectedWaiterEmail.value;
        isLoading.value = true;
        notif.sync(`Sincronizando informaci\xF3n`);
        const response = await axios.post(`${user.ssl + user.domain}/api/login`, user);
        if (response.data.success) {
          const {
            email,
            logo,
            name,
            ruc,
            restaurant_role_code,
            establishment_id,
            seriedefault,
            success,
            token,
            company,
            sellerId
          } = response.data;
          const dataUser = {
            email,
            logo,
            name,
            ruc,
            restaurant_role_code,
            establishment_id,
            seriedefault,
            success,
            token,
            sellerId
          };
          userSession.setToken(dataUser.token);
          userSession.setEmail(dataUser.email);
          userSession.setName(dataUser.name);
          userSession.setUrl(user.domain);
          userSession.setPwd(user.password);
          userSession.setSsl(user.ssl);
          userSession.setEstablishmentId(dataUser.establishment_id);
          userSession.setIsBlockedPin(0);
          if (dataUser.sellerId) {
            userSession.setSellerId(dataUser.sellerId);
            userSession.setSellerName(dataUser.name);
          }
          if (dataUser.restaurant_role_code) {
            userSession.setRole(dataUser.restaurant_role_code);
          } else {
            userSession.setRole("NOTHING");
          }
          if (company) {
            userSession.setUrlLogo(company.url_logo);
            userSession.setLogoBase64(company.logo_base64);
          }
          use.connect();
          use.sendCompany();
          await MasterService.syncData();
          notif.dismissAll();
          notif.success(`Bienvenido, ${dataUser.name}`);
          let role = {
            id: 0,
            name: "POS",
            code: "POS",
            menu: NAME_ROUTE_POS
          };
          role = ROLES.find((role2) => role2.code === dataUser.restaurant_role_code);
          if (redirect) {
            router.push(redirect);
          } else if (dataUser.restaurant_role_code && role.code != "ADM") {
            router.push({
              name: role.menu
            });
          } else {
            router.push({
              name: companySession.firstMenu
            });
          }
        } else {
          notif.dismissAll();
          notif.error("Datos de usuario incorrectos.");
        }
      } catch (error) {
        notif.error("Ocurri\xF3 un error al ingresar.");
      } finally {
        isLoading.value = false;
      }
    };
    const getListWaiter = async () => {
      try {
        const response = await provideApi().get(`/restaurant/list-waiter`);
        const data = response.data;
        if (data.success && data.data.length > 0) {
          waiters.value = data.data;
        }
      } catch (error) {
        console.error("Error data:", error);
      }
    };
    const selectWaiter = (email, name) => {
      selectedWaiterEmail.value = email;
      modalTitle.value = `Bienvenido ${name}`;
      user.password = "";
      dialogPinAvailable.value = true;
    };
    useHead({
      title: "Ingreso - Mozo.pe"
    });
    onMounted(async () => {
      const url = userSession.url;
      if (url) {
        user.domain = url;
      }
      getListWaiter();
    });
    return (_ctx, _cache) => {
      const _component_LandingGrids = resolveComponent("LandingGrids");
      const _component_AnimatedLogo = __unplugin_components_0;
      const _component_RouterLink = resolveComponent("RouterLink");
      const _component_VLabel = resolveComponent("VLabel");
      const _component_VControl = __unplugin_components_1;
      const _component_VField = _sfc_main$2;
      const _component_VButton = _sfc_main$4;
      const _component_VModal = _sfc_main$3;
      return openBlock(), createElementBlock(Fragment, null, [
        createBaseVNode("div", _hoisted_1, [
          createVNode(_component_LandingGrids, { class: "is-contrasted" }),
          createBaseVNode("div", _hoisted_2, [
            _hoisted_3,
            createBaseVNode("div", _hoisted_4, [
              createVNode(_component_RouterLink, {
                to: "/",
                class: "header-item"
              }, {
                default: withCtx(() => [
                  createVNode(_component_AnimatedLogo, {
                    width: "38px",
                    height: "38px"
                  })
                ]),
                _: 1
              })
            ]),
            _hoisted_5
          ]),
          createBaseVNode("div", _hoisted_6, [
            createBaseVNode("div", _hoisted_7, [
              createBaseVNode("div", _hoisted_8, [
                createBaseVNode("div", _hoisted_9, [
                  createVNode(_component_VField, { class: "plans" }, {
                    default: withCtx(() => [
                      (openBlock(true), createElementBlock(Fragment, null, renderList(waiters.value, (waiter) => {
                        return openBlock(), createBlock(_component_VControl, {
                          key: waiter.email,
                          class: normalizeClass(["plan column is-4", { selected: selectedWaiterEmail.value === waiter.email }]),
                          subcontrol: "",
                          onClick: ($event) => selectWaiter(waiter.email, waiter.name),
                          style: { "cursor": "pointer" }
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_VLabel, {
                              raw: "",
                              class: normalizeClass(["plan-inner", { selected: selectedWaiterEmail.value === waiter.email }]),
                              onClick: ($event) => selectedWaiterEmail.value = waiter.email
                            }, {
                              default: withCtx(() => [
                                createBaseVNode("img", {
                                  src: _imports_0,
                                  alt: "",
                                  class: normalizeClass({ colored: selectedWaiterEmail.value === waiter.email })
                                }, null, 2),
                                createBaseVNode("div", _hoisted_10, [
                                  createBaseVNode("span", null, toDisplayString(waiter.name), 1)
                                ])
                              ]),
                              _: 2
                            }, 1032, ["class", "onClick"])
                          ]),
                          _: 2
                        }, 1032, ["onClick", "class"]);
                      }), 128))
                    ]),
                    _: 1
                  })
                ])
              ])
            ])
          ])
        ]),
        createVNode(_component_VModal, {
          open: dialogPinAvailable.value,
          title: modalTitle.value,
          size: "small",
          actions: "center",
          "cancel-label": "Cerrar",
          onClose: _cache[1] || (_cache[1] = ($event) => dialogPinAvailable.value = false)
        }, {
          content: withCtx(() => [
            createBaseVNode("div", _hoisted_11, [
              createBaseVNode("div", _hoisted_12, [
                createBaseVNode("div", _hoisted_13, [
                  createBaseVNode("div", _hoisted_14, [
                    createBaseVNode("div", _hoisted_15, [
                      createBaseVNode("form", {
                        method: "post",
                        novalidate: "",
                        onSubmit: withModifiers(handleLogin, ["prevent"])
                      }, [
                        createBaseVNode("div", _hoisted_17, [
                          createVNode(_component_VField, null, {
                            default: withCtx(() => [
                              createVNode(_component_VControl, { icon: "feather:lock" }, {
                                default: withCtx(() => [
                                  withDirectives(createBaseVNode("input", {
                                    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => unref(user).password = $event),
                                    class: "input",
                                    type: "password",
                                    placeholder: "Pin",
                                    autocomplete: "current-password",
                                    maxlength: "4"
                                  }, null, 512), [
                                    [vModelText, unref(user).password]
                                  ])
                                ]),
                                _: 1
                              })
                            ]),
                            _: 1
                          }),
                          createVNode(_component_VControl, { class: "login" }, {
                            default: withCtx(() => [
                              createVNode(_component_VButton, {
                                loading: isLoading.value,
                                color: "primary",
                                type: "submit",
                                bold: "",
                                fullwidth: "",
                                raised: ""
                              }, {
                                default: withCtx(() => [
                                  _hoisted_18
                                ]),
                                _: 1
                              }, 8, ["loading"])
                            ]),
                            _: 1
                          })
                        ])
                      ], 40, _hoisted_16)
                    ])
                  ])
                ])
              ])
            ])
          ]),
          _: 1
        }, 8, ["open", "title"])
      ], 64);
    };
  }
});
export { _sfc_main as default };
