var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
import { u as useUserSession, p as provideApi } from "./index.3ef89e82.js";
import { u as useCompanySession, S as STATUS_NEW, M as MesaService } from "./mesaService.8e343c4f.js";
import { G as defineStore, u as useStorage } from "./vendor.48417147.js";
const useProductSession = defineStore("productSession", () => {
  const defaultProductsData = [];
  const products = useStorage("products", defaultProductsData);
  const defaultCategoriesData = [
    {
      id: 0,
      name: "Todos",
      selected: true
    }
  ];
  const categories = useStorage("categories", defaultCategoriesData);
  function setProducts(data) {
    products.value = data;
  }
  function setCategories(data) {
    categories.value = data;
    categories.value.unshift({
      id: 0,
      name: "Todos",
      selected: true
    });
  }
  const getProducts = () => {
    return products.value;
  };
  return {
    products,
    setProducts,
    categories,
    setCategories,
    getProducts
  };
});
const userSession = useUserSession();
const companySession = useCompanySession();
const productSession = useProductSession();
const saveDataCompany = async () => {
  const { data } = await provideApi().get(`${userSession.ssl + userSession.url}/api/company`);
  companySession.setCompany(data.company);
  companySession.setEstablishments(data.establishments);
  companySession.setSeries(data.series);
  companySession.setCustomers(data.customers);
  companySession.savePaymentMethods(data.payment_method_types);
  companySession.savePaymentDestinations(data.payment_destinations);
};
const saveDataProducts = async () => {
  const { data } = await provideApi().get("/restaurant/items");
  const products = data.data;
  const productsStorage = [];
  products.forEach((element) => {
    const item = {
      internalId: element.internal_id,
      barcode: element.barcode,
      id: element.id,
      name: element.description,
      imageUrl: element.image_url,
      price: Number(element.price),
      currencyTypeSymbol: element.currency_type_symbol,
      quantity: 0,
      categoryId: element.category_id,
      itemCode: element.item_code,
      unitTypeId: element.unit_type_id,
      statusBar: STATUS_NEW.id,
      statusKitchen: STATUS_NEW.id,
      sale_affectation_igv_type_id: element.sale_affectation_igv_type_id,
      quantity_send: 0,
      quantity_pending: 0
    };
    productsStorage.push(item);
  });
  productSession.setProducts(productsStorage);
};
const saveDataCategories = async () => {
  const { data } = await provideApi().get("/restaurant/categories");
  const catagories = data.data;
  const categoriessStorage = catagories.map((row) => {
    return __spreadProps(__spreadValues({}, row), { selected: false });
  });
  productSession.setCategories(categoriessStorage);
};
const saveDataConfiguration = async () => {
  const { data } = await provideApi().get("/restaurant/configurations");
  const configurations = data.data;
  companySession.setConfiguration(configurations);
};
const saveWaiters = async () => {
  const { data } = await provideApi().get("/restaurant/waiters");
  companySession.setWaiters(data.data);
};
const getNotes = async () => {
  try {
    const { data } = await provideApi().get("/restaurant/notes");
    return data.records;
  } catch (err) {
    console.error(err);
    return [];
  }
};
const syncData = async () => {
  await saveDataCompany();
  await saveDataProducts();
  await saveDataCategories();
  await saveDataConfiguration();
  await saveWaiters();
  await MesaService.syncMesasAndEnvironments();
};
const MasterService = { syncData, saveDataProducts, getNotes };
export { MasterService as M, useProductSession as u };
