import { _ as __unplugin_components_0 } from "./VDropdown.765cfd1c.js";
import { C as CommandStatusService, _ as _sfc_main$4 } from "./restaurantService.e10f7c8d.js";
import { _ as _sfc_main$5 } from "./KanbanDropdown.decc9adc.js";
import { _ as _sfc_main$3 } from "./VLoader.f2b91af0.js";
import { d as defineStore, b as defineComponent, r as ref, a as computed, f as openBlock, g as createElementBlock, X as createBaseVNode, Y as normalizeClass, D as createTextVNode, z as toDisplayString, C as createCommentVNode, Z as unref, w as createVNode, B as withCtx, F as Fragment, A as renderList, L as watch, o as onMounted, P as onUnmounted, am as resolveDirective, a6 as withDirectives, ar as vModelCheckbox, e as useHead } from "./vendor.f66678d1.js";
import { b as useMesaSession, C as COMMAND_BAR, c as COMMAND_KITCHEN, d as MesaService, a as use, M as MasterService, u as useCompanySession } from "./masterService.7663a99b.js";
import { p as provideApi, u as useUserSession, R as ROLES } from "./index.62345777.js";
import { p as pageTitle } from "./sidebarLayoutState.aff70478.js";
import "./VIcon.b97ff747.js";
import "./plugin-vue_export-helper.5a098b48.js";
const { getMesas2 } = useMesaSession();
const useCommandSession = defineStore("commandSession", () => {
  function productStatusFilter(status, command_type) {
    const products = [];
    if (command_type == "kitchen") {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusKitchen === status ? products.push(newItem) : "";
        });
      });
    } else {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusBar === status ? products.push(newItem) : "";
        });
      });
    }
    return products;
  }
  async function changeStatus(product, type) {
    const mesa = getMesas2().find((mesa2) => mesa2.id == product.mesa);
    mesa && mesa.products.forEach(async (item) => {
      if (type.code === COMMAND_BAR.code) {
        product.id == item.id ? item.statusBar = item.statusBar + 1 : "";
      }
      if (type.code === COMMAND_KITCHEN.code) {
        product.id == item.id ? item.statusKitchen = item.statusKitchen + 1 : "";
      }
    });
    if (mesa) {
      await MesaService.saveMesa(mesa);
      use.updateTable(mesa);
    }
  }
  return {
    productStatusFilter,
    changeStatus
  };
});
var CommandProduct_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$2 = { class: "command-card-grid" };
const _hoisted_2$1 = { class: "mesa-header" };
const _hoisted_3$1 = {
  key: 0,
  class: "tag ml-1 is-light",
  style: { "font-size": "10px" }
};
const _hoisted_4$1 = { class: "mesa-info-cliente" };
const _hoisted_5$1 = { class: "cliente-info-stack" };
const _hoisted_6$1 = /* @__PURE__ */ createBaseVNode("label", { class: "is-mesa-title" }, "mesa", -1);
const _hoisted_7$1 = { class: "is-cliente-name" };
const _hoisted_8$1 = { class: "action-header" };
const _hoisted_9$1 = {
  key: 0,
  class: "btn-next"
};
const _hoisted_10$1 = ["disabled", "aria-busy"];
const _hoisted_11$1 = /* @__PURE__ */ createBaseVNode("i", {
  class: "fas fa-arrow-right ml-2",
  style: { "font-size": "0.8rem" }
}, null, -1);
const _hoisted_12$1 = { class: "product-body" };
const _hoisted_13$1 = { class: "card-body p-0" };
const _hoisted_14$1 = { class: "table-container" };
const _hoisted_15$1 = { class: "table is-striped is-narrow is-hoverable is-fullwidth order-item" };
const _hoisted_16$1 = { key: 0 };
const _hoisted_17$1 = { class: "has-text-danger" };
const _hoisted_18$1 = { key: 1 };
const _hoisted_19$1 = {
  class: "is-narrow toc-ignore is-thin",
  style: { "font-size": "0.7rem" }
};
const _hoisted_20$1 = /* @__PURE__ */ createBaseVNode("br", null, null, -1);
const _hoisted_21$1 = { class: "action-body" };
const _hoisted_22$1 = { class: "action-meta" };
const _hoisted_23$1 = {
  key: 0,
  class: "custom-tag is-info"
};
const _hoisted_24$1 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-utensils" }, null, -1);
const _hoisted_25$1 = {
  key: 1,
  class: "custom-tag is-warning"
};
const _hoisted_26$1 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-clock" }, null, -1);
const _hoisted_27$1 = {
  key: 2,
  class: "custom-tag is-orange"
};
const _hoisted_28$1 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-user" }, null, -1);
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  props: {
    product: { type: null, required: true, default: Object },
    view: { type: null, required: true, default: Object },
    mostrarConfig: { type: Object, required: false, default: () => ({
      tiempo: true,
      ambiente: true,
      area: true,
      mozo: true
    }) }
  },
  emits: ["setProducts"],
  setup(__props, { emit }) {
    const props = __props;
    const loading = ref(false);
    const isLoaderActive = ref(false);
    useCommandSession();
    const mesaSession = useMesaSession();
    const mesa = computed(() => mesaSession.getMesas2().find((m) => m.id === props.product.mesa_id));
    const changeStatus = async (id, product) => {
      if (loading.value)
        return;
      loading.value = true;
      const mesaid = product.mesa_id || 0;
      try {
        const response = await provideApi().get(`restaurant/command-status/set/${id}`);
        const data = response.data;
        if (data.success) {
          const served = await CommandStatusService.getProductsByCommandStatus(mesaid);
          useMesaSession().setServerMesa(mesaid, served);
          const service = await MasterService.saveDataProducts();
          emit("setProducts");
        }
      } catch (error) {
        console.error("Error data:", error);
      } finally {
        loading.value = false;
      }
    };
    const statusMessageMapping = {
      1: "Preparar",
      2: "Listo",
      3: "Entregar"
    };
    const changeStatusMessageName = (status) => {
      if (!status) {
        return "Preparar";
      }
      return statusMessageMapping[status] || "Preparar";
    };
    const statusClass = (status) => {
      switch (status) {
        case 1:
          return "is-warning";
        case 2:
          return "is-primary";
        case 3:
          return "is-info";
        default:
          return "is-light";
      }
    };
    const formatElapsedFromDate = (dateInput) => {
      if (typeof dateInput !== "string" || dateInput.trim() === "")
        return "";
      const parsed = new Date(dateInput);
      if (Number.isNaN(parsed.getTime()))
        return "";
      const diffMs = Date.now() - parsed.getTime();
      if (!Number.isFinite(diffMs) || diffMs < 0)
        return "";
      const totalSeconds = Math.floor(diffMs / 1e3);
      const hours = Math.floor(totalSeconds / 3600);
      const minutes = Math.floor(totalSeconds % 3600 / 60);
      if (hours > 0)
        return `${hours}h ${minutes}m`;
      return `${minutes}m`;
    };
    const elapsedTime = computed(() => {
      var _a, _b, _c, _d, _e, _f, _g;
      if (!((_a = props.mostrarConfig) == null ? void 0 : _a.tiempo))
        return "";
      const productAny = props.product;
      const rawString = (_d = (_c = (_b = productAny == null ? void 0 : productAny.elapsed_time) != null ? _b : productAny == null ? void 0 : productAny.elapsedTime) != null ? _c : productAny == null ? void 0 : productAny.time_elapsed) != null ? _d : productAny == null ? void 0 : productAny.timeElapsed;
      if (typeof rawString === "string" && rawString.trim() !== "") {
        return rawString.trim();
      }
      const createdAt = (_g = (_f = (_e = productAny == null ? void 0 : productAny.created_at) != null ? _e : productAny == null ? void 0 : productAny.createdAt) != null ? _f : productAny == null ? void 0 : productAny.created_datetime) != null ? _g : productAny == null ? void 0 : productAny.created;
      return formatElapsedFromDate(createdAt);
    });
    return (_ctx, _cache) => {
      var _a, _b;
      const _component_VLoader = _sfc_main$3;
      return openBlock(), createElementBlock("div", _hoisted_1$2, [
        createBaseVNode("div", _hoisted_2$1, [
          createBaseVNode("p", {
            class: normalizeClass([{
              "is-mesa": !Number.isNaN(Number(props.product.mesa))
            }, "card-header-title m-0 p-2 has-text-primary title is-5"])
          }, [
            createTextVNode(toDisplayString(props.product.mesa) + " ", 1),
            props.mostrarConfig.ambiente ? (openBlock(), createElementBlock("span", _hoisted_3$1, toDisplayString(props.product.environment), 1)) : createCommentVNode("", true),
            createBaseVNode("span", _hoisted_4$1, [
              createBaseVNode("div", _hoisted_5$1, [
                _hoisted_6$1,
                createBaseVNode("label", _hoisted_7$1, toDisplayString((_a = unref(mesa)) == null ? void 0 : _a.cliente), 1)
              ])
            ])
          ], 2)
        ]),
        createBaseVNode("div", _hoisted_8$1, [
          props.product.status < 4 ? (openBlock(), createElementBlock("div", _hoisted_9$1, [
            createBaseVNode("button", {
              type: "button",
              disabled: loading.value,
              "aria-busy": loading.value,
              class: normalizeClass([
                "card-footer-item",
                "button",
                "is-light",
                "m-1",
                statusClass(props.product.status),
                loading.value && "is-loading"
              ]),
              onClick: _cache[0] || (_cache[0] = ($event) => changeStatus(props.product.id, props.product))
            }, [
              createTextVNode(toDisplayString(changeStatusMessageName(props.product.status)) + " ", 1),
              _hoisted_11$1
            ], 10, _hoisted_10$1)
          ])) : createCommentVNode("", true)
        ]),
        createBaseVNode("div", _hoisted_12$1, [
          createVNode(_component_VLoader, {
            size: "small",
            active: isLoaderActive.value,
            translucent: ""
          }, {
            default: withCtx(() => [
              createBaseVNode("div", _hoisted_13$1, [
                createBaseVNode("div", _hoisted_14$1, [
                  createBaseVNode("table", _hoisted_15$1, [
                    createBaseVNode("tr", null, [
                      createBaseVNode("td", null, [
                        createBaseVNode("span", null, toDisplayString(props.product.quantity), 1),
                        createTextVNode(" " + toDisplayString(props.product.name), 1)
                      ])
                    ]),
                    props.product.note ? (openBlock(), createElementBlock("tr", _hoisted_16$1, [
                      createBaseVNode("td", _hoisted_17$1, toDisplayString(props.product.note), 1)
                    ])) : createCommentVNode("", true),
                    props.product.modifiers_applied ? (openBlock(), createElementBlock("tr", _hoisted_18$1, [
                      createBaseVNode("td", null, [
                        (openBlock(true), createElementBlock(Fragment, null, renderList(props.product.modifiers_applied, (modify, index) => {
                          return openBlock(), createElementBlock("div", { key: index }, [
                            createBaseVNode("span", _hoisted_19$1, toDisplayString(modify.groupName), 1),
                            _hoisted_20$1,
                            (openBlock(true), createElementBlock(Fragment, null, renderList(modify.items, (item, idx) => {
                              return openBlock(), createElementBlock("div", {
                                key: idx,
                                class: "badge badge-success mr-1"
                              }, toDisplayString(item.name), 1);
                            }), 128))
                          ]);
                        }), 128))
                      ])
                    ])) : createCommentVNode("", true)
                  ])
                ])
              ])
            ]),
            _: 1
          }, 8, ["active"])
        ]),
        createBaseVNode("div", _hoisted_21$1, [
          createBaseVNode("div", _hoisted_22$1, [
            props.product.preparation_area_name && props.mostrarConfig.area ? (openBlock(), createElementBlock("span", _hoisted_23$1, [
              _hoisted_24$1,
              createBaseVNode("span", null, toDisplayString(props.product.preparation_area_name), 1)
            ])) : createCommentVNode("", true),
            unref(elapsedTime) && props.mostrarConfig.tiempo ? (openBlock(), createElementBlock("span", _hoisted_25$1, [
              _hoisted_26$1,
              createBaseVNode("span", null, toDisplayString(unref(elapsedTime)), 1)
            ])) : createCommentVNode("", true),
            ((_b = unref(mesa)) == null ? void 0 : _b.waiter) && props.mostrarConfig.mozo ? (openBlock(), createElementBlock("span", _hoisted_27$1, [
              _hoisted_28$1,
              createBaseVNode("span", null, toDisplayString(unref(mesa).waiter), 1)
            ])) : createCommentVNode("", true)
          ])
        ])
      ]);
    };
  }
});
var CommandRestaurant_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$1 = { class: "page-content kanban-content is-relative" };
const _hoisted_2 = { class: "columns is-multiline is-mobile" };
const _hoisted_3 = { class: "column is-11" };
const _hoisted_4 = { class: "tabs-wrapper" };
const _hoisted_5 = { class: "tabs-inner" };
const _hoisted_6 = { class: "tabs is-left mb-1" };
const _hoisted_7 = { class: "tabs-list-command tabs-listing-table" };
const _hoisted_8 = /* @__PURE__ */ createBaseVNode("span", {
  class: "text-center",
  style: { "line-height": "1.2" }
}, [
  /* @__PURE__ */ createBaseVNode("i", {
    "aria-hidden": "true",
    class: "iconify",
    "data-icon": "feather:grid"
  }),
  /* @__PURE__ */ createBaseVNode("br"),
  /* @__PURE__ */ createBaseVNode("span", { style: { "font-size": "0.7rem" } }, "Todo")
], -1);
const _hoisted_9 = [
  _hoisted_8
];
const _hoisted_10 = ["onClick"];
const _hoisted_11 = { class: "label-container" };
const _hoisted_12 = {
  key: 0,
  class: "m-prefix"
};
const _hoisted_13 = /* @__PURE__ */ createBaseVNode("strong", null, "M", -1);
const _hoisted_14 = [
  _hoisted_13
];
const _hoisted_15 = { class: "label-value m-0" };
const _hoisted_16 = { class: "tab-environment" };
const _hoisted_17 = /* @__PURE__ */ createBaseVNode("li", { class: "tab-naver" }, null, -1);
const _hoisted_18 = { class: "columns is-mobile is-vcentered mt-1" };
const _hoisted_19 = { class: "column is-narrow" };
const _hoisted_20 = ["onClick"];
const _hoisted_21 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-layer-group" }, null, -1);
const _hoisted_22 = { class: "filter-text" };
const _hoisted_23 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-chevron-down" }, null, -1);
const _hoisted_24 = ["onClick"];
const _hoisted_25 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-globe mr-2" }, null, -1);
const _hoisted_26 = /* @__PURE__ */ createTextVNode(" Todas las \xE1reas ");
const _hoisted_27 = [
  _hoisted_25,
  _hoisted_26
];
const _hoisted_28 = /* @__PURE__ */ createBaseVNode("hr", { class: "dropdown-divider" }, null, -1);
const _hoisted_29 = ["onClick"];
const _hoisted_30 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-utensils mr-2" }, null, -1);
const _hoisted_31 = { class: "column is-narrow" };
const _hoisted_32 = ["onClick"];
const _hoisted_33 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-eye" }, null, -1);
const _hoisted_34 = /* @__PURE__ */ createBaseVNode("span", { class: "filter-text" }, "Mostrar", -1);
const _hoisted_35 = /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-chevron-down" }, null, -1);
const _hoisted_36 = [
  _hoisted_33,
  _hoisted_34,
  _hoisted_35
];
const _hoisted_37 = { class: "dropdown-content" };
const _hoisted_38 = ["onUpdate:modelValue"];
const _hoisted_39 = { class: "column is-narrow" };
const _hoisted_40 = { class: "columns is-kanban-wrapper" };
const _hoisted_41 = { class: "collapsed-content" };
const _hoisted_42 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_43 = [
  _hoisted_42
];
const _hoisted_44 = { class: "task-count" };
const _hoisted_45 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Recibidos", -1);
const _hoisted_46 = { class: "expanded-content" };
const _hoisted_47 = { class: "column-title" };
const _hoisted_48 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_49 = { class: "task-count tag is-danger px-2 py-1 is-inline" };
const _hoisted_50 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Recibidos", -1);
const _hoisted_51 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_52 = { class: "empty-text" };
const _hoisted_53 = ["data-id"];
const _hoisted_54 = { class: "collapsed-content" };
const _hoisted_55 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_56 = [
  _hoisted_55
];
const _hoisted_57 = { class: "task-count" };
const _hoisted_58 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Preparando", -1);
const _hoisted_59 = { class: "expanded-content" };
const _hoisted_60 = { class: "column-title" };
const _hoisted_61 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_62 = { class: "task-count tag is-warning px-2 py-1 is-inline" };
const _hoisted_63 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Preparando ", -1);
const _hoisted_64 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_65 = { class: "empty-text" };
const _hoisted_66 = ["data-id"];
const _hoisted_67 = { class: "collapsed-content" };
const _hoisted_68 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_69 = [
  _hoisted_68
];
const _hoisted_70 = { class: "task-count" };
const _hoisted_71 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Por entregar", -1);
const _hoisted_72 = { class: "expanded-content" };
const _hoisted_73 = { class: "column-title" };
const _hoisted_74 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_75 = { class: "task-count tag is-primary px-2 py-1 is-inline" };
const _hoisted_76 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Por entregar ", -1);
const _hoisted_77 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_78 = { class: "empty-text" };
const _hoisted_79 = ["data-id"];
const _hoisted_80 = { class: "collapsed-content" };
const _hoisted_81 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_82 = [
  _hoisted_81
];
const _hoisted_83 = { class: "task-count" };
const _hoisted_84 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Entregados", -1);
const _hoisted_85 = { class: "expanded-content" };
const _hoisted_86 = { class: "column-title" };
const _hoisted_87 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_88 = { class: "task-count tag is-secondary px-2 py-1 is-inline" };
const _hoisted_89 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Entregados ", -1);
const _hoisted_90 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_91 = { class: "empty-text" };
const _hoisted_92 = ["data-id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const userSession = useUserSession();
    const roleCurrent = Number(userSession.userRole);
    const role = ROLES.find((role2) => role2.id === roleCurrent);
    const disableBar = ref(true);
    const disableKitchen = ref(true);
    useMesaSession().mesas;
    let intervalId = void 0;
    const selectArea = (area) => {
      selectedPreparationArea.value = area;
    };
    const defaultView = () => {
      let response = COMMAND_KITCHEN;
      if (role && role.id != 3) {
        if (role.code == "BAR") {
          response = COMMAND_BAR;
          disableBar.value = false;
        }
        if (role.code == "KIT") {
          response = COMMAND_KITCHEN;
          disableKitchen.value = false;
        }
      }
      if ((role == null ? void 0 : role.id) == 3) {
        disableBar.value = false;
        disableKitchen.value = false;
      }
      return response;
    };
    let currentView = ref(defaultView());
    const isColumnPreparationCollapsed = ref(false);
    const isColumnDispatchedCollapsed = ref(false);
    const isColumnToDeliverCollapsed = ref(false);
    const isColumnDeliveredCollapsed = ref(false);
    const isLoaderActive = ref(false);
    const loaderCounter = ref(0);
    const emptyText = ref("No existe registro actualmente");
    useCommandSession();
    ref([]);
    let productsStatusReceived = ref([]);
    let productsStatusProcessing = ref([]);
    let productsStatusToDeliver = ref([]);
    let productsStatusDelivered = ref([]);
    const companySession = useCompanySession();
    companySession.configuration;
    const selectedTableId = ref(0);
    const mesasSession = useMesaSession();
    const mesasDisabled = mesasSession.getMesasNotAvailable();
    const isCheckLetterZise = ref(false);
    const getProductsApi = async (showLoader = false) => {
      var _a;
      if (showLoader) {
        loaderCounter.value += 1;
        isLoaderActive.value = true;
      }
      try {
        let id = (_a = selectedTableId.value) != null ? _a : 0;
        const response = await provideApi().get(`restaurant/command-status/items/${id}`);
        const data = response.data;
        if (data.success) {
          productsStatusReceived.value = data.data.productsStatusReceived;
          productsStatusProcessing.value = data.data.productsStatusProcessing;
          productsStatusToDeliver.value = data.data.productsStatusToDeliver;
          productsStatusDelivered.value = data.data.productsStatusDelivered;
          console.log("Productos recibidos:", productsStatusReceived.value);
          console.log("\xC1reas de preparaci\xF3n encontradas:", preparationAreas.value);
        }
      } catch (error) {
        console.error("Error data:", error);
      } finally {
        if (showLoader) {
          loaderCounter.value = Math.max(0, loaderCounter.value - 1);
          isLoaderActive.value = loaderCounter.value > 0;
        }
      }
    };
    const selectTable = (id) => {
      selectedTableId.value = id;
      getProductsApi(true);
    };
    const isNumeric = (value) => {
      return !isNaN(parseFloat(value)) && isFinite(value);
    };
    const changeView = (view) => {
      currentView.value = view;
      getProductsApi(true);
    };
    const checkedLetterSize = () => {
      isCheckLetterZise.value = !isCheckLetterZise.value;
      let isChecked = isCheckLetterZise.value ? 1 : 0;
      userSession.setIsCheckLetterZise(isChecked);
    };
    const STORAGE_KEY_PREPARATION_AREA = "command_preparation_area";
    const selectedPreparationArea = ref(localStorage.getItem(STORAGE_KEY_PREPARATION_AREA) || "all");
    watch(selectedPreparationArea, (value) => {
      localStorage.setItem(STORAGE_KEY_PREPARATION_AREA, value);
    });
    const allProducts = computed(() => [
      ...productsStatusReceived.value,
      ...productsStatusProcessing.value,
      ...productsStatusToDeliver.value,
      ...productsStatusDelivered.value
    ]);
    const preparationAreas = computed(() => {
      const set = new Set();
      allProducts.value.forEach((p) => {
        if (p.preparation_area_name && p.preparation_area_name.trim() !== "") {
          set.add(p.preparation_area_name.trim());
        }
      });
      return Array.from(set);
    });
    const filterByPreparationArea = (items) => {
      if (selectedPreparationArea.value === "all")
        return items;
      return items.filter((p) => p.preparation_area_name === selectedPreparationArea.value);
    };
    const productsReceivedFiltered = computed(() => filterByPreparationArea(productsStatusReceived.value));
    const productsProcessingFiltered = computed(() => filterByPreparationArea(productsStatusProcessing.value));
    const productsToDeliverFiltered = computed(() => filterByPreparationArea(productsStatusToDeliver.value));
    const productsDeliveredFiltered = computed(() => filterByPreparationArea(productsStatusDelivered.value));
    const STORAGE_KEY_VISUALIZACION_PEDIDOS = "restaurant_visualizacion_pedidos";
    const visualizacionPedidos = ref({
      tiempo: {
        label: "Tiempo",
        activo: true
      },
      area: {
        label: "\xC1rea",
        activo: true
      },
      ambiente: {
        label: "Ambiente",
        activo: false
      },
      mozo: {
        label: "Mozo",
        activo: true
      }
    });
    const mostrarPedidosConfig = computed(() => {
      return {
        tiempo: visualizacionPedidos.value.tiempo.activo,
        area: visualizacionPedidos.value.area.activo,
        ambiente: visualizacionPedidos.value.ambiente.activo,
        mozo: visualizacionPedidos.value.mozo.activo
      };
    });
    onMounted(() => {
      changeView(currentView.value);
      getProductsApi(true);
      intervalId = window.setInterval(() => getProductsApi(false), 5e3);
      isCheckLetterZise.value = userSession.isCheckLetterZise ? true : false;
      const raw = localStorage.getItem(STORAGE_KEY_VISUALIZACION_PEDIDOS);
      if (raw) {
        const saved = JSON.parse(raw);
        visualizacionPedidos.value = {
          tiempo: saved.tiempo || { label: "Tiempo", activo: true },
          area: saved.area || { label: "\xC1rea", activo: true },
          ambiente: saved.ambiente || { label: "Ambiente", activo: false },
          mozo: saved.mozo || { label: "Mozo", activo: true }
        };
      }
    });
    watch(visualizacionPedidos, (val) => {
      localStorage.setItem(STORAGE_KEY_VISUALIZACION_PEDIDOS, JSON.stringify(val));
    }, { deep: true });
    onUnmounted(() => {
      if (intervalId !== void 0) {
        clearInterval(intervalId);
      }
    });
    return (_ctx, _cache) => {
      const _component_VDropdown = __unplugin_components_0;
      const _component_VTag = _sfc_main$4;
      const _component_KanbanDropdown = _sfc_main$5;
      const _component_CommandProduct = _sfc_main$2;
      const _component_VLoader = _sfc_main$3;
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        createBaseVNode("div", _hoisted_2, [
          createBaseVNode("div", _hoisted_3, [
            createBaseVNode("div", _hoisted_4, [
              createBaseVNode("div", _hoisted_5, [
                createBaseVNode("div", _hoisted_6, [
                  createBaseVNode("ul", _hoisted_7, [
                    createBaseVNode("li", {
                      class: normalizeClass({ "is-active": selectedTableId.value === 0 })
                    }, [
                      createBaseVNode("a", {
                        onClick: _cache[0] || (_cache[0] = ($event) => selectTable(0))
                      }, _hoisted_9)
                    ], 2),
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(mesasDisabled), (tab, key) => {
                      return openBlock(), createElementBlock("li", {
                        key,
                        class: normalizeClass([selectedTableId.value == tab.id && "is-active"])
                      }, [
                        createBaseVNode("a", {
                          class: "list-table",
                          onClick: ($event) => selectTable(tab.id)
                        }, [
                          createBaseVNode("span", _hoisted_11, [
                            createBaseVNode("span", null, [
                              isNumeric(tab.label) ? (openBlock(), createElementBlock("span", _hoisted_12, _hoisted_14)) : createCommentVNode("", true),
                              createBaseVNode("small", _hoisted_15, [
                                createBaseVNode("strong", null, toDisplayString(tab.label), 1)
                              ])
                            ]),
                            createBaseVNode("span", _hoisted_16, toDisplayString(tab.environment), 1)
                          ])
                        ], 8, _hoisted_10)
                      ], 2);
                    }), 128)),
                    _hoisted_17
                  ])
                ])
              ])
            ])
          ])
        ]),
        createBaseVNode("div", _hoisted_18, [
          createBaseVNode("div", _hoisted_19, [
            createVNode(_component_VDropdown, {
              color: "primary",
              spaced: "",
              modern: ""
            }, {
              button: withCtx(({ toggle }) => [
                createBaseVNode("div", {
                  class: "filter-container",
                  onClick: toggle
                }, [
                  _hoisted_21,
                  createBaseVNode("span", _hoisted_22, toDisplayString(selectedPreparationArea.value === "all" ? "Todas las \xE1reas" : selectedPreparationArea.value), 1),
                  _hoisted_23
                ], 8, _hoisted_20)
              ]),
              content: withCtx(({ close }) => [
                createBaseVNode("a", {
                  class: normalizeClass(["dropdown-item", { "is-active": selectedPreparationArea.value === "all" }]),
                  onClick: ($event) => (selectArea("all"), close())
                }, _hoisted_27, 10, _hoisted_24),
                _hoisted_28,
                (openBlock(true), createElementBlock(Fragment, null, renderList(unref(preparationAreas), (area) => {
                  return openBlock(), createElementBlock("a", {
                    key: area,
                    class: normalizeClass(["dropdown-item", { "is-active": selectedPreparationArea.value === area }]),
                    onClick: ($event) => (selectArea(area), close())
                  }, [
                    _hoisted_30,
                    createTextVNode(" " + toDisplayString(area), 1)
                  ], 10, _hoisted_29);
                }), 128))
              ]),
              _: 1
            })
          ]),
          createBaseVNode("div", _hoisted_31, [
            createVNode(_component_VDropdown, {
              color: "primary",
              spaced: "",
              modern: ""
            }, {
              button: withCtx(({ toggle }) => [
                createBaseVNode("div", {
                  class: "filter-container",
                  onClick: toggle
                }, _hoisted_36, 8, _hoisted_32)
              ]),
              content: withCtx(() => [
                createBaseVNode("div", _hoisted_37, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(visualizacionPedidos.value, (opcion, key) => {
                    return openBlock(), createElementBlock("label", {
                      key,
                      class: "dropdown-item is-flex is-align-items-center"
                    }, [
                      withDirectives(createBaseVNode("input", {
                        "onUpdate:modelValue": ($event) => opcion.activo = $event,
                        type: "checkbox",
                        class: "mr-2"
                      }, null, 8, _hoisted_38), [
                        [vModelCheckbox, opcion.activo]
                      ]),
                      createBaseVNode("span", null, toDisplayString(opcion.label), 1)
                    ]);
                  }), 128))
                ])
              ]),
              _: 1
            })
          ]),
          createBaseVNode("div", _hoisted_39, [
            createBaseVNode("a", {
              class: "list-table has-text-dark has-text-weight-bold",
              onClick: _cache[1] || (_cache[1] = ($event) => checkedLetterSize())
            }, [
              withDirectives(createVNode(_component_VTag, {
                color: "primary",
                label: "A+",
                modern: ""
              }, null, 512), [
                [
                  _directive_tooltip,
                  "Cambiar tama\xF1o de letra",
                  void 0,
                  {
                    bottom: true,
                    left: true
                  }
                ]
              ])
            ])
          ])
        ]),
        createBaseVNode("div", _hoisted_40, [
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnPreparationCollapsed.value && "is-1 is-mini",
              !isColumnPreparationCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-1", [isColumnPreparationCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_41, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[2] || (_cache[2] = ($event) => isColumnPreparationCollapsed.value = false)
                    }, _hoisted_43),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_44, toDisplayString(unref(productsStatusReceived).length), 1)
                    ]),
                    _hoisted_45
                  ]),
                  createBaseVNode("div", _hoisted_46, [
                    createBaseVNode("div", _hoisted_47, [
                      _hoisted_48,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_49, toDisplayString(unref(productsStatusReceived).length), 1),
                        _hoisted_50
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[3] || (_cache[3] = ($event) => isColumnPreparationCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsReceivedFiltered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_51, [
                        createBaseVNode("p", _hoisted_52, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsReceivedFiltered), (item) => {
                        return openBlock(), createElementBlock("div", {
                          key: item.id,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            "mostrar-config": unref(mostrarPedidosConfig),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view", "mostrar-config"])
                        ], 10, _hoisted_53);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDispatchedCollapsed.value && "is-1 is-mini",
              !isColumnDispatchedCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-2", [isColumnDispatchedCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_54, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[4] || (_cache[4] = ($event) => isColumnDispatchedCollapsed.value = false)
                    }, _hoisted_56),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_57, toDisplayString(unref(productsStatusProcessing).length), 1)
                    ]),
                    _hoisted_58
                  ]),
                  createBaseVNode("div", _hoisted_59, [
                    createBaseVNode("div", _hoisted_60, [
                      _hoisted_61,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_62, toDisplayString(unref(productsStatusProcessing).length), 1),
                        _hoisted_63
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[5] || (_cache[5] = ($event) => isColumnDispatchedCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsProcessingFiltered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_64, [
                        createBaseVNode("p", _hoisted_65, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsProcessingFiltered), (item) => {
                        return openBlock(), createElementBlock("div", {
                          key: item.id,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            "mostrar-config": unref(mostrarPedidosConfig),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view", "mostrar-config"])
                        ], 10, _hoisted_66);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnToDeliverCollapsed.value && "is-1 is-mini",
              !isColumnToDeliverCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-3", [isColumnToDeliverCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_67, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[6] || (_cache[6] = ($event) => isColumnToDeliverCollapsed.value = false)
                    }, _hoisted_69),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_70, toDisplayString(unref(productsStatusToDeliver).length), 1)
                    ]),
                    _hoisted_71
                  ]),
                  createBaseVNode("div", _hoisted_72, [
                    createBaseVNode("div", _hoisted_73, [
                      _hoisted_74,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_75, toDisplayString(unref(productsStatusToDeliver).length), 1),
                        _hoisted_76
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[7] || (_cache[7] = ($event) => isColumnToDeliverCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsToDeliverFiltered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_77, [
                        createBaseVNode("p", _hoisted_78, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsToDeliverFiltered), (item) => {
                        return openBlock(), createElementBlock("div", {
                          key: item.id,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            "mostrar-config": unref(mostrarPedidosConfig),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view", "mostrar-config"])
                        ], 10, _hoisted_79);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDeliveredCollapsed.value && "is-1 is-mini",
              !isColumnDeliveredCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-4", [isColumnDeliveredCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_80, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[8] || (_cache[8] = ($event) => isColumnDeliveredCollapsed.value = false)
                    }, _hoisted_82),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_83, toDisplayString(unref(productsStatusDelivered).length), 1)
                    ]),
                    _hoisted_84
                  ]),
                  createBaseVNode("div", _hoisted_85, [
                    createBaseVNode("div", _hoisted_86, [
                      _hoisted_87,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_88, toDisplayString(unref(productsStatusDelivered).length), 1),
                        _hoisted_89
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[9] || (_cache[9] = ($event) => isColumnDeliveredCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsDeliveredFiltered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_90, [
                        createBaseVNode("p", _hoisted_91, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsDeliveredFiltered), (item) => {
                        return openBlock(), createElementBlock("div", {
                          key: item.id,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            "mostrar-config": unref(mostrarPedidosConfig),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view", "mostrar-config"])
                        ], 10, _hoisted_92);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2)
        ])
      ]);
    };
  }
});
const _hoisted_1 = { class: "page-content-inner" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    pageTitle.value = "Pedidos";
    useHead({
      title: "Pedidos"
    });
    return (_ctx, _cache) => {
      const _component_CommandRestaurant = _sfc_main$1;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_CommandRestaurant)
      ]);
    };
  }
});
export { _sfc_main as default };
