import { d as defineComponent, o as openBlock, g as createElementBlock, B as toDisplayString, i as normalizeClass, D as defineStore, r as ref, p as createBaseVNode, z as createTextVNode, H as createBlock, _ as createCommentVNode, s as createVNode, t as withCtx, F as Fragment, G as onMounted, a6 as onUnmounted, ar as resolveDirective, Z as renderList, f as unref, v as withDirectives, E as useHead } from "./vendor.07f7b9b8.js";
import { _ as _sfc_main$6 } from "./KanbanDropdown.cef8eb72.js";
import { _ as _sfc_main$4 } from "./VPlaceloadText.46729e9a.js";
import { _ as _sfc_main$5 } from "./VLoader.26886e01.js";
import { b as useMesaSession, C as COMMAND_BAR, c as COMMAND_KITCHEN, M as MesaService, a as use, u as useCompanySession } from "./mesaService.4fddb767.js";
import { p as provideApi, u as useUserSession, R as ROLES } from "./index.a5dcc74e.js";
import { p as pageTitle } from "./sidebarLayoutState.6a27402a.js";
import "./VDropdown.ae4137f7.js";
import "./VIcon.72bd6243.js";
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  props: {
    label: { type: [String, Number], required: false, default: void 0 },
    color: { type: String, required: false, default: void 0 },
    rounded: { type: Boolean, required: false },
    curved: { type: Boolean, required: false },
    outlined: { type: Boolean, required: false },
    elevated: { type: Boolean, required: false },
    remove: { type: Boolean, required: false }
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("small", {
        class: normalizeClass(["tag", [
          props.color && "is-" + props.color,
          props.rounded && "is-rounded",
          props.curved && "is-curved",
          props.outlined && "is-outlined",
          props.elevated && "is-elevated",
          props.remove && "is-delete"
        ]])
      }, toDisplayString(props.label), 3);
    };
  }
});
const { getMesas2 } = useMesaSession();
const useCommandSession = defineStore("commandSession", () => {
  function productStatusFilter(status, command_type) {
    const products = [];
    if (command_type == "kitchen") {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusKitchen === status ? products.push(newItem) : "";
        });
      });
    } else {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusBar === status ? products.push(newItem) : "";
        });
      });
    }
    return products;
  }
  async function changeStatus(product, type) {
    const mesa = getMesas2().find((mesa2) => mesa2.id == product.mesa);
    mesa && mesa.products.forEach(async (item) => {
      if (type.code === COMMAND_BAR.code) {
        product.id == item.id ? item.statusBar = item.statusBar + 1 : "";
      }
      if (type.code === COMMAND_KITCHEN.code) {
        product.id == item.id ? item.statusKitchen = item.statusKitchen + 1 : "";
      }
    });
    if (mesa) {
      await MesaService.saveMesa(mesa);
      use.updateTable(mesa);
    }
  }
  return {
    productStatusFilter,
    changeStatus
  };
});
var CommandProduct_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$2 = { class: "card-header is-relative" };
const _hoisted_2$1 = {
  class: "tag ml-1 is-light",
  style: { "font-size": "10px" }
};
const _hoisted_3$1 = {
  key: 0,
  class: "btn-next"
};
const _hoisted_4$1 = /* @__PURE__ */ createBaseVNode("i", {
  class: "fas fa-arrow-right ml-2",
  style: { "font-size": "0.8rem" }
}, null, -1);
const _hoisted_5$1 = { class: "card-body p-0" };
const _hoisted_6$1 = { class: "table-container" };
const _hoisted_7$1 = { class: "table-container" };
const _hoisted_8$1 = { class: "table is-striped is-narrow is-hoverable is-fullwidth order-item" };
const _hoisted_9$1 = { key: 0 };
const _hoisted_10$1 = { class: "has-text-danger" };
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  props: {
    product: { type: null, required: true, default: Object },
    view: { type: null, required: true, default: Object }
  },
  emits: ["setProducts"],
  setup(__props, { emit }) {
    const props = __props;
    const loading = ref(false);
    const isLoaderActive = ref(false);
    useCommandSession();
    const changeStatus = async (id) => {
      loading.value = true;
      try {
        const response = await provideApi().get(`restaurant/command-status/set/${id}`);
        const data = response.data;
        if (data.success) {
          emit("setProducts");
        }
      } catch (error) {
        console.error("Error data:", error);
      }
      loading.value = false;
    };
    const statusMessageMapping = {
      1: "Preparar",
      2: "Listo",
      3: "Entregar"
    };
    const changeStatusMessageName = (status) => {
      if (!status) {
        return "Preparar";
      }
      return statusMessageMapping[status] || "Preparar";
    };
    const statusClass = (status) => {
      switch (status) {
        case 1:
          return "is-warning";
        case 2:
          return "is-primary";
        case 3:
          return "is-info";
        default:
          return "is-light";
      }
    };
    return (_ctx, _cache) => {
      const _component_VPlaceloadText = _sfc_main$4;
      const _component_VLoader = _sfc_main$5;
      return openBlock(), createElementBlock(Fragment, null, [
        createBaseVNode("div", _hoisted_1$2, [
          createBaseVNode("p", {
            class: normalizeClass([{
              "is-mesa": !isNaN(props.product.mesa)
            }, "card-header-title m-0 p-2 has-text-primary title is-5"])
          }, [
            createTextVNode(toDisplayString(props.product.mesa) + " ", 1),
            createBaseVNode("span", _hoisted_2$1, toDisplayString(props.product.environment), 1)
          ], 2),
          props.product.status < 4 ? (openBlock(), createElementBlock("div", _hoisted_3$1, [
            loading.value ? (openBlock(), createBlock(_component_VPlaceloadText, {
              key: 0,
              lines: 1,
              width: "100%",
              "last-line-width": "25%"
            })) : (openBlock(), createElementBlock("a", {
              key: 1,
              class: normalizeClass([
                "card-footer-item",
                "button",
                "is-light",
                "m-1",
                statusClass(props.product.status)
              ]),
              onClick: _cache[0] || (_cache[0] = ($event) => changeStatus(props.product.id))
            }, [
              createTextVNode(toDisplayString(changeStatusMessageName(props.product.status)) + " ", 1),
              _hoisted_4$1
            ], 2))
          ])) : createCommentVNode("", true)
        ]),
        createVNode(_component_VLoader, {
          size: "small",
          active: isLoaderActive.value,
          translucent: ""
        }, {
          default: withCtx(() => [
            createBaseVNode("div", _hoisted_5$1, [
              createBaseVNode("div", _hoisted_6$1, [
                createBaseVNode("div", _hoisted_7$1, [
                  createBaseVNode("table", _hoisted_8$1, [
                    createBaseVNode("tr", null, [
                      createBaseVNode("td", null, [
                        createBaseVNode("span", null, toDisplayString(props.product.quantity), 1),
                        createTextVNode(" " + toDisplayString(props.product.name), 1)
                      ])
                    ]),
                    props.product.note ? (openBlock(), createElementBlock("tr", _hoisted_9$1, [
                      createBaseVNode("td", _hoisted_10$1, toDisplayString(props.product.note), 1)
                    ])) : createCommentVNode("", true)
                  ])
                ])
              ])
            ])
          ]),
          _: 1
        }, 8, ["active"])
      ], 64);
    };
  }
});
var CommandRestaurant_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$1 = { class: "page-content kanban-content is-relative" };
const _hoisted_2 = { class: "columns is-multiline is-mobile" };
const _hoisted_3 = { class: "column is-11" };
const _hoisted_4 = { class: "tabs-wrapper" };
const _hoisted_5 = { class: "tabs-inner" };
const _hoisted_6 = { class: "tabs is-boxed is-left mb-1" };
const _hoisted_7 = {
  style: {},
  class: ""
};
const _hoisted_8 = { class: "" };
const _hoisted_9 = /* @__PURE__ */ createBaseVNode("span", { class: "has-text-dark" }, [
  /* @__PURE__ */ createBaseVNode("i", {
    "aria-hidden": "true",
    class: "iconify",
    "data-icon": "feather:grid"
  })
], -1);
const _hoisted_10 = [
  _hoisted_9
];
const _hoisted_11 = ["onClick"];
const _hoisted_12 = { class: "label-container" };
const _hoisted_13 = /* @__PURE__ */ createBaseVNode("li", { class: "tab-naver" }, null, -1);
const _hoisted_14 = { class: "column is-1" };
const _hoisted_15 = { class: "columns is-kanban-wrapper" };
const _hoisted_16 = { class: "collapsed-content" };
const _hoisted_17 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_18 = [
  _hoisted_17
];
const _hoisted_19 = { class: "task-count" };
const _hoisted_20 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Recibidos", -1);
const _hoisted_21 = { class: "expanded-content" };
const _hoisted_22 = { class: "column-title" };
const _hoisted_23 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_24 = { class: "task-count tag is-danger px-2 py-1 is-inline" };
const _hoisted_25 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Recibidos", -1);
const _hoisted_26 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_27 = { class: "empty-text" };
const _hoisted_28 = ["data-id"];
const _hoisted_29 = { class: "collapsed-content" };
const _hoisted_30 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_31 = [
  _hoisted_30
];
const _hoisted_32 = { class: "task-count" };
const _hoisted_33 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Preparando", -1);
const _hoisted_34 = { class: "expanded-content" };
const _hoisted_35 = { class: "column-title" };
const _hoisted_36 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_37 = { class: "task-count tag is-warning px-2 py-1 is-inline" };
const _hoisted_38 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Preparando ", -1);
const _hoisted_39 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_40 = { class: "empty-text" };
const _hoisted_41 = ["data-id"];
const _hoisted_42 = { class: "collapsed-content" };
const _hoisted_43 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_44 = [
  _hoisted_43
];
const _hoisted_45 = { class: "task-count" };
const _hoisted_46 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Por entregar", -1);
const _hoisted_47 = { class: "expanded-content" };
const _hoisted_48 = { class: "column-title" };
const _hoisted_49 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_50 = { class: "task-count tag is-primary px-2 py-1 is-inline" };
const _hoisted_51 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Por entregar ", -1);
const _hoisted_52 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_53 = { class: "empty-text" };
const _hoisted_54 = ["data-id"];
const _hoisted_55 = { class: "collapsed-content" };
const _hoisted_56 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_57 = [
  _hoisted_56
];
const _hoisted_58 = { class: "task-count" };
const _hoisted_59 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Entregados", -1);
const _hoisted_60 = { class: "expanded-content" };
const _hoisted_61 = { class: "column-title" };
const _hoisted_62 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_63 = { class: "task-count tag is-secondary px-2 py-1 is-inline" };
const _hoisted_64 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Entregados ", -1);
const _hoisted_65 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_66 = { class: "empty-text" };
const _hoisted_67 = ["data-id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const userSession = useUserSession();
    const roleCurrent = userSession.userRole;
    const role = ROLES.find((role2) => role2.id === roleCurrent);
    const disableBar = ref(true);
    const disableKitchen = ref(true);
    useMesaSession().mesas;
    let intervalId = void 0;
    const defaultView = () => {
      let response = COMMAND_KITCHEN;
      if (role && role.id != 3) {
        if (role.code == "BAR") {
          response = COMMAND_BAR;
          disableBar.value = false;
        }
        if (role.code == "KIT") {
          response = COMMAND_KITCHEN;
          disableKitchen.value = false;
        }
      }
      if ((role == null ? void 0 : role.id) == 3) {
        disableBar.value = false;
        disableKitchen.value = false;
      }
      return response;
    };
    let currentView = ref(defaultView());
    const isColumnPreparationCollapsed = ref(false);
    const isColumnDispatchedCollapsed = ref(false);
    const isColumnToDeliverCollapsed = ref(false);
    const isColumnDeliveredCollapsed = ref(false);
    const isLoaderActive = ref(false);
    const emptyText = ref("No existe registro actualmente");
    useCommandSession();
    ref([]);
    let productsStatusReceived = ref([]);
    let productsStatusProcessing = ref([]);
    let productsStatusToDeliver = ref([]);
    let productsStatusDelivered = ref([]);
    const companySession = useCompanySession();
    companySession.configuration;
    const selectedTableId = ref(0);
    const mesasSession = useMesaSession();
    const mesasDisabled = mesasSession.getMesasNotAvailable();
    const isCheckLetterZise = ref(false);
    const getProductsApi = async () => {
      var _a;
      try {
        let id = (_a = selectedTableId.value) != null ? _a : 0;
        const response = await provideApi().get(`restaurant/command-status/items/${id}`);
        const data = response.data;
        if (data.success) {
          productsStatusReceived.value = data.data.productsStatusReceived;
          productsStatusProcessing.value = data.data.productsStatusProcessing;
          productsStatusToDeliver.value = data.data.productsStatusToDeliver;
          productsStatusDelivered.value = data.data.productsStatusDelivered;
        }
      } catch (error) {
        console.error("Error data:", error);
      }
    };
    const selectTable = (id) => {
      selectedTableId.value = id;
      getProductsApi();
    };
    const isNumeric = (value) => {
      return !isNaN(parseFloat(value)) && isFinite(value);
    };
    const changeView = (view) => {
      currentView.value = view;
      getProductsApi();
    };
    const checkedLetterSize = () => {
      isCheckLetterZise.value = !isCheckLetterZise.value;
      let isChecked = isCheckLetterZise.value ? 1 : 0;
      userSession.setIsCheckLetterZise(isChecked);
    };
    onMounted(() => {
      changeView(currentView.value);
      getProductsApi();
      intervalId = window.setInterval(getProductsApi, 5e3);
      isCheckLetterZise.value = userSession.isCheckLetterZise ? true : false;
    });
    onUnmounted(() => {
      if (intervalId !== void 0) {
        clearInterval(intervalId);
      }
    });
    return (_ctx, _cache) => {
      const _component_VTag = _sfc_main$3;
      const _component_KanbanDropdown = _sfc_main$6;
      const _component_CommandProduct = _sfc_main$2;
      const _component_VLoader = _sfc_main$5;
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        createBaseVNode("div", _hoisted_2, [
          createBaseVNode("div", _hoisted_3, [
            createBaseVNode("div", _hoisted_4, [
              createBaseVNode("div", _hoisted_5, [
                createBaseVNode("div", _hoisted_6, [
                  createBaseVNode("ul", _hoisted_7, [
                    createBaseVNode("li", _hoisted_8, [
                      createBaseVNode("a", {
                        onClick: _cache[0] || (_cache[0] = ($event) => selectTable(0))
                      }, _hoisted_10)
                    ]),
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(mesasDisabled), (tab, key) => {
                      return openBlock(), createElementBlock("li", {
                        key,
                        class: normalizeClass([selectedTableId.value == tab.id && "is-active"])
                      }, [
                        createBaseVNode("a", {
                          class: "list-table has-text-dark",
                          onClick: ($event) => selectTable(tab.id)
                        }, [
                          createBaseVNode("span", _hoisted_12, [
                            createBaseVNode("span", null, toDisplayString(isNumeric(tab.label) ? `M${tab.label}` : tab.label), 1),
                            createBaseVNode("span", null, toDisplayString(tab.environment), 1)
                          ])
                        ], 8, _hoisted_11)
                      ], 2);
                    }), 128)),
                    _hoisted_13
                  ])
                ])
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_14, [
            createBaseVNode("a", {
              class: "list-table has-text-dark has-text-weight-bold",
              style: { "position": "absolute", "right": "1%" },
              onClick: _cache[1] || (_cache[1] = ($event) => checkedLetterSize())
            }, [
              withDirectives(createVNode(_component_VTag, {
                color: "white",
                label: "A+"
              }, null, 512), [
                [
                  _directive_tooltip,
                  "Cambiar tama\xF1o de letra",
                  void 0,
                  {
                    bottom: true,
                    left: true
                  }
                ]
              ])
            ])
          ])
        ]),
        createBaseVNode("div", _hoisted_15, [
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnPreparationCollapsed.value && "is-1 is-mini",
              !isColumnPreparationCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-1", [isColumnPreparationCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_16, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[2] || (_cache[2] = ($event) => isColumnPreparationCollapsed.value = false)
                    }, _hoisted_18),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_19, toDisplayString(unref(productsStatusReceived).length), 1)
                    ]),
                    _hoisted_20
                  ]),
                  createBaseVNode("div", _hoisted_21, [
                    createBaseVNode("div", _hoisted_22, [
                      _hoisted_23,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_24, toDisplayString(unref(productsStatusReceived).length), 1),
                        _hoisted_25
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[3] || (_cache[3] = ($event) => isColumnPreparationCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusReceived).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_26, [
                        createBaseVNode("p", _hoisted_27, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusReceived), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 10, _hoisted_28);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDispatchedCollapsed.value && "is-1 is-mini",
              !isColumnDispatchedCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-2", [isColumnDispatchedCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_29, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[4] || (_cache[4] = ($event) => isColumnDispatchedCollapsed.value = false)
                    }, _hoisted_31),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_32, toDisplayString(unref(productsStatusProcessing).length), 1)
                    ]),
                    _hoisted_33
                  ]),
                  createBaseVNode("div", _hoisted_34, [
                    createBaseVNode("div", _hoisted_35, [
                      _hoisted_36,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_37, toDisplayString(unref(productsStatusProcessing).length), 1),
                        _hoisted_38
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[5] || (_cache[5] = ($event) => isColumnDispatchedCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusProcessing).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_39, [
                        createBaseVNode("p", _hoisted_40, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusProcessing), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 10, _hoisted_41);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnToDeliverCollapsed.value && "is-1 is-mini",
              !isColumnToDeliverCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-3", [isColumnToDeliverCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_42, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[6] || (_cache[6] = ($event) => isColumnToDeliverCollapsed.value = false)
                    }, _hoisted_44),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_45, toDisplayString(unref(productsStatusToDeliver).length), 1)
                    ]),
                    _hoisted_46
                  ]),
                  createBaseVNode("div", _hoisted_47, [
                    createBaseVNode("div", _hoisted_48, [
                      _hoisted_49,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_50, toDisplayString(unref(productsStatusToDeliver).length), 1),
                        _hoisted_51
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[7] || (_cache[7] = ($event) => isColumnToDeliverCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusToDeliver).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_52, [
                        createBaseVNode("p", _hoisted_53, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusToDeliver), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 10, _hoisted_54);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDeliveredCollapsed.value && "is-1 is-mini",
              !isColumnDeliveredCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-4", [isColumnDeliveredCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_55, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[8] || (_cache[8] = ($event) => isColumnDeliveredCollapsed.value = false)
                    }, _hoisted_57),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_58, toDisplayString(unref(productsStatusDelivered).length), 1)
                    ]),
                    _hoisted_59
                  ]),
                  createBaseVNode("div", _hoisted_60, [
                    createBaseVNode("div", _hoisted_61, [
                      _hoisted_62,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_63, toDisplayString(unref(productsStatusDelivered).length), 1),
                        _hoisted_64
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[9] || (_cache[9] = ($event) => isColumnDeliveredCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusDelivered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_65, [
                        createBaseVNode("p", _hoisted_66, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusDelivered), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: normalizeClass(["kanban-card is-new", [
                            isCheckLetterZise.value && "is-size-3 has-text-weight-bold"
                          ]])
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 10, _hoisted_67);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2)
        ])
      ]);
    };
  }
});
const _hoisted_1 = { class: "page-content-inner" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    pageTitle.value = "Pedidos";
    useHead({
      title: "Pedidos"
    });
    return (_ctx, _cache) => {
      const _component_CommandRestaurant = _sfc_main$1;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_CommandRestaurant)
      ]);
    };
  }
});
export { _sfc_main as default };
